/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.Objects;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.types.DataType;

@Experimental
public interface TableChange {
    public static TableChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static TableChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static TableChange addColumn(String[] fieldNames, DataType dataType) {
        return new AddColumn(fieldNames, dataType, true, null);
    }

    public static TableChange addColumn(String[] fieldNames, DataType dataType, boolean isNullable) {
        return new AddColumn(fieldNames, dataType, isNullable, null);
    }

    public static TableChange addColumn(String[] fieldNames, DataType dataType, boolean isNullable, String comment) {
        return new AddColumn(fieldNames, dataType, isNullable, comment);
    }

    public static TableChange renameColumn(String[] fieldNames, String newName) {
        return new RenameColumn(fieldNames, newName);
    }

    public static TableChange updateColumnType(String[] fieldNames, DataType newDataType) {
        return new UpdateColumnType(fieldNames, newDataType, true);
    }

    public static TableChange updateColumnType(String[] fieldNames, DataType newDataType, boolean isNullable) {
        return new UpdateColumnType(fieldNames, newDataType, isNullable);
    }

    public static TableChange updateColumnComment(String[] fieldNames, String newComment) {
        return new UpdateColumnComment(fieldNames, newComment);
    }

    public static TableChange deleteColumn(String[] fieldNames) {
        return new DeleteColumn(fieldNames);
    }

    public static final class DeleteColumn
    implements ColumnChange {
        private final String[] fieldNames;

        private DeleteColumn(String[] fieldNames) {
            this.fieldNames = fieldNames;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteColumn that = (DeleteColumn)o;
            return Arrays.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fieldNames);
        }
    }

    public static final class UpdateColumnComment
    implements ColumnChange {
        private final String[] fieldNames;
        private final String newComment;

        private UpdateColumnComment(String[] fieldNames, String newComment) {
            this.fieldNames = fieldNames;
            this.newComment = newComment;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public String newComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnComment that = (UpdateColumnComment)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newComment.equals(that.newComment);
        }

        public int hashCode() {
            int result = Objects.hash(this.newComment);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class UpdateColumnType
    implements ColumnChange {
        private final String[] fieldNames;
        private final DataType newDataType;
        private final boolean isNullable;

        private UpdateColumnType(String[] fieldNames, DataType newDataType, boolean isNullable) {
            this.fieldNames = fieldNames;
            this.newDataType = newDataType;
            this.isNullable = isNullable;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public DataType newDataType() {
            return this.newDataType;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnType that = (UpdateColumnType)o;
            return this.isNullable == that.isNullable && Arrays.equals(this.fieldNames, that.fieldNames) && this.newDataType.equals(that.newDataType);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDataType, this.isNullable);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class RenameColumn
    implements ColumnChange {
        private final String[] fieldNames;
        private final String newName;

        private RenameColumn(String[] fieldNames, String newName) {
            this.fieldNames = fieldNames;
            this.newName = newName;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public String newName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameColumn that = (RenameColumn)o;
            return Arrays.equals(this.fieldNames, that.fieldNames) && this.newName.equals(that.newName);
        }

        public int hashCode() {
            int result = Objects.hash(this.newName);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static final class AddColumn
    implements ColumnChange {
        private final String[] fieldNames;
        private final DataType dataType;
        private final boolean isNullable;
        private final String comment;

        private AddColumn(String[] fieldNames, DataType dataType, boolean isNullable, String comment) {
            this.fieldNames = fieldNames;
            this.dataType = dataType;
            this.isNullable = isNullable;
            this.comment = comment;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public DataType dataType() {
            return this.dataType;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public String comment() {
            return this.comment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return this.isNullable == addColumn.isNullable && Arrays.equals(this.fieldNames, addColumn.fieldNames) && this.dataType.equals(addColumn.dataType) && this.comment.equals(addColumn.comment);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataType, this.isNullable, this.comment);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }
    }

    public static interface ColumnChange
    extends TableChange {
        public String[] fieldNames();
    }

    public static final class RemoveProperty
    implements TableChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String property() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty that = (RemoveProperty)o;
            return this.property.equals(that.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }
    }

    public static final class SetProperty
    implements TableChange {
        private final String property;
        private final String value;

        private SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty that = (SetProperty)o;
            return this.property.equals(that.property) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }
    }
}

