/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.expressions;

import java.util.Arrays;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LogicalExpressions;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Experimental
public class Expressions {
    private Expressions() {
    }

    public static Transform apply(String name, Expression ... args) {
        return LogicalExpressions.apply(name, (Seq<Expression>)JavaConverters.asScalaBuffer(Arrays.asList(args)).toSeq());
    }

    public static NamedReference column(String name) {
        return LogicalExpressions.reference(name);
    }

    public static <T> Literal<T> literal(T value) {
        return LogicalExpressions.literal(value);
    }

    public static Transform bucket(int numBuckets, String ... columns) {
        return LogicalExpressions.bucket(numBuckets, (Seq<String>)JavaConverters.asScalaBuffer(Arrays.asList(columns)).toSeq());
    }

    public static Transform identity(String column) {
        return LogicalExpressions.identity(column);
    }

    public static Transform years(String column) {
        return LogicalExpressions.years(column);
    }

    public static Transform months(String column) {
        return LogicalExpressions.months(column);
    }

    public static Transform days(String column) {
        return LogicalExpressions.days(column);
    }

    public static Transform hours(String column) {
        return LogicalExpressions.hours(column);
    }
}

