/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.Locale;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class StaticSQLConf$ {
    public static StaticSQLConf$ MODULE$;
    private final ConfigEntry<String> WAREHOUSE_PATH;
    private final ConfigEntry<String> CATALOG_IMPLEMENTATION;
    private final ConfigEntry<String> GLOBAL_TEMP_DATABASE;
    private final ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD;
    private final ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    private final ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES;
    private final ConfigEntry<Object> CODEGEN_COMMENTS;
    private final ConfigEntry<Object> DEBUG_MODE;
    private final ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION;
    private final OptionalConfigEntry<Seq<String>> SPARK_SESSION_EXTENSIONS;
    private final OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS;
    private final OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS;
    private final ConfigEntry<Object> UI_RETAINED_EXECUTIONS;
    private final ConfigEntry<Object> BROADCAST_EXCHANGE_MAX_THREAD_THRESHOLD;
    private final ConfigEntry<Object> SQL_EVENT_TRUNCATE_LENGTH;
    private final ConfigEntry<Object> SQL_LEGACY_SESSION_INIT_WITH_DEFAULTS;

    static {
        new StaticSQLConf$();
    }

    public ConfigEntry<String> WAREHOUSE_PATH() {
        return this.WAREHOUSE_PATH;
    }

    public ConfigEntry<String> CATALOG_IMPLEMENTATION() {
        return this.CATALOG_IMPLEMENTATION;
    }

    public ConfigEntry<String> GLOBAL_TEMP_DATABASE() {
        return this.GLOBAL_TEMP_DATABASE;
    }

    public ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD() {
        return this.SCHEMA_STRING_LENGTH_THRESHOLD;
    }

    public ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE() {
        return this.FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    }

    public ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES() {
        return this.CODEGEN_CACHE_MAX_ENTRIES;
    }

    public ConfigEntry<Object> CODEGEN_COMMENTS() {
        return this.CODEGEN_COMMENTS;
    }

    public ConfigEntry<Object> DEBUG_MODE() {
        return this.DEBUG_MODE;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION() {
        return this.HIVE_THRIFT_SERVER_SINGLESESSION;
    }

    public OptionalConfigEntry<Seq<String>> SPARK_SESSION_EXTENSIONS() {
        return this.SPARK_SESSION_EXTENSIONS;
    }

    public OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS() {
        return this.QUERY_EXECUTION_LISTENERS;
    }

    public OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS() {
        return this.STREAMING_QUERY_LISTENERS;
    }

    public ConfigEntry<Object> UI_RETAINED_EXECUTIONS() {
        return this.UI_RETAINED_EXECUTIONS;
    }

    public ConfigEntry<Object> BROADCAST_EXCHANGE_MAX_THREAD_THRESHOLD() {
        return this.BROADCAST_EXCHANGE_MAX_THREAD_THRESHOLD;
    }

    public ConfigEntry<Object> SQL_EVENT_TRUNCATE_LENGTH() {
        return this.SQL_EVENT_TRUNCATE_LENGTH;
    }

    public ConfigEntry<Object> SQL_LEGACY_SESSION_INIT_WITH_DEFAULTS() {
        return this.SQL_LEGACY_SESSION_INIT_WITH_DEFAULTS;
    }

    private StaticSQLConf$() {
        MODULE$ = this;
        this.WAREHOUSE_PATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.warehouse.dir").doc("The default location for managed databases and tables.").stringConf().createWithDefault((Object)Utils$.MODULE$.resolveURI("spark-warehouse").toString());
        this.CATALOG_IMPLEMENTATION = SQLConf$.MODULE$.buildStaticConf("spark.sql.catalogImplementation").internal().stringConf().checkValues((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hive", "in-memory"}))).createWithDefault((Object)"in-memory");
        this.GLOBAL_TEMP_DATABASE = SQLConf$.MODULE$.buildStaticConf("spark.sql.globalTempDatabase").internal().stringConf().transform((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).createWithDefault((Object)"global_temp");
        this.SCHEMA_STRING_LENGTH_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.sources.schemaStringLengthThreshold").doc("The maximum length allowed in a single cell when storing additional schema information in Hive's metastore.").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4000));
        this.FILESOURCE_TABLE_RELATION_CACHE_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.sql.filesourceTableRelationCacheSize").internal().doc("The maximum size of the cache that maps qualified table names to table relation plans.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)cacheSize -> cacheSize >= 0, "The maximum size of the cache must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.CODEGEN_CACHE_MAX_ENTRIES = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.cache.maxEntries").internal().doc("When nonzero, enable caching of generated classes for operators and expressions. All jobs share the cache that can use up to the specified number for generated classes.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)maxEntries -> maxEntries >= 0, "The maximum must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.CODEGEN_COMMENTS = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.comments").internal().doc("When true, put comment in the generated code. Since computing huge comments can be extremely expensive in certain cases, such as deeply-nested expressions which operate over inputs with wide schemas, default is false.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DEBUG_MODE = SQLConf$.MODULE$.buildStaticConf("spark.sql.debug").internal().doc("Only used for internal debugging. Not all functions are supported when it is enabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_THRIFT_SERVER_SINGLESESSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.thriftServer.singleSession").doc("When set to true, Hive Thrift server is running in a single session mode. All the JDBC/ODBC connections share the temporary views, function registries, SQL configuration and the current database.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.SPARK_SESSION_EXTENSIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.extensions").doc("A comma-separated list of classes that implement Function1[SparkSessionExtensions, Unit] used to configure Spark Session extensions. The classes must have a no-args constructor. If multiple extensions are specified, they are applied in the specified order. For the case of rules and planner strategies, they are applied in the specified order. For the case of parsers, the last parser is used and each parser can delegate to its predecessor. For the case of function name conflicts, the last registered function name is used.").stringConf().toSequence().createOptional();
        this.QUERY_EXECUTION_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.queryExecutionListeners").doc("List of class names implementing QueryExecutionListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").stringConf().toSequence().createOptional();
        this.STREAMING_QUERY_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.streamingQueryListeners").doc("List of class names implementing StreamingQueryListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").stringConf().toSequence().createOptional();
        this.UI_RETAINED_EXECUTIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.ui.retainedExecutions").doc("Number of executions to retain in the Spark UI.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.BROADCAST_EXCHANGE_MAX_THREAD_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.broadcastExchange.maxThreadThreshold").internal().doc("The maximum degree of parallelism to fetch and broadcast the table. If we encounter memory issue like frequently full GC or OOM when broadcast table we can decrease this number in order to reduce memory usage. Notice the number should be carefully chosen since decreasing parallelism might cause longer waiting for other broadcasting. Also, increasing parallelism may cause memory problem.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)thres -> thres > 0 && thres <= 128, "The threshold must be in [0,128].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)128));
        this.SQL_EVENT_TRUNCATE_LENGTH = SQLConf$.MODULE$.buildStaticConf("spark.sql.event.truncate.length").doc("Threshold of SQL length beyond which it will be truncated before adding to event. Defaults to no truncation. If set to 0, callsite will be logged instead.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$2 -> x$2 >= 0, "Must be set greater or equal to zero").createWithDefault((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        this.SQL_LEGACY_SESSION_INIT_WITH_DEFAULTS = SQLConf$.MODULE$.buildStaticConf("spark.sql.legacy.sessionInitWithConfigDefaults").doc("Flag to revert to legacy behavior where a cloned SparkSession receives SparkConf defaults, dropping any overrides in its parent SparkSession.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }
}

