/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.spark.sql.connector.expressions;

import org.apache.spark.annotation.Experimental;

/**
 * Represents a transform function in the public logical expression API.
 * <p>
 * For example, the transform date(ts) is used to derive a date value from a timestamp column. The
 * transform name is "date" and its argument is a reference to the "ts" column.
 */
@Experimental
public interface Transform extends Expression {
  /**
   * Returns the transform function name.
   */
  String name();

  /**
   * Returns all field references in the transform arguments.
   */
  NamedReference[] references();

  /**
   * Returns the arguments passed to the transform function.
   */
  Expression[] arguments();
}
