/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$DecimalAsIfIntegral$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015\u0019\u0007\u0001\"\u0011X\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015A\u0007\u0001\"\u0011X\u0011!I\u0007\u0001#b\u0001\n\u0013Q\u0007\"B9\u0001\t\u0003\u0012\bbB;\u0001\u0003\u0003%\tA\u001e\u0005\bs\u0002\t\n\u0011\"\u0001{\u0011!\tY\u0001AI\u0001\n\u0003Q\b\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u0011%\ty\u0002AA\u0001\n\u0003\t\t\u0003C\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131\u0007\u0005\n\u0003\u0003\u0002\u0011\u0011!C\u0001\u0003\u0007B\u0011\"!\u0014\u0001\u0003\u0003%\t%a\u0014\b\u000f\u00055d\u0004#\u0001\u0002p\u00191QD\bE\u0001\u0003cBa\u0001\u0012\r\u0005\u0002\u0005e\u0004bBA>1\u0011\u0005\u0011Q\u0010\u0005\n\u0003\u0007C\u0012\u0011!CA\u0003\u000bC\u0011\"a&\u0019\u0003\u0003%I!!'\u0003\u001d%sG/Z4sC2$\u0015N^5eK*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001YA\u001a\u0014\b\u0005\u0002.]5\ta$\u0003\u00020=\t\u0001\")\u001b8bef\f%/\u001b;i[\u0016$\u0018n\u0019\t\u0003[EJ!A\r\u0010\u0003\u0015\u0011Kg/T8e\u0019&\\W\r\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0004Qe>$Wo\u0019;\u0011\u0005QR\u0014BA\u001e6\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003y\u0002\"!L \n\u0005\u0001s\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDc\u0001$H\u0011B\u0011Q\u0006\u0001\u0005\u0006y\u0015\u0001\rA\u0010\u0005\u0006\u0005\u0016\u0001\rAP\u0001\nS:\u0004X\u000f\u001e+za\u0016,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\n\nQ\u0001^=qKNL!\u0001U'\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003M\u0003\"\u0001\u0014+\n\u0005Uk%\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\rMLXNY8m+\u0005A\u0006CA-a\u001d\tQf\f\u0005\u0002\\k5\tAL\u0003\u0002^U\u00051AH]8pizJ!aX\u001b\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?V\nQ\u0002Z3dS6\fG.T3uQ>$\u0017\u0001\u00073fG&l\u0017\r\u001c+p\t\u0006$\u0018\rV=qK\u000e{G-Z$f]R\u0011\u0001L\u001a\u0005\u0006O*\u0001\r\u0001W\u0001\u000eI\u0016\u001c\u0017.\\1m%\u0016\u001cX\u000f\u001c;\u0002\u0017M\fHn\u00149fe\u0006$xN]\u0001\u0004I&4X#A6\u0011\u000bQbgN\u001c8\n\u00055,$!\u0003$v]\u000e$\u0018n\u001c83!\t!t.\u0003\u0002qk\t\u0019\u0011I\\=\u0002\u001b\u00154\u0018\r\\(qKJ\fG/[8o)\rq7\u000f\u001e\u0005\u0006y5\u0001\rA\u001c\u0005\u0006\u00056\u0001\rA\\\u0001\u0005G>\u0004\u0018\u0010F\u0002GobDq\u0001\u0010\b\u0011\u0002\u0003\u0007a\bC\u0004C\u001dA\u0005\t\u0019\u0001 \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t1P\u000b\u0002?y.\nQ\u0010E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!A\u0005v]\u000eDWmY6fI*\u0019\u0011QA\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\n}\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\tA\u0001\\1oO*\u0011\u00111D\u0001\u0005U\u00064\u0018-C\u0002b\u0003+\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\t\u0011\u0007Q\n)#C\u0002\u0002(U\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2A\\A\u0017\u0011%\tycEA\u0001\u0002\u0004\t\u0019#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0001R!a\u000e\u0002>9l!!!\u000f\u000b\u0007\u0005mR'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u0002:\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)%a\u0013\u0011\u0007Q\n9%C\u0002\u0002JU\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u00020U\t\t\u00111\u0001o\u0003\u0019)\u0017/^1mgR!\u0011QIA)\u0011!\tyCFA\u0001\u0002\u0004q\u0007f\u0004\u0001\u0002V\u0005m\u0013QLA1\u0003G\n9'!\u001b\u0011\u00075\n9&C\u0002\u0002Zy\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002`\u0005\tI!\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003\u0005R5wS\u0012,\u0007\u0005Y3yaJ\f\u0004\r\t2zA\u0001,\u0007\u0010\u001d:3A:\u0002\u0013\n\u001e\u0011sKR,(O\\:!\u001dVcE\nI5gA\u0005t\u0007e\u001c9fe\u0006tG\rI5tA9+F\n\u0014\u0011pe\u0002\u0002W\r\u001f9se\u0001\u0004\u0013n\u001d\u00111]\u0001\"\u0006.\u001a\u0011sKN,H\u000e\u001e\u0011jg\u0002\u001a\u0017m\u001d;fI\u0002\"x\u000e\t7p]\u001et\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0015\u0014!\u000e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!g\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\nQa]5oG\u0016\f#!a\u001b\u0002\u000bMr\u0003G\f\u0019\u0002\u001d%sG/Z4sC2$\u0015N^5eKB\u0011Q\u0006G\n\u00051\u0005M\u0014\bE\u00025\u0003kJ1!a\u001e6\u0005\u0019\te.\u001f*fMR\u0011\u0011qN\u0001\u0006CB\u0004H.\u001f\u000b\u0006\r\u0006}\u0014\u0011\u0011\u0005\u0006yi\u0001\rA\u0010\u0005\u0006\u0005j\u0001\rAP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9)a%\u0011\u000bQ\nI)!$\n\u0007\u0005-UG\u0001\u0004PaRLwN\u001c\t\u0006i\u0005=eHP\u0005\u0004\u0003#+$A\u0002+va2,'\u0007\u0003\u0005\u0002\u0016n\t\t\u00111\u0001G\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u001cB!\u00111CAO\u0013\u0011\ty*!\u0006\u0003\r=\u0013'.Z2u\u0001")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike,
scala.Serializable {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(IntegralDivide integralDivide) {
        return IntegralDivide$.MODULE$.unapply(integralDivide);
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, DecimalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return new StringBuilder(9).append(decimalResult).append(".toLong()").toString();
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if (!this.bitmap$0) {
                Decimal$DecimalAsIfIntegral$ decimal$DecimalAsIfIntegral$;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    decimal$DecimalAsIfIntegral$ = integralType.integral();
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    decimal$DecimalAsIfIntegral$ = decimalType.asIntegral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Decimal$DecimalAsIfIntegral$ integral = decimal$DecimalAsIfIntegral$;
                this.div = (Function2 & Serializable & scala.Serializable)(x, y) -> {
                    Object res = integral.quot(x, y);
                    return res == null ? null : BoxesRunTime.boxToLong((long)integral.toLong(res));
                };
                this.bitmap$0 = true;
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        return !this.bitmap$0 ? this.div$lzycompute() : this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    public IntegralDivide copy(Expression left, Expression right) {
        return new IntegralDivide(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        DivModLike.$init$(this);
    }
}

