/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ColumnStatsMap;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.FilterEstimation$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.NumericValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering;
import scala.math.ScalaNumericAnyConversions;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u0014(\u0001bB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001b\")!\u000b\u0001C\u0001'\"9q\u000b\u0001b\u0001\n\u0013A\u0006B\u0002/\u0001A\u0003%\u0011\fC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u001dY\b!%A\u0005\u0002qDq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003Cq!a#\u0001\t\u0013\ti\tC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"I\u0011Q\u0017\u0001\u0002\u0002\u0013\u0005\u0011q\u0017\u0005\n\u0003w\u0003\u0011\u0013!C\u0001\u0003{C\u0011\"!1\u0001\u0003\u0003%\t%a1\t\u0013\u0005U\u0007!!A\u0005\u0002\u0005]\u0007\"CAp\u0001\u0005\u0005I\u0011AAq\u0011%\t9\u000fAA\u0001\n\u0003\nI\u000fC\u0005\u0002x\u0002\t\t\u0011\"\u0001\u0002z\"I\u0011Q \u0001\u0002\u0002\u0013\u0005\u0013q \u0005\n\u0005\u0003\u0001\u0011\u0011!C!\u0005\u0007A\u0011B!\u0002\u0001\u0003\u0003%\tEa\u0002\b\u0013\t-q%!A\t\u0002\t5a\u0001\u0003\u0014(\u0003\u0003E\tAa\u0004\t\rI\u0003C\u0011\u0001B\u000f\u0011%\u0011\t\u0001IA\u0001\n\u000b\u0012\u0019\u0001C\u0005\u0003 \u0001\n\t\u0011\"!\u0003\"!I!Q\u0005\u0011\u0002\u0002\u0013\u0005%q\u0005\u0005\n\u0005_\u0001\u0013\u0011!C\u0005\u0005c\u0011\u0001CR5mi\u0016\u0014Xi\u001d;j[\u0006$\u0018n\u001c8\u000b\u0005!J\u0013aD:uCR\u001cXi\u001d;j[\u0006$\u0018n\u001c8\u000b\u0005)Z\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003Y5\nQ\u0001\u001d7b]NT!AL\u0018\u0002\u0011\r\fG/\u00197zgRT!\u0001M\u0019\u0002\u0007M\fHN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u001d@\u000b\"\u0003\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0007C\u0001!D\u001b\u0005\t%B\u0001\"2\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001#B\u0005\u001daunZ4j]\u001e\u0004\"A\u000f$\n\u0005\u001d[$a\u0002)s_\u0012,8\r\u001e\t\u0003u%K!AS\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\tAd\u0017M\\\u000b\u0002\u001bB\u0011ajT\u0007\u0002S%\u0011\u0001+\u000b\u0002\u0007\r&dG/\u001a:\u0002\u000bAd\u0017M\u001c\u0011\u0002\rqJg.\u001b;?)\t!f\u000b\u0005\u0002V\u00015\tq\u0005C\u0003L\u0007\u0001\u0007Q*\u0001\u0006dQ&dGm\u0015;biN,\u0012!\u0017\t\u0003\u001djK!aW\u0015\u0003\u0015M#\u0018\r^5ti&\u001c7/A\u0006dQ&dGm\u0015;biN\u0004\u0013aC2pYN#\u0018\r^:NCB,\u0012a\u0018\t\u0003+\u0002L!!Y\u0014\u0003\u001d\r{G.^7o'R\fGo]'ba\u0006a1m\u001c7Ti\u0006$8/T1qA\u0005AQm\u001d;j[\u0006$X-F\u0001f!\rQd-W\u0005\u0003On\u0012aa\u00149uS>t\u0017AG2bY\u000e,H.\u0019;f\r&dG/\u001a:TK2,7\r^5wSRLHc\u00016omB\u0019!HZ6\u0011\u0005ib\u0017BA7<\u0005\u0019!u.\u001e2mK\")q.\u0003a\u0001a\u0006I1m\u001c8eSRLwN\u001c\t\u0003cRl\u0011A\u001d\u0006\u0003g6\n1\"\u001a=qe\u0016\u001c8/[8og&\u0011QO\u001d\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007bB<\n!\u0003\u0005\r\u0001_\u0001\u0007kB$\u0017\r^3\u0011\u0005iJ\u0018B\u0001><\u0005\u001d\u0011un\u001c7fC:\fAeY1mGVd\u0017\r^3GS2$XM]*fY\u0016\u001cG/\u001b<jif$C-\u001a4bk2$HEM\u000b\u0002{*\u0012\u0001P`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tIaO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003a\u0019\u0017\r\\2vY\u0006$XmU5oO2,7i\u001c8eSRLwN\u001c\u000b\u0006U\u0006M\u0011Q\u0003\u0005\u0006_.\u0001\r\u0001\u001d\u0005\u0006o.\u0001\r\u0001_\u0001\u0012KZ\fG.^1uK:+H\u000e\\\"iK\u000e\\Gc\u00026\u0002\u001c\u0005\u0015\u0012\u0011\u0006\u0005\b\u0003;a\u0001\u0019AA\u0010\u0003\u0011\tG\u000f\u001e:\u0011\u0007E\f\t#C\u0002\u0002$I\u0014\u0011\"\u0011;ue&\u0014W\u000f^3\t\r\u0005\u001dB\u00021\u0001y\u0003\u0019I7OT;mY\")q\u000f\u0004a\u0001q\u0006qQM^1mk\u0006$XMQ5oCJLH#\u00036\u00020\u0005e\u00121HA#\u0011\u001d\t\t$\u0004a\u0001\u0003g\t!a\u001c9\u0011\u0007E\f)$C\u0002\u00028I\u0014\u0001CQ5oCJL8i\\7qCJL7o\u001c8\t\u000f\u0005uQ\u00021\u0001\u0002 !9\u0011QH\u0007A\u0002\u0005}\u0012a\u00027ji\u0016\u0014\u0018\r\u001c\t\u0004c\u0006\u0005\u0013bAA\"e\n9A*\u001b;fe\u0006d\u0007\"B<\u000e\u0001\u0004A\u0018\u0001E3wC2,\u0018\r^3FcV\fG.\u001b;z)\u001dQ\u00171JA'\u0003\u001fBq!!\b\u000f\u0001\u0004\ty\u0002C\u0004\u0002>9\u0001\r!a\u0010\t\u000b]t\u0001\u0019\u0001=\u0002\u001f\u00154\u0018\r\\;bi\u0016d\u0015\u000e^3sC2$2A[A+\u0011\u001d\tid\u0004a\u0001\u0003\u007f\tQ\"\u001a<bYV\fG/Z%o'\u0016$Hc\u00026\u0002\\\u0005u\u0013Q\u0010\u0005\b\u0003;\u0001\u0002\u0019AA\u0010\u0011\u001d\ty\u0006\u0005a\u0001\u0003C\nA\u0001[*fiB1\u00111MA9\u0003orA!!\u001a\u0002nA\u0019\u0011qM\u001e\u000e\u0005\u0005%$bAA6o\u00051AH]8pizJ1!a\u001c<\u0003\u0019\u0001&/\u001a3fM&!\u00111OA;\u0005\r\u0019V\r\u001e\u0006\u0004\u0003_Z\u0004c\u0001\u001e\u0002z%\u0019\u00111P\u001e\u0003\u0007\u0005s\u0017\u0010C\u0003x!\u0001\u0007\u00010\u0001\rfm\u0006dW/\u0019;f\u0005&t\u0017M]=G_JtU/\\3sS\u000e$\u0012B[AB\u0003\u000b\u000b9)!#\t\u000f\u0005E\u0012\u00031\u0001\u00024!9\u0011QD\tA\u0002\u0005}\u0001bBA\u001f#\u0001\u0007\u0011q\b\u0005\u0006oF\u0001\r\u0001_\u0001&G>l\u0007/\u001e;f\u000bF,\u0018\r\\5usB{7o]5cS2LG/\u001f\"z\u0011&\u001cHo\\4sC6$Ra[AH\u0003#Cq!!\u0010\u0013\u0001\u0004\ty\u0004C\u0004\u0002\u0014J\u0001\r!!&\u0002\u000f\r|Gn\u0015;biB\u0019a*a&\n\u0007\u0005e\u0015F\u0001\u0006D_2,XN\\*uCR\fqeY8naV$XmQ8na\u0006\u0014\u0018n]8o!>\u001c8/\u001b2jY&$\u0018PQ=ISN$xn\u001a:b[R91.a(\u0002\"\u0006\r\u0006bBA\u0019'\u0001\u0007\u00111\u0007\u0005\b\u0003{\u0019\u0002\u0019AA \u0011\u001d\t\u0019j\u0005a\u0001\u0003+\u000b1$\u001a<bYV\fG/\u001a\"j]\u0006\u0014\u0018PR8s)^|7i\u001c7v[:\u001cH#\u00036\u0002*\u0006-\u0016qVAZ\u0011\u001d\t\t\u0004\u0006a\u0001\u0003gAq!!,\u0015\u0001\u0004\ty\"\u0001\u0005biR\u0014H*\u001a4u\u0011\u001d\t\t\f\u0006a\u0001\u0003?\t\u0011\"\u0019;ueJKw\r\u001b;\t\u000b]$\u0002\u0019\u0001=\u0002\t\r|\u0007/\u001f\u000b\u0004)\u0006e\u0006bB&\u0016!\u0003\u0005\r!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyL\u000b\u0002N}\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!2\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006!A.\u00198h\u0015\t\ty-\u0001\u0003kCZ\f\u0017\u0002BAj\u0003\u0013\u0014aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAm!\rQ\u00141\\\u0005\u0004\u0003;\\$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA<\u0003GD\u0011\"!:\u001a\u0003\u0003\u0005\r!!7\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u000f\u0005\u0004\u0002n\u0006M\u0018qO\u0007\u0003\u0003_T1!!=<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\fyO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001=\u0002|\"I\u0011Q]\u000e\u0002\u0002\u0003\u0007\u0011qO\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\\\u0001\ti>\u001cFO]5oOR\u0011\u0011QY\u0001\u0007KF,\u0018\r\\:\u0015\u0007a\u0014I\u0001C\u0005\u0002fz\t\t\u00111\u0001\u0002x\u0005\u0001b)\u001b7uKJ,5\u000f^5nCRLwN\u001c\t\u0003+\u0002\u001aB\u0001\tB\t\u0011B1!1\u0003B\r\u001bRk!A!\u0006\u000b\u0007\t]1(A\u0004sk:$\u0018.\\3\n\t\tm!Q\u0003\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDC\u0001B\u0007\u0003\u0015\t\u0007\u000f\u001d7z)\r!&1\u0005\u0005\u0006\u0017\u000e\u0002\r!T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011ICa\u000b\u0011\u0007i2W\n\u0003\u0005\u0003.\u0011\n\t\u00111\u0001U\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00034A!\u0011q\u0019B\u001b\u0013\u0011\u00119$!3\u0003\r=\u0013'.Z2u\u0001")
public class FilterEstimation
implements Logging,
Product,
scala.Serializable {
    private final Filter plan;
    private final Statistics childStats;
    private final ColumnStatsMap colStatsMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Filter> unapply(FilterEstimation filterEstimation) {
        return FilterEstimation$.MODULE$.unapply(filterEstimation);
    }

    public static FilterEstimation apply(Filter filter) {
        return FilterEstimation$.MODULE$.apply(filter);
    }

    public static <A> Function1<Filter, A> andThen(Function1<FilterEstimation, A> function1) {
        return FilterEstimation$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, FilterEstimation> compose(Function1<A, Filter> function1) {
        return FilterEstimation$.MODULE$.compose(function1);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Filter plan() {
        return this.plan;
    }

    private Statistics childStats() {
        return this.childStats;
    }

    private ColumnStatsMap colStatsMap() {
        return this.colStatsMap;
    }

    public Option<Statistics> estimate() {
        if (this.childStats().rowCount().isEmpty()) {
            return None$.MODULE$;
        }
        double filterSelectivity = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(this.plan().condition(), this.calculateFilterSelectivity$default$2()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
        BigInt filteredRowCount = EstimationUtils$.MODULE$.ceil(package$.MODULE$.BigDecimal().apply((BigInt)this.childStats().rowCount().get()).$times(BigDecimal$.MODULE$.double2bigDecimal(filterSelectivity)));
        AttributeMap<ColumnStat> newColStats = BoxesRunTime.equalsNumObject((Number)filteredRowCount, (Object)BoxesRunTime.boxToInteger((int)0)) ? AttributeMap$.MODULE$.apply(Nil$.MODULE$) : this.colStatsMap().outputColumnStats((BigInt)this.childStats().rowCount().get(), filteredRowCount);
        BigInt filteredSizeInBytes = EstimationUtils$.MODULE$.getOutputSize(this.plan().output(), filteredRowCount, newColStats);
        return new Some((Object)this.childStats().copy(filteredSizeInBytes, (Option<BigInt>)new Some((Object)filteredRowCount), newColStats));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> calculateFilterSelectivity(Expression condition, boolean update) {
        Some some;
        Literal literal;
        Object object;
        Expression l;
        Expression expression;
        Expression expression2;
        boolean bl = false;
        Not not = null;
        Expression expression3 = condition;
        if (expression3 instanceof And) {
            And and = (And)expression3;
            Expression cond1 = and.left();
            Expression cond2 = and.right();
            double percent1 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond1, update).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            double percent2 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond2, update).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            return new Some((Object)BoxesRunTime.boxToDouble((double)(percent1 * percent2)));
        }
        if (expression3 instanceof Or) {
            Or or = (Or)expression3;
            Expression cond1 = or.left();
            Expression cond2 = or.right();
            double percent1 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond1, false).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            double percent2 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond2, false).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0));
            return new Some((Object)BoxesRunTime.boxToDouble((double)(percent1 + percent2 - percent1 * percent2)));
        }
        if (expression3 instanceof Not) {
            bl = true;
            not = (Not)expression3;
            Expression expression4 = not.child();
            if (expression4 instanceof And) {
                And and = (And)expression4;
                Expression cond1 = and.left();
                Expression cond2 = and.right();
                return this.calculateFilterSelectivity(new Or(new Not(cond1), new Not(cond2)), false);
            }
        }
        if (bl && (expression2 = not.child()) instanceof Or) {
            Or or = (Or)expression2;
            Expression cond1 = or.left();
            Expression cond2 = or.right();
            return this.calculateFilterSelectivity(new And(new Not(cond1), new Not(cond2)), false);
        }
        if (bl && (expression = not.child()) instanceof Not) {
            Not not2 = (Not)expression;
            Expression cond = not2.child();
            return this.calculateFilterSelectivity(cond, false);
        }
        if (bl && (l = not.child()) instanceof Literal && (object = (literal = (Literal)l).value()) == null) {
            return this.calculateSingleCondition(literal, false);
        }
        if (!bl) return this.calculateSingleCondition(condition, update);
        Expression cond = not.child();
        Option<Object> option = this.calculateFilterSelectivity(cond, false);
        if (option instanceof Some) {
            Some some2 = (Some)option;
            double percent = BoxesRunTime.unboxToDouble((Object)some2.value());
            some = new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - percent)));
            return some;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            some = None$.MODULE$;
        }
        return some;
    }

    public boolean calculateFilterSelectivity$default$2() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> calculateSingleCondition(Expression condition, boolean update) {
        Option<Tuple2<Expression, Expression>> option;
        IsNotNull isNotNull;
        Expression ar;
        IsNull isNull;
        Expression ar2;
        Option<Tuple2<Expression, Expression>> option2;
        boolean bl = false;
        BinaryComparison binaryComparison = null;
        boolean bl2 = false;
        LessThan lessThan = null;
        boolean bl3 = false;
        LessThanOrEqual lessThanOrEqual = null;
        boolean bl4 = false;
        GreaterThan greaterThan = null;
        boolean bl5 = false;
        GreaterThanOrEqual greaterThanOrEqual = null;
        Expression expression = condition;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            return this.evaluateLiteral(literal);
        }
        if (expression instanceof BinaryComparison) {
            bl = true;
            binaryComparison = (BinaryComparison)expression;
            Option<Tuple2<Expression, Expression>> option3 = Equality$.MODULE$.unapply(binaryComparison);
            if (!option3.isEmpty()) {
                Expression ar3 = (Expression)((Tuple2)option3.get())._1();
                Expression l = (Expression)((Tuple2)option3.get())._2();
                if (ar3 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar3;
                    if (l instanceof Literal) {
                        Literal literal = (Literal)l;
                        return this.evaluateEquality(attribute, literal, update);
                    }
                }
            }
        }
        if (bl && !(option2 = Equality$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression l = (Expression)((Tuple2)option2.get())._1();
            Expression ar4 = (Expression)((Tuple2)option2.get())._2();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar4 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar4;
                    return this.evaluateEquality(attribute, literal, update);
                }
            }
        }
        if (expression instanceof LessThan) {
            bl2 = true;
            lessThan = (LessThan)expression;
            Expression ar5 = lessThan.left();
            Expression l = lessThan.right();
            if (ar5 instanceof Attribute) {
                Attribute attribute = (Attribute)ar5;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(lessThan, attribute, literal, update);
                }
            }
        }
        if (bl2) {
            Expression l = lessThan.left();
            Expression ar6 = lessThan.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar6 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar6;
                    return this.evaluateBinary(new GreaterThan(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            bl3 = true;
            lessThanOrEqual = (LessThanOrEqual)expression;
            Expression ar7 = lessThanOrEqual.left();
            Expression l = lessThanOrEqual.right();
            if (ar7 instanceof Attribute) {
                Attribute attribute = (Attribute)ar7;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(lessThanOrEqual, attribute, literal, update);
                }
            }
        }
        if (bl3) {
            Expression l = lessThanOrEqual.left();
            Expression ar8 = lessThanOrEqual.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar8 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar8;
                    return this.evaluateBinary(new GreaterThanOrEqual(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof GreaterThan) {
            bl4 = true;
            greaterThan = (GreaterThan)expression;
            Expression ar9 = greaterThan.left();
            Expression l = greaterThan.right();
            if (ar9 instanceof Attribute) {
                Attribute attribute = (Attribute)ar9;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(greaterThan, attribute, literal, update);
                }
            }
        }
        if (bl4) {
            Expression l = greaterThan.left();
            Expression ar10 = greaterThan.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar10 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar10;
                    return this.evaluateBinary(new LessThan(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof GreaterThanOrEqual) {
            bl5 = true;
            greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression ar11 = greaterThanOrEqual.left();
            Expression l = greaterThanOrEqual.right();
            if (ar11 instanceof Attribute) {
                Attribute attribute = (Attribute)ar11;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(greaterThanOrEqual, attribute, literal, update);
                }
            }
        }
        if (bl5) {
            Expression l = greaterThanOrEqual.left();
            Expression ar12 = greaterThanOrEqual.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar12 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar12;
                    return this.evaluateBinary(new LessThanOrEqual(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression ar13 = in.value();
            Seq<Expression> expList = in.list();
            if (ar13 instanceof Attribute) {
                Attribute attribute = (Attribute)ar13;
                if (expList.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FilterEstimation.$anonfun$calculateSingleCondition$1(e)))) {
                    Seq hSet = (Seq)expList.map((Function1 & Serializable & scala.Serializable)e -> e.eval(e.eval$default$1()), Seq$.MODULE$.canBuildFrom());
                    return this.evaluateInSet(attribute, (Set<Object>)((Set)((SetLike)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)hSet)), update);
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression ar14 = inSet.child();
            Set<Object> set = inSet.hset();
            if (ar14 instanceof Attribute) {
                Attribute attribute = (Attribute)ar14;
                return this.evaluateInSet(attribute, set, update);
            }
        }
        if (expression instanceof IsNull && (ar2 = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)ar2;
            if (this.plan().child() instanceof LeafNode) {
                return this.evaluateNullCheck(attribute, true, update);
            }
        }
        if (expression instanceof IsNotNull && (ar = (isNotNull = (IsNotNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)ar;
            if (this.plan().child() instanceof LeafNode) {
                return this.evaluateNullCheck(attribute, false, update);
            }
        }
        if (bl && !(option = Equality$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression attrLeft = (Expression)((Tuple2)option.get())._1();
            Expression attrRight = (Expression)((Tuple2)option.get())._2();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute2 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(binaryComparison, attribute, attribute2, update);
                }
            }
        }
        if (bl2) {
            Expression attrLeft = lessThan.left();
            Expression attrRight = lessThan.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute3 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(lessThan, attribute, attribute3, update);
                }
            }
        }
        if (bl3) {
            Expression attrLeft = lessThanOrEqual.left();
            Expression attrRight = lessThanOrEqual.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute4 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(lessThanOrEqual, attribute, attribute4, update);
                }
            }
        }
        if (bl4) {
            Expression attrLeft = greaterThan.left();
            Expression attrRight = greaterThan.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute5 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(greaterThan, attribute, attribute5, update);
                }
            }
        }
        if (bl5) {
            Expression attrLeft = greaterThanOrEqual.left();
            Expression attrRight = greaterThanOrEqual.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute6 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(greaterThanOrEqual, attribute, attribute6, update);
                }
            }
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("[CBO] Unsupported filter condition: ").append(condition).toString());
        return None$.MODULE$;
    }

    public Option<Object> evaluateNullCheck(Attribute attr, boolean isNull, boolean update) {
        double nullPercent;
        if (!this.colStatsMap().contains(attr) || !this.colStatsMap().apply(attr).hasCountStats()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        BigInt rowCountValue = (BigInt)this.childStats().rowCount().get();
        double d = nullPercent = BoxesRunTime.equalsNumObject((Number)rowCountValue, (Object)BoxesRunTime.boxToInteger((int)0)) ? 0.0 : package$.MODULE$.BigDecimal().apply((BigInt)colStat.nullCount().get()).$div(package$.MODULE$.BigDecimal().apply(rowCountValue)).toDouble();
        if (update) {
            ColumnStat columnStat;
            if (isNull) {
                columnStat = colStat.copy((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, colStat.copy$default$4(), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
            } else {
                Some x$1 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Option<BigInt> x$2 = colStat.copy$default$1();
                Option<Object> x$3 = colStat.copy$default$2();
                Option<Object> x$4 = colStat.copy$default$3();
                Option<Object> x$5 = colStat.copy$default$5();
                Option<Object> x$6 = colStat.copy$default$6();
                Option<Histogram> x$7 = colStat.copy$default$7();
                int x$8 = colStat.copy$default$8();
                columnStat = colStat.copy(x$2, x$3, x$4, (Option<BigInt>)x$1, x$5, x$6, x$7, x$8);
            }
            ColumnStat newStats = columnStat;
            this.colStatsMap().update(attr, newStats);
        }
        double percent = isNull ? nullPercent : 1.0 - nullPercent;
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    public Option<Object> evaluateBinary(BinaryComparison op, Attribute attr, Literal literal, boolean update) {
        None$ none$;
        if (!this.colStatsMap().contains(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        DataType dataType = attr.dataType();
        boolean bl = dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : BooleanType$.MODULE$.equals(dataType)));
        if (bl) {
            none$ = this.evaluateBinaryForNumeric(op, attr, literal, update);
        } else {
            boolean bl2 = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
            if (bl2) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("[CBO] No range comparison statistics for String/Binary type ").append(attr).toString());
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return none$;
    }

    public Option<Object> evaluateEquality(Attribute attr, Literal literal, boolean update) {
        Object object;
        if (!this.colStatsMap().contains(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        ValueInterval statsInterval = ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), attr.dataType());
        if (statsInterval.contains(literal)) {
            if (update) {
                ColumnStat columnStat;
                DataType dataType = attr.dataType();
                boolean bl = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
                if (bl) {
                    Some x$1 = new Some((Object)BigInt$.MODULE$.int2bigInt(1));
                    Some x$2 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                    Option<Object> x$3 = colStat.copy$default$2();
                    Option<Object> x$4 = colStat.copy$default$3();
                    Option<Object> x$5 = colStat.copy$default$5();
                    Option<Object> x$6 = colStat.copy$default$6();
                    Option<Histogram> x$7 = colStat.copy$default$7();
                    int x$8 = colStat.copy$default$8();
                    columnStat = colStat.copy((Option<BigInt>)x$1, x$3, x$4, (Option<BigInt>)x$2, x$5, x$6, x$7, x$8);
                } else {
                    columnStat = colStat.copy((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option<Object>)new Some(literal.value()), (Option<Object>)new Some(literal.value()), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
                }
                ColumnStat newStats = columnStat;
                this.colStatsMap().update(attr, newStats);
            }
            object = colStat.histogram().isEmpty() ? (!colStat.distinctCount().isEmpty() ? new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 / ((ScalaNumericAnyConversions)colStat.distinctCount().get()).toDouble()))) : None$.MODULE$) : new Some((Object)BoxesRunTime.boxToDouble((double)this.computeEqualityPossibilityByHistogram(literal, colStat)));
        } else {
            object = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        return object;
    }

    public Option<Object> evaluateLiteral(Literal literal) {
        Object object;
        Object object2;
        Literal literal2 = literal;
        if (literal2 != null && (object2 = literal2.value()) == null) {
            object = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        } else {
            Literal literal3 = Literal$.MODULE$.FalseLiteral();
            Literal literal4 = literal2;
            if (!(literal3 != null ? !((Object)literal3).equals(literal4) : literal4 != null)) {
                object = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            } else {
                Literal literal5 = Literal$.MODULE$.TrueLiteral();
                Literal literal6 = literal2;
                object = !(literal5 != null ? !((Object)literal5).equals(literal6) : literal6 != null) ? new Some((Object)BoxesRunTime.boxToDouble((double)1.0)) : None$.MODULE$;
            }
        }
        return object;
    }

    public Option<Object> evaluateInSet(Attribute attr, Set<Object> hSet, boolean update) {
        if (!this.colStatsMap().hasDistinctCount(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        BigInt ndv = (BigInt)colStat.distinctCount().get();
        DataType dataType = attr.dataType();
        BigInt newNdv = ndv;
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof NumericType ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2)));
        if (bl) {
            BoxedUnit boxedUnit;
            if (ndv.toDouble() == 0.0 || colStat.min().isEmpty() || colStat.max().isEmpty()) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            NumericValueInterval statsInterval = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), dataType);
            Set validQuerySet = (Set)hSet.filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)FilterEstimation.$anonfun$evaluateInSet$2(statsInterval, dataType, v)));
            if (validQuerySet.isEmpty()) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            Object newMax = validQuerySet.maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)EstimationUtils$.MODULE$.toDouble(x$1, dataType)), (Ordering)Ordering.Double$.MODULE$);
            Object newMin = validQuerySet.minBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)EstimationUtils$.MODULE$.toDouble(x$2, dataType)), (Ordering)Ordering.Double$.MODULE$);
            newNdv = ndv.min(package$.MODULE$.BigInt().apply(validQuerySet.size()));
            if (update) {
                ColumnStat newStats = colStat.copy((Option<BigInt>)new Some((Object)newNdv), (Option<Object>)new Some(newMin), (Option<Object>)new Some(newMax), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
                this.colStatsMap().update(attr, newStats);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            boolean bl2 = StringType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2);
            if (bl2) {
                BoxedUnit boxedUnit;
                if (ndv.toDouble() == 0.0) {
                    return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                }
                newNdv = ndv.min(package$.MODULE$.BigInt().apply(hSet.size()));
                if (update) {
                    Some x$12 = new Some((Object)newNdv);
                    Some x$22 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                    Option<Object> x$3 = colStat.copy$default$2();
                    Option<Object> x$4 = colStat.copy$default$3();
                    Option<Object> x$5 = colStat.copy$default$5();
                    Option<Object> x$6 = colStat.copy$default$6();
                    Option<Histogram> x$7 = colStat.copy$default$7();
                    int x$8 = colStat.copy$default$8();
                    ColumnStat newStats = colStat.copy((Option<BigInt>)x$12, x$3, x$4, (Option<BigInt>)x$22, x$5, x$6, x$7, x$8);
                    this.colStatsMap().update(attr, newStats);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(newNdv.toDouble() / ndv.toDouble(), 1.0)));
    }

    public Option<Object> evaluateBinaryForNumeric(BinaryComparison op, Attribute attr, Literal literal, boolean update) {
        Tuple2.mcZZ.sp sp2;
        if (!this.colStatsMap().hasMinMaxStats(attr) || !this.colStatsMap().hasDistinctCount(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attr).toString());
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        NumericValueInterval statsInterval = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), attr.dataType());
        double max = statsInterval.max();
        double min = statsInterval.min();
        double ndv = ((ScalaNumericAnyConversions)colStat.distinctCount().get()).toDouble();
        double numericLiteral = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        BinaryComparison binaryComparison = op;
        if (binaryComparison instanceof LessThan) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral <= min, numericLiteral > max);
        } else if (binaryComparison instanceof LessThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral < min, numericLiteral >= max);
        } else if (binaryComparison instanceof GreaterThan) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral >= max, numericLiteral < min);
        } else if (binaryComparison instanceof GreaterThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(numericLiteral > max, numericLiteral <= min);
        } else {
            throw new MatchError((Object)binaryComparison);
        }
        Tuple2.mcZZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        boolean noOverlap = sp3._1$mcZ$sp();
        boolean completeOverlap = sp3._2$mcZ$sp();
        boolean bl = noOverlap;
        boolean bl2 = completeOverlap;
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(bl, bl2);
        Tuple2.mcZZ.sp sp5 = sp4;
        boolean noOverlap2 = sp5._1$mcZ$sp();
        boolean completeOverlap2 = sp5._2$mcZ$sp();
        double percent = 1.0;
        if (noOverlap2) {
            percent = 0.0;
        } else if (completeOverlap2) {
            percent = 1.0;
        } else {
            if (colStat.histogram().isEmpty()) {
                double d;
                Predef$.MODULE$.assert(max > min);
                BinaryComparison binaryComparison2 = op;
                if (binaryComparison2 instanceof LessThan) {
                    d = numericLiteral == max ? 1.0 - 1.0 / ndv : (numericLiteral - min) / (max - min);
                } else if (binaryComparison2 instanceof LessThanOrEqual) {
                    d = numericLiteral == min ? 1.0 / ndv : (numericLiteral - min) / (max - min);
                } else if (binaryComparison2 instanceof GreaterThan) {
                    d = numericLiteral == min ? 1.0 - 1.0 / ndv : (max - numericLiteral) / (max - min);
                } else if (binaryComparison2 instanceof GreaterThanOrEqual) {
                    d = numericLiteral == max ? 1.0 / ndv : (max - numericLiteral) / (max - min);
                } else {
                    throw new MatchError((Object)binaryComparison2);
                }
                percent = d;
            } else {
                percent = this.computeComparisonPossibilityByHistogram(op, literal, colStat);
            }
            if (update) {
                Some newValue = new Some(literal.value());
                Some newMax = colStat.max();
                Some newMin = colStat.min();
                BinaryComparison binaryComparison3 = op;
                boolean bl3 = binaryComparison3 instanceof GreaterThan ? true : binaryComparison3 instanceof GreaterThanOrEqual;
                if (bl3) {
                    newMin = newValue;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl4 = binaryComparison3 instanceof LessThan ? true : binaryComparison3 instanceof LessThanOrEqual;
                    if (bl4) {
                        newMax = newValue;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)binaryComparison3);
                    }
                }
                ColumnStat newStats = colStat.copy((Option<BigInt>)new Some((Object)EstimationUtils$.MODULE$.ceil(BigDecimal$.MODULE$.double2bigDecimal(ndv * percent))), (Option<Object>)newMin, (Option<Object>)newMax, (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
                this.colStatsMap().update(attr, newStats);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    private double computeEqualityPossibilityByHistogram(Literal literal, ColumnStat colStat) {
        double datum = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        Histogram histogram = (Histogram)colStat.histogram().get();
        double min = EstimationUtils$.MODULE$.toDouble(colStat.min().get(), literal.dataType());
        double max = EstimationUtils$.MODULE$.toDouble(colStat.max().get(), literal.dataType());
        double numBinsHoldingEntireRange = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, min, true, histogram.bins());
        double numBinsHoldingDatum = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, true, datum, true, histogram.bins());
        return numBinsHoldingDatum / numBinsHoldingEntireRange;
    }

    private double computeComparisonPossibilityByHistogram(BinaryComparison op, Literal literal, ColumnStat colStat) {
        double d;
        double datum = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        Histogram histogram = (Histogram)colStat.histogram().get();
        double min = EstimationUtils$.MODULE$.toDouble(colStat.min().get(), literal.dataType());
        double max = EstimationUtils$.MODULE$.toDouble(colStat.max().get(), literal.dataType());
        double numBinsHoldingEntireRange = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, min, true, histogram.bins());
        BinaryComparison binaryComparison = op;
        if (binaryComparison instanceof LessThan) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, false, min, true, histogram.bins());
        } else if (binaryComparison instanceof LessThanOrEqual) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, true, min, true, histogram.bins());
        } else if (binaryComparison instanceof GreaterThan) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, datum, false, histogram.bins());
        } else if (binaryComparison instanceof GreaterThanOrEqual) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, datum, true, histogram.bins());
        } else {
            throw new MatchError((Object)binaryComparison);
        }
        double numBinsHoldingRange = d;
        return numBinsHoldingRange / numBinsHoldingEntireRange;
    }

    public Option<Object> evaluateBinaryForTwoColumns(BinaryComparison op, Attribute attrLeft, Attribute attrRight, boolean update) {
        Tuple2.mcZZ.sp sp2;
        if (!this.colStatsMap().hasCountStats(attrLeft)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attrLeft).toString());
            return None$.MODULE$;
        }
        if (!this.colStatsMap().hasCountStats(attrRight)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("[CBO] No statistics for ").append(attrRight).toString());
            return None$.MODULE$;
        }
        DataType dataType = attrLeft.dataType();
        boolean bl = StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType);
        if (bl) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("[CBO] No range comparison statistics for String/Binary type ").append(attrLeft).toString());
            return None$.MODULE$;
        }
        if (!this.colStatsMap().hasMinMaxStats(attrLeft)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("[CBO] No min/max statistics for ").append(attrLeft).toString());
            return None$.MODULE$;
        }
        if (!this.colStatsMap().hasMinMaxStats(attrRight)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("[CBO] No min/max statistics for ").append(attrRight).toString());
            return None$.MODULE$;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        ColumnStat colStatLeft = this.colStatsMap().apply(attrLeft);
        NumericValueInterval statsIntervalLeft = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStatLeft.min(), colStatLeft.max(), attrLeft.dataType());
        double maxLeft = statsIntervalLeft.max();
        double minLeft = statsIntervalLeft.min();
        ColumnStat colStatRight = this.colStatsMap().apply(attrRight);
        NumericValueInterval statsIntervalRight = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStatRight.min(), colStatRight.max(), attrRight.dataType());
        double maxRight = statsIntervalRight.max();
        double minRight = statsIntervalRight.min();
        boolean allNotNull = BoxesRunTime.equals((Object)colStatLeft.nullCount().get(), (Object)BoxesRunTime.boxToInteger((int)0)) && BoxesRunTime.equals((Object)colStatRight.nullCount().get(), (Object)BoxesRunTime.boxToInteger((int)0));
        BinaryComparison binaryComparison = op;
        if (binaryComparison instanceof LessThan) {
            sp2 = new Tuple2.mcZZ.sp(minLeft >= maxRight, maxLeft < minRight && allNotNull);
        } else if (binaryComparison instanceof LessThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(minLeft > maxRight, maxLeft <= minRight && allNotNull);
        } else if (binaryComparison instanceof GreaterThan) {
            sp2 = new Tuple2.mcZZ.sp(maxLeft <= minRight, minLeft > maxRight && allNotNull);
        } else if (binaryComparison instanceof GreaterThanOrEqual) {
            sp2 = new Tuple2.mcZZ.sp(maxLeft < minRight, minLeft >= maxRight && allNotNull);
        } else if (binaryComparison instanceof EqualTo) {
            sp2 = new Tuple2.mcZZ.sp(maxLeft < minRight || maxRight < minLeft, minLeft == minRight && maxLeft == maxRight && allNotNull && BoxesRunTime.equals((Object)colStatLeft.distinctCount().get(), (Object)colStatRight.distinctCount().get()));
        } else if (binaryComparison instanceof EqualNullSafe) {
            sp2 = new Tuple2.mcZZ.sp((maxLeft < minRight || maxRight < minLeft) && allNotNull, minLeft == minRight && maxLeft == maxRight && allNotNull && BoxesRunTime.equals((Object)colStatLeft.distinctCount().get(), (Object)colStatRight.distinctCount().get()));
        } else {
            throw new MatchError((Object)binaryComparison);
        }
        Tuple2.mcZZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        boolean noOverlap = sp3._1$mcZ$sp();
        boolean completeOverlap = sp3._2$mcZ$sp();
        boolean bl2 = noOverlap;
        boolean bl3 = completeOverlap;
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(bl2, bl3);
        Tuple2.mcZZ.sp sp5 = sp4;
        boolean noOverlap2 = sp5._1$mcZ$sp();
        boolean completeOverlap2 = sp5._2$mcZ$sp();
        double percent = 1.0;
        if (noOverlap2) {
            percent = 0.0;
        } else if (completeOverlap2) {
            percent = 1.0;
        } else {
            percent = 0.3333333333333333;
            if (update) {
                BigDecimal ndvLeft = package$.MODULE$.BigDecimal().apply((BigInt)colStatLeft.distinctCount().get());
                BigInt newNdvLeft = EstimationUtils$.MODULE$.ceil(ndvLeft.$times(BigDecimal$.MODULE$.double2bigDecimal(percent)));
                BigDecimal ndvRight = package$.MODULE$.BigDecimal().apply((BigInt)colStatRight.distinctCount().get());
                BigInt newNdvRight = EstimationUtils$.MODULE$.ceil(ndvRight.$times(BigDecimal$.MODULE$.double2bigDecimal(percent)));
                Option<Object> newMaxLeft = colStatLeft.max();
                Option<Object> newMinLeft = colStatLeft.min();
                Option<Object> newMaxRight = colStatRight.max();
                Option<Object> newMinRight = colStatRight.min();
                BinaryComparison binaryComparison2 = op;
                boolean bl4 = binaryComparison2 instanceof LessThan ? true : binaryComparison2 instanceof LessThanOrEqual;
                if (bl4) {
                    BoxedUnit boxedUnit2;
                    if (minLeft > minRight) {
                        newMinRight = colStatLeft.min();
                    }
                    if (maxLeft > maxRight) {
                        newMaxLeft = colStatRight.max();
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit2;
                } else {
                    boolean bl5 = binaryComparison2 instanceof GreaterThan ? true : binaryComparison2 instanceof GreaterThanOrEqual;
                    if (bl5) {
                        BoxedUnit boxedUnit4;
                        if (minLeft < minRight) {
                            newMinLeft = colStatRight.min();
                        }
                        if (maxLeft < maxRight) {
                            newMaxRight = colStatLeft.max();
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit5 = boxedUnit4;
                    } else {
                        boolean bl6 = binaryComparison2 instanceof EqualTo ? true : binaryComparison2 instanceof EqualNullSafe;
                        if (bl6) {
                            BoxedUnit boxedUnit6;
                            if (minLeft < minRight) {
                                newMinLeft = colStatRight.min();
                            } else {
                                newMinRight = colStatLeft.min();
                            }
                            if (maxLeft < maxRight) {
                                newMaxRight = colStatLeft.max();
                                boxedUnit6 = BoxedUnit.UNIT;
                            } else {
                                newMaxLeft = colStatRight.max();
                                boxedUnit6 = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit7 = boxedUnit6;
                        } else {
                            throw new MatchError((Object)binaryComparison2);
                        }
                    }
                }
                ColumnStat newStatsLeft = colStatLeft.copy((Option<BigInt>)new Some((Object)newNdvLeft), newMinLeft, newMaxLeft, colStatLeft.copy$default$4(), colStatLeft.copy$default$5(), colStatLeft.copy$default$6(), colStatLeft.copy$default$7(), colStatLeft.copy$default$8());
                this.colStatsMap().update(attrLeft, newStatsLeft);
                ColumnStat newStatsRight = colStatRight.copy((Option<BigInt>)new Some((Object)newNdvRight), newMinRight, newMaxRight, colStatRight.copy$default$4(), colStatRight.copy$default$5(), colStatRight.copy$default$6(), colStatRight.copy$default$7(), colStatRight.copy$default$8());
                this.colStatsMap().update(attrRight, newStatsRight);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    public FilterEstimation copy(Filter plan2) {
        return new FilterEstimation(plan2);
    }

    public Filter copy$default$1() {
        return this.plan();
    }

    public String productPrefix() {
        return "FilterEstimation";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.plan();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FilterEstimation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FilterEstimation)) return false;
        boolean bl = true;
        if (!bl) return false;
        FilterEstimation filterEstimation = (FilterEstimation)x$1;
        Filter filter = this.plan();
        Filter filter2 = filterEstimation.plan();
        if (filter == null) {
            if (filter2 != null) {
                return false;
            }
        } else if (!((Object)filter).equals(filter2)) return false;
        if (!filterEstimation.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$calculateSingleCondition$1(Expression e) {
        return e instanceof Literal;
    }

    public static final /* synthetic */ boolean $anonfun$evaluateInSet$2(NumericValueInterval statsInterval$1, DataType dataType$1, Object v) {
        return v != null && statsInterval$1.contains(new Literal(v, dataType$1));
    }

    public FilterEstimation(Filter plan2) {
        this.plan = plan2;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.childStats = plan2.child().stats();
        this.colStatsMap = new ColumnStatsMap(this.childStats().attributeStats());
    }
}

