/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.ScalaObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RebaseDateTime$ {
    public static RebaseDateTime$ MODULE$;
    private final int[] julianGregDiffs;
    private final int[] julianGregDiffSwitchDay;
    private final int lastSwitchJulianDay;
    private final int julianCommonEraStartDay;
    private final int[] gregJulianDiffs;
    private final int[] gregJulianDiffSwitchDay;
    private final int lastSwitchGregorianDay;
    private final int gregorianCommonEraStartDay;
    private final LocalDate gregorianStartDate;
    private final LocalDate julianEndDate;
    private final AnyRefMap<String, RebaseDateTime.RebaseInfo> gregJulianRebaseMap;
    private final long lastSwitchGregorianTs;
    private final LocalDateTime gregorianStartTs;
    private final LocalDateTime julianEndTs;
    private final AnyRefMap<String, RebaseDateTime.RebaseInfo> julianGregRebaseMap;
    private final long lastSwitchJulianTs;

    static {
        new RebaseDateTime$();
    }

    private int rebaseDays(int[] switches, int[] diffs, int days) {
        int i = switches.length;
        while (--i > 0 && days < switches[i]) {
        }
        return days + diffs[i];
    }

    private int[] julianGregDiffs() {
        return this.julianGregDiffs;
    }

    private int[] julianGregDiffSwitchDay() {
        return this.julianGregDiffSwitchDay;
    }

    public final int lastSwitchJulianDay() {
        return this.lastSwitchJulianDay;
    }

    private final int julianCommonEraStartDay() {
        return this.julianCommonEraStartDay;
    }

    public int localRebaseJulianToGregorianDays(int days) {
        Calendar utcCal = new Calendar.Builder().setCalendarType("gregory").setTimeZone(DateTimeUtils$.MODULE$.TimeZoneUTC()).setInstant(Math.multiplyExact((long)days, 86400000L)).build();
        LocalDate localDate = LocalDate.of(utcCal.get(1), utcCal.get(2) + 1, 1).with(ChronoField.ERA, utcCal.get(0)).plusDays(utcCal.get(5) - 1);
        return Math.toIntExact(localDate.toEpochDay());
    }

    public int rebaseJulianToGregorianDays(int days) {
        return days < this.julianCommonEraStartDay() ? this.localRebaseJulianToGregorianDays(days) : this.rebaseDays(this.julianGregDiffSwitchDay(), this.julianGregDiffs(), days);
    }

    private int[] gregJulianDiffs() {
        return this.gregJulianDiffs;
    }

    private int[] gregJulianDiffSwitchDay() {
        return this.gregJulianDiffSwitchDay;
    }

    public final int lastSwitchGregorianDay() {
        return this.lastSwitchGregorianDay;
    }

    private final int gregorianCommonEraStartDay() {
        return this.gregorianCommonEraStartDay;
    }

    private final LocalDate gregorianStartDate() {
        return this.gregorianStartDate;
    }

    private final LocalDate julianEndDate() {
        return this.julianEndDate;
    }

    public int localRebaseGregorianToJulianDays(int days) {
        LocalDate localDate = LocalDate.ofEpochDay(days);
        if (localDate.isAfter(this.julianEndDate()) && localDate.isBefore(this.gregorianStartDate())) {
            localDate = this.gregorianStartDate();
        }
        Calendar utcCal = new Calendar.Builder().setCalendarType("gregory").setTimeZone(DateTimeUtils$.MODULE$.TimeZoneUTC()).setDate(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth()).build();
        return Math.toIntExact(Math.floorDiv(utcCal.getTimeInMillis(), 86400000L));
    }

    public int rebaseGregorianToJulianDays(int days) {
        return days < this.gregorianCommonEraStartDay() ? this.localRebaseGregorianToJulianDays(days) : this.rebaseDays(this.gregJulianDiffSwitchDay(), this.gregJulianDiffs(), days);
    }

    private long rebaseMicros(RebaseDateTime.RebaseInfo rebaseInfo, long micros) {
        long[] switches = rebaseInfo.switches();
        int i = switches.length;
        while (--i > 0 && micros < switches[i]) {
        }
        return micros + rebaseInfo.diffs()[i];
    }

    public AnyRefMap<String, RebaseDateTime.RebaseInfo> loadRebaseRecords(String fileName) {
        URL file = Thread.currentThread().getContextClassLoader().getResource(fileName);
        ScalaObjectMapper mapper = new ScalaObjectMapper(){
            private final Class<Map<?, ?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP;
            private final Class<Option<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION;
            private final Class<Iterable<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE;

            public final <Target, MixinSource> ObjectMapper addMixin(Manifest<Target> evidence$1, Manifest<MixinSource> evidence$2) {
                return ScalaObjectMapper.addMixin$((ScalaObjectMapper)this, evidence$1, evidence$2);
            }

            public final <Target, MixinSource> ObjectMapper addMixInAnnotations(Manifest<Target> evidence$3, Manifest<MixinSource> evidence$4) {
                return ScalaObjectMapper.addMixInAnnotations$((ScalaObjectMapper)this, evidence$3, evidence$4);
            }

            public final <T> Class<?> findMixInClassFor(Manifest<T> evidence$5) {
                return ScalaObjectMapper.findMixInClassFor$((ScalaObjectMapper)this, evidence$5);
            }

            public <T> JavaType constructType(Manifest<T> m) {
                return ScalaObjectMapper.constructType$((ScalaObjectMapper)this, m);
            }

            public <T> T readValue(JsonParser jp, Manifest<T> evidence$6) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (JsonParser)jp, evidence$6);
            }

            public <T> MappingIterator<T> readValues(JsonParser jp, Manifest<T> evidence$7) {
                return ScalaObjectMapper.readValues$((ScalaObjectMapper)this, (JsonParser)jp, evidence$7);
            }

            public <T> T treeToValue(TreeNode n, Manifest<T> evidence$8) {
                return (T)ScalaObjectMapper.treeToValue$((ScalaObjectMapper)this, (TreeNode)n, evidence$8);
            }

            public <T> boolean canSerialize(Manifest<T> evidence$9) {
                return ScalaObjectMapper.canSerialize$((ScalaObjectMapper)this, evidence$9);
            }

            public <T> boolean canDeserialize(Manifest<T> evidence$10) {
                return ScalaObjectMapper.canDeserialize$((ScalaObjectMapper)this, evidence$10);
            }

            public <T> T readValue(File src, Manifest<T> evidence$11) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (File)src, evidence$11);
            }

            public <T> T readValue(URL src, Manifest<T> evidence$12) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (URL)src, evidence$12);
            }

            public <T> T readValue(String content, Manifest<T> evidence$13) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (String)content, evidence$13);
            }

            public <T> T readValue(Reader src, Manifest<T> evidence$14) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (Reader)src, evidence$14);
            }

            public <T> T readValue(InputStream src, Manifest<T> evidence$15) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (InputStream)src, evidence$15);
            }

            public <T> T readValue(byte[] src, Manifest<T> evidence$16) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (byte[])src, evidence$16);
            }

            public <T> T readValue(byte[] src, int offset, int len, Manifest<T> evidence$17) {
                return (T)ScalaObjectMapper.readValue$((ScalaObjectMapper)this, (byte[])src, (int)offset, (int)len, evidence$17);
            }

            public <T> ObjectWriter writerWithView(Manifest<T> evidence$18) {
                return ScalaObjectMapper.writerWithView$((ScalaObjectMapper)this, evidence$18);
            }

            public <T> ObjectWriter writerWithType(Manifest<T> evidence$19) {
                return ScalaObjectMapper.writerWithType$((ScalaObjectMapper)this, evidence$19);
            }

            public <T> ObjectWriter writerFor(Manifest<T> evidence$20) {
                return ScalaObjectMapper.writerFor$((ScalaObjectMapper)this, evidence$20);
            }

            public <T> ObjectReader reader(Manifest<T> evidence$21) {
                return ScalaObjectMapper.reader$((ScalaObjectMapper)this, evidence$21);
            }

            public <T> ObjectReader readerFor(Manifest<T> evidence$22) {
                return ScalaObjectMapper.readerFor$((ScalaObjectMapper)this, evidence$22);
            }

            public <T> ObjectReader readerWithView(Manifest<T> evidence$23) {
                return ScalaObjectMapper.readerWithView$((ScalaObjectMapper)this, evidence$23);
            }

            public <T> T convertValue(Object fromValue, Manifest<T> evidence$24) {
                return (T)ScalaObjectMapper.convertValue$((ScalaObjectMapper)this, (Object)fromValue, evidence$24);
            }

            public <T> JsonSchema generateJsonSchema(Manifest<T> evidence$25) {
                return ScalaObjectMapper.generateJsonSchema$((ScalaObjectMapper)this, evidence$25);
            }

            public <T> void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, Manifest<T> evidence$26) {
                ScalaObjectMapper.acceptJsonFormatVisitor$((ScalaObjectMapper)this, (JsonFormatVisitorWrapper)visitor, evidence$26);
            }

            public Class<Map<?, ?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP() {
                return this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP;
            }

            public Class<Option<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION() {
                return this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION;
            }

            public Class<Iterable<?>> com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE() {
                return this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE;
            }

            public final void com$fasterxml$jackson$module$scala$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP_$eq(Class<Map<?, ?>> x$1) {
                this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$MAP = x$1;
            }

            public final void com$fasterxml$jackson$module$scala$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION_$eq(Class<Option<?>> x$1) {
                this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$OPTION = x$1;
            }

            public final void com$fasterxml$jackson$module$scala$ScalaObjectMapper$_setter_$com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE_$eq(Class<Iterable<?>> x$1) {
                this.com$fasterxml$jackson$module$scala$ScalaObjectMapper$$ITERABLE = x$1;
            }
            {
                ScalaObjectMapper.$init$((ScalaObjectMapper)this);
            }
        };
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        Seq jsonRebaseRecords = (Seq)((ScalaObjectMapper)mapper).readValue(file, ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(RebaseDateTime.JsonRebaseRecord.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        AnyRefMap anyRefMap = new AnyRefMap(3 * jsonRebaseRecords.size() / 2);
        jsonRebaseRecords.foreach((Function1 & Serializable & scala.Serializable)jsonRecord -> {
            RebaseDateTime$.$anonfun$loadRebaseRecords$1(anyRefMap, jsonRecord);
            return BoxedUnit.UNIT;
        });
        return anyRefMap;
    }

    private AnyRefMap<String, RebaseDateTime.RebaseInfo> gregJulianRebaseMap() {
        return this.gregJulianRebaseMap;
    }

    /*
     * WARNING - void declaration
     */
    private long getLastSwitchTs(AnyRefMap<String, RebaseDateTime.RebaseInfo> rebaseMap) {
        void var2_2;
        long latestTs = BoxesRunTime.unboxToLong((Object)((TraversableOnce)rebaseMap.values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)RebaseDateTime$.$anonfun$getLastSwitchTs$1(x$1)), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
        Predef$.MODULE$.require(rebaseMap.values().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RebaseDateTime$.$anonfun$getLastSwitchTs$2(x$2))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Differences between Julian and Gregorian calendar after ").append(DateTimeUtils$.MODULE$.microsToInstant(latestTs)).append(" ").append("are expected to be zero for all available time zones.").toString());
        return (long)var2_2;
    }

    public final long lastSwitchGregorianTs() {
        return this.lastSwitchGregorianTs;
    }

    private final LocalDateTime gregorianStartTs() {
        return this.gregorianStartTs;
    }

    private final LocalDateTime julianEndTs() {
        return this.julianEndTs;
    }

    public long rebaseGregorianToJulianMicros(ZoneId zoneId, long micros) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(micros);
        LocalDateTime ldt = instant.atZone(zoneId).toLocalDateTime();
        if (ldt.isAfter(this.julianEndTs()) && ldt.isBefore(this.gregorianStartTs())) {
            ldt = LocalDateTime.of(this.gregorianStartDate(), ldt.toLocalTime());
        }
        Calendar cal = new Calendar.Builder().setCalendarType("gregory").setDate(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth()).setTimeOfDay(ldt.getHour(), ldt.getMinute(), ldt.getSecond()).set(16, (int)zoneId.getRules().getDaylightSavings(instant).toMillis()).build();
        return DateTimeUtils$.MODULE$.fromMillis(cal.getTimeInMillis()) + (long)ldt.get(ChronoField.MICRO_OF_SECOND);
    }

    public long rebaseGregorianToJulianMicros(long micros) {
        long l;
        if (micros >= this.lastSwitchGregorianTs()) {
            l = micros;
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            String tzId = timeZone.getID();
            RebaseDateTime.RebaseInfo rebaseRecord = (RebaseDateTime.RebaseInfo)this.gregJulianRebaseMap().getOrNull((Object)tzId);
            l = rebaseRecord == null || micros < rebaseRecord.switches()[0] ? this.rebaseGregorianToJulianMicros(timeZone.toZoneId(), micros) : this.rebaseMicros(rebaseRecord, micros);
        }
        return l;
    }

    public long rebaseJulianToGregorianMicros(ZoneId zoneId, long micros) {
        Calendar cal = new Calendar.Builder().setCalendarType("gregory").setInstant(DateTimeUtils$.MODULE$.toMillis(micros)).build();
        LocalDateTime localDateTime = LocalDateTime.of(cal.get(1), cal.get(2) + 1, 1, cal.get(11), cal.get(12), cal.get(13), (int)(Math.floorMod(micros, 1000000L) * 1000L)).with(ChronoField.ERA, cal.get(0)).plusDays(cal.get(5) - 1);
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        ZonedDateTime adjustedZdt = cal.get(16) == 0 ? zonedDateTime.withLaterOffsetAtOverlap() : zonedDateTime;
        return DateTimeUtils$.MODULE$.instantToMicros(adjustedZdt.toInstant());
    }

    private AnyRefMap<String, RebaseDateTime.RebaseInfo> julianGregRebaseMap() {
        return this.julianGregRebaseMap;
    }

    public final long lastSwitchJulianTs() {
        return this.lastSwitchJulianTs;
    }

    public long rebaseJulianToGregorianMicros(long micros) {
        long l;
        if (micros >= this.lastSwitchJulianTs()) {
            l = micros;
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            String tzId = timeZone.getID();
            RebaseDateTime.RebaseInfo rebaseRecord = (RebaseDateTime.RebaseInfo)this.julianGregRebaseMap().getOrNull((Object)tzId);
            l = rebaseRecord == null || micros < rebaseRecord.switches()[0] ? this.rebaseJulianToGregorianMicros(timeZone.toZoneId(), micros) : this.rebaseMicros(rebaseRecord, micros);
        }
        return l;
    }

    public static final /* synthetic */ void $anonfun$loadRebaseRecords$1(AnyRefMap anyRefMap$1, RebaseDateTime.JsonRebaseRecord jsonRecord) {
        RebaseDateTime.RebaseInfo rebaseInfo = new RebaseDateTime.RebaseInfo(jsonRecord.switches(), jsonRecord.diffs());
        for (int i = 0; i < rebaseInfo.switches().length; ++i) {
            rebaseInfo.switches()[i] = rebaseInfo.switches()[i] * 1000000L;
            rebaseInfo.diffs()[i] = rebaseInfo.diffs()[i] * 1000000L;
        }
        anyRefMap$1.update((Object)jsonRecord.tz(), (Object)rebaseInfo);
    }

    public static final /* synthetic */ long $anonfun$getLastSwitchTs$1(RebaseDateTime.RebaseInfo x$1) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$1.switches())).last());
    }

    public static final /* synthetic */ boolean $anonfun$getLastSwitchTs$2(RebaseDateTime.RebaseInfo x$2) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$2.diffs())).last()) == 0L;
    }

    private RebaseDateTime$() {
        MODULE$ = this;
        this.julianGregDiffs = new int[]{2, 1, 0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, 0};
        this.julianGregDiffSwitchDay = new int[]{-719164, -682945, -646420, -609895, -536845, -500320, -463795, -390745, -354220, -317695, -244645, -208120, -171595, -141427};
        this.lastSwitchJulianDay = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.julianGregDiffSwitchDay())).last());
        this.julianCommonEraStartDay = this.julianGregDiffSwitchDay()[0];
        this.gregJulianDiffs = new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        this.gregJulianDiffSwitchDay = new int[]{-719162, -682944, -646420, -609896, -536847, -500323, -463799, -390750, -354226, -317702, -244653, -208129, -171605, -141436, -141435, -141434, -141433, -141432, -141431, -141430, -141429, -141428, -141427};
        this.lastSwitchGregorianDay = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.gregJulianDiffSwitchDay())).last());
        this.gregorianCommonEraStartDay = this.gregJulianDiffSwitchDay()[0];
        this.gregorianStartDate = LocalDate.of(1582, 10, 15);
        this.julianEndDate = LocalDate.of(1582, 10, 4);
        this.gregJulianRebaseMap = this.loadRebaseRecords("gregorian-julian-rebase-micros.json");
        this.lastSwitchGregorianTs = this.getLastSwitchTs(this.gregJulianRebaseMap());
        this.gregorianStartTs = LocalDateTime.of(this.gregorianStartDate(), LocalTime.MIDNIGHT);
        this.julianEndTs = LocalDateTime.of(this.julianEndDate(), LocalTime.of(23, 59, 59, 999999999));
        this.julianGregRebaseMap = this.loadRebaseRecords("julian-gregorian-rebase-micros.json");
        this.lastSwitchJulianTs = this.getLastSwitchTs(this.julianGregRebaseMap());
    }
}

