/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple7;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(years, months, weeks, days, hours, mins, secs) - Make interval from years, months, weeks, days, hours, mins and secs.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n      * weeks - the number of weeks, positive or negative\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(100, 11, 1, 1, 12, 30, 01.001001);\n       100 years 11 months 8 days 12 hours 30 minutes 1.001001 seconds\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n      > SELECT _FUNC_(0, 1, 0, 1, 0, 0, 100.000001);\n       1 months 1 days 1 minutes 40.000001 seconds\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\t=e\u0001B\u001a5\u0001\u0006C\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u0011q\u0003!Q3A\u0005\u0002MC\u0001\"\u0018\u0001\u0003\u0012\u0003\u0006I\u0001\u0016\u0005\t=\u0002\u0011)\u001a!C\u0001'\"Aq\f\u0001B\tB\u0003%A\u000b\u0003\u0005a\u0001\tU\r\u0011\"\u0001T\u0011!\t\u0007A!E!\u0002\u0013!\u0006\u0002\u00032\u0001\u0005+\u0007I\u0011A*\t\u0011\r\u0004!\u0011#Q\u0001\nQCQ\u0001\u001a\u0001\u0005\u0002\u0015DQ\u0001\u001a\u0001\u0005\u00029DQ\u0001\u001a\u0001\u0005\u0002UDQ\u0001\u001a\u0001\u0005\u0002mDa\u0001\u001a\u0001\u0005\u0002\u0005\u0005\u0001B\u00023\u0001\t\u0003\tI\u0001\u0003\u0004e\u0001\u0011\u0005\u0011q\u0002\u0005\u0007I\u0002!\t!a\u0005\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t9\u0006\u0001C!\u00033Bq!a!\u0001\t\u0003\n)\tC\u0004\u0002\"\u0002!\t%a)\t\u0013\u0005U\u0006!!A\u0005\u0002\u0005]\u0006\"CAd\u0001E\u0005I\u0011AAe\u0011%\ty\u000eAI\u0001\n\u0003\tI\rC\u0005\u0002b\u0002\t\n\u0011\"\u0001\u0002J\"I\u00111\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001a\u0005\n\u0003K\u0004\u0011\u0013!C\u0001\u0003\u0013D\u0011\"a:\u0001#\u0003%\t!!3\t\u0013\u0005%\b!%A\u0005\u0002\u0005%\u0007\"CAv\u0001\u0005\u0005I\u0011IAw\u0011%\ti\u0010AA\u0001\n\u0003\ty\u0010C\u0005\u0003\b\u0001\t\t\u0011\"\u0001\u0003\n!I!q\u0002\u0001\u0002\u0002\u0013\u0005#\u0011\u0003\u0005\n\u0005?\u0001\u0011\u0011!C\u0001\u0005CA\u0011B!\n\u0001\u0003\u0003%\tEa\n\b\u0013\t-C'!A\t\u0002\t5c\u0001C\u001a5\u0003\u0003E\tAa\u0014\t\r\u0011lC\u0011\u0001B/\u0011%\u0011y&LA\u0001\n\u000b\u0012\t\u0007C\u0005\u0003d5\n\t\u0011\"!\u0003f!I!QO\u0017\u0002\u0002\u0013\u0005%q\u000f\u0005\n\u0005\u000bk\u0013\u0011!C\u0005\u0005\u000f\u0013A\"T1lK&sG/\u001a:wC2T!!\u000e\u001c\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003oa\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003si\n1a]9m\u0015\tYD(A\u0003ta\u0006\u00148N\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<7\u0001A\n\u0006\u0001\t3\u0015j\u0014\t\u0003\u0007\u0012k\u0011\u0001N\u0005\u0003\u000bR\u00121cU3qi\u0016t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aQ$\n\u0005!#$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\u000fA\u0013x\u000eZ;diB\u0011!\nU\u0005\u0003#.\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQ!_3beN,\u0012\u0001\u0016\t\u0003\u0007VK!A\u0016\u001b\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004zK\u0006\u00148\u000fI\u0001\u0007[>tG\u000f[:\u0002\u000f5|g\u000e\u001e5tA\u0005)q/Z3lg\u00061q/Z3lg\u0002\nA\u0001Z1zg\u0006)A-Y=tA\u0005)\u0001n\\;sg\u00061\u0001n\\;sg\u0002\nA!\\5og\u0006)Q.\u001b8tA\u0005!1/Z2t\u0003\u0015\u0019XmY:!\u0003\u0019a\u0014N\\5u}QAam\u001a5jU.dW\u000e\u0005\u0002D\u0001!)!k\u0004a\u0001)\")\u0001l\u0004a\u0001)\")!l\u0004a\u0001)\")Al\u0004a\u0001)\")al\u0004a\u0001)\")\u0001m\u0004a\u0001)\")!m\u0004a\u0001)R9am\u001c9reN$\b\"\u0002*\u0011\u0001\u0004!\u0006\"\u0002-\u0011\u0001\u0004!\u0006\"\u0002.\u0011\u0001\u0004!\u0006\"\u0002/\u0011\u0001\u0004!\u0006\"\u00020\u0011\u0001\u0004!\u0006\"\u00021\u0011\u0001\u0004!FC\u00024wobL(\u0010C\u0003S#\u0001\u0007A\u000bC\u0003Y#\u0001\u0007A\u000bC\u0003[#\u0001\u0007A\u000bC\u0003]#\u0001\u0007A\u000bC\u0003_#\u0001\u0007A\u000bF\u0003gyvtx\u0010C\u0003S%\u0001\u0007A\u000bC\u0003Y%\u0001\u0007A\u000bC\u0003[%\u0001\u0007A\u000bC\u0003]%\u0001\u0007A\u000bF\u0004g\u0003\u0007\t)!a\u0002\t\u000bI\u001b\u0002\u0019\u0001+\t\u000ba\u001b\u0002\u0019\u0001+\t\u000bi\u001b\u0002\u0019\u0001+\u0015\u000b\u0019\fY!!\u0004\t\u000bI#\u0002\u0019\u0001+\t\u000ba#\u0002\u0019\u0001+\u0015\u0007\u0019\f\t\u0002C\u0003S+\u0001\u0007A\u000bF\u0001g\u0003!\u0019\u0007.\u001b7ee\u0016tWCAA\r!\u0015\tY\"a\u000bU\u001d\u0011\ti\"a\n\u000f\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tA\u0003\u0019a$o\\8u}%\tA*C\u0002\u0002*-\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002.\u0005=\"aA*fc*\u0019\u0011\u0011F&\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u00026A1\u00111DA\u0016\u0003o\u0001B!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{A\u0014!\u0002;za\u0016\u001c\u0018\u0002BA!\u0003w\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0012\u0011\t\u0005e\u0012\u0011J\u0005\u0005\u0003\u0017\nYD\u0001\u0005ECR\fG+\u001f9f\u0003!qW\u000f\u001c7bE2,WCAA)!\rQ\u00151K\u0005\u0004\u0003+Z%a\u0002\"p_2,\u0017M\\\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0011\u00037\n\t'!\u001a\u0002j\u00055\u0014\u0011OA;\u0003s\u00022ASA/\u0013\r\tyf\u0013\u0002\u0004\u0003:L\bbBA27\u0001\u0007\u00111L\u0001\u0005s\u0016\f'\u000fC\u0004\u0002hm\u0001\r!a\u0017\u0002\u000b5|g\u000e\u001e5\t\u000f\u0005-4\u00041\u0001\u0002\\\u0005!q/Z3l\u0011\u001d\tyg\u0007a\u0001\u00037\n1\u0001Z1z\u0011\u001d\t\u0019h\u0007a\u0001\u00037\nA\u0001[8ve\"9\u0011qO\u000eA\u0002\u0005m\u0013aA7j]\"9\u00111P\u000eA\u0002\u0005u\u0014aA:fGB)!*a \u0002\\%\u0019\u0011\u0011Q&\u0003\r=\u0003H/[8o\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\b\u0006M\u0015Q\u0014\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u001b\u0002\u000f\r|G-Z4f]&!\u0011\u0011SAF\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBAK9\u0001\u0007\u0011qS\u0001\u0004GRD\b\u0003BAE\u00033KA!a'\u0002\f\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBAP9\u0001\u0007\u0011qQ\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\t)\u000b\u0005\u0003\u0002(\u0006=f\u0002BAU\u0003W\u00032!a\bL\u0013\r\tikS\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00161\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u000556*\u0001\u0003d_BLHc\u00044\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019-!2\t\u000fIs\u0002\u0013!a\u0001)\"9\u0001L\bI\u0001\u0002\u0004!\u0006b\u0002.\u001f!\u0003\u0005\r\u0001\u0016\u0005\b9z\u0001\n\u00111\u0001U\u0011\u001dqf\u0004%AA\u0002QCq\u0001\u0019\u0010\u0011\u0002\u0003\u0007A\u000bC\u0004c=A\u0005\t\u0019\u0001+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u001a\u0016\u0004)\u000657FAAh!\u0011\t\t.a7\u000e\u0005\u0005M'\u0002BAk\u0003/\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e7*\u0001\u0006b]:|G/\u0019;j_:LA!!8\u0002T\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003_\u0004B!!=\u0002|6\u0011\u00111\u001f\u0006\u0005\u0003k\f90\u0001\u0003mC:<'BAA}\u0003\u0011Q\u0017M^1\n\t\u0005E\u00161_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u0003\u00012A\u0013B\u0002\u0013\r\u0011)a\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00037\u0012Y\u0001C\u0005\u0003\u000e!\n\t\u00111\u0001\u0003\u0002\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0005\u0011\r\tU!1DA.\u001b\t\u00119BC\u0002\u0003\u001a-\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iBa\u0006\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\u0012\u0019\u0003C\u0005\u0003\u000e)\n\t\u00111\u0001\u0002\\\u00051Q-];bYN$B!!\u0015\u0003*!I!QB\u0016\u0002\u0002\u0003\u0007\u00111\f\u0015\u0014\u0001\t5\"1\u0007B\u001b\u0005s\u0011YDa\u0010\u0003B\t\u0015#q\t\t\u0004\u0007\n=\u0012b\u0001B\u0019i\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u001c\u0003q|f)\u0016(D?\"JX-\u0019:tY\u0001jwN\u001c;ig2\u0002s/Z3lg2\u0002C-Y=tY\u0001Bw.\u001e:tY\u0001j\u0017N\\:-AM,7m]\u0015![\u0001j\u0015m[3!S:$XM\u001d<bY\u00022'o\\7!s\u0016\f'o\u001d\u0017![>tG\u000f[:-A],Wm[:-A\u0011\f\u0017p\u001d\u0017!Q>,(o\u001d\u0017![&t7\u000fI1oI\u0002\u001aXmY:/\u0003%\t'oZ;nK:$8/\t\u0002\u0003>\u0005\u0019yI\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!s\u0016\f'o\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gAe,\u0017M]:-AA|7/\u001b;jm\u0016\u0004sN\u001d\u0011oK\u001e\fG/\u001b<f\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001jwN\u001c;ig\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007%\\8oi\"\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011xK\u0016\\7\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!o\u0016,7n\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011\f\u0017p\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gA\u0011\f\u0017p\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+A!|WO]:![\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002Bw.\u001e:tY\u0001\u0002xn]5uSZ,\u0007e\u001c:!]\u0016<\u0017\r^5wK*\u0001\u0003\u0005\t\u0011!A)\u0002S.\u001b8tA5\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u0004S.\u001b8vi\u0016\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u000e\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011tK\u000e|g\u000eZ:!o&$\b\u000e\t;iK\u00022'/Y2uS>t\u0017\r\u001c\u0011qCJ$\b%\u001b8![&\u001c'o\\:fG>tG\r\t9sK\u000eL7/[8o])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\u0019%\u0001B+\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0004\u0007\r\u0017!cEb\u0003%\r\u0017!c1\u0002\u0013G\r\u0017!gAb\u0003\u0005M\u0019/aA\n\u0004\u0007M\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0004\u0007\r\u0011zK\u0006\u00148\u000fI\u00192A5|g\u000e\u001e5tAa\u0002C-Y=tAE\u0012\u0004\u0005[8veN\u00043\u0007\r\u0011nS:,H/Z:!c9\u0002\u0004'\r\u00191c\u0001\u001aXmY8oINT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u00191Y\u0001rW\u000f\u001c7-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\r\u0017!c1\u0002\u0003\u0007\f\u00112Y\u0001\u0002D\u0006\t\u0019-AE\u0002\u0004G\f\u00191aA\u0002\u0014'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c\u0001jwN\u001c;ig\u0002\n\u0004\u0005Z1zg\u0002\n\u0004%\\5okR,7\u000f\t\u001b1]A\u0002\u0004\u0007\r\u00192AM,7m\u001c8eg*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003J\u0005)1G\f\u0019/a\u0005aQ*Y6f\u0013:$XM\u001d<bYB\u00111)L\n\u0005[\tEs\n\u0005\u0007\u0003T\teC\u000b\u0016+U)R#f-\u0004\u0002\u0003V)\u0019!qK&\u0002\u000fI,h\u000e^5nK&!!1\fB+\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\u000e\u000b\u0003\u0005\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003_\fQ!\u00199qYf$rB\u001aB4\u0005S\u0012YG!\u001c\u0003p\tE$1\u000f\u0005\u0006%B\u0002\r\u0001\u0016\u0005\u00061B\u0002\r\u0001\u0016\u0005\u00065B\u0002\r\u0001\u0016\u0005\u00069B\u0002\r\u0001\u0016\u0005\u0006=B\u0002\r\u0001\u0016\u0005\u0006AB\u0002\r\u0001\u0016\u0005\u0006EB\u0002\r\u0001V\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IH!!\u0011\u000b)\u000byHa\u001f\u0011\u0015)\u0013i\b\u0016+U)R#F+C\u0002\u0003\u0000-\u0013a\u0001V;qY\u0016<\u0004\u0002\u0003BBc\u0005\u0005\t\u0019\u00014\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001BE!\u0011\t\tPa#\n\t\t5\u00151\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class MakeInterval
extends SeptenaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression years;
    private final Expression months;
    private final Expression weeks;
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;

    public static Option<Tuple7<Expression, Expression, Expression, Expression, Expression, Expression, Expression>> unapply(MakeInterval makeInterval) {
        return MakeInterval$.MODULE$.unapply(makeInterval);
    }

    public static Function1<Tuple7<Expression, Expression, Expression, Expression, Expression, Expression, Expression>, MakeInterval> tupled() {
        return MakeInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, MakeInterval>>>>>>> curried() {
        return MakeInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    public Expression weeks() {
        return this.weeks;
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.years(), this.months(), this.weeks(), this.days(), this.hours(), this.mins(), this.secs()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)}));
    }

    @Override
    public DataType dataType() {
        return CalendarIntervalType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object week, Object day, Object hour, Object min, Option<Object> sec) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = IntervalUtils$.MODULE$.makeInterval(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)week), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec.map((Function1 & Serializable & scala.Serializable)x$1 -> (Decimal)x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
        }
        catch (ArithmeticException arithmeticException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable & scala.Serializable)(year, month, week, day, hour, min, sec) -> {
            String iu = new StringOps(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            String secFrac = (String)sec.getOrElse((Function0 & Serializable & scala.Serializable)() -> "0");
            return new StringBuilder(144).append("\n        try {\n          ").append(ev.value()).append(" = ").append(iu).append(".makeInterval(").append((String)year).append(", ").append((String)month).append(", ").append((String)week).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", ").append(secFrac).append(");\n        } catch (java.lang.ArithmeticException e) {\n          ").append(ev.isNull()).append(" = true;\n        }\n      ").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_interval";
    }

    public MakeInterval copy(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs) {
        return new MakeInterval(years, months, weeks, days, hours, mins, secs);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    public Expression copy$default$3() {
        return this.weeks();
    }

    public Expression copy$default$4() {
        return this.days();
    }

    public Expression copy$default$5() {
        return this.hours();
    }

    public Expression copy$default$6() {
        return this.mins();
    }

    public Expression copy$default$7() {
        return this.secs();
    }

    @Override
    public String productPrefix() {
        return "MakeInterval";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.years();
                break;
            }
            case 1: {
                expression = this.months();
                break;
            }
            case 2: {
                expression = this.weeks();
                break;
            }
            case 3: {
                expression = this.days();
                break;
            }
            case 4: {
                expression = this.hours();
                break;
            }
            case 5: {
                expression = this.mins();
                break;
            }
            case 6: {
                expression = this.secs();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeInterval makeInterval = (MakeInterval)x$1;
        Expression expression = this.years();
        Expression expression2 = makeInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.weeks();
        Expression expression6 = makeInterval.weeks();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.days();
        Expression expression8 = makeInterval.days();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.hours();
        Expression expression10 = makeInterval.hours();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.mins();
        Expression expression12 = makeInterval.mins();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Expression expression13 = this.secs();
        Expression expression14 = makeInterval.secs();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        if (!makeInterval.canEqual(this)) return false;
        return true;
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        ExpectsInputTypes.$init$(this);
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins) {
        this(years, months, weeks, days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours) {
        this(years, months, weeks, days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days) {
        this(years, months, weeks, days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks) {
        this(years, months, weeks, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months) {
        this(years, months, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

