/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Slice$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(x, start, length) - Subsets array x starting from index start (array indices start at 1, or starting from the end if start is negative) with the specified length.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 2, 2);\n       [2,3]\n      > SELECT _FUNC_(array(1, 2, 3, 4), -2, 2);\n       [3,4]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u0011\"\u0001:B\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011!9\u0005A!f\u0001\n\u0003\u0001\u0005\u0002\u0003%\u0001\u0005#\u0005\u000b\u0011B!\t\u000b%\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000b]\u0003A\u0011\t-\t\u0011!\u0004\u0001R1A\u0005B%D\u0001b\u001c\u0001\t\u0006\u0004%I\u0001\u0015\u0005\u0006c\u0002!\tE\u001d\u0005\u0006y\u0002!\t% \u0005\b\u0003/\u0001A\u0011AA\r\u0011%\tY\u0004AA\u0001\n\u0003\ti\u0004C\u0005\u0002F\u0001\t\n\u0011\"\u0001\u0002H!I\u0011Q\f\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003\u000fB\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\t)\tAA\u0001\n\u0003\n9\tC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0001\u0002\u0018\"I\u0011\u0011\u0015\u0001\u0002\u0002\u0013\u0005\u00131U\u0004\n\u0003\u000f\f\u0013\u0011!E\u0001\u0003\u00134\u0001\u0002I\u0011\u0002\u0002#\u0005\u00111\u001a\u0005\u0007\u0013j!\t!!7\t\u0013\u0005m'$!A\u0005F\u0005u\u0007\"CAp5\u0005\u0005I\u0011QAq\u0011%\tIOGA\u0001\n\u0003\u000bY\u000fC\u0005\u0002~j\t\t\u0011\"\u0003\u0002\u0000\n)1\u000b\\5dK*\u0011!eI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002%K\u0005A1-\u0019;bYf\u001cHO\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001_M2D\b\u0005\u00021c5\t\u0011%\u0003\u00023C\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005A\"\u0014BA\u001b\"\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$a\u0002)s_\u0012,8\r\u001e\t\u0003ouJ!A\u0010\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0003a,\u0012!\u0011\t\u0003a\tK!aQ\u0011\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0002yA\u0005)1\u000f^1si\u000611\u000f^1si\u0002\na\u0001\\3oORD\u0017a\u00027f]\u001e$\b\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t-cUJ\u0014\t\u0003a\u0001AQaP\u0004A\u0002\u0005CQ!R\u0004A\u0002\u0005CQaR\u0004A\u0002\u0005\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011A+J\u0001\u0006if\u0004Xm]\u0005\u0003-N\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A-\u0011\u0007i\u0013WM\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011a,L\u0001\u0007yI|w\u000e\u001e \n\u0003eJ!!\u0019\u001d\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0004'\u0016\f(BA19!\t\u0011f-\u0003\u0002h'\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tG\"LG\u000e\u001a:f]V\t!\u000eE\u0002[E\u0006C#A\u00037\u0011\u0005]j\u0017B\u000189\u0005%!(/\u00198tS\u0016tG/A\u0006fY\u0016lWM\u001c;UsB,\u0007FA\u0006m\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\u0019h\u000f\u001f>\u0011\u0005]\"\u0018BA;9\u0005\r\te.\u001f\u0005\u0006o2\u0001\ra]\u0001\u0005qZ\u000bG\u000eC\u0003z\u0019\u0001\u00071/\u0001\u0005ti\u0006\u0014HOV1m\u0011\u0015YH\u00021\u0001t\u0003%aWM\\4uQZ\u000bG.A\u0005e_\u001e+gnQ8eKR)a0!\u0003\u0002\u0014A\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002C\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0004\u0003\u0003\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u0017i\u0001\u0019AA\u0007\u0003\r\u0019G\u000f\u001f\t\u0004\u007f\u0006=\u0011\u0002BA\t\u0003\u0003\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u00165\u0001\rA`\u0001\u0003KZ\f\u0001cZ3o\u0007>$WMR8s%\u0016\u001cX\u000f\u001c;\u0015\u0019\u0005m\u00111FA\u0017\u0003_\t\u0019$a\u000e\u0011\t\u0005u\u0011Q\u0005\b\u0005\u0003?\t\t\u0003\u0005\u0002]q%\u0019\u00111\u0005\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t9#!\u000b\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u0003\u000f\u0005\b\u0003\u0017q\u0001\u0019AA\u0007\u0011\u0019\t)B\u0004a\u0001}\"9\u0011\u0011\u0007\bA\u0002\u0005m\u0011AC5oaV$\u0018I\u001d:bs\"9\u0011Q\u0007\bA\u0002\u0005m\u0011\u0001C:uCJ$\u0018\n\u001a=\t\u000f\u0005eb\u00021\u0001\u0002\u001c\u0005I!/Z:MK:<G\u000f[\u0001\u0005G>\u0004\u0018\u0010F\u0004L\u0003\u007f\t\t%a\u0011\t\u000f}z\u0001\u0013!a\u0001\u0003\"9Qi\u0004I\u0001\u0002\u0004\t\u0005bB$\u0010!\u0003\u0005\r!Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIEK\u0002B\u0003\u0017Z#!!\u0014\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003/B\u0014AC1o]>$\u0018\r^5p]&!\u00111LA)\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nA\u0001\\1oO*\u0011\u0011qN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0005%\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA<!\r9\u0014\u0011P\u0005\u0004\u0003wB$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA:\u0002\u0002\"I\u00111Q\u000b\u0002\u0002\u0003\u0007\u0011qO\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\u0005#BAF\u0003#\u001bXBAAG\u0015\r\ty\tO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAJ\u0003\u001b\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011TAP!\r9\u00141T\u0005\u0004\u0003;C$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0007;\u0012\u0011!a\u0001g\u00061Q-];bYN$B!!'\u0002&\"A\u00111\u0011\r\u0002\u0002\u0003\u00071\u000fK\n\u0001\u0003S\u000by+!-\u00026\u0006]\u00161XA_\u0003\u0003\f\u0019\rE\u00021\u0003WK1!!,\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a-\u0002\u0003'zf)\u0016(D?\"BH\u0006I:uCJ$H\u0006\t7f]\u001e$\b.\u000b\u0011.AM+(m]3ug\u0002\n'O]1zAa\u00043\u000f^1si&tw\r\t4s_6\u0004\u0013N\u001c3fq\u0002\u001aH/\u0019:uA!\n'O]1zA%tG-[2fg\u0002\u001aH/\u0019:uA\u0005$\b%\r\u0017!_J\u00043\u000f^1si&tw\r\t4s_6\u0004C\u000f[3!K:$\u0007%\u001b4!gR\f'\u000f\u001e\u0011jg\u0002rWmZ1uSZ,\u0017\u0006I<ji\"\u0004C\u000f[3!gB,7-\u001b4jK\u0012\u0004C.\u001a8hi\"t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0016!!\u0007\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114Y\u0001\"\u0014\u0006\f\u00113Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\e1\u001aTL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003e\r\u0017!i%b\u0003%\f\u001a-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.4YQj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005}\u0016aC1se\u0006LxLZ;oGN\fQa]5oG\u0016\f#!!2\u0002\u000bIrCG\f\u0019\u0002\u000bMc\u0017nY3\u0011\u0005AR2\u0003\u0002\u000e\u0002Nr\u0002\u0002\"a4\u0002V\u0006\u000b\u0015iS\u0007\u0003\u0003#T1!a59\u0003\u001d\u0011XO\u001c;j[\u0016LA!a6\u0002R\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005%\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0014!B1qa2LHcB&\u0002d\u0006\u0015\u0018q\u001d\u0005\u0006\u007fu\u0001\r!\u0011\u0005\u0006\u000bv\u0001\r!\u0011\u0005\u0006\u000fv\u0001\r!Q\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti/!?\u0011\u000b]\ny/a=\n\u0007\u0005E\bH\u0001\u0004PaRLwN\u001c\t\u0007o\u0005U\u0018)Q!\n\u0007\u0005]\bH\u0001\u0004UkBdWm\r\u0005\t\u0003wt\u0012\u0011!a\u0001\u0017\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0003\u0001B!a\u001a\u0003\u0004%!!QAA5\u0005\u0019y%M[3di\u0002")
public class Slice
extends TernaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Seq<Expression> children;
    private transient DataType elementType;
    private final Expression x;
    private final Expression start;
    private final Expression length;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Slice slice) {
        return Slice$.MODULE$.unapply(slice);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Slice> tupled() {
        return Slice$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Slice>>> curried() {
        return Slice$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression x() {
        return this.x;
    }

    public Expression start() {
        return this.start;
    }

    public Expression length() {
        return this.length;
    }

    @Override
    public DataType dataType() {
        return this.x().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    private Seq<Expression> children$lzycompute() {
        Slice slice = this;
        synchronized (slice) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.children = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.x(), this.start(), this.length()}));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.children;
    }

    @Override
    public Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.children$lzycompute() : this.children;
    }

    private DataType elementType$lzycompute() {
        Slice slice = this;
        synchronized (slice) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementType = ((ArrayType)this.x().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Object nullSafeEval(Object xVal, Object startVal, Object lengthVal) {
        int startIndex;
        int startInt = BoxesRunTime.unboxToInt((Object)startVal);
        int lengthInt = BoxesRunTime.unboxToInt((Object)lengthVal);
        ArrayData arr = (ArrayData)xVal;
        if (startInt == 0) {
            throw new RuntimeException(new StringBuilder(70).append("Unexpected value for start in function ").append(this.prettyName()).append(": SQL array indices start at 1.").toString());
        }
        int n = startIndex = startInt < 0 ? startInt + arr.numElements() : startInt - 1;
        if (lengthInt < 0) {
            throw new RuntimeException(new StringBuilder(84).append("Unexpected value for length in function ").append(this.prettyName()).append(": ").append("length must be greater than or equal to 0.").toString());
        }
        if (startIndex < 0 || startIndex >= arr.numElements()) {
            return new GenericArrayData(Array$.MODULE$.empty(ClassTag$.MODULE$.AnyRef()));
        }
        IndexedSeq data = arr.toSeq(this.elementType());
        return new GenericArrayData((Seq<Object>)((Seq)data.slice(startIndex, startIndex + lengthInt)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(x, start, length) -> {
            String startIdx = ctx.freshName("startIdx");
            String resLength = ctx.freshName("resLength");
            String defaultIntValue = CodeGenerator$.MODULE$.defaultValue("int", false);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(684).append("\n         |").append("int").append(" ").append(startIdx).append(" = ").append(defaultIntValue).append(";\n         |").append("int").append(" ").append(resLength).append(" = ").append(defaultIntValue).append(";\n         |if (").append((String)start).append(" == 0) {\n         |  throw new RuntimeException(\"Unexpected value for start in function ").append(this.prettyName()).append(": \"\n         |    + \"SQL array indices start at 1.\");\n         |} else if (").append((String)start).append(" < 0) {\n         |  ").append(startIdx).append(" = ").append((String)start).append(" + ").append((String)x).append(".numElements();\n         |} else {\n         |  // arrays in SQL are 1-based instead of 0-based\n         |  ").append(startIdx).append(" = ").append((String)start).append(" - 1;\n         |}\n         |if (").append((String)length).append(" < 0) {\n         |  throw new RuntimeException(\"Unexpected value for length in function ").append(this.prettyName()).append(": \"\n         |    + \"length must be greater than or equal to 0.\");\n         |} else if (").append((String)length).append(" > ").append((String)x).append(".numElements() - ").append(startIdx).append(") {\n         |  ").append(resLength).append(" = ").append((String)x).append(".numElements() - ").append(startIdx).append(";\n         |} else {\n         |  ").append(resLength).append(" = ").append((String)length).append(";\n         |}\n         |").append(this.genCodeForResult(ctx, ev, (String)x, startIdx, resLength)).append("\n       ").toString())).stripMargin();
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String startIdx, String resLength) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String genericArrayData = GenericArrayData.class.getName();
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, i, new StringBuilder(3).append(i).append(" + ").append(startIdx).toString(), ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("\n       |if (").append(startIdx).append(" < 0 || ").append(startIdx).append(" >= ").append(inputArray).append(".numElements()) {\n       |  ").append(ev.value()).append(" = new ").append(genericArrayData).append("(new Object[0]);\n       |} else {\n       |  ").append(allocation).append("\n       |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(resLength).append("; ").append(i).append(" ++) {\n       |    ").append(assignment).append("\n       |  }\n       |  ").append(ev.value()).append(" = ").append(values).append(";\n       |}\n     ").toString())).stripMargin();
    }

    public Slice copy(Expression x, Expression start, Expression length) {
        return new Slice(x, start, length);
    }

    public Expression copy$default$1() {
        return this.x();
    }

    public Expression copy$default$2() {
        return this.start();
    }

    public Expression copy$default$3() {
        return this.length();
    }

    @Override
    public String productPrefix() {
        return "Slice";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.x();
                break;
            }
            case 1: {
                expression = this.start();
                break;
            }
            case 2: {
                expression = this.length();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Slice;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Slice)) return false;
        boolean bl = true;
        if (!bl) return false;
        Slice slice = (Slice)x$1;
        Expression expression = this.x();
        Expression expression2 = slice.x();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.start();
        Expression expression4 = slice.start();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.length();
        Expression expression6 = slice.length();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!slice.canEqual(this)) return false;
        return true;
    }

    public Slice(Expression x, Expression start, Expression length) {
        this.x = x;
        this.start = start;
        this.length = length;
        ExpectsInputTypes.$init$(this);
    }
}

