/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array((map('a', 1))));\n       [{\"a\":1}]\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u0015+\u0001^B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\tC\u0002\u0011\t\u0012)A\u0005'\"A!\r\u0001BK\u0002\u0013\u00051\r\u0003\u0005h\u0001\tE\t\u0015!\u0003e\u0011!A\u0007A!f\u0001\n\u0003I\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011\u00026\t\u000b9\u0004A\u0011A8\t\u000bQ\u0004A\u0011I;\t\u000b9\u0004A\u0011A=\t\u000b9\u0004A\u0011\u0001?\t\u000b9\u0004A\u0011\u0001@\t\u0015\u0005\r\u0001\u0001#b\u0001\n\u0003\t)\u0001\u0003\u0006\u0002 \u0001A)\u0019!C\u0001\u0003CA!\"!\r\u0001\u0011\u000b\u0007I\u0011AA\u001a\u0011)\t\u0019\u0005\u0001EC\u0002\u0013\u0005\u0011Q\t\u0005\b\u0003G\u0002A\u0011IA\u001a\u0011\u001d\t)\u0007\u0001C!\u0003OBq!!\u001e\u0001\t\u0003\n9\bC\u0004\u0002|\u0001!\t%! \t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006\"CAR\u0001\u0005\u0005I\u0011AAS\u0011%\ti\u000bAI\u0001\n\u0003\ty\u000bC\u0005\u0002F\u0002\t\n\u0011\"\u0001\u0002H\"I\u00111\u001a\u0001\u0012\u0002\u0013\u0005\u0011Q\u001a\u0005\n\u0003#\u0004\u0011\u0011!C!\u0003'D\u0011\"a8\u0001\u0003\u0003%\t!!9\t\u0013\u0005%\b!!A\u0005\u0002\u0005-\b\"CAy\u0001\u0005\u0005I\u0011IAz\u0011%\u0011\t\u0001AA\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003\b\u0001\t\t\u0011\"\u0011\u0003\n\u001dI!Q\u0006\u0016\u0002\u0002#\u0005!q\u0006\u0004\tS)\n\t\u0011#\u0001\u00032!1a.\tC\u0001\u0005\u007fA\u0011B!\u0011\"\u0003\u0003%)Ea\u0011\t\u0013\t\u0015\u0013%!A\u0005\u0002\n\u001d\u0003\"\u0003B(CE\u0005I\u0011AAg\u0011%\u0011\t&IA\u0001\n\u0003\u0013\u0019\u0006C\u0005\u0003b\u0005\n\n\u0011\"\u0001\u0002N\"I!1M\u0011\u0002\u0002\u0013%!Q\r\u0002\u000e'R\u0014Xo\u0019;t)>T5o\u001c8\u000b\u0005-b\u0013aC3yaJ,7o]5p]NT!!\f\u0018\u0002\u0011\r\fG/\u00197zgRT!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u001d=\u007f\u0015Ce\n\u0005\u0002:u5\t!&\u0003\u0002<U\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002:{%\u0011aH\u000b\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0016\u0002\u000f\r|G-Z4f]&\u0011A)\u0011\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011\u0011HR\u0005\u0003\u000f*\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u001d\u0001&o\u001c3vGR\u0004\"!S(\n\u0005AS%\u0001D*fe&\fG.\u001b>bE2,\u0017aB8qi&|gn]\u000b\u0002'B!Ak\u00170_\u001d\t)\u0016\f\u0005\u0002W\u00156\tqK\u0003\u0002Ym\u00051AH]8pizJ!A\u0017&\u0002\rA\u0013X\rZ3g\u0013\taVLA\u0002NCBT!A\u0017&\u0011\u0005Q{\u0016B\u00011^\u0005\u0019\u0019FO]5oO\u0006Aq\u000e\u001d;j_:\u001c\b%A\u0003dQ&dG-F\u0001e!\tIT-\u0003\u0002gU\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002UB\u0019\u0011j\u001b0\n\u00051T%AB(qi&|g.A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003qcJ\u001c\bCA\u001d\u0001\u0011\u0015\tv\u00011\u0001T\u0011\u0015\u0011w\u00011\u0001e\u0011\u001dAw\u0001%AA\u0002)\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002mB\u0011\u0011j^\u0005\u0003q*\u0013qAQ8pY\u0016\fg\u000eF\u0002qunDQ!U\u0005A\u0002MCQAY\u0005A\u0002\u0011$\"\u0001]?\t\u000b\tT\u0001\u0019\u00013\u0015\tA|\u0018\u0011\u0001\u0005\u0006E.\u0001\r\u0001\u001a\u0005\u0006#.\u0001\r\u0001Z\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0003S>T!!!\u0005\u0002\t)\fg/Y\u0005\u0005\u0003+\tYAA\bDQ\u0006\u0014\u0018I\u001d:bs^\u0013\u0018\u000e^3sQ\ra\u0011\u0011\u0004\t\u0004\u0013\u0006m\u0011bAA\u000f\u0015\nIAO]1og&,g\u000e^\u0001\u0004O\u0016tWCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015Y\u0005!!n]8o\u0013\u0011\ti#a\n\u0003!)\u000b7m[:p]\u001e+g.\u001a:bi>\u0014\bfA\u0007\u0002\u001a\u0005Y\u0011N\u001c9viN\u001b\u0007.Z7b+\t\t)\u0004\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tYDL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u007f\tID\u0001\u0005ECR\fG+\u001f9fQ\rq\u0011\u0011D\u0001\nG>tg/\u001a:uKJ,\"!a\u0012\u0011\u000f%\u000bI%!\u0014\u0002T%\u0019\u00111\n&\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA%\u0002P%\u0019\u0011\u0011\u000b&\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002V\u0005uSBAA,\u0015\u0011\tY$!\u0017\u000b\u0007\u0005m\u0003'\u0001\u0004v]N\fg-Z\u0005\u0005\u0003?\n9F\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3aDA\r\u0003!!\u0017\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8Y\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002t\u00055$a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007q\nI\bC\u0003i%\u0001\u0007a,\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002N\u0005}\u0004bBAA'\u0001\u0007\u0011QJ\u0001\u0006m\u0006dW/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAD!\u0019\tI)a%\u0002\u001a:!\u00111RAH\u001d\r1\u0016QR\u0005\u0002\u0017&\u0019\u0011\u0011\u0013&\u0002\u000fA\f7m[1hK&!\u0011QSAL\u0005\r\u0019V-\u001d\u0006\u0004\u0003#S\u0005\u0003BA\u001c\u00037KA!!(\u0002:\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#\u00010\u0002\t\r|\u0007/\u001f\u000b\ba\u0006\u001d\u0016\u0011VAV\u0011\u001d\tf\u0003%AA\u0002MCqA\u0019\f\u0011\u0002\u0003\u0007A\rC\u0004i-A\u0005\t\u0019\u00016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0017\u0016\u0004'\u0006M6FAA[!\u0011\t9,!1\u000e\u0005\u0005e&\u0002BA^\u0003{\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}&*\u0001\u0006b]:|G/\u0019;j_:LA!a1\u0002:\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001a\u0016\u0004I\u0006M\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001fT3A[AZ\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*!\u00111\\A\b\u0003\u0011a\u0017M\\4\n\u0007\u0001\fI.\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002dB\u0019\u0011*!:\n\u0007\u0005\u001d(JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002N\u00055\b\"CAx9\u0005\u0005\t\u0019AAr\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001f\t\u0007\u0003o\fi0!\u0014\u000e\u0005\u0005e(bAA~\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0018\u0011 \u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002w\u0005\u000bA\u0011\"a<\u001f\u0003\u0003\u0005\r!!\u0014\u0002\r\u0015\fX/\u00197t)\r1(1\u0002\u0005\n\u0003_|\u0012\u0011!a\u0001\u0003\u001bB3\u0003\u0001B\b\u0005+\u00119Ba\u0007\u0003\u001e\t\u0005\"1\u0005B\u0014\u0005S\u00012!\u000fB\t\u0013\r\u0011\u0019B\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011I\"A%`\rVs5i\u0018\u0015fqB\u00148\f\f\u0011paRLwN\\:^S\u0001j\u0003EU3ukJt7\u000fI1!\u0015N{e\nI:ue&tw\rI<ji\"\u0004\u0013\rI4jm\u0016t\u0007e\u001d;sk\u000e$\bE^1mk\u0016\f\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005?\tAq\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)]\u0006lW\rZ0tiJ,8\r\u001e\u0015(C\u001eb\u0003%\r\u0017!O\t<C\u0006\t\u001a*SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#uEb#E\u0019\u0012;euT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\\1nK\u0012|6\u000f\u001e:vGRDs\u0005^5nK\u001eb\u0003\u0005^8`i&lWm\u001d;b[BDsE\r\u00192k5\u0002\u0004(\f\u001a7O1\u0002s%_=zs6jU*\f3eO%JC\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(\u0005^5nK\nR$E\r\u001c0aaz#\u0007M\u00196EuT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDc.Y7fI~\u001bHO];di\":\u0013m\n\u0017!c1\u0002sEY\u0014-AIJ\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7n\u0014\u0013M\t\u001e2Y\t\u0012'E\u000f\u001a~;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)O\u0005<C\u0006\t8b[\u0016$wl\u001d;sk\u000e$\bf\n2(Y\u0001\n\u0014&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e|E\t\u0014#(M?~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j\u0017\r\u001d\u0015oC6,GmX:ueV\u001cG\u000fK\u0014bO1\u0002\u0013'\u000b\u0017oC6,GmX:ueV\u001cG\u000fK\u0014cO1\u0002#'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(eW\u0019^EiZ(E\u0019\u0012;eul(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK7ba\":\u0013m\n\u0017!c%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014' \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015)[\u0006\u0004\bfJ1(Y\u0001\n\u0014&K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI1#uEjXL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011)#\u0001\u0006kg>twLZ;oGN\fQa]5oG\u0016\f#Aa\u000b\u0002\u000bIr#G\f\u0019\u0002\u001bM#(/^2ugR{'j]8o!\tI\u0014e\u0005\u0003\"\u0005gq\u0005\u0003\u0003B\u001b\u0005w\u0019FM\u001b9\u000e\u0005\t]\"b\u0001B\u001d\u0015\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u001f\u0005o\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0011y#\u0001\u0005u_N#(/\u001b8h)\t\t).A\u0003baBd\u0017\u0010F\u0004q\u0005\u0013\u0012YE!\u0014\t\u000bE#\u0003\u0019A*\t\u000b\t$\u0003\u0019\u00013\t\u000f!$\u0003\u0013!a\u0001U\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tU#Q\f\t\u0005\u0013.\u00149\u0006\u0005\u0004J\u00053\u001aFM[\u0005\u0004\u00057R%A\u0002+va2,7\u0007\u0003\u0005\u0003`\u0019\n\t\u00111\u0001q\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005O\u0002B!a6\u0003j%!!1NAm\u0005\u0019y%M[3di\u0002")
public class StructsToJson
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
scala.Serializable {
    private transient CharArrayWriter writer;
    private transient JacksonGenerator gen;
    private transient DataType inputSchema;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson structsToJson) {
        return StructsToJson$.MODULE$.unapply(structsToJson);
    }

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private JacksonGenerator gen$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.gen = new JacksonGenerator(this.inputSchema(), this.writer(), new JSONOptions(this.options(), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gen;
    }

    public JacksonGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputSchema;
    }

    public DataType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.inputSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable & scala.Serializable)row -> {
                        this.gen().write((InternalRow)row);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable & scala.Serializable)arr -> {
                        this.gen().write((ArrayData)arr);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable & scala.Serializable)map -> {
                        this.gen().write((MapData)map);
                        return this.getAndReset$1();
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType) {
            TypeCheckResult typeCheckResult2;
            StructType structType = (StructType)dataType;
            try {
                JacksonUtils$.MODULE$.verifySchema(structType);
                typeCheckResult2 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult2 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult2;
        } else if (dataType instanceof MapType) {
            TypeCheckResult typeCheckResult3;
            MapType mapType = (MapType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), mapType);
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult3;
        } else if (dataType instanceof ArrayType) {
            TypeCheckResult typeCheckResult4;
            ArrayType arrayType = (ArrayType)dataType;
            try {
                JacksonUtils$.MODULE$.verifyType(this.prettyName(), arrayType);
                typeCheckResult4 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            catch (UnsupportedOperationException e) {
                typeCheckResult4 = new TypeCheckResult.TypeCheckFailure(e.getMessage());
            }
            typeCheckResult = typeCheckResult4;
        } else {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("Input type ").append(this.child().dataType().catalogString()).append(" must be a struct, array of structs or ").append("a map or array of map.").toString());
        }
        return typeCheckResult;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return Nil$.MODULE$.$colon$colon((Object)typeCollection);
    }

    @Override
    public String prettyName() {
        return "to_json";
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    private final UTF8String getAndReset$1() {
        this.gen().flush();
        String json = this.writer().toString();
        this.writer().reset();
        return UTF8String.fromString((String)json);
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

