/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TruncDate$;
import org.apache.spark.sql.catalyst.expressions.TruncInstant;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date, fmt) - Returns `date` with the time portion of the day truncated to the unit specified by the format model `fmt`.\n  ", arguments="\n     Arguments:\n       * date - date value or valid date string\n       * fmt - the format representing the unit to be truncated to\n           - \"YEAR\", \"YYYY\", \"YY\" - truncate to the first date of the year that the `date` falls in\n           - \"QUARTER\" - truncate to the first date of the quarter that the `date` falls in\n           - \"MONTH\", \"MM\", \"MON\" - truncate to the first date of the month that the `date` falls in\n           - \"WEEK\" - truncate to the Monday of the week that the `date` falls in\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2019-08-04', 'week');\n       2019-07-29\n      > SELECT _FUNC_('2019-08-04', 'quarter');\n       2019-07-01\n      > SELECT _FUNC_('2009-02-12', 'MM');\n       2009-02-01\n      > SELECT _FUNC_('2015-10-27', 'YEAR');\n       2015-01-01\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015Y\u0005\u0001\"\u0011@\u0011\u0015a\u0005\u0001\"\u0011@\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u00151\u0007\u0001\"\u0011h\u0011\u001d\u0001\bA1A\u0005B}Ba!\u001d\u0001!\u0002\u0013\u0001\u0005\"\u0002:\u0001\t\u0003\u001a\b\"B?\u0001\t\u0003r\b\"CA\r\u0001\u0005\u0005I\u0011AA\u000e\u0011%\t\t\u0003AI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002:\u0001\t\n\u0011\"\u0001\u0002$!I\u00111\b\u0001\u0002\u0002\u0013\u0005\u0013Q\b\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001fB\u0011\"a\u0016\u0001\u0003\u0003%\t!!\u0017\t\u0013\u0005}\u0003!!A\u0005B\u0005\u0005\u0004\"CA8\u0001\u0005\u0005I\u0011AA9\u0011%\tY\bAA\u0001\n\u0003\nihB\u0005\u0002(\u0002\n\t\u0011#\u0001\u0002*\u001aAq\u0004IA\u0001\u0012\u0003\tY\u000b\u0003\u0004G3\u0011\u0005\u0011\u0011\u0018\u0005\n\u0003wK\u0012\u0011!C#\u0003{C\u0011\"a0\u001a\u0003\u0003%\t)!1\t\u0013\u0005\u001d\u0017$!A\u0005\u0002\u0006%\u0007\"CAn3\u0005\u0005I\u0011BAo\u0005%!&/\u001e8d\t\u0006$XM\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0015\u0001aFM\u001b<!\ty\u0003'D\u0001!\u0013\t\t\u0004E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011qfM\u0005\u0003i\u0001\u0012A\u0002\u0016:v]\u000eLen\u001d;b]R\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00027y%\u0011Qh\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005I\u0006$X-F\u0001A!\ty\u0013)\u0003\u0002CA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b\u0011\fG/\u001a\u0011\u0002\r\u0019|'/\\1u\u0003\u001d1wN]7bi\u0002\na\u0001P5oSRtDc\u0001%J\u0015B\u0011q\u0006\u0001\u0005\u0006}\u0015\u0001\r\u0001\u0011\u0005\u0006\t\u0016\u0001\r\u0001Q\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\u0012a\u0014\t\u0004!b[fBA)W\u001d\t\u0011V+D\u0001T\u0015\t!F&\u0001\u0004=e>|GOP\u0005\u0002q%\u0011qkN\u0001\ba\u0006\u001c7.Y4f\u0013\tI&LA\u0002TKFT!aV\u001c\u0011\u0005q{V\"A/\u000b\u0005y#\u0013!\u0002;za\u0016\u001c\u0018B\u00011^\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005\u0019\u0007C\u0001/e\u0013\t)WL\u0001\u0005ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002QB\u0011\u0011.\u001c\b\u0003U.\u0004\"AU\u001c\n\u00051<\u0014A\u0002)sK\u0012,g-\u0003\u0002o_\n11\u000b\u001e:j]\u001eT!\u0001\\\u001c\u0002\u000f%t7\u000f^1oi\u0006A\u0011N\\:uC:$\b%\u0001\u0003fm\u0006dGC\u0001;x!\t1T/\u0003\u0002wo\t\u0019\u0011I\\=\t\u000fal\u0001\u0013!a\u0001s\u0006)\u0011N\u001c9viB\u0011!p_\u0007\u0002E%\u0011AP\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR)q0a\u0003\u0002\u0016A!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\u0001\nqaY8eK\u001e,g.\u0003\u0003\u0002\n\u0005\r!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u00055a\u00021\u0001\u0002\u0010\u0005\u00191\r\u001e=\u0011\t\u0005\u0005\u0011\u0011C\u0005\u0005\u0003'\t\u0019A\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005]a\u00021\u0001\u0000\u0003\t)g/\u0001\u0003d_BLH#\u0002%\u0002\u001e\u0005}\u0001b\u0002 \u0010!\u0003\u0005\r\u0001\u0011\u0005\b\t>\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\n+\u0007\u0001\u000b9c\u000b\u0002\u0002*A!\u00111FA\u001b\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012!C;oG\",7m[3e\u0015\r\t\u0019dN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001c\u0003[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nA\u0001\\1oO*\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-C\u0002o\u0003\u0007\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0015\u0011\u0007Y\n\u0019&C\u0002\u0002V]\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001^A.\u0011%\ti\u0006FA\u0001\u0002\u0004\t\t&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003G\u0002R!!\u001a\u0002lQl!!a\u001a\u000b\u0007\u0005%t'\u0001\u0006d_2dWm\u0019;j_:LA!!\u001c\u0002h\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019(!\u001f\u0011\u0007Y\n)(C\u0002\u0002x]\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002^Y\t\t\u00111\u0001u\u0003\u0019)\u0017/^1mgR!\u00111OA@\u0011!\tifFA\u0001\u0002\u0004!\bf\u0006\u0001\u0002\u0004\u0006%\u00151RAH\u0003#\u000b)*a&\u0002\u001c\u0006u\u0015\u0011UAR!\ry\u0013QQ\u0005\u0004\u0003\u000f\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001b\u000b\u0011Q\u0002\u0006!A\u0001\u0002sLR+O\u0007~CC-\u0019;fY\u00012W\u000e^\u0015![\u0001\u0012V\r^;s]N\u0004\u0003\rZ1uK\u0002\u0004s/\u001b;iAQDW\r\t;j[\u0016\u0004\u0003o\u001c:uS>t\u0007e\u001c4!i\",\u0007\u0005Z1zAQ\u0014XO\\2bi\u0016$\u0007\u0005^8!i\",\u0007%\u001e8ji\u0002\u001a\b/Z2jM&,G\r\t2zAQDW\r\t4pe6\fG\u000fI7pI\u0016d\u0007\u0005\u00194ni\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAAJ\u0003\rm(\u0002\t\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011+A\u0011\fG/\u001a\u0011.A\u0011\fG/\u001a\u0011wC2,X\rI8sAY\fG.\u001b3!I\u0006$X\rI:ue&twM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0016!M6$\b%\f\u0011uQ\u0016\u0004cm\u001c:nCR\u0004#/\u001a9sKN,g\u000e^5oO\u0002\"\b.\u001a\u0011v]&$\b\u0005^8!E\u0016\u0004CO];oG\u0006$X\r\u001a\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tJV)\u0011*#Y\u0001\u0012\u0013,W-ZE1\u0002#%W-#A5\u0002CO];oG\u0006$X\r\t;pAQDW\r\t4jeN$\b\u0005Z1uK\u0002zg\r\t;iK\u0002JX-\u0019:!i\"\fG\u000f\t;iK\u0002\u0002G-\u0019;fA\u00022\u0017\r\u001c7tA%t'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%U+B%R+%K\t\u0011.AQ\u0014XO\\2bi\u0016\u0004Co\u001c\u0011uQ\u0016\u0004c-\u001b:ti\u0002\"\u0017\r^3!_\u001a\u0004C\u000f[3!cV\f'\u000f^3sAQD\u0017\r\u001e\u0011uQ\u0016\u0004\u0003\rZ1uK\u0002\u0004c-\u00197mg\u0002JgN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI'P\u001dRC%\u0005\f\u0011#\u001b6\u0013C\u0006\t\u0012N\u001f:\u0013\u0003%\f\u0011ueVt7-\u0019;fAQ|\u0007\u0005\u001e5fA\u0019L'o\u001d;!I\u0006$X\rI8gAQDW\rI7p]RD\u0007\u0005\u001e5bi\u0002\"\b.\u001a\u0011aI\u0006$X\r\u0019\u0011gC2d7\u000fI5o\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E]+Ui\u0013\u0012![\u0001\"(/\u001e8dCR,\u0007\u0005^8!i\",\u0007%T8oI\u0006L\be\u001c4!i\",\u0007e^3fW\u0002\"\b.\u0019;!i\",\u0007\u0005\u00193bi\u0016\u0004\u0007EZ1mYN\u0004\u0013N\u001c\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u001a\u0006\u0011iB\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\n\u0014(\f\u00199[A\"t\u0005\f\u0011(o\u0016,7nJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'O\u00171o5\u0012\u0014H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\n\u0014(\f\u00199[A\"t\u0005\f\u0011(cV\f'\u000f^3sO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192s5\u0002t'\f\u00192\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007\r\u0019:[A\u0012T&\r\u001a(Y\u0001:S*T\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004\u0007M\u001d.aIj\u0003'\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014'N\u00172a5\u0012tg\n\u0017!Oe+\u0015IU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001b.aEj\u0003'\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011qT\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t)+A\u00032]Ur\u0003'A\u0005UeVt7\rR1uKB\u0011q&G\n\u00053\u000556\bE\u0004\u00020\u0006U\u0006\t\u0011%\u000e\u0005\u0005E&bAAZo\u00059!/\u001e8uS6,\u0017\u0002BA\\\u0003c\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\tI+\u0001\u0005u_N#(/\u001b8h)\t\ty$A\u0003baBd\u0017\u0010F\u0003I\u0003\u0007\f)\rC\u0003?9\u0001\u0007\u0001\tC\u0003E9\u0001\u0007\u0001)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005-\u0017q\u001b\t\u0006m\u00055\u0017\u0011[\u0005\u0004\u0003\u001f<$AB(qi&|g\u000eE\u00037\u0003'\u0004\u0005)C\u0002\u0002V^\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAm;\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAp!\u0011\t\t%!9\n\t\u0005\r\u00181\t\u0002\u0007\u001f\nTWm\u0019;")
public class TruncDate
extends BinaryExpression
implements TruncInstant,
scala.Serializable {
    private final Expression date;
    private final Expression format;
    private final Expression instant;
    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(TruncDate truncDate) {
        return TruncDate$.MODULE$.unapply(truncDate);
    }

    public static Function1<Tuple2<Expression, Expression>, TruncDate> tupled() {
        return TruncDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, TruncDate>> curried() {
        return TruncDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return TruncInstant.nullable$(this);
    }

    @Override
    public Object evalHelper(InternalRow input, int minLevel, Function2<Object, Object, Object> truncFunc) {
        return TruncInstant.evalHelper$(this, input, minLevel, truncFunc);
    }

    @Override
    public ExprCode codeGenHelper(CodegenContext ctx, ExprCode ev, int minLevel, boolean orderReversed, Function2<String, String, String> truncFunc) {
        return TruncInstant.codeGenHelper$(this, ctx, ev, minLevel, orderReversed, truncFunc);
    }

    @Override
    public boolean codeGenHelper$default$4() {
        return TruncInstant.codeGenHelper$default$4$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() {
        TruncDate truncDate = this;
        synchronized (truncDate) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel = TruncInstant.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    @Override
    public int org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$TruncInstant$$truncLevel;
    }

    public Expression date() {
        return this.date;
    }

    @Override
    public Expression format() {
        return this.format;
    }

    @Override
    public Expression left() {
        return this.date();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "trunc";
    }

    @Override
    public Expression instant() {
        return this.instant;
    }

    @Override
    public Object eval(InternalRow input) {
        return this.evalHelper(input, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_DATE_TRUNC(), (Function2<Object, Object, Object>)(Function2 & Serializable & scala.Serializable)(d, level) -> BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.truncDate(BoxesRunTime.unboxToInt((Object)d), BoxesRunTime.unboxToInt((Object)level))));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.codeGenHelper(ctx, ev, DateTimeUtils$.MODULE$.MIN_LEVEL_OF_DATE_TRUNC(), this.codeGenHelper$default$4(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(date, fmt) -> new StringBuilder(14).append("truncDate(").append((String)date).append(", ").append((String)fmt).append(");").toString());
    }

    public TruncDate copy(Expression date, Expression format) {
        return new TruncDate(date, format);
    }

    public Expression copy$default$1() {
        return this.date();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "TruncDate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.date();
                break;
            }
            case 1: {
                expression = this.format();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncDate truncDate = (TruncDate)x$1;
        Expression expression = this.date();
        Expression expression2 = truncDate.date();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = truncDate.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!truncDate.canEqual(this)) return false;
        return true;
    }

    public TruncDate(Expression date, Expression format) {
        this.date = date;
        this.format = format;
        ExpectsInputTypes.$init$(this);
        TruncInstant.$init$(this);
        this.instant = date;
    }
}

