/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0011#\u0001FB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\")\u0011\n\u0001C\u0001\u0015\")Q\n\u0001C!\u001d\")1\f\u0001C!9\")\u0001\r\u0001C!C\")\u0001\u000e\u0001C!S\")a\u000e\u0001C!_\"Aa\u000f\u0001EC\u0002\u0013%q\u000f\u0003\u0005\u007f\u0001!\u0015\r\u0011\"\u0003x\u0011%y\b\u0001#b\u0001\n\u0013\t\t\u0001\u0003\u0006\u0002\n\u0001A)\u0019!C\u0005\u0003\u0017A!\"a\u0005\u0001\u0011\u000b\u0007I\u0011IA\u000b\u0011%\t9\u0003\u0001EC\u0002\u0013\u0005c\nC\u0005\u0002*\u0001A)\u0019!C!\u001d\"I\u00111\u0006\u0001\t\u0006\u0004%\tE\u0014\u0005\n\u0003[\u0001\u0001R1A\u0005B\u0011C\u0011\"a\f\u0001\u0003\u0003%\t!!\r\t\u0013\u0005U\u0002!%A\u0005\u0002\u0005]\u0002\"CA'\u0001\u0005\u0005I\u0011IA(\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002l\u0001\t\t\u0011\"\u0001\u0002n!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00131\u0010\u0005\n\u0003\u000b\u0003\u0011\u0011!C\u0001\u0003\u000fC\u0011\"a#\u0001\u0003\u0003%\t%!$\b\u0013\u0005E&%!A\t\u0002\u0005Mf\u0001C\u0011#\u0003\u0003E\t!!.\t\r%[B\u0011AAb\u0011%\t)mGA\u0001\n\u000b\n9\rC\u0005\u0002Jn\t\t\u0011\"!\u0002L\"I\u0011qZ\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u001b\u0005\n\u0003;\\\u0012\u0011!C\u0005\u0003?\u00141aU;n\u0015\t\u0019C%A\u0005bO\u001e\u0014XmZ1uK*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001eYR\u0004\t\u0005\u00024i5\t!%\u0003\u00026E\t!B)Z2mCJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"a\u000e\u001d\u000e\u0003\u0011J!!\u000f\u0013\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002<\u0003&\u0011!\t\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u000bB\u0011qGR\u0005\u0003\u000f\u0012\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"a\u0013'\u0011\u0005M\u0002\u0001\"B\"\u0004\u0001\u0004)\u0015\u0001C2iS2$'/\u001a8\u0016\u0003=\u00032\u0001\u0015-F\u001d\t\tfK\u0004\u0002S+6\t1K\u0003\u0002Ua\u00051AH]8pizJ\u0011!P\u0005\u0003/r\nq\u0001]1dW\u0006<W-\u0003\u0002Z5\n\u00191+Z9\u000b\u0005]c\u0014\u0001\u00038vY2\f'\r\\3\u0016\u0003u\u0003\"a\u000f0\n\u0005}c$a\u0002\"p_2,\u0017M\\\u0001\tI\u0006$\u0018\rV=qKV\t!\r\u0005\u0002dM6\tAM\u0003\u0002fQ\u0005)A/\u001f9fg&\u0011q\r\u001a\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003)\u00042\u0001\u0015-l!\t\u0019G.\u0003\u0002nI\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\u00111OJ\u0001\tC:\fG._:jg&\u0011QO\u001d\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006Q!/Z:vYR$\u0016\u0010]3\u0016\u0003a\u0014B!_>;\u0001\u001a!!\u0010\u0001\u0001y\u00051a$/\u001a4j]\u0016lWM\u001c;?!\t\u0019G0\u0003\u0002~I\nYa*^7fe&\u001cG+\u001f9f\u0003-\u0019X/\u001c#bi\u0006$\u0016\u0010]3\u0002\u0007M,X.\u0006\u0002\u0002\u0004A\u0019q'!\u0002\n\u0007\u0005\u001dAE\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0017\u0001\u0002>fe>,\"!!\u0004\u0011\u0007]\ny!C\u0002\u0002\u0012\u0011\u0012q\u0001T5uKJ\fG.A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/\u0006\u0002\u0002\u0018A1\u0011\u0011DA\u0012\u0003\u0007i!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nS6lW\u000f^1cY\u0016T1!!\t=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\tYB\u0001\u0003MSN$\u0018!D5oSRL\u0017\r\u001c,bYV,7/A\tva\u0012\fG/Z#yaJ,7o]5p]N\f\u0001#\\3sO\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0002%\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\\\u0001\u0005G>\u0004\u0018\u0010F\u0002L\u0003gAqa\u0011\n\u0011\u0002\u0003\u0007Q)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"fA#\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002Hq\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0003mC:<'BAA.\u0003\u0011Q\u0017M^1\n\t\u0005}\u0013Q\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0004cA\u001e\u0002h%\u0019\u0011\u0011\u000e\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0014Q\u000f\t\u0004w\u0005E\u0014bAA:y\t\u0019\u0011I\\=\t\u0013\u0005]d#!AA\u0002\u0005\u0015\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002~A1\u0011qPAA\u0003_j!!a\b\n\t\u0005\r\u0015q\u0004\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002^\u0003\u0013C\u0011\"a\u001e\u0019\u0003\u0003\u0005\r!a\u001c\u0002\r\u0015\fX/\u00197t)\ri\u0016q\u0012\u0005\n\u0003oJ\u0012\u0011!a\u0001\u0003_B3\u0003AAJ\u00033\u000bY*a(\u0002\"\u0006\u0015\u0016qUAV\u0003[\u00032aNAK\u0013\r\t9\n\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti*A!`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\rI:v[\u0002\u001a\u0017\r\\2vY\u0006$X\r\u001a\u0011ge>l\u0007E^1mk\u0016\u001c\be\u001c4!C\u0002:'o\\;q]\u0005AQ\r_1na2,7/\t\u0002\u0002$\u0006\tyP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002BS'\u000b\u0017!QE\u0002\u0014\u0006\f\u0011)cUJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u00023\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>d\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003FT+M\u0019&b\u0003\u0005K\u00191S1\u0002\u0003&M\u001b*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eUR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!Q9+F\nT\u0015-A!rU\u000b\u0014'*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!\u0003\u00159'o\\;qC\t\tI+A\u0005bO\u001e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011qV\u0001\u0006c9\u0002d\u0006M\u0001\u0004'Vl\u0007CA\u001a\u001c'\u0011Y\u0012q\u0017!\u0011\r\u0005e\u0016qX#L\u001b\t\tYLC\u0002\u0002>r\nqA];oi&lW-\u0003\u0003\u0002B\u0006m&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u00111W\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011K\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0017\u00065\u0007\"B\"\u001f\u0001\u0004)\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003'\fI\u000e\u0005\u0003<\u0003+,\u0015bAAly\t1q\n\u001d;j_:D\u0001\"a7 \u0003\u0003\u0005\raS\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!9\u0011\t\u0005M\u00131]\u0005\u0005\u0003K\f)F\u0001\u0004PE*,7\r\u001e")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes {
    private NumericType resultType;
    private NumericType sumDataType;
    private AttributeReference sum;
    private Literal zero;
    private List<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private volatile int bitmap$0;

    public static Option<Expression> unapply(Sum sum) {
        return Sum$.MODULE$.unapply(sum);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sum, A> function1) {
        return Sum$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Sum> compose(Function1<A, Expression> function1) {
        return Sum$.MODULE$.compose(function1);
    }

    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType$[]{NumericType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForNumericExpr(this.child().dataType(), "function sum");
    }

    private NumericType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                NumericType numericType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    numericType = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else {
                    numericType = dataType instanceof IntegralType ? LongType$.MODULE$ : DoubleType$.MODULE$;
                }
                this.resultType = numericType;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private NumericType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private NumericType sumDataType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                this.sumDataType = this.resultType();
                this.bitmap$0 |= 2;
            }
        }
        return this.sumDataType;
    }

    private NumericType sumDataType() {
        return (this.bitmap$0 & 2) == 0 ? this.sumDataType$lzycompute() : this.sumDataType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "sum";
                NumericType x$2 = this.sumDataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.sum = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        return (this.bitmap$0 & 4) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default(this.sumDataType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        return (this.bitmap$0 & 8) == 0 ? this.zero$lzycompute() : this.zero;
    }

    private List<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.sum();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    public List<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(null, this.sumDataType())}));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.updateExpressions = this.child().nullable() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.sumDataType())), this.sum()}))})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.sumDataType()))}));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.mergeExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()}))).$plus(this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()}))}));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x80) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                NumericType numericType = this.resultType();
                if (numericType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)numericType;
                    expression = new CheckOverflow(this.sum(), decimalType, !SQLConf$.MODULE$.get().ansiEnabled());
                } else {
                    expression = this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x100) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    public Sum copy(Expression child) {
        return new Sum(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

