/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate `percentile` of the numeric\n      column `col` which is the smallest value in the ordered `col` values (sorted from least to\n      greatest) such that no more than `percentage` of `col` values is less than the value\n      or equal to that value. The value of percentage must be between 0.0 and 1.0. The `accuracy`\n      parameter (default: 10000) is a positive numeric literal which controls approximation accuracy\n      at the cost of memory. Higher value of `accuracy` yields better accuracy, `1.0/accuracy` is\n      the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col, array(0.5, 0.4, 0.1), 100) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [1,1,0]\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (0), (6), (7), (9), (10) AS tab(col);\n       7\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001B$I\u0001^C!\"!)\u0001\u0005+\u0007I\u0011AAx\u0011)\t\t\u0010\u0001B\tB\u0003%\u00111\u0015\u0005\u000b\u0003[\u0003!Q3A\u0005\u0002\u0005=\bBCAz\u0001\tE\t\u0015!\u0003\u0002$\"Q\u0011\u0011\u0017\u0001\u0003\u0016\u0004%\t!a<\t\u0015\u0005U\bA!E!\u0002\u0013\t\u0019\u000bC\u0005\u00026\u0002\u0011)\u001a!C!}\"I\u0011q\u001f\u0001\u0003\u0012\u0003\u0006Ia \u0005\n\u0003s\u0003!Q3A\u0005ByD\u0011\"!?\u0001\u0005#\u0005\u000b\u0011B@\t\rm\u0004A\u0011AA~\u0011\u0019Y\b\u0001\"\u0001\u0003\b!11\u0010\u0001C\u0001\u0005\u001fA!B!\u0006\u0001\u0011\u000b\u0007I\u0011\u0002B\f\u0011\u001d\u0011y\u0002\u0001C!\u0005CAA\"a\n\u0001!\u0003E9\u0019)C\u0005\u0005\u0003B!B!\u0013\u0001\u0011\u000b\u0007I\u0011BA!\u0011)\t9\u0007\u0001EC\u0002\u0013%!1\n\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0011\u001d\u0011i\u0006\u0001C!\u0005?BqA!\u0019\u0001\t\u0003\u0012\u0019\u0007C\u0004\u0002T\u0001!\tE!\u001e\t\u000f\tm\u0004\u0001\"\u0011\u0003~!9!q\u0011\u0001\u0005B\t%\u0005b\u0002BH\u0001\u0011\u0005#\u0011\u0013\u0005\b\u0005+\u0003A\u0011\tBL\u0011\u001d\u0011Y\n\u0001C!\u0003\u0003BqA!(\u0001\t\u0003\u0012y\nC\u0004\u0003(\u0002!\tE!+\t\u000f\u0005m\u0004\u0001\"\u0011\u0003<\"9\u00111\u0012\u0001\u0005B\t}\u0006\"\u0003Bb\u0001\u0005\u0005I\u0011\u0001Bc\u0011%\u0011\t\u000eAI\u0001\n\u0003\u0011\u0019\u000eC\u0005\u0003j\u0002\t\n\u0011\"\u0001\u0003T\"I!1\u001e\u0001\u0012\u0002\u0013\u0005!1\u001b\u0005\n\u0005[\u0004\u0011\u0013!C\u0001\u0005_D\u0011Ba=\u0001#\u0003%\tAa<\t\u0013\tU\b!!A\u0005B\t]\b\u0002\u0003B\u007f\u0001\u0005\u0005I\u0011\u0001@\t\u0013\t}\b!!A\u0005\u0002\r\u0005\u0001\"CB\u0003\u0001\u0005\u0005I\u0011IB\u0004\u0011%\u0019)\u0002AA\u0001\n\u0003\u00199\u0002C\u0005\u0004\u001c\u0001\t\t\u0011\"\u0011\u0004\u001e\u001d)q\u000e\u0013E\u0001a\u001a)q\t\u0013E\u0001c\")10\fC\u0001y\"9Q0\fb\u0001\n\u0003q\bbBA\u0003[\u0001\u0006Ia \u0004\u0007\u0003\u000fi\u0003!!\u0003\t\u0015\u0005-\u0011G!a\u0001\n\u0013\ti\u0001\u0003\u0006\u0002\u001cE\u0012\t\u0019!C\u0005\u0003;A!\"!\u000b2\u0005\u0003\u0005\u000b\u0015BA\b\u0011\u0019Y\u0018\u0007\"\u0001\u0002,!110\rC\u0001\u0003gA\u0001\"a\u00102\t\u0003q\u0015\u0011\t\u0005\b\u0003\u0013\nD\u0011AA\u0007\u0011\u001d\tY%\rC\u0001\u0003\u001bBq!a\u00152\t\u0003\t)\u0006C\u0004\u0002\\E\"\t!!\u0018\t\u000f\u0005%\u0014\u0007\"\u0004\u0002l\u00191\u0011QN\u0017\u0001\u0003_Baa_\u001f\u0005\u0002\u0005E\u0004bBA;{\u00115\u0011q\u000f\u0005\b\u0003wjDQAA?\u0011\u001d\tY)\u0010C\u0003\u0003\u001bC\u0011\"a%.\u0005\u0004%\t!!&\t\u0011\u0005]U\u0006)A\u0005\u0003gB\u0011\"!'.\u0003\u0003%\t)a'\t\u0013\u0005mV&!A\u0005\u0002\u0006u\u0006\"CAh[\u0005\u0005I\u0011BAi\u0005U\t\u0005\u000f\u001d:pq&l\u0017\r^3QKJ\u001cWM\u001c;jY\u0016T!!\u0013&\u0002\u0013\u0005<wM]3hCR,'BA&M\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00055s\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005=\u0003\u0016aA:rY*\u0011\u0011KU\u0001\u0006gB\f'o\u001b\u0006\u0003'R\u000ba!\u00199bG\",'\"A+\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001A\u00161]AuqB\u0019\u0011L\u0017/\u000e\u0003!K!a\u0017%\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002^c9\u0011a\f\f\b\u0003?:t!\u0001Y7\u000f\u0005\u0005dgB\u00012l\u001d\t\u0019'N\u0004\u0002eS:\u0011Q\r[\u0007\u0002M*\u0011qMV\u0001\u0007yI|w\u000e\u001e \n\u0003UK!a\u0015+\n\u0005E\u0013\u0016BA(Q\u0013\tie*\u0003\u0002L\u0019&\u0011\u0011JS\u0001\u0016\u0003B\u0004(o\u001c=j[\u0006$X\rU3sG\u0016tG/\u001b7f!\tIVfE\u0002.eb\u0004\"a\u001d<\u000e\u0003QT\u0011!^\u0001\u0006g\u000e\fG.Y\u0005\u0003oR\u0014a!\u00118z%\u00164\u0007CA:z\u0013\tQHO\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002a\u0006YB)\u0012$B+2#v\fU#S\u0007\u0016sE+\u0013'F?\u0006\u001b5)\u0016*B\u0007f+\u0012a \t\u0004g\u0006\u0005\u0011bAA\u0002i\n\u0019\u0011J\u001c;\u00029\u0011+e)Q+M)~\u0003VIU\"F\u001dRKE*R0B\u0007\u000e+&+Q\"ZA\t\u0001\u0002+\u001a:dK:$\u0018\u000e\\3ES\u001e,7\u000f^\n\u0003cI\f\u0011b];n[\u0006\u0014\u0018.Z:\u0016\u0005\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005UA*\u0001\u0003vi&d\u0017\u0002BA\r\u0003'\u0011\u0011#U;b]RLG.Z*v[6\f'/[3t\u00035\u0019X/\\7be&,7o\u0018\u0013fcR!\u0011qDA\u0013!\r\u0019\u0018\u0011E\u0005\u0004\u0003G!(\u0001B+oSRD\u0011\"a\n4\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0013'\u0001\u0006tk6l\u0017M]5fg\u0002\"B!!\f\u00022A\u0019\u0011qF\u0019\u000e\u00035Bq!a\u00036\u0001\u0004\ty\u0001\u0006\u0003\u0002.\u0005U\u0002bBA\u001cm\u0001\u0007\u0011\u0011H\u0001\u000ee\u0016d\u0017\r^5wK\u0016\u0013(o\u001c:\u0011\u0007M\fY$C\u0002\u0002>Q\u0014a\u0001R8vE2,\u0017\u0001D5t\u0007>l\u0007O]3tg\u0016$WCAA\"!\r\u0019\u0018QI\u0005\u0004\u0003\u000f\"(a\u0002\"p_2,\u0017M\\\u0001\u0012cV\fg\u000e^5mKN+X.\\1sS\u0016\u001c\u0018aA1eIR!\u0011qDA(\u0011\u001d\t\t&\u000fa\u0001\u0003s\tQA^1mk\u0016\fQ!\\3sO\u0016$B!a\b\u0002X!9\u0011\u0011\f\u001eA\u0002\u00055\u0012!B8uQ\u0016\u0014\u0018AD4fiB+'oY3oi&dWm\u001d\u000b\u0005\u0003?\n)\u0007E\u0003t\u0003C\nI$C\u0002\u0002dQ\u0014Q!\u0011:sCfDq!a\u001a<\u0001\u0004\ty&A\u0006qKJ\u001cWM\u001c;bO\u0016\u001c\u0018\u0001C2p[B\u0014Xm]:\u0015\u0005\u0005}!A\u0007)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\u0016\u0014\u0018.\u00197ju\u0016\u00148CA\u001fs)\t\t\u0019\bE\u0002\u00020u\na\u0001\\3oORDGcA@\u0002z!9\u00111B A\u0002\u0005=\u0011!C:fe&\fG.\u001b>f)\u0011\ty(a\"\u0011\u000bM\f\t'!!\u0011\u0007M\f\u0019)C\u0002\u0002\u0006R\u0014AAQ=uK\"9\u0011\u0011\u0012!A\u0002\u00055\u0012aA8cU\u0006YA-Z:fe&\fG.\u001b>f)\u0011\ti#a$\t\u000f\u0005E\u0015\t1\u0001\u0002\u0000\u0005)!-\u001f;fg\u0006Q1/\u001a:jC2L'0\u001a:\u0016\u0005\u0005M\u0014aC:fe&\fG.\u001b>fe\u0002\nQ!\u00199qYf$B\"!(\u0002 \u0006-\u0016qVAZ\u0003o\u0003\"!\u0017\u0001\t\u000f\u0005\u0005F\t1\u0001\u0002$\u0006)1\r[5mIB!\u0011QUAT\u001b\u0005Q\u0015bAAU\u0015\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u00055F\t1\u0001\u0002$\u0006!\u0002/\u001a:dK:$\u0018mZ3FqB\u0014Xm]:j_:Dq!!-E\u0001\u0004\t\u0019+\u0001\nbG\u000e,(/Y2z\u000bb\u0004(/Z:tS>t\u0007BBA[\t\u0002\u0007q0\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u0019\tI\f\u0012a\u0001\u007f\u0006!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002@\u0006-\u0007#B:\u0002B\u0006\u0015\u0017bAAbi\n1q\n\u001d;j_:\u00042b]Ad\u0003G\u000b\u0019+a)\u0000\u007f&\u0019\u0011\u0011\u001a;\u0003\rQ+\b\u000f\\36\u0011%\ti-RA\u0001\u0002\u0004\ti*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001b\t\u0005\u0003+\fy.\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0017\u0001\u00026bm\u0006LA!!9\u0002X\n1qJ\u00196fGR\u0004B!!*\u0002f&\u0019\u0011q\u001d&\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042a]Av\u0013\r\ti\u000f\u001e\u0002\b!J|G-^2u+\t\t\u0019+\u0001\u0004dQ&dG\rI\u0001\u0016a\u0016\u00148-\u001a8uC\u001e,W\t\u001f9sKN\u001c\u0018n\u001c8!\u0003M\t7mY;sC\u000eLX\t\u001f9sKN\u001c\u0018n\u001c8!\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0015\u0019\u0005u\u0015Q`A\u0000\u0005\u0003\u0011\u0019A!\u0002\t\u000f\u0005\u00056\u00021\u0001\u0002$\"9\u0011QV\u0006A\u0002\u0005\r\u0006bBAY\u0017\u0001\u0007\u00111\u0015\u0005\u0007\u0003k[\u0001\u0019A@\t\r\u0005e6\u00021\u0001\u0000)!\tiJ!\u0003\u0003\f\t5\u0001bBAQ\u0019\u0001\u0007\u00111\u0015\u0005\b\u0003[c\u0001\u0019AAR\u0011\u001d\t\t\f\u0004a\u0001\u0003G#b!!(\u0003\u0012\tM\u0001bBAQ\u001b\u0001\u0007\u00111\u0015\u0005\b\u0003[k\u0001\u0019AAR\u0003!\t7mY;sC\u000eLXC\u0001B\r!\r\u0019(1D\u0005\u0004\u0005;!(\u0001\u0002'p]\u001e\f!\"\u001b8qkR$\u0016\u0010]3t+\t\u0011\u0019\u0003\u0005\u0004\u0003&\t=\"Q\u0007\b\u0005\u0005O\u0011YCD\u0002f\u0005SI\u0011!^\u0005\u0004\u0005[!\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005c\u0011\u0019DA\u0002TKFT1A!\fu!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e\u001d\u0006)A/\u001f9fg&!!q\bB\u001d\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0006\u0002\u0003DA91O!\u0012\u0002D\u0005}\u0013b\u0001B$i\n1A+\u001e9mKJ\nQC]3ukJt\u0007+\u001a:dK:$\u0018\u000e\\3BeJ\f\u00170\u0006\u0002\u0002`\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011!\u0011\u000b\t\u0005\u0005'\u0012I&\u0004\u0002\u0003V)\u0019!q\u000b'\u0002\u0011\u0005t\u0017\r\\=tSNLAAa\u0017\u0003V\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\tA,\u0001\u0004va\u0012\fG/\u001a\u000b\u00069\n\u0015$\u0011\u000e\u0005\u0007\u0005O*\u0002\u0019\u0001/\u0002\r\t,hMZ3s\u0011\u001d\u0011Y'\u0006a\u0001\u0005[\n\u0001\"\u001b8qkR\u0014vn\u001e\t\u0005\u0005_\u0012\t(D\u0001M\u0013\r\u0011\u0019\b\u0014\u0002\f\u0013:$XM\u001d8bYJ{w\u000fF\u0003]\u0005o\u0012I\b\u0003\u0004\u0003hY\u0001\r\u0001\u0018\u0005\u0007\u000332\u0002\u0019\u0001/\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0005\u007f\u0012)\tE\u0002t\u0005\u0003K1Aa!u\u0005\r\te.\u001f\u0005\u0007\u0005O:\u0002\u0019\u0001/\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!!(\u0003\f\"1!Q\u0012\rA\u0002}\f\u0011B\\3x\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\tiJa%\t\r\t5\u0015\u00041\u0001\u0000\u0003!\u0019\u0007.\u001b7ee\u0016tWC\u0001BM!\u0019\u0011)Ca\f\u0002$\u0006Aa.\u001e7mC\ndW-\u0001\u0005eCR\fG+\u001f9f+\t\u0011\t\u000b\u0005\u0003\u00038\t\r\u0016\u0002\u0002BS\u0005s\u0011\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,WC\u0001BV!\u0011\u0011iK!.\u000f\t\t=&\u0011\u0017\t\u0003KRL1Aa-u\u0003\u0019\u0001&/\u001a3fM&!!q\u0017B]\u0005\u0019\u0019FO]5oO*\u0019!1\u0017;\u0015\t\u0005}$Q\u0018\u0005\u0007\u0003\u0013s\u0002\u0019\u0001/\u0015\u0007q\u0013\t\rC\u0004\u0002\u0012~\u0001\r!a \u0002\t\r|\u0007/\u001f\u000b\r\u0003;\u00139M!3\u0003L\n5'q\u001a\u0005\n\u0003C\u0003\u0003\u0013!a\u0001\u0003GC\u0011\"!,!!\u0003\u0005\r!a)\t\u0013\u0005E\u0006\u0005%AA\u0002\u0005\r\u0006\u0002CA[AA\u0005\t\u0019A@\t\u0011\u0005e\u0006\u0005%AA\u0002}\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003V*\"\u00111\u0015BlW\t\u0011I\u000e\u0005\u0003\u0003\\\n\u0015XB\u0001Bo\u0015\u0011\u0011yN!9\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bri\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d(Q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!=+\u0007}\u00149.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u0010\u0005\u0003\u0002V\nm\u0018\u0002\u0002B\\\u0003/\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\u0000\r\r\u0001\u0002CA\u0014Q\u0005\u0005\t\u0019A@\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0003\u0011\r\r-1\u0011\u0003B@\u001b\t\u0019iAC\u0002\u0004\u0010Q\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019b!\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0007\u001aI\u0002C\u0005\u0002()\n\t\u00111\u0001\u0003\u0000\u00051Q-];bYN$B!a\u0011\u0004 !I\u0011qE\u0016\u0002\u0002\u0003\u0007!q\u0010\u0015\u0014\u0001\r\r2\u0011FB\u0016\u0007_\u0019\td!\u000e\u00048\rm2Q\b\t\u0005\u0003K\u001b)#C\u0002\u0004()\u0013Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0004.\u00051YJ\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!a\u0016\u00148-\u001a8uC\u001e,\u0007e\u0017\u0017!C\u000e\u001cWO]1dsvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u00199qe>D\u0018.\\1uK\u0002\u0002\u0007/\u001a:dK:$\u0018\u000e\\3aA=4\u0007\u0005\u001e5fA9,X.\u001a:jG*\u0001\u0003\u0005\t\u0011!A\r|G.^7oA\u0001\u001cw\u000e\u001c1!o\"L7\r\u001b\u0011jg\u0002\"\b.\u001a\u0011t[\u0006dG.Z:uAY\fG.^3!S:\u0004C\u000f[3!_J$WM]3eA\u0001\u001cw\u000e\u001c1!m\u0006dW/Z:!QM|'\u000f^3eA\u0019\u0014x.\u001c\u0011mK\u0006\u001cH\u000f\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!OJ,\u0017\r^3ti&\u00023/^2iAQD\u0017\r\u001e\u0011o_\u0002jwN]3!i\"\fg\u000e\t1qKJ\u001cWM\u001c;bO\u0016\u0004\u0007e\u001c4!A\u000e|G\u000e\u0019\u0011wC2,Xm\u001d\u0011jg\u0002bWm]:!i\"\fg\u000e\t;iK\u00022\u0018\r\\;f\u0015\u0001\u0002\u0003\u0005\t\u0011!_J\u0004S-];bY\u0002\"x\u000e\t;iCR\u0004c/\u00197vK:\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u0002\u0002XM]2f]R\fw-\u001a\u0011nkN$\bEY3!E\u0016$x/Z3oAAr\u0003\u0007I1oI\u0002\nd\u0006\r\u0018!)\",\u0007\u0005Y1dGV\u0014\u0018mY=a\u0015\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u0014\u0018-\\3uKJ\u0004\u0003\u0006Z3gCVdGO\u000f\u00112aA\u0002\u0004'\u000b\u0011jg\u0002\n\u0007\u0005]8tSRLg/\u001a\u0011ok6,'/[2!Y&$XM]1mA]D\u0017n\u00195!G>tGO]8mg\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^5p]\u0002\n7mY;sC\u000eL(\u0002\t\u0011!A\u0001\u0002\u0013\r\u001e\u0011uQ\u0016\u00043m\\:uA=4\u0007%\\3n_JLh\u0006\t%jO\",'\u000f\t<bYV,\u0007e\u001c4!A\u0006\u001c7-\u001e:bGf\u0004\u0007%_5fY\u0012\u001c\bEY3ui\u0016\u0014\b%Y2dkJ\f7-\u001f\u0017!AFr\u0003gL1dGV\u0014\u0018mY=aA%\u001c(\u0002\t\u0011!A\u0001\u0002C\u000f[3!e\u0016d\u0017\r^5wK\u0002*'O]8sA=4\u0007\u0005\u001e5fA\u0005\u0004\bO]8yS6\fG/[8o])\u0001\u0003\u0005\t\u0011!A]CWM\u001c\u0011aa\u0016\u00148-\u001a8uC\u001e,\u0007\rI5tA\u0005t\u0007%\u0019:sCfd\u0003%Z1dQ\u00022\u0018\r\\;fA=4\u0007\u0005\u001e5fAA,'oY3oi\u0006<W\rI1se\u0006L\b%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0011!A\u0001\u0002\u0003%\u00138!i\"L7\u000fI2bg\u0016d\u0003E]3ukJt7\u000f\t;iK\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^3!a\u0016\u00148-\u001a8uS2,\u0007%\u0019:sCf\u0004sN\u001a\u0011d_2,XN\u001c\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t'\u0002\t\u0011!A\u0001\u0002\u0003/\u001a:dK:$\u0018mZ3!CJ\u0014\u0018-\u001f\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0007g\t\u0011q\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006I1se\u0006L\b\u0006\r\u00186Y\u0001\u0002d\u0006\u000e\u0017!a9\n\u0014\u0006\f\u00112aAJ\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0003'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003&\r\u0019*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Fb\u0013\u0007\f\u0019^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!a9*D\u0006I\u00191a%\u0002cIU(NAY\u000bE*V#TA!\u0002\u0014\u0006\f\u0011)m%b\u0003\u0005K\u001c*Y\u0001B\u0013(\u000b\u0017!QE\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u000e\u0006!A\u0005)qM]8va\u0006\u00121\u0011H\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#aa\u0010\u0002\u000bIr\u0013G\f\u0019")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
scala.Serializable {
    private long accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private long accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = ((Number)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1())).longValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracy;
    }

    private long accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, new ArrayType(DoubleType$.MODULE$, false)})), IntegralType$.MODULE$}));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), null);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                } else {
                    throw new MatchError(object);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                boolean returnPercentileArray = tuple22._1$mcZ$sp();
                double[] percentages = (double[])tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)returnPercentileArray), (Object)percentages);
                this.x$1 = tuple23;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() || !this.accuracyExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal") : (this.accuracy() <= 0L || this.accuracy() > Integer.MAX_VALUE ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(72).append("The accuracy provided must be a literal between (0, ").append(Integer.MAX_VALUE).append("]").append(" (current value = ").append(this.accuracy()).append(")").toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(62).append("All percentage values must be between 0.0 and 1.0 ").append("(current = ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).mkString(", ")).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            if (DateType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                d = BoxesRunTime.unboxToLong((Object)value);
            } else if (dataType instanceof NumericType) {
                NumericType numericType = (NumericType)dataType;
                d = numericType.numeric().toDouble(value);
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
                }
                throw new MatchError((Object)dataType);
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        Object object;
        double[] doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        if (DateType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$2 -> (int)x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$3 -> (long)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$4))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$5))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$6 -> (int)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$7 -> (long)x$7, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$8 -> (float)x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = doubleResult;
        } else if (dataType instanceof DecimalType) {
            object = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(doubleResult)).map((Function1 & Serializable & scala.Serializable)x$9 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Decimal.class)));
        } else {
            if (dataType != null) {
                DataType dataType2 = dataType;
                throw new UnsupportedOperationException(new StringBuilder(21).append("Unexpected data type ").append(dataType2.catalogString()).toString());
            }
            throw new MatchError((Object)dataType);
        }
        Object result = object;
        return ScalaRunTime$.MODULE$.array_length(result) == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : ScalaRunTime$.MODULE$.array_apply(result, 0));
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "percentile_approx");
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$5) {
        return (short)x$5;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                dArray = Array$.MODULE$.emptyDoubleArray();
            } else {
                void var2_2;
                double[] result = new double[percentages.length];
                for (int i = 0; i < percentages.length; ++i) {
                    result[i] = BoxesRunTime.unboxToDouble((Object)this.summaries().query(percentages[i]).get());
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, x$3));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

