/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.CountMinSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, eps, confidence, seed) - Returns a count-min sketch of a column with the given esp,\n      confidence and seed. The result is an array of bytes, which can be deserialized to a\n      `CountMinSketch` before usage. Count-min sketch is a probabilistic data structure used for\n      cardinality estimation using sub-linear space.\n  ", group="agg_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\tee\u0001\u0002\u001b6\u0001\u0012C\u0001B\u0018\u0001\u0003\u0016\u0004%\ta\u0018\u0005\tG\u0002\u0011\t\u0012)A\u0005A\"AA\r\u0001BK\u0002\u0013\u0005q\f\u0003\u0005f\u0001\tE\t\u0015!\u0003a\u0011!1\u0007A!f\u0001\n\u0003y\u0006\u0002C4\u0001\u0005#\u0005\u000b\u0011\u00021\t\u0011!\u0004!Q3A\u0005\u0002}C\u0001\"\u001b\u0001\u0003\u0012\u0003\u0006I\u0001\u0019\u0005\tU\u0002\u0011)\u001a!C!W\"Aq\u000e\u0001B\tB\u0003%A\u000e\u0003\u0005q\u0001\tU\r\u0011\"\u0011l\u0011!\t\bA!E!\u0002\u0013a\u0007\"\u0002:\u0001\t\u0003\u0019\b\"\u0002:\u0001\t\u0003Y\bBCA\u0001\u0001!\u0015\r\u0011\"\u0003\u0002\u0004!Q\u00111\u0002\u0001\t\u0006\u0004%I!a\u0001\t\u0013\u00055\u0001\u0001#b\u0001\n\u0013Y\u0007bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011Q\f\u0001\u0005B\u0005}\u0003bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\t)\b\u0001C!\u0003oBq!!(\u0001\t\u0003\ny\nC\u0004\u0002(\u0002!\t%!+\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006\"CAf\u0001\u0005\u0005I\u0011AAg\u0011%\tY\u000eAI\u0001\n\u0003\ti\u000eC\u0005\u0002t\u0002\t\n\u0011\"\u0001\u0002^\"I\u0011Q\u001f\u0001\u0012\u0002\u0013\u0005\u0011Q\u001c\u0005\n\u0003o\u0004\u0011\u0013!C\u0001\u0003;D\u0011\"!?\u0001#\u0003%\t!a?\t\u0013\u0005}\b!%A\u0005\u0002\u0005m\b\"\u0003B\u0001\u0001\u0005\u0005I\u0011\tB\u0002\u0011!\u0011\u0019\u0002AA\u0001\n\u0003Y\u0007\"\u0003B\u000b\u0001\u0005\u0005I\u0011\u0001B\f\u0011%\u0011i\u0002AA\u0001\n\u0003\u0012y\u0002C\u0005\u0003.\u0001\t\t\u0011\"\u0001\u00030!I!1\u0007\u0001\u0002\u0002\u0013\u0005#QG\u0004\n\u0005'*\u0014\u0011!E\u0001\u0005+2\u0001\u0002N\u001b\u0002\u0002#\u0005!q\u000b\u0005\u0007e:\"\tA!\u001a\t\u0013\t\u001dd&!A\u0005F\t%\u0004\"\u0003B6]\u0005\u0005I\u0011\u0011B7\u0011%\u0011YHLA\u0001\n\u0003\u0013i\bC\u0005\u0003\u0010:\n\t\u0011\"\u0003\u0003\u0012\n\t2i\\;oi6KgnU6fi\u000eD\u0017iZ4\u000b\u0005Y:\u0014!C1hOJ,w-\u0019;f\u0015\tA\u0014(A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u001e<\u0003!\u0019\u0017\r^1msN$(B\u0001\u001f>\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003}}\nQa\u001d9be.T!\u0001Q!\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0015aA8sO\u000e\u00011#\u0002\u0001F#V[\u0006c\u0001$H\u00136\tQ'\u0003\u0002Ik\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005){U\"A&\u000b\u00051k\u0015AB:lKR\u001c\u0007N\u0003\u0002O{\u0005!Q\u000f^5m\u0013\t\u00016J\u0001\bD_VtG/T5o'.,Go\u00195\u0011\u0005I\u001bV\"A\u001c\n\u0005Q;$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\n9\u0001K]8ek\u000e$\bC\u0001,]\u0013\tivK\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001a!\t\u0011\u0016-\u0003\u0002co\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u00035)\u0007o]#yaJ,7o]5p]\u0006qQ\r]:FqB\u0014Xm]:j_:\u0004\u0013\u0001F2p]\u001aLG-\u001a8dK\u0016C\bO]3tg&|g.A\u000bd_:4\u0017\u000eZ3oG\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002\u001dM,W\rZ#yaJ,7o]5p]\u0006y1/Z3e\u000bb\u0004(/Z:tS>t\u0007%\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\u0005a\u0007C\u0001,n\u0013\tqwKA\u0002J]R\fq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002)%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003UIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\na\u0001P5oSRtDc\u0002;vm^D\u0018P\u001f\t\u0003\r\u0002AQAX\u0007A\u0002\u0001DQ\u0001Z\u0007A\u0002\u0001DQAZ\u0007A\u0002\u0001DQ\u0001[\u0007A\u0002\u0001DQA[\u0007A\u00021DQ\u0001]\u0007A\u00021$R\u0001\u001e?~}~DQA\u0018\bA\u0002\u0001DQ\u0001\u001a\bA\u0002\u0001DQA\u001a\bA\u0002\u0001DQ\u0001\u001b\bA\u0002\u0001\f1!\u001a9t+\t\t)\u0001E\u0002W\u0003\u000fI1!!\u0003X\u0005\u0019!u.\u001e2mK\u0006Q1m\u001c8gS\u0012,gnY3\u0002\tM,W\rZ\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033I\u0014\u0001C1oC2L8/[:\n\t\u0005u\u0011q\u0003\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002\u0013\u00061Q\u000f\u001d3bi\u0016$R!SA\u0014\u0003WAa!!\u000b\u0015\u0001\u0004I\u0015A\u00022vM\u001a,'\u000fC\u0004\u0002.Q\u0001\r!a\f\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005E\u00121G\u0007\u0002s%\u0019\u0011QG\u001d\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0006\u0013\u0006m\u0012Q\b\u0005\u0007\u0003S)\u0002\u0019A%\t\r\u00055R\u00031\u0001J\u0003\u0011)g/\u00197\u0015\t\u0005\r\u0013\u0011\n\t\u0004-\u0006\u0015\u0013bAA$/\n\u0019\u0011I\\=\t\r\u0005%b\u00031\u0001J\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002P\u0005m\u0003#\u0002,\u0002R\u0005U\u0013bAA*/\n)\u0011I\u001d:bsB\u0019a+a\u0016\n\u0007\u0005esK\u0001\u0003CsR,\u0007BBA\u0015/\u0001\u0007\u0011*A\u0006eKN,'/[1mSj,GcA%\u0002b!9\u00111\r\rA\u0002\u0005=\u0013!D:u_J\fw-\u001a$pe6\fG/A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\r!\u0018\u0011\u000e\u0005\u0007\u0003WJ\u0002\u0019\u00017\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u0007Q\f\t\b\u0003\u0004\u0002ti\u0001\r\u0001\\\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f!\"\u001b8qkR$\u0016\u0010]3t+\t\tI\b\u0005\u0004\u0002|\u0005-\u0015\u0011\u0013\b\u0005\u0003{\n9I\u0004\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019iQ\u0001\u0007yI|w\u000e\u001e \n\u0003aK1!!#X\u0003\u001d\u0001\u0018mY6bO\u0016LA!!$\u0002\u0010\n\u00191+Z9\u000b\u0007\u0005%u\u000b\u0005\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9jO\u0001\u0006if\u0004Xm]\u0005\u0005\u00037\u000b)J\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002\"B\u0019a+a)\n\u0007\u0005\u0015vKA\u0004C_>dW-\u00198\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a+\u0011\t\u0005M\u0015QV\u0005\u0005\u0003_\u000b)J\u0001\u0005ECR\fG+\u001f9f\u0003!\u0019\u0007.\u001b7ee\u0016tWCAA[!\u0015\tY(a#a\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003w\u0003B!!0\u0002F:!\u0011qXAa!\r\tyhV\u0005\u0004\u0003\u0007<\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002H\u0006%'AB*ue&twMC\u0002\u0002D^\u000bAaY8qsRiA/a4\u0002R\u0006M\u0017Q[Al\u00033DqA\u0018\u0011\u0011\u0002\u0003\u0007\u0001\rC\u0004eAA\u0005\t\u0019\u00011\t\u000f\u0019\u0004\u0003\u0013!a\u0001A\"9\u0001\u000e\tI\u0001\u0002\u0004\u0001\u0007b\u00026!!\u0003\u0005\r\u0001\u001c\u0005\ba\u0002\u0002\n\u00111\u0001m\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a8+\u0007\u0001\f\to\u000b\u0002\u0002dB!\u0011Q]Ax\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018!C;oG\",7m[3e\u0015\r\tioV\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAy\u0003O\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q \u0016\u0004Y\u0006\u0005\u0018AD2paf$C-\u001a4bk2$HEN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005#i!A!\u0003\u000b\t\t-!QB\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0010\u0005!!.\u0019<b\u0013\u0011\t9M!\u0003\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\tB\r\u0011!\u0011Y\"KA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\"A1!1\u0005B\u0015\u0003\u0007j!A!\n\u000b\u0007\t\u001dr+\u0001\u0006d_2dWm\u0019;j_:LAAa\u000b\u0003&\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\tK!\r\t\u0013\tm1&!AA\u0002\u0005\r\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002\"\n]\u0002\"\u0003B\u000eY\u0005\u0005\t\u0019AA\"Q=\u0001!1\bB!\u0005\u0007\u00129E!\u0013\u0003N\t=\u0003c\u0001*\u0003>%\u0019!qH\u001c\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QI\u0001\u00032*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015d_2d\u0003%\u001a9tY\u0001\u001awN\u001c4jI\u0016t7-\u001a\u0017!g\u0016,G-\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007eY8v]RlS.\u001b8!g.,Go\u00195!_\u001a\u0004\u0013\rI2pYVlg\u000eI<ji\"\u0004C\u000f[3!O&4XM\u001c\u0011fgBd#\u0002\t\u0011!A\u0001\u00023m\u001c8gS\u0012,gnY3!C:$\u0007e]3fI:\u0002C\u000b[3!e\u0016\u001cX\u000f\u001c;!SN\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gA\tLH/Z:-A]D\u0017n\u00195!G\u0006t\u0007EY3!I\u0016\u001cXM]5bY&TX\r\u001a\u0011u_\u0002\n'\u0002\t\u0011!A\u0001\u0002\u0003mQ8v]Rl\u0015N\\*lKR\u001c\u0007\u000e\u0019\u0011cK\u001a|'/\u001a\u0011vg\u0006<WM\f\u0011D_VtG/L7j]\u0002\u001a8.\u001a;dQ\u0002J7\u000fI1!aJ|'-\u00192jY&\u001cH/[2!I\u0006$\u0018\rI:ueV\u001cG/\u001e:fAU\u001cX\r\u001a\u0011g_JT\u0001\u0005\t\u0011!A\u0001\u001a\u0017M\u001d3j]\u0006d\u0017\u000e^=!KN$\u0018.\\1uS>t\u0007%^:j]\u001e\u00043/\u001e2.Y&tW-\u0019:!gB\f7-\u001a\u0018\u000bA\u0001\nQa\u001a:pkB\f#Aa\u0013\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B)\u0003\u0015\u0011dF\r\u00181\u0003E\u0019u.\u001e8u\u001b&t7k[3uG\"\fum\u001a\t\u0003\r:\u001aBA\fB-7BY!1\fB1A\u0002\u0004\u0007\r\u001c7u\u001b\t\u0011iFC\u0002\u0003`]\u000bqA];oi&lW-\u0003\u0003\u0003d\tu#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8omQ\u0011!QK\u0001\ti>\u001cFO]5oOR\u0011!QA\u0001\u0006CB\u0004H.\u001f\u000b\u000ei\n=$\u0011\u000fB:\u0005k\u00129H!\u001f\t\u000by\u000b\u0004\u0019\u00011\t\u000b\u0011\f\u0004\u0019\u00011\t\u000b\u0019\f\u0004\u0019\u00011\t\u000b!\f\u0004\u0019\u00011\t\u000b)\f\u0004\u0019\u00017\t\u000bA\f\u0004\u0019\u00017\u0002\u000fUt\u0017\r\u001d9msR!!q\u0010BF!\u00151&\u0011\u0011BC\u0013\r\u0011\u0019i\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0013Y\u00139\t\u00191aA2d\u0017b\u0001BE/\n1A+\u001e9mKZB\u0001B!$3\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa%\u0011\t\t\u001d!QS\u0005\u0005\u0005/\u0013IA\u0001\u0004PE*,7\r\u001e")
public class CountMinSketchAgg
extends TypedImperativeAggregate<CountMinSketch>
implements ExpectsInputTypes,
Serializable {
    private double eps;
    private double confidence;
    private int seed;
    private final Expression child;
    private final Expression epsExpression;
    private final Expression confidenceExpression;
    private final Expression seedExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile byte bitmap$0;

    public static Option<Tuple6<Expression, Expression, Expression, Expression, Object, Object>> unapply(CountMinSketchAgg countMinSketchAgg) {
        return CountMinSketchAgg$.MODULE$.unapply(countMinSketchAgg);
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Expression, Object, Object>, CountMinSketchAgg> tupled() {
        return CountMinSketchAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, CountMinSketchAgg>>>>>> curried() {
        return CountMinSketchAgg$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public Expression epsExpression() {
        return this.epsExpression;
    }

    public Expression confidenceExpression() {
        return this.confidenceExpression;
    }

    public Expression seedExpression() {
        return this.seedExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private double eps$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eps = BoxesRunTime.unboxToDouble((Object)this.epsExpression().eval(this.epsExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.eps;
    }

    private double eps() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eps$lzycompute() : this.eps;
    }

    private double confidence$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.confidence = BoxesRunTime.unboxToDouble((Object)this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.confidence;
    }

    private double confidence() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.confidence$lzycompute() : this.confidence;
    }

    private int seed$lzycompute() {
        CountMinSketchAgg countMinSketchAgg = this;
        synchronized (countMinSketchAgg) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.seed = BoxesRunTime.unboxToInt((Object)this.seedExpression().eval(this.seedExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.seed;
    }

    private int seed() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.seed$lzycompute() : this.seed;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.epsExpression().foldable() || !this.confidenceExpression().foldable() || !this.seedExpression().foldable() ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided must be a literal or foldable") : (this.epsExpression().eval(this.epsExpression().eval$default$1()) == null || this.confidenceExpression().eval(this.confidenceExpression().eval$default$1()) == null || this.seedExpression().eval(this.seedExpression().eval$default$1()) == null ? new TypeCheckResult.TypeCheckFailure("The eps, confidence or seed provided should not be null") : (this.eps() <= 0.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(50).append("Relative error must be positive (current value = ").append(this.eps()).append(")").toString()) : (this.confidence() <= 0.0 || this.confidence() >= 1.0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(61).append("Confidence must be within range (0.0, 1.0) (current value = ").append(this.confidence()).append(")").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$))));
    }

    @Override
    public CountMinSketch createAggregationBuffer() {
        return CountMinSketch.create((double)this.eps(), (double)this.confidence(), (int)this.seed());
    }

    @Override
    public CountMinSketch update(CountMinSketch buffer, InternalRow input) {
        block2: {
            Object value = this.child().eval(input);
            if (value == null) break block2;
            DataType dataType = this.child().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                buffer.addBinary(((UTF8String)value).getBytes());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                buffer.add(value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return buffer;
    }

    @Override
    public CountMinSketch merge(CountMinSketch buffer, CountMinSketch input) {
        buffer.mergeInPlace(input);
        return buffer;
    }

    @Override
    public Object eval(CountMinSketch buffer) {
        return this.serialize(buffer);
    }

    @Override
    public byte[] serialize(CountMinSketch buffer) {
        return buffer.toByteArray();
    }

    @Override
    public CountMinSketch deserialize(byte[] storageFormat) {
        return CountMinSketch.readFrom((byte[])storageFormat);
    }

    @Override
    public CountMinSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public CountMinSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        int x$6 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$1);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$})), DoubleType$.MODULE$, DoubleType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.epsExpression(), this.confidenceExpression(), this.seedExpression()}));
    }

    @Override
    public String prettyName() {
        return "count_min_sketch";
    }

    public CountMinSketchAgg copy(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CountMinSketchAgg(child, epsExpression, confidenceExpression, seedExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.epsExpression();
    }

    public Expression copy$default$3() {
        return this.confidenceExpression();
    }

    public Expression copy$default$4() {
        return this.seedExpression();
    }

    public int copy$default$5() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$6() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CountMinSketchAgg";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.epsExpression();
                break;
            }
            case 2: {
                object = this.confidenceExpression();
                break;
            }
            case 3: {
                object = this.seedExpression();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CountMinSketchAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CountMinSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        CountMinSketchAgg countMinSketchAgg = (CountMinSketchAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = countMinSketchAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.epsExpression();
        Expression expression4 = countMinSketchAgg.epsExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.confidenceExpression();
        Expression expression6 = countMinSketchAgg.confidenceExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.seedExpression();
        Expression expression8 = countMinSketchAgg.seedExpression();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (this.mutableAggBufferOffset() != countMinSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != countMinSketchAgg.inputAggBufferOffset()) return false;
        if (!countMinSketchAgg.canEqual(this)) return false;
        return true;
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.epsExpression = epsExpression;
        this.confidenceExpression = confidenceExpression;
        this.seedExpression = seedExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public CountMinSketchAgg(Expression child, Expression epsExpression, Expression confidenceExpression, Expression seedExpression) {
        this(child, epsExpression, confidenceExpression, seedExpression, 0, 0);
    }
}

