/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;

final class BufferHolder {
    private static final int ARRAY_MAX = ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH;
    private byte[] buffer;
    private int cursor = Platform.BYTE_ARRAY_OFFSET;
    private final UnsafeRow row;
    private final int fixedSize;

    BufferHolder(UnsafeRow row) {
        this(row, 64);
    }

    BufferHolder(UnsafeRow row, int initialSize) {
        int bitsetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
        if (row.numFields() > (ARRAY_MAX - initialSize - bitsetWidthInBytes) / 8) {
            throw new UnsupportedOperationException("Cannot create BufferHolder for input UnsafeRow because there are too many fields (number of fields: " + row.numFields() + ")");
        }
        this.fixedSize = bitsetWidthInBytes + 8 * row.numFields();
        int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)(this.fixedSize + initialSize));
        this.buffer = new byte[roundedSize];
        this.row = row;
        this.row.pointTo(this.buffer, this.buffer.length);
    }

    void grow(int neededSize) {
        if (neededSize < 0) {
            throw new IllegalArgumentException("Cannot grow BufferHolder by size " + neededSize + " because the size is negative");
        }
        if (neededSize > ARRAY_MAX - this.totalSize()) {
            throw new IllegalArgumentException("Cannot grow BufferHolder by size " + neededSize + " because the size after growing exceeds size limitation " + ARRAY_MAX);
        }
        int length = this.totalSize() + neededSize;
        if (this.buffer.length < length) {
            int newLength = length < ARRAY_MAX / 2 ? length * 2 : ARRAY_MAX;
            int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)newLength);
            byte[] tmp = new byte[roundedSize];
            Platform.copyMemory((Object)this.buffer, (long)Platform.BYTE_ARRAY_OFFSET, (Object)tmp, (long)Platform.BYTE_ARRAY_OFFSET, (long)this.totalSize());
            this.buffer = tmp;
            this.row.pointTo(this.buffer, this.buffer.length);
        }
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    int getCursor() {
        return this.cursor;
    }

    void increaseCursor(int val) {
        this.cursor += val;
    }

    void reset() {
        this.cursor = Platform.BYTE_ARRAY_OFFSET + this.fixedSize;
    }

    int totalSize() {
        return this.cursor - Platform.BYTE_ARRAY_OFFSET;
    }
}

