/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MicrosCalendar;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\u0007\u000e\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A!\b\u0001B\u0001B\u0003%1\bC\u0003A\u0001\u0011\u0005\u0011\t\u0003\u0005G\u0001!\u0015\r\u0011\"\u0003H\u0011!)\u0006\u0001#b\u0001\n\u00131\u0006\"B.\u0001\t\u0003b\u0006\"\u0002:\u0001\t\u0003\u001a\b\"\u0002:\u0001\t\u00032\b\"\u0002:\u0001\t\u0003r\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0002\u001d\u0019\u0016<\u0017mY=GCN$H+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0015\tqq\"\u0001\u0003vi&d'B\u0001\t\u0012\u0003!\u0019\u0017\r^1msN$(B\u0001\n\u0014\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0012\u000e\u00035I!\u0001J\u0007\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM]\u0001\ba\u0006$H/\u001a:o!\t9cF\u0004\u0002)YA\u0011\u0011&H\u0007\u0002U)\u00111&G\u0001\u0007yI|w\u000e\u001e \n\u00055j\u0012A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!L\u000f\u0002\ri|g.Z%e!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003uS6,'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012aAW8oK&#\u0017A\u00027pG\u0006dW\r\u0005\u0002=}5\tQH\u0003\u0002\u000fm%\u0011q(\u0010\u0002\u0007\u0019>\u001c\u0017\r\\3\u0002\rqJg.\u001b;?)\u0011\u00115\tR#\u0011\u0005\t\u0002\u0001\"B\u0013\u0005\u0001\u00041\u0003\"B\u0019\u0005\u0001\u0004\u0011\u0004\"\u0002\u001e\u0005\u0001\u0004Y\u0014A\u00044bgR$\u0015\r^3G_Jl\u0017\r^\u000b\u0002\u0011B\u0011\u0011jT\u0007\u0002\u0015*\u0011Qg\u0013\u0006\u0003\u00196\u000bQ\u0001\\1oONR!AT\u000b\u0002\u000f\r|W.\\8og&\u0011\u0001K\u0013\u0002\u000f\r\u0006\u001cH\u000fR1uK\u001a{'/\\1uQ\t)!\u000b\u0005\u0002\u001d'&\u0011A+\b\u0002\niJ\fgn]5f]R\f1aY1m+\u00059\u0006C\u0001\u0012Y\u0013\tIVB\u0001\bNS\u000e\u0014xn]\"bY\u0016tG-\u0019:)\u0005\u0019\u0011\u0016!\u00029beN,GCA/q!\tqVN\u0004\u0002`W:\u0011\u0001M\u001b\b\u0003C&t!A\u00195\u000f\u0005\r<gB\u00013g\u001d\tIS-C\u0001\u0019\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003!EI!AD\b\n\u00051l\u0011!\u0004#bi\u0016$\u0016.\\3Vi&d7/\u0003\u0002o_\na1+\u0015'US6,7\u000f^1na*\u0011A.\u0004\u0005\u0006c\u001e\u0001\rAJ\u0001\u0002g\u00061am\u001c:nCR$\"A\n;\t\u000bUD\u0001\u0019A/\u0002\u0013QLW.Z:uC6\u0004HC\u0001\u0014x\u0011\u0015A\u0018\u00021\u0001z\u0003\t!8\u000f\u0005\u0002{y6\t1P\u0003\u0002\u0013m%\u0011Qp\u001f\u0002\n)&lWm\u001d;b[B$\"AJ@\t\u000f\u0005\u0005!\u00021\u0001\u0002\u0004\u00059\u0011N\\:uC:$\bcA\u001a\u0002\u0006%\u0019\u0011q\u0001\u001b\u0003\u000f%s7\u000f^1oi\u0006)b/\u00197jI\u0006$X\rU1ui\u0016\u0014hn\u0015;sS:<GCAA\u0007!\ra\u0012qB\u0005\u0004\u0003#i\"\u0001B+oSR\u0004")
public class LegacyFastTimestampFormatter
implements TimestampFormatter {
    private transient FastDateFormat fastDateFormat;
    private transient MicrosCalendar cal;
    private final String pattern;
    private final ZoneId zoneId;
    private final Locale locale;
    private volatile transient byte bitmap$trans$0;

    private FastDateFormat fastDateFormat$lzycompute() {
        LegacyFastTimestampFormatter legacyFastTimestampFormatter = this;
        synchronized (legacyFastTimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.fastDateFormat = FastDateFormat.getInstance((String)this.pattern, (TimeZone)TimeZone.getTimeZone(this.zoneId), (Locale)this.locale);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.fastDateFormat;
    }

    private FastDateFormat fastDateFormat() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.fastDateFormat$lzycompute() : this.fastDateFormat;
    }

    private MicrosCalendar cal$lzycompute() {
        LegacyFastTimestampFormatter legacyFastTimestampFormatter = this;
        synchronized (legacyFastTimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.cal = new MicrosCalendar(this.fastDateFormat().getTimeZone(), new StringOps(Predef$.MODULE$.augmentString(this.fastDateFormat().getPattern())).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LegacyFastTimestampFormatter.$anonfun$cal$1(BoxesRunTime.unboxToChar((Object)x$4)))));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cal;
    }

    private MicrosCalendar cal() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.cal$lzycompute() : this.cal;
    }

    @Override
    public long parse(String s) {
        this.cal().clear();
        if (!this.fastDateFormat().parse(s, new ParsePosition(0), (Calendar)this.cal())) {
            throw new IllegalArgumentException(new StringBuilder(26).append("'").append(s).append("' is an invalid timestamp").toString());
        }
        long micros = this.cal().getMicros();
        this.cal().set(14, 0);
        long julianMicros = Math.addExact(DateTimeUtils$.MODULE$.fromMillis(this.cal().getTimeInMillis()), micros);
        return RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(julianMicros);
    }

    @Override
    public String format(long timestamp) {
        long julianMicros = RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(timestamp);
        this.cal().setTimeInMillis(Math.floorDiv(julianMicros, 1000000L) * 1000L);
        this.cal().setMicros(Math.floorMod(julianMicros, 1000000L));
        return this.fastDateFormat().format((Calendar)this.cal());
    }

    @Override
    public String format(Timestamp ts) {
        return ts.getNanos() == 0 ? this.fastDateFormat().format((Date)ts) : this.format(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts));
    }

    @Override
    public String format(Instant instant) {
        return this.format(DateTimeUtils$.MODULE$.instantToMicros(instant));
    }

    @Override
    public void validatePatternString() {
        this.fastDateFormat();
    }

    public static final /* synthetic */ boolean $anonfun$cal$1(char x$4) {
        return x$4 == 'S';
    }

    public LegacyFastTimestampFormatter(String pattern, ZoneId zoneId, Locale locale) {
        this.pattern = pattern;
        this.zoneId = zoneId;
        this.locale = locale;
    }
}

