/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.RaiseError;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import org.apache.spark.sql.catalyst.expressions.StringRPad$;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.VarcharType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CharVarcharUtils$
implements Logging {
    public static CharVarcharUtils$ MODULE$;
    private final String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CharVarcharUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY() {
        return this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY;
    }

    public StructType replaceCharVarcharWithStringInSchema(StructType st) {
        return StructType$.MODULE$.apply((Seq<StructField>)((Seq)st.map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            if (MODULE$.hasCharVarchar(field.dataType())) {
                Metadata metadata = new MetadataBuilder().withMetadata(field.metadata()).putString(MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY(), field.dataType().sql()).build();
                DataType x$1 = MODULE$.replaceCharVarcharWithString(field.dataType());
                Metadata x$2 = metadata;
                String x$3 = field.copy$default$1();
                boolean x$4 = field.copy$default$3();
                structField = field.copy(x$3, x$1, x$4, x$2);
            } else {
                structField = field;
            }
            return structField;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public boolean hasCharVarchar(DataType dt) {
        return dt.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CharVarcharUtils$.$anonfun$hasCharVarchar$1(f)));
    }

    public DataType failIfHasCharVarchar(DataType dt) {
        if (!SQLConf$.MODULE$.get().charVarcharAsString() && this.hasCharVarchar(dt)) {
            throw new AnalysisException(new StringBuilder(150).append("char/varchar type can only be used in the table schema. ").append("You can set ").append(SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()).append(" to true, so that Spark").append(" treat them as string type as same as Spark 3.0 and earlier").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.replaceCharVarcharWithString(dt);
    }

    public DataType replaceCharVarcharWithString(DataType dt) {
        DataType dataType;
        DataType dataType2 = dt;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType et = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            dataType = new ArrayType(this.replaceCharVarcharWithString(et), nullable);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean nullable = mapType.valueContainsNull();
            dataType = new MapType(this.replaceCharVarcharWithString(kt), this.replaceCharVarcharWithString(vt), nullable);
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            dataType = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> {
                DataType x$1 = MODULE$.replaceCharVarcharWithString(field.dataType());
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        } else {
            dataType = dataType2 instanceof CharType ? StringType$.MODULE$ : (dataType2 instanceof VarcharType ? StringType$.MODULE$ : dt);
        }
        return dataType;
    }

    public DataType replaceCharVarcharWithStringForCast(DataType dt) {
        DataType dataType;
        if (SQLConf$.MODULE$.get().charVarcharAsString()) {
            dataType = this.replaceCharVarcharWithString(dt);
        } else if (this.hasCharVarchar(dt)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(255).append("The Spark cast operator does not support char/varchar type and simply treats them as string type. Please use string type directly to avoid confusion. Otherwise,").append(" you can set ").append(SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key()).append(" to true, so that Spark treat").append(" them as string type as same as Spark 3.0 and earlier").toString());
            dataType = this.replaceCharVarcharWithString(dt);
        } else {
            dataType = dt;
        }
        return dataType;
    }

    public AttributeReference cleanAttrMetadata(AttributeReference attr) {
        Metadata cleaned = new MetadataBuilder().withMetadata(attr.metadata()).remove(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()).build();
        return attr.withMetadata(cleaned);
    }

    public Option<DataType> getRawType(Metadata metadata) {
        return metadata.contains(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()) ? new Some((Object)CatalystSqlParser$.MODULE$.parseDataType(metadata.getString(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()))) : None$.MODULE$;
    }

    public StructType getRawSchema(StructType schema) {
        Seq fields = (Seq)schema.map((Function1 & Serializable & scala.Serializable)field -> (StructField)MODULE$.getRawType(field.metadata()).map((Function1 & Serializable & scala.Serializable)dt -> {
            DataType x$1 = dt;
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            return field.copy(x$2, x$1, x$3, x$4);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> field), Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq<StructField>)fields);
    }

    public Seq<NamedExpression> paddingWithLengthCheck(Seq<AttributeReference> output) {
        return (Seq)output.map((Function1 & Serializable & scala.Serializable)attr -> (NamedExpression)MODULE$.getRawType(attr.metadata()).filter((Function1 & Serializable & scala.Serializable)rawType -> BoxesRunTime.boxToBoolean((boolean)rawType.existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)CharVarcharUtils$.$anonfun$paddingWithLengthCheck$3(dt))))).map((Function1 & Serializable & scala.Serializable)rawType -> {
            Expression x$1 = MODULE$.paddingWithLengthCheck((Expression)attr, (DataType)rawType);
            String x$2 = attr.name();
            Some x$3 = new Some((Object)attr.metadata());
            ExprId x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$4, x$5, (Option<Metadata>)x$3, x$6);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> attr), Seq$.MODULE$.canBuildFrom());
    }

    private Expression paddingWithLengthCheck(Expression expr, DataType dt) {
        Expression expression;
        DataType dataType = dt;
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            expression = new StringRPad(this.stringLengthCheck(expr, dt), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length)), StringRPad$.MODULE$.apply$default$3());
        } else if (dataType instanceof VarcharType) {
            expression = this.stringLengthCheck(expr, dt);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            CreateNamedStruct struct = new CreateNamedStruct((Seq<Expression>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply(f.name()), MODULE$.paddingWithLengthCheck(new GetStructField(expr, i, (Option<String>)new Some((Object)f.name())), f.dataType())}));
                return seq;
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            expression = expr.nullable() ? new If(new IsNull(expr), new Literal(null, struct.dataType()), struct) : struct;
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            expression = this.charTypePaddingInArray(expr, et, containsNull);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            Expression newKeys = this.charTypePaddingInArray(new MapKeys(expr), kt, false);
            Expression newValues = this.charTypePaddingInArray(new MapValues(expr), vt, valueContainsNull);
            expression = new MapFromArrays(newKeys, newValues);
        } else {
            expression = expr;
        }
        return expression;
    }

    private Expression charTypePaddingInArray(Expression arr, DataType et, boolean containsNull) {
        NamedLambdaVariable param = new NamedLambdaVariable("x", this.replaceCharVarcharWithString(et), containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        LambdaFunction func = new LambdaFunction(this.paddingWithLengthCheck(param, et), (Seq<NamedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{param}))), LambdaFunction$.MODULE$.apply$default$3());
        return new ArrayTransform(arr, func);
    }

    public Expression stringLengthCheck(Expression expr, Attribute targetAttr) {
        return (Expression)this.getRawType(targetAttr.metadata()).map((Function1 & Serializable & scala.Serializable)rawType -> MODULE$.stringLengthCheck(expr, (DataType)rawType)).getOrElse((Function0 & Serializable & scala.Serializable)() -> expr);
    }

    private Expression raiseError(Expression expr, String typeName, int length) {
        Concat errorMsg = new Concat((Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply("input string of length "), new Cast(new Length(expr), StringType$.MODULE$, Cast$.MODULE$.apply$default$3()), Literal$.MODULE$.apply(new StringBuilder(34).append(" exceeds ").append(typeName).append(" type length limitation: ").append(length).toString())}))));
        return new Cast(new RaiseError(errorMsg), StringType$.MODULE$, Cast$.MODULE$.apply$default$3());
    }

    private Expression stringLengthCheck(Expression expr, DataType dt) {
        Expression expression;
        DataType dataType = dt;
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            StringTrimRight trimmed = StringTrimRight$.MODULE$.apply(expr);
            expression = new If(new GreaterThan(new Length(trimmed), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length))), this.raiseError(expr, "char", length), trimmed);
        } else if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int length = varcharType.length();
            StringTrimRight trimmed = StringTrimRight$.MODULE$.apply(expr);
            expression = new If(new LessThanOrEqual(new Length(expr), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length))), expr, new If(new GreaterThan(new Length(trimmed), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length))), this.raiseError(expr, "varchar", length), new StringRPad(trimmed, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length)), StringRPad$.MODULE$.apply$default$3())));
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            CreateNamedStruct struct = new CreateNamedStruct((Seq<Expression>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply(f.name()), MODULE$.stringLengthCheck((Expression)new GetStructField(expr, i, (Option<String>)new Some((Object)f.name())), f.dataType())}));
                return seq;
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
            expression = expr.nullable() ? new If(new IsNull(expr), new Literal(null, struct.dataType()), struct) : struct;
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            expression = this.stringLengthCheckInArray(expr, et, containsNull);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            Expression newKeys = this.stringLengthCheckInArray(new MapKeys(expr), kt, false);
            Expression newValues = this.stringLengthCheckInArray(new MapValues(expr), vt, valueContainsNull);
            expression = new MapFromArrays(newKeys, newValues);
        } else {
            expression = expr;
        }
        return expression;
    }

    private Expression stringLengthCheckInArray(Expression arr, DataType et, boolean containsNull) {
        NamedLambdaVariable param = new NamedLambdaVariable("x", this.replaceCharVarcharWithString(et), containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        LambdaFunction func = new LambdaFunction(this.stringLengthCheck((Expression)param, et), (Seq<NamedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{param}))), LambdaFunction$.MODULE$.apply$default$3());
        return new ArrayTransform(arr, func);
    }

    public Seq<Expression> addPaddingInStringComparison(Seq<Attribute> attrs2) {
        Seq seq;
        Seq rawTypes = (Seq)attrs2.map((Function1 & Serializable & scala.Serializable)attr -> MODULE$.getRawType(attr.metadata()), Seq$.MODULE$.canBuildFrom());
        if (rawTypes.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))) {
            seq = attrs2;
        } else {
            DataType typeWithTargetCharLength = (DataType)((TraversableOnce)rawTypes.map((Function1 & Serializable & scala.Serializable)x$2 -> (DataType)x$2.get(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(type1, type2) -> MODULE$.typeWithWiderCharLength((DataType)type1, (DataType)type2));
            seq = (Seq)((TraversableLike)attrs2.zip((GenIterable)rawTypes.map((Function1 & Serializable & scala.Serializable)x$3 -> (DataType)x$3.get(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute attr = (Attribute)tuple2._1();
                DataType rawType = (DataType)tuple2._2();
                Expression expression = (Expression)MODULE$.padCharToTargetLength(attr, rawType, typeWithTargetCharLength).getOrElse((Function0 & Serializable & scala.Serializable)() -> attr);
                return expression;
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private DataType typeWithWiderCharLength(DataType type1, DataType type2) {
        void var3_14;
        Tuple2 tuple2 = new Tuple2((Object)type1, (Object)type2);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof CharType) {
                CharType charType = (CharType)dataType;
                int len1 = charType.length();
                if (dataType2 instanceof CharType) {
                    CharType charType2 = (CharType)dataType2;
                    int len2 = charType2.length();
                    CharType charType3 = new CharType(package$.MODULE$.max(len1, len2));
                    return var3_14;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields1 = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] fields2 = structType2.fields();
                    Predef$.MODULE$.assert(fields1.length == fields2.length);
                    StructType structType3 = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        StructField left = (StructField)tuple2._1();
                        StructField right = (StructField)tuple2._2();
                        StructField structField = new StructField("", MODULE$.typeWithWiderCharLength(left.dataType(), right.dataType()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                        return structField;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                    return var3_14;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et1 = arrayType.elementType();
                if (dataType4 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType4;
                    DataType et2 = arrayType2.elementType();
                    ArrayType arrayType3 = ArrayType$.MODULE$.apply(this.typeWithWiderCharLength(et1, et2));
                    return var3_14;
                }
            }
        }
        NullType$ nullType$ = NullType$.MODULE$;
        return var3_14;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Expression> padCharToTargetLength(Expression expr, DataType rawType, DataType typeWithTargetCharLength) {
        Tuple2 tuple2 = new Tuple2((Object)rawType, (Object)typeWithTargetCharLength);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof CharType) {
                CharType charType;
                int target;
                CharType charType2 = (CharType)dataType;
                int len = charType2.length();
                if (dataType2 instanceof CharType && (target = (charType = (CharType)dataType2).length()) > len) {
                    return new Some((Object)new StringRPad(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)target)), StringRPad$.MODULE$.apply$default$3()));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] targets = structType2.fields();
                    Predef$.MODULE$.assert(fields.length == targets.length);
                    boolean needPadding = false;
                    ArrayBuffer createStructExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                    for (int i = 0; i < fields.length; ++i) {
                        StructField field = fields[i];
                        GetStructField fieldExpr = new GetStructField(expr, i, (Option<String>)new Some((Object)field.name()));
                        Option<Expression> padded2 = this.padCharToTargetLength(fieldExpr, field.dataType(), targets[i].dataType());
                        needPadding = padded2.isDefined();
                        createStructExprs.$plus$eq((Object)Literal$.MODULE$.apply(field.name()));
                        createStructExprs.$plus$eq(padded2.getOrElse((Function0 & Serializable & scala.Serializable)() -> fieldExpr));
                    }
                    return needPadding ? new Some((Object)new CreateNamedStruct((Seq<Expression>)createStructExprs.toSeq())) : None$.MODULE$;
                }
            }
        }
        if (tuple2 == null) return None$.MODULE$;
        DataType dataType = (DataType)tuple2._1();
        DataType dataType4 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return None$.MODULE$;
        ArrayType arrayType = (ArrayType)dataType;
        DataType et = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        if (!(dataType4 instanceof ArrayType)) return None$.MODULE$;
        ArrayType arrayType2 = (ArrayType)dataType4;
        DataType target = arrayType2.elementType();
        NamedLambdaVariable param = new NamedLambdaVariable("x", this.replaceCharVarcharWithString(et), containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        return this.padCharToTargetLength(param, et, target).map((Function1 & Serializable & scala.Serializable)padded -> {
            LambdaFunction func = new LambdaFunction((Expression)padded, (Seq<NamedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{param}))), LambdaFunction$.MODULE$.apply$default$3());
            return new ArrayTransform(expr, func);
        });
    }

    public static final /* synthetic */ boolean $anonfun$hasCharVarchar$1(DataType f) {
        return f instanceof CharType || f instanceof VarcharType;
    }

    public static final /* synthetic */ boolean $anonfun$paddingWithLengthCheck$3(DataType dt) {
        return dt instanceof CharType || dt instanceof VarcharType;
    }

    private CharVarcharUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY = "__CHAR_VARCHAR_TYPE_STRING";
    }
}

