/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha1$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns a sha1 hash value as a hex string of the `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark');\n       85f5955f4b27a9a4c2aab6ffe5d7189fc298b92c\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\f\u0019\u0001\u0016B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005\u007f!)1\t\u0001C\u0001\t\")q\t\u0001C!\u0011\")q\n\u0001C!!\")A\f\u0001C);\")1\r\u0001C!I\"9!\u000fAA\u0001\n\u0003\u0019\bbB;\u0001#\u0003%\tA\u001e\u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000bA\u0011\"a\u0006\u0001\u0003\u0003%\t!!\u0007\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0002\"CA\u0015\u0001\u0005\u0005I\u0011IA\u0016\u0011%\tI\u0004AA\u0001\n\u0003\tY\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H\u001dI\u0011Q\r\r\u0002\u0002#\u0005\u0011q\r\u0004\t/a\t\t\u0011#\u0001\u0002j!11)\u0005C\u0001\u0003oB\u0011\"!\u001f\u0012\u0003\u0003%)%a\u001f\t\u0013\u0005u\u0014#!A\u0005\u0002\u0006}\u0004\"CAB#\u0005\u0005I\u0011QAC\u0011%\t\t*EA\u0001\n\u0013\t\u0019J\u0001\u0003TQ\u0006\f$BA\r\u001b\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005ma\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00011#&\f\u001b;!\t9\u0003&D\u0001\u0019\u0013\tI\u0003DA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t93&\u0003\u0002-1\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002/c9\u0011qeL\u0005\u0003aa\tq\u0001]1dW\u0006<W-\u0003\u00023g\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001\u0019\u0019!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u001d\u0001&o\u001c3vGR\u0004\"!N\u001e\n\u0005q2$\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#A \u0011\u0005\u001d\u0002\u0015BA!\u0019\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t)e\t\u0005\u0002(\u0001!)Qh\u0001a\u0001\u007f\u0005AA-\u0019;b)f\u0004X-F\u0001J!\tQU*D\u0001L\u0015\taE$A\u0003usB,7/\u0003\u0002O\u0017\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0015\t\u0004%fKeBA*Y\u001d\t!v+D\u0001V\u0015\t1F%\u0001\u0004=e>|GOP\u0005\u0002o%\u0011\u0001GN\u0005\u00035n\u00131aU3r\u0015\t\u0001d'\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002_CB\u0011QgX\u0005\u0003AZ\u00121!\u00118z\u0011\u0015\u0011g\u00011\u0001_\u0003\u0015Ig\u000e];u\u0003%!wnR3o\u0007>$W\rF\u0002fWB\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\r\u0002\u000f\r|G-Z4f]&\u0011!n\u001a\u0002\t\u000bb\u0004(oQ8eK\")An\u0002a\u0001[\u0006\u00191\r\u001e=\u0011\u0005\u0019t\u0017BA8h\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!]\u0004A\u0002\u0015\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0003\u000bRDq!\u0010\u0005\u0011\u0002\u0003\u0007q(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003]T#a\u0010=,\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0013Ut7\r[3dW\u0016$'B\u0001@7\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003Y(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u00198h\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017\u0002BA\u000b\u0003\u0017\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u000e!\r)\u0014QD\u0005\u0004\u0003?1$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00010\u0002&!I\u0011q\u0005\u0007\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0002#BA\u0018\u0003kqVBAA\u0019\u0015\r\t\u0019DN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001c\u0003c\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QHA\"!\r)\u0014qH\u0005\u0004\u0003\u00032$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003Oq\u0011\u0011!a\u0001=\u00061Q-];bYN$B!!\u0010\u0002J!A\u0011qE\b\u0002\u0002\u0003\u0007a\fK\b\u0001\u0003\u001b\n\u0019&!\u0016\u0002Z\u0005m\u0013qLA1!\r9\u0013qJ\u0005\u0004\u0003#B\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003/\nqi\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAMD\u0017-\r\u0011iCND\u0007E^1mk\u0016\u0004\u0013m\u001d\u0011bA!,\u0007\u0010I:ue&tw\rI8gAQDW\r\t1fqB\u0014\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QL\u0001b\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001d6MVJT'\u000e45EJ:\u0014-O15GJ\n\u0017M\u0019\u001cgM\u0016,DmN\u00199s\u0019\u001c''\u000f\u001dcsI\u001a'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\r\u0014!B\u0019/k9\u0002\u0014\u0001B*iCF\u0002\"aJ\t\u0014\tE\tYG\u000f\t\u0007\u0003[\n\u0019hP#\u000e\u0005\u0005=$bAA9m\u00059!/\u001e8uS6,\u0017\u0002BA;\u0003_\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\t9'\u0001\u0005u_N#(/\u001b8h)\t\t9!A\u0003baBd\u0017\u0010F\u0002F\u0003\u0003CQ!\u0010\u000bA\u0002}\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\b\u00065\u0005\u0003B\u001b\u0002\n~J1!a#7\u0005\u0019y\u0005\u000f^5p]\"A\u0011qR\u000b\u0002\u0002\u0003\u0007Q)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0013\t\u0005\u0003\u0013\t9*\u0003\u0003\u0002\u001a\u0006-!AB(cU\u0016\u001cG\u000f")
public class Sha1
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Sha1 sha1) {
        return Sha1$.MODULE$.unapply(sha1);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Sha1, A> function1) {
        return Sha1$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Sha1> compose(Function1<A, Expression> function1) {
        return Sha1$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryType$[]{BinaryType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input) {
        return UTF8String.fromString((String)DigestUtils.sha1Hex((byte[])((byte[])input)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(33).append("UTF8String.fromString(").append(DigestUtils.class.getName()).append(".sha1Hex(").append((String)c).append("))").toString());
    }

    public Sha1 copy(Expression child) {
        return new Sha1(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Sha1";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha1)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha1 sha1 = (Sha1)x$1;
        Expression expression = this.child();
        Expression expression2 = sha1.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!sha1.canEqual(this)) return false;
        return true;
    }

    public Sha1(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

