/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GroupingID;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;

public final class QueryCompilationErrors$ {
    public static QueryCompilationErrors$ MODULE$;

    static {
        new QueryCompilationErrors$();
    }

    public Throwable groupingIDMismatchError(GroupingID groupingID, Seq<Expression> groupByExprs) {
        return new AnalysisException(new StringBuilder(60).append("Columns of grouping_id (").append(groupingID.groupByExprs().mkString(",")).append(") ").append("does not match grouping columns (").append(groupByExprs.mkString(",")).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable groupingColInvalidError(Expression groupingCol, Seq<Expression> groupByExprs) {
        return new AnalysisException(new StringBuilder(57).append("Column of grouping (").append(groupingCol).append(") can't be found ").append("in grouping columns ").append(groupByExprs.mkString(",")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable groupingSizeTooLargeError(int sizeLimit) {
        return new AnalysisException(new StringBuilder(42).append("Grouping sets size cannot be greater than ").append(sizeLimit).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unorderablePivotColError(Expression pivotCol) {
        return new AnalysisException(new StringBuilder(58).append("Invalid pivot column '").append(pivotCol).append("'. Pivot columns must be comparable.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonLiteralPivotValError(Expression pivotVal) {
        return new AnalysisException(new StringBuilder(55).append("Literal expressions required for pivot values, found '").append(pivotVal).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable pivotValDataTypeMismatchError(Expression pivotVal, Expression pivotCol) {
        return new AnalysisException(new StringBuilder(79).append("Invalid pivot value '").append(pivotVal).append("': ").append("value data type ").append(pivotVal.dataType().simpleString()).append(" does not match ").append("pivot column data type ").append(pivotCol.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedIfNotExistsError(String tableName) {
        return new AnalysisException(new StringBuilder(56).append("Cannot write, IF NOT EXISTS is not supported for table: ").append(tableName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonPartitionColError(String partitionName) {
        return new AnalysisException(new StringBuilder(61).append("PARTITION clause cannot contain a non-partition column name: ").append(partitionName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable addStaticValToUnknownColError(String staticName) {
        return new AnalysisException(new StringBuilder(44).append("Cannot add static value for unknown column: ").append(staticName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unknownStaticPartitionColError(String name) {
        return new AnalysisException(new StringBuilder(33).append("Unknown static partition column: ").append(name).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nestedGeneratorError(Expression trimmedNestedGenerator) {
        return new AnalysisException(new StringBuilder(71).append("Generators are not supported when it's nested in expressions, but got: ").append(package$.MODULE$.toPrettySQL(trimmedNestedGenerator)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable moreThanOneGeneratorError(Seq<Expression> generators, String clause) {
        return new AnalysisException(new StringBuilder(51).append("Only one generator allowed per ").append(clause).append(" clause but found ").append(generators.size()).append(": ").append(((TraversableOnce)generators.map((Function1 & java.io.Serializable & Serializable)e -> package$.MODULE$.toPrettySQL((Expression)e), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable generatorOutsideSelectError(LogicalPlan plan2) {
        return new AnalysisException(new StringBuilder(65).append("Generators are not supported outside the SELECT clause, but got: ").append(plan2.simpleString(SQLConf$.MODULE$.get().maxToStringFields())).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable legacyStoreAssignmentPolicyError() {
        String configKey = SQLConf$.MODULE$.STORE_ASSIGNMENT_POLICY().key();
        return new AnalysisException(new StringBuilder(116).append("LEGACY store assignment policy is disallowed in Spark data source V2. ").append("Please set the configuration ").append(configKey).append(" to other values.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unresolvedUsingColForJoinError(String colName, LogicalPlan plan2, String side) {
        return new AnalysisException(new StringBuilder(82).append("USING column `").append(colName).append("` cannot be resolved on the ").append(side).append(" ").append("side of the join. The ").append(side).append("-side columns: [").append(((TraversableOnce)plan2.output().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataTypeMismatchForDeserializerError(DataType dataType, String desiredType) {
        String quantifier = desiredType.equals("array") ? "an" : "a";
        return new AnalysisException(new StringBuilder(21).append("need ").append(quantifier).append(" ").append(desiredType).append(" field but got ").append(dataType.catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable fieldNumberMismatchForDeserializerError(StructType schema, int maxOrdinal) {
        return new AnalysisException(new StringBuilder(74).append("Try to map ").append(schema.catalogString()).append(" to Tuple").append(maxOrdinal + 1).append(", ").append("but failed as the number of fields does not line up.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable upCastFailureError(String fromStr, Expression from, DataType to, Seq<String> walkedTypePath) {
        return new AnalysisException(new StringBuilder(187).append("Cannot up cast ").append(fromStr).append(" from ").append(from.dataType().catalogString()).append(" to ").append(to.catalogString()).append(".\n").append("The type path of the target object is:\n").append(walkedTypePath.mkString("", "\n", "\n")).append("You can either add an explicit cast to the input data or choose a higher precision ").append("type of the field in the target object").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedAbstractDataTypeForUpCastError(AbstractDataType gotType) {
        return new AnalysisException(new StringBuilder(66).append("UpCast only support DecimalType as AbstractDataType yet, but got: ").append(gotType).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable outerScopeFailureForNewInstanceError(String className) {
        return new AnalysisException(new StringBuilder(155).append("Unable to generate an encoder for inner class `").append(className).append("` without ").append("access to the scope that this class was defined in.\n").append("Try moving this class out of its parent class.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable referenceColNotFoundForAlterTableChangesError(TableChange.After after, String parentName) {
        return new AnalysisException(new StringBuilder(43).append("Couldn't find the reference column for ").append(after).append(" at ").append(parentName).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private QueryCompilationErrors$() {
        MODULE$ = this;
    }
}

