/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetJsonObject$;
import org.apache.spark.sql.catalyst.expressions.JsonPathParser$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Key$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Subscript$;
import org.apache.spark.sql.catalyst.expressions.PathInstruction$Wildcard$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$FlattenStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$QuotedStyle$;
import org.apache.spark.sql.catalyst.expressions.WriteStyle$RawStyle$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(json_txt, path) - Extracts a json object from `path`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":\"b\"}', '$.a');\n       b\n  ", group="json_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0011#\u0001>B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0006\u0001\"\u0011H\u0011\u0015!\u0006\u0001\"\u0011H\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\u0001\b\u0001\"\u0011r\u0011!Q\b\u0001#b\u0001\n\u0013Y\bbBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!a\u001d\u0001\t\u0013\t)\bC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0001\u0002\u0012\"I\u0011q\u0013\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003_\u0003\u0011\u0013!C\u0001\u00033C\u0011\"!-\u0001\u0003\u0003%\t%a-\t\u0013\u0005\r\u0007!!A\u0005\u0002\u0005\u0015\u0007\"CAg\u0001\u0005\u0005I\u0011AAh\u0011%\t)\u000eAA\u0001\n\u0003\n9\u000eC\u0005\u0002f\u0002\t\t\u0011\"\u0001\u0002h\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0013Q^\u0004\n\u0005#\u0011\u0013\u0011!E\u0001\u0005'1\u0001\"\t\u0012\u0002\u0002#\u0005!Q\u0003\u0005\u0007\u001dn!\tAa\t\t\u0013\t\u00152$!A\u0005F\t\u001d\u0002\"\u0003B\u00157\u0005\u0005I\u0011\u0011B\u0016\u0011%\u0011\tdGA\u0001\n\u0003\u0013\u0019\u0004C\u0005\u0003Bm\t\t\u0011\"\u0003\u0003D\tiq)\u001a;Kg>twJ\u00196fGRT!a\t\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\u0007\u0001A\"t'P\"\u0011\u0005E\u0012T\"\u0001\u0012\n\u0005M\u0012#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tT'\u0003\u00027E\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005aZT\"A\u001d\u000b\u0005i\u0012\u0013aB2pI\u0016<WM\\\u0005\u0003ye\u0012qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\b!J|G-^2u!\tqD)\u0003\u0002F\u007f\ta1+\u001a:jC2L'0\u00192mK\u0006!!n]8o+\u0005A\u0005CA\u0019J\u0013\tQ%E\u0001\u0006FqB\u0014Xm]:j_:\fQA[:p]\u0002\nA\u0001]1uQ\u0006)\u0001/\u0019;iA\u00051A(\u001b8jiz\"2\u0001U)S!\t\t\u0004\u0001C\u0003G\u000b\u0001\u0007\u0001\nC\u0003M\u000b\u0001\u0007\u0001*\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018AC5oaV$H+\u001f9fgV\tq\u000bE\u0002YA\u000et!!\u00170\u000f\u0005ikV\"A.\u000b\u0005qs\u0013A\u0002\u001fs_>$h(C\u0001A\u0013\tyv(A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'aA*fc*\u0011ql\u0010\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u001a\nQ\u0001^=qKNL!\u0001[3\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002G\u0006Aa.\u001e7mC\ndW-F\u0001n!\tqd.\u0003\u0002p\u007f\t9!i\\8mK\u0006t\u0017A\u00039sKR$\u0018PT1nKV\t!\u000f\u0005\u0002to:\u0011A/\u001e\t\u00035~J!A^ \u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003m~\n!\u0002]1sg\u0016$\u0007+\u0019;i+\u0005a\bc\u0001 ~\u007f&\u0011ap\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000ba\u000b\t!!\u0002\n\u0007\u0005\r!M\u0001\u0003MSN$\bcA\u0019\u0002\b%\u0019\u0011\u0011\u0002\u0012\u0003\u001fA\u000bG\u000f[%ogR\u0014Xo\u0019;j_:D3\u0001DA\u0007!\rq\u0014qB\u0005\u0004\u0003#y$!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u0011)g/\u00197\u0015\t\u0005]\u0011Q\u0004\t\u0004}\u0005e\u0011bAA\u000e\u007f\t\u0019\u0011I\\=\t\u0013\u0005}Q\u0002%AA\u0002\u0005\u0005\u0012!B5oaV$\b\u0003BA\u0012\u0003Ki\u0011\u0001J\u0005\u0004\u0003O!#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002]1sg\u0016\u0004\u0016\r\u001e5\u0015\u0007q\fi\u0003\u0003\u0004M\u001d\u0001\u0007\u0011q\u0006\t\u0005\u0003c\tI$\u0004\u0002\u00024)\u0019a-!\u000e\u000b\u0007\u0005]\u0002&\u0001\u0004v]N\fg-Z\u0005\u0005\u0003w\t\u0019D\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\f!\"\u0019:sCfLe\u000eZ3y)\u0019\t\t%!\u0014\u0002jA1a(a\u0011\u0002H5L1!!\u0012@\u0005%1UO\\2uS>t\u0017\u0007E\u0002?\u0003\u0013J1!a\u0013@\u0005\u0011auN\\4\t\u000f\u0005=s\u00021\u0001\u0002R\u0005\t\u0001\u000f\u0005\u0003\u0002T\u0005\u0015TBAA+\u0015\u0011\t9&!\u0017\u0002\t\r|'/\u001a\u0006\u0005\u00037\ni&A\u0004kC\u000e\\7o\u001c8\u000b\t\u0005}\u0013\u0011M\u0001\nM\u0006\u001cH/\u001a:y[2T!!a\u0019\u0002\u0007\r|W.\u0003\u0003\u0002h\u0005U#A\u0003&t_:\u0004\u0016M]:fe\"9\u00111N\bA\u0002\u00055\u0014!\u00014\u0011\ty\ny'\\\u0005\u0004\u0003cz$!\u0003$v]\u000e$\u0018n\u001c81\u00031)g/\u00197vCR,\u0007+\u0019;i)%i\u0017qOA=\u0003\u0007\u000bi\tC\u0004\u0002PA\u0001\r!!\u0015\t\u000f\u0005m\u0004\u00031\u0001\u0002~\u0005\tq\r\u0005\u0003\u0002T\u0005}\u0014\u0002BAA\u0003+\u0012QBS:p]\u001e+g.\u001a:bi>\u0014\bbBAC!\u0001\u0007\u0011qQ\u0001\u0006gRLH.\u001a\t\u0004c\u0005%\u0015bAAFE\tQqK]5uKN#\u0018\u0010\\3\t\u000b1\u0003\u0002\u0019A@\u0002\t\r|\u0007/\u001f\u000b\u0006!\u0006M\u0015Q\u0013\u0005\b\rF\u0001\n\u00111\u0001I\u0011\u001da\u0015\u0003%AA\u0002!\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001c*\u001a\u0001*!(,\u0005\u0005}\u0005\u0003BAQ\u0003Wk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!+@\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\u000b\u0019KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003k\u0003B!a.\u0002B6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,\u0001\u0003mC:<'BAA`\u0003\u0011Q\u0017M^1\n\u0007a\fI,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002HB\u0019a(!3\n\u0007\u0005-wHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0018\u0005E\u0007\"CAj-\u0005\u0005\t\u0019AAd\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001c\t\u0007\u00037\f\t/a\u0006\u000e\u0005\u0005u'bAAp\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0018Q\u001c\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002n\u0003SD\u0011\"a5\u0019\u0003\u0003\u0005\r!a\u0006\u0002\r\u0015\fX/\u00197t)\ri\u0017q\u001e\u0005\n\u0003'L\u0012\u0011!a\u0001\u0003/A3\u0003AAz\u0003s\fY0a@\u0003\u0002\t\u0015!q\u0001B\u0006\u0005\u001b\u00012!MA{\u0013\r\t9P\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti0\u0001\u001f`\rVs5i\u0018\u0015kg>tw\f\u001e=uY\u0001\u0002\u0018\r\u001e5*A5\u0002S\t\u001f;sC\u000e$8\u000fI1!UN|g\u000eI8cU\u0016\u001cG\u000f\t4s_6\u0004\u0003\r]1uQ\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\r\u0011!\u0012\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Om\u0014\u0013M\t\u001e#E\njx\u0005\f\u0011(I9\nw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!E*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003\n\u0005Q!n]8o?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t=\u0011!B\u0019/k9\u0002\u0014!D$fi*\u001bxN\\(cU\u0016\u001cG\u000f\u0005\u000227M!1Da\u0006D!\u001d\u0011IBa\bI\u0011Bk!Aa\u0007\u000b\u0007\tuq(A\u0004sk:$\u0018.\\3\n\t\t\u0005\"1\u0004\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001B\n\u0003!!xn\u0015;sS:<GCAA[\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0001&Q\u0006B\u0018\u0011\u00151e\u00041\u0001I\u0011\u0015ae\u00041\u0001I\u0003\u001d)h.\u00199qYf$BA!\u000e\u0003>A!a( B\u001c!\u0015q$\u0011\b%I\u0013\r\u0011Yd\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t}r$!AA\u0002A\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0003\u0003BA\\\u0005\u000fJAA!\u0013\u0002:\n1qJ\u00196fGR\u0004")
public class GetJsonObject
extends BinaryExpression
implements ExpectsInputTypes,
CodegenFallback,
scala.Serializable {
    private transient Option<List<PathInstruction>> parsedPath;
    private final Expression json;
    private final Expression path;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(GetJsonObject getJsonObject) {
        return GetJsonObject$.MODULE$.unapply(getJsonObject);
    }

    public static Function1<Tuple2<Expression, Expression>, GetJsonObject> tupled() {
        return GetJsonObject$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GetJsonObject>> curried() {
        return GetJsonObject$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression json() {
        return this.json;
    }

    public Expression path() {
        return this.path;
    }

    @Override
    public Expression left() {
        return this.json();
    }

    @Override
    public Expression right() {
        return this.path();
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "get_json_object";
    }

    private Option<List<PathInstruction>> parsedPath$lzycompute() {
        GetJsonObject getJsonObject = this;
        synchronized (getJsonObject) {
            if (!this.bitmap$trans$0) {
                this.parsedPath = this.parsePath((UTF8String)this.path().eval(this.path().eval$default$1()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.parsedPath;
    }

    private Option<List<PathInstruction>> parsedPath() {
        return !this.bitmap$trans$0 ? this.parsedPath$lzycompute() : this.parsedPath;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Option<List<PathInstruction>> parsed;
        UTF8String jsonStr = (UTF8String)this.json().eval(input);
        if (jsonStr == null) {
            return null;
        }
        Option<List<PathInstruction>> option = parsed = this.path().foldable() ? this.parsedPath() : this.parsePath((UTF8String)this.path().eval(input));
        if (parsed.isDefined()) {
            try {
                object = Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), jsonStr), (Function1 & Serializable & scala.Serializable)parser -> {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    boolean matched = BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)output, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> BoxesRunTime.boxToBoolean((boolean)GetJsonObject.$anonfun$eval$4(this, parser, parsed, generator))));
                    return matched ? UTF8String.fromBytes((byte[])output.toByteArray()) : null;
                });
            }
            catch (JsonProcessingException jsonProcessingException) {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    private Option<List<PathInstruction>> parsePath(UTF8String path) {
        return path != null ? JsonPathParser$.MODULE$.parse(path.toString()) : None$.MODULE$;
    }

    private Function1<Object, Object> arrayIndex(JsonParser p, Function0<Object> f) {
        return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x0$1 -> {
            boolean bl;
            long l = x0$1;
            JsonToken jsonToken = p.getCurrentToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken != null ? !jsonToken.equals(jsonToken2) : jsonToken2 != null)) {
                bl = false;
            } else if (0L == l) {
                boolean dirty = f.apply$mcZ$sp();
                while (true) {
                    JsonToken jsonToken3 = p.nextToken();
                    JsonToken jsonToken4 = JsonToken.END_ARRAY;
                    if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
                    p.skipChildren();
                }
                bl = dirty;
            } else if (l > 0L) {
                p.skipChildren();
                p.nextToken();
                bl = this.arrayIndex(p, f).apply$mcZJ$sp(l - 1L);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            return bl;
        };
    }

    private boolean evaluatePath(JsonParser p, JsonGenerator g, WriteStyle style, List<PathInstruction> path) {
        boolean bl;
        block56: {
            while (true) {
                List list;
                Tuple2 tuple2;
                if ((tuple2 = new Tuple2((Object)p.getCurrentToken(), path)) != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list2 = (List)tuple2._2();
                    if (JsonToken.VALUE_STRING.equals(jsonToken) && Nil$.MODULE$.equals(list2)) {
                        WriteStyle writeStyle = style;
                        WriteStyle$RawStyle$ writeStyle$RawStyle$ = WriteStyle$RawStyle$.MODULE$;
                        if (!(writeStyle != null ? !writeStyle.equals(writeStyle$RawStyle$) : writeStyle$RawStyle$ != null)) {
                            if (p.hasTextCharacters()) {
                                g.writeRaw(p.getTextCharacters(), p.getTextOffset(), p.getTextLength());
                            } else {
                                g.writeRaw(p.getText());
                            }
                            bl = true;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list3 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && Nil$.MODULE$.equals(list3)) {
                        WriteStyle writeStyle = style;
                        WriteStyle$FlattenStyle$ writeStyle$FlattenStyle$ = WriteStyle$FlattenStyle$.MODULE$;
                        if (!(writeStyle != null ? !writeStyle.equals(writeStyle$FlattenStyle$) : writeStyle$FlattenStyle$ != null)) {
                            boolean dirty = false;
                            while (true) {
                                JsonToken jsonToken2 = p.nextToken();
                                JsonToken jsonToken3 = JsonToken.END_ARRAY;
                                if (!(jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3))) break;
                                dirty |= this.evaluatePath(p, g, style, (List<PathInstruction>)Nil$.MODULE$);
                            }
                            bl = dirty;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null && Nil$.MODULE$.equals(list = (List)tuple2._2())) {
                    g.copyCurrentStructure(p);
                    bl = true;
                    break block56;
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list4 = (List)tuple2._2();
                    if (JsonToken.START_OBJECT.equals(jsonToken) && list4 instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list4;
                        PathInstruction pathInstruction = (PathInstruction)colon2.head();
                        List xs = colon2.tl$access$1();
                        if (PathInstruction$Key$.MODULE$.equals(pathInstruction)) {
                            boolean dirty = false;
                            while (true) {
                                JsonParser jsonParser;
                                JsonToken jsonToken4 = p.nextToken();
                                JsonToken jsonToken5 = JsonToken.END_OBJECT;
                                if (!(jsonToken4 == null ? jsonToken5 != null : !jsonToken4.equals(jsonToken5))) break;
                                if (dirty) {
                                    jsonParser = p.skipChildren();
                                    continue;
                                }
                                dirty = this.evaluatePath(p, g, style, (List<PathInstruction>)xs);
                                jsonParser = BoxedUnit.UNIT;
                            }
                            bl = dirty;
                            break block56;
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list5 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list5 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list5;
                        PathInstruction pathInstruction = (PathInstruction)colon3.head();
                        List list6 = colon3.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list6 instanceof .colon.colon) {
                            .colon.colon colon4 = (.colon.colon)list6;
                            PathInstruction pathInstruction2 = (PathInstruction)colon4.head();
                            List list7 = colon4.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction2) && list7 instanceof .colon.colon) {
                                .colon.colon colon5 = (.colon.colon)list7;
                                PathInstruction pathInstruction3 = (PathInstruction)colon5.head();
                                List list8 = colon5.tl$access$1();
                                if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction3) && list8 instanceof .colon.colon) {
                                    .colon.colon colon6 = (.colon.colon)list8;
                                    PathInstruction pathInstruction4 = (PathInstruction)colon6.head();
                                    List xs = colon6.tl$access$1();
                                    if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction4)) {
                                        boolean dirty = false;
                                        g.writeStartArray();
                                        while (true) {
                                            JsonToken jsonToken6 = p.nextToken();
                                            JsonToken jsonToken7 = JsonToken.END_ARRAY;
                                            if (!(jsonToken6 == null ? jsonToken7 != null : !jsonToken6.equals(jsonToken7))) break;
                                            dirty |= this.evaluatePath(p, g, WriteStyle$FlattenStyle$.MODULE$, (List<PathInstruction>)xs);
                                        }
                                        g.writeEndArray();
                                        bl = dirty;
                                        break block56;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list9 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list9 instanceof .colon.colon) {
                        .colon.colon colon7 = (.colon.colon)list9;
                        PathInstruction pathInstruction = (PathInstruction)colon7.head();
                        List list10 = colon7.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list10 instanceof .colon.colon) {
                            .colon.colon colon8 = (.colon.colon)list10;
                            PathInstruction pathInstruction5 = (PathInstruction)colon8.head();
                            List xs = colon8.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction5)) {
                                WriteStyle writeStyle = style;
                                WriteStyle$QuotedStyle$ writeStyle$QuotedStyle$ = WriteStyle$QuotedStyle$.MODULE$;
                                if (writeStyle == null ? writeStyle$QuotedStyle$ != null : !writeStyle.equals(writeStyle$QuotedStyle$)) {
                                    WriteStyle writeStyle2;
                                    WriteStyle writeStyle3 = style;
                                    if (WriteStyle$RawStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$QuotedStyle$.MODULE$;
                                    } else if (WriteStyle$FlattenStyle$.MODULE$.equals(writeStyle3)) {
                                        writeStyle2 = WriteStyle$FlattenStyle$.MODULE$;
                                    } else {
                                        if (WriteStyle$QuotedStyle$.MODULE$.equals(writeStyle3)) {
                                            throw new IllegalStateException();
                                        }
                                        throw new MatchError((Object)writeStyle3);
                                    }
                                    WriteStyle$QuotedStyle$ nextStyle = writeStyle2;
                                    StringWriter buffer = new StringWriter();
                                    IntRef dirty = IntRef.create((int)0);
                                    Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((Writer)buffer), (Function1 & Serializable & scala.Serializable)flattenGenerator -> {
                                        GetJsonObject.$anonfun$evaluatePath$2(this, p, dirty, nextStyle, xs, flattenGenerator);
                                        return BoxedUnit.UNIT;
                                    });
                                    StringBuffer buf = buffer.getBuffer();
                                    if (dirty.elem > 1) {
                                        g.writeRawValue(buf.toString());
                                    } else if (dirty.elem == 1) {
                                        g.writeRawValue(buf.substring(1, buf.length() - 1));
                                    }
                                    bl = dirty.elem > 0;
                                    break block56;
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list11 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list11 instanceof .colon.colon) {
                        .colon.colon colon9 = (.colon.colon)list11;
                        PathInstruction pathInstruction = (PathInstruction)colon9.head();
                        List list12 = colon9.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list12 instanceof .colon.colon) {
                            .colon.colon colon10 = (.colon.colon)list12;
                            PathInstruction pathInstruction6 = (PathInstruction)colon10.head();
                            List xs = colon10.tl$access$1();
                            if (PathInstruction$Wildcard$.MODULE$.equals(pathInstruction6)) {
                                boolean dirty = false;
                                g.writeStartArray();
                                while (true) {
                                    JsonToken jsonToken8 = p.nextToken();
                                    JsonToken jsonToken9 = JsonToken.END_ARRAY;
                                    if (!(jsonToken8 == null ? jsonToken9 != null : !jsonToken8.equals(jsonToken9))) break;
                                    dirty |= this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)xs);
                                }
                                g.writeEndArray();
                                bl = dirty;
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list13 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list13 instanceof .colon.colon) {
                        .colon.colon colon11 = (.colon.colon)list13;
                        PathInstruction pathInstruction = (PathInstruction)colon11.head();
                        List list14 = colon11.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list14 instanceof .colon.colon) {
                            .colon.colon colon12 = (.colon.colon)list14;
                            PathInstruction pathInstruction7 = (PathInstruction)colon12.head();
                            List xs = colon12.tl$access$1();
                            if (pathInstruction7 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction7;
                                long idx = index.index();
                                if (xs instanceof .colon.colon) {
                                    .colon.colon colon13;
                                    PathInstruction pathInstruction8;
                                    .colon.colon colon14 = (.colon.colon)xs;
                                    PathInstruction pathInstruction9 = (PathInstruction)colon14.head();
                                    List list15 = colon14.tl$access$1();
                                    if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction9) && list15 instanceof .colon.colon && PathInstruction$Wildcard$.MODULE$.equals(pathInstruction8 = (PathInstruction)(colon13 = (.colon.colon)list15).head())) {
                                        p.nextToken();
                                        bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.evaluatePath(p, g, WriteStyle$QuotedStyle$.MODULE$, (List<PathInstruction>)colon14)).apply$mcZJ$sp(idx);
                                        break block56;
                                    }
                                }
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list16 = (List)tuple2._2();
                    if (JsonToken.START_ARRAY.equals(jsonToken) && list16 instanceof .colon.colon) {
                        .colon.colon colon15 = (.colon.colon)list16;
                        PathInstruction pathInstruction = (PathInstruction)colon15.head();
                        List list17 = colon15.tl$access$1();
                        if (PathInstruction$Subscript$.MODULE$.equals(pathInstruction) && list17 instanceof .colon.colon) {
                            .colon.colon colon16 = (.colon.colon)list17;
                            PathInstruction pathInstruction10 = (PathInstruction)colon16.head();
                            List xs = colon16.tl$access$1();
                            if (pathInstruction10 instanceof PathInstruction.Index) {
                                PathInstruction.Index index = (PathInstruction.Index)pathInstruction10;
                                long idx = index.index();
                                p.nextToken();
                                bl = this.arrayIndex(p, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.evaluatePath(p, g, style, (List<PathInstruction>)xs)).apply$mcZJ$sp(idx);
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 != null) {
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    List list18 = (List)tuple2._2();
                    if (JsonToken.FIELD_NAME.equals(jsonToken) && list18 instanceof .colon.colon) {
                        .colon.colon colon17 = (.colon.colon)list18;
                        PathInstruction pathInstruction = (PathInstruction)colon17.head();
                        List xs = colon17.tl$access$1();
                        if (pathInstruction instanceof PathInstruction.Named) {
                            PathInstruction.Named named = (PathInstruction.Named)pathInstruction;
                            String name = named.name();
                            String string = p.getCurrentName();
                            String string2 = name;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                JsonToken jsonToken10 = p.nextToken();
                                JsonToken jsonToken11 = JsonToken.VALUE_NULL;
                                if (jsonToken10 == null ? jsonToken11 != null : !jsonToken10.equals(jsonToken11)) {
                                    path = xs;
                                    continue;
                                }
                                bl = false;
                                break block56;
                            }
                        }
                    }
                }
                if (tuple2 == null) break;
                JsonToken jsonToken = (JsonToken)tuple2._1();
                List list19 = (List)tuple2._2();
                if (!JsonToken.FIELD_NAME.equals(jsonToken) || !(list19 instanceof .colon.colon)) break;
                .colon.colon colon18 = (.colon.colon)list19;
                PathInstruction pathInstruction = (PathInstruction)colon18.head();
                List xs = colon18.tl$access$1();
                if (!PathInstruction$Wildcard$.MODULE$.equals(pathInstruction)) break;
                p.nextToken();
                path = xs;
            }
            p.skipChildren();
            bl = false;
        }
        return bl;
    }

    public GetJsonObject copy(Expression json, Expression path) {
        return new GetJsonObject(json, path);
    }

    public Expression copy$default$1() {
        return this.json();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "GetJsonObject";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.json();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetJsonObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetJsonObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetJsonObject getJsonObject = (GetJsonObject)x$1;
        Expression expression = this.json();
        Expression expression2 = getJsonObject.json();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = getJsonObject.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!getJsonObject.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$eval$4(GetJsonObject $this, JsonParser parser$1, Option parsed$1, JsonGenerator generator) {
        parser$1.nextToken();
        return $this.evaluatePath(parser$1, generator, WriteStyle$RawStyle$.MODULE$, (List<PathInstruction>)((List)parsed$1.get()));
    }

    public static final /* synthetic */ void $anonfun$evaluatePath$2(GetJsonObject $this, JsonParser p$2, IntRef dirty$1, Product nextStyle$1, List xs$1, JsonGenerator flattenGenerator) {
        flattenGenerator.writeStartArray();
        while (true) {
            JsonToken jsonToken = p$2.nextToken();
            JsonToken jsonToken2 = JsonToken.END_ARRAY;
            if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
            dirty$1.elem = dirty$1.elem + ($this.evaluatePath(p$2, flattenGenerator, (WriteStyle)nextStyle$1, (List<PathInstruction>)xs$1) ? 1 : 0);
        }
        flattenGenerator.writeEndArray();
    }

    public GetJsonObject(Expression json, Expression path) {
        this.json = json;
        this.path = path;
        ExpectsInputTypes.$init$(this);
        CodegenFallback.$init$(this);
    }
}

