/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0010!\u00016B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000bU\u0003A\u0011\t,\t\u000bu\u0003A\u0011\t0\t\u000b)\u0004A\u0011I6\t\u000b5\u0004A\u0011\t8\t\u000b]\u0004A\u0011\t=\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!I\u00111\u0005\u0001\u0002\u0002\u0013\u0005\u0011Q\u0005\u0005\n\u0003[\u0001\u0011\u0013!C\u0001\u0003_A\u0011\"!\u0012\u0001#\u0003%\t!a\f\t\u0013\u0005\u001d\u0003!%A\u0005\u0002\u0005=\u0002\"CA%\u0001\u0005\u0005I\u0011IA&\u0011%\tY\u0006AA\u0001\n\u0003\ti\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0001\u0002h!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013q\u000e\u0005\n\u0003{\u0002\u0011\u0011!C\u0001\u0003\u007fB\u0011\"!#\u0001\u0003\u0003%\t%a#\b\u0013\u0005%\u0006%!A\t\u0002\u0005-f\u0001C\u0010!\u0003\u0003E\t!!,\t\r=KB\u0011AA^\u0011%\ti,GA\u0001\n\u000b\ny\fC\u0005\u0002Bf\t\t\u0011\"!\u0002D\"I\u00111Z\r\u0002\u0002\u0013\u0005\u0015Q\u001a\u0005\n\u0003?L\u0012\u0011!C\u0005\u0003C\u0014abU;cgR\u0014\u0018N\\4J]\u0012,\u0007P\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u0019\u0001aFM\u001b=\u0005B\u0011q\u0006M\u0007\u0002A%\u0011\u0011\u0007\t\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00184\u0013\t!\u0004E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t1\u0014H\u0004\u00020o%\u0011\u0001\bI\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005a\u0002\u0003CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$a\u0002)s_\u0012,8\r\u001e\t\u0003{\rK!\u0001\u0012 \u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000fM$(/\u0012=qeV\tq\t\u0005\u00020\u0011&\u0011\u0011\n\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C:ue\u0016C\bO\u001d\u0011\u0002\u0013\u0011,G.[7FqB\u0014\u0018A\u00033fY&lW\t\u001f9sA\u0005I1m\\;oi\u0016C\bO]\u0001\u000bG>,h\u000e^#yaJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003R%N#\u0006CA\u0018\u0001\u0011\u0015)u\u00011\u0001H\u0011\u0015Yu\u00011\u0001H\u0011\u0015iu\u00011\u0001H\u0003!!\u0017\r^1UsB,W#A,\u0011\u0005a[V\"A-\u000b\u0005i#\u0013!\u0002;za\u0016\u001c\u0018B\u0001/Z\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tq\fE\u0002aO^s!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u0011d\u0013A\u0002\u001fs_>$h(C\u0001@\u0013\tAd(\u0003\u0002iS\n\u00191+Z9\u000b\u0005ar\u0014\u0001C2iS2$'/\u001a8\u0016\u00031\u00042\u0001Y4H\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002_B\u0011\u0001\u000f\u001e\b\u0003cJ\u0004\"A\u0019 \n\u0005Mt\u0014A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a\u001d \u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u000bedh0!\u0001\u0011\u0005uR\u0018BA>?\u0005\r\te.\u001f\u0005\u0006{2\u0001\r!_\u0001\u0004gR\u0014\b\"B@\r\u0001\u0004I\u0018!\u00023fY&l\u0007BBA\u0002\u0019\u0001\u0007\u00110A\u0003d_VtG/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011BA\u000b\u0003?\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f\u0001\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003'\tiA\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9\"\u0004a\u0001\u00033\t1a\u0019;y!\u0011\tY!a\u0007\n\t\u0005u\u0011Q\u0002\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\t#\u0004a\u0001\u0003\u0013\t!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\b#\u0006\u001d\u0012\u0011FA\u0016\u0011\u001d)e\u0002%AA\u0002\u001dCqa\u0013\b\u0011\u0002\u0003\u0007q\tC\u0004N\u001dA\u0005\t\u0019A$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0007\u0016\u0004\u000f\u0006M2FAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}b(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0011\u0002:\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001\u00027b]\u001eT!!a\u0016\u0002\t)\fg/Y\u0005\u0004k\u0006E\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA0!\ri\u0014\u0011M\u0005\u0004\u0003Gr$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA=\u0002j!I\u00111\u000e\u000b\u0002\u0002\u0003\u0007\u0011qL\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0004#BA:\u0003sJXBAA;\u0015\r\t9HP\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA>\u0003k\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011QAD!\ri\u00141Q\u0005\u0004\u0003\u000bs$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003W2\u0012\u0011!a\u0001s\u00061Q-];bYN$B!!!\u0002\u000e\"A\u00111N\f\u0002\u0002\u0003\u0007\u0011\u0010K\b\u0001\u0003#\u000b9*!'\u0002\u001e\u0006}\u00151UAS!\ry\u00131S\u0005\u0004\u0003+\u0003#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\u000b1\u0011\u0012\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:-A\u0011,G.[7-A\r|WO\u001c;*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAM,(m\u001d;sS:<\u0007E\u001a:p[\u0002\u00027\u000f\u001e:aA\t,gm\u001c:fA\u0001\u001cw.\u001e8uA\u0002z7mY;se\u0016t7-Z:!_\u001a\u0004C\u000f[3!I\u0016d\u0017.\\5uKJ\u0004\u0003\rZ3mS6\u0004gF\u0003\u0011!A\u0001\u0002\u0003%\u00134!A\u000e|WO\u001c;aA%\u001c\b\u0005]8tSRLg/\u001a\u0017!KZ,'/\u001f;iS:<\u0007\u0005^8!i\",\u0007\u0005\\3gi\u0002zg\r\t;iK\u00022\u0017N\\1mA\u0011,G.[7ji\u0016\u0014\b\u0005K2pk:$\u0018N\\4!MJ|W\u000e\t;iK*\u0001\u0003\u0005\t\u0011!A1,g\r^\u0015!SN\u0004#/\u001a;ve:,GM\f\u0011JM\u0002\u00027m\\;oi\u0002\u0004\u0013n\u001d\u0011oK\u001e\fG/\u001b<fY\u0001*g/\u001a:zi\"Lgn\u001a\u0011u_\u0002\"\b.\u001a\u0011sS\u001eDG\u000fI8gAQDW\r\t4j]\u0006d\u0007\u0005Z3mS6LG/\u001a:\u000bA\u0001\u0002\u0003\u0005\t\u0011)G>,h\u000e^5oO\u00022'o\\7!i\",\u0007E]5hQRL\u0003%[:!e\u0016$XO\u001d8fI:\u0002C\u000b[3!MVt7\r^5p]\u0002\u001aXOY:ue&twmX5oI\u0016D\b\u0005]3sM>\u0014Xn\u001d\u0011bA\r\f7/Z\u0017tK:\u001c\u0018\u000e^5wK\u0002j\u0017\r^2i\u0015\u0001\u0002\u0003\u0005\t\u0011!o\",g\u000eI:fCJ\u001c\u0007.\u001b8hA\u0019|'\u000f\t1eK2LW\u000e\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003C\u000bAK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(o^<h&\u00199bG\",gf\u001c:hO1\u0002sEL\u0014-AIJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I<xo:\n\u0007/Y2iK*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002(\u0006)\u0011GL\u001b/a\u0005q1+\u001e2tiJLgnZ%oI\u0016D\bCA\u0018\u001a'\u0011I\u0012q\u0016\"\u0011\u0011\u0005E\u0016qW$H\u000fFk!!a-\u000b\u0007\u0005Uf(A\u0004sk:$\u0018.\\3\n\t\u0005e\u00161\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAV\u0003!!xn\u0015;sS:<GCAA'\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\t\u0016QYAd\u0003\u0013DQ!\u0012\u000fA\u0002\u001dCQa\u0013\u000fA\u0002\u001dCQ!\u0014\u000fA\u0002\u001d\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002P\u0006m\u0007#B\u001f\u0002R\u0006U\u0017bAAj}\t1q\n\u001d;j_:\u0004b!PAl\u000f\u001e;\u0015bAAm}\t1A+\u001e9mKNB\u0001\"!8\u001e\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a9\u0011\t\u0005=\u0013Q]\u0005\u0005\u0003O\f\tF\u0001\u0004PE*,7\r\u001e")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex substringIndex) {
        return SubstringIndex$.MODULE$.unapply(substringIndex);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.strExpr(), this.delimExpr(), this.countExpr()}));
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return ((UTF8String)str).subStringIndex((UTF8String)delim, BoxesRunTime.unboxToInt((Object)count));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, delim, count) -> new StringBuilder(19).append((String)str).append(".subStringIndex(").append((String)delim).append(", ").append((String)count).append(")").toString());
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.strExpr();
                break;
            }
            case 1: {
                expression = this.delimExpr();
                break;
            }
            case 2: {
                expression = this.countExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

