/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringLPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, left-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n      If `pad` is not specified, `str` will be padded to the left with space characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       ???hi\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n          hi\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0013'\u0001NB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011!\u0019\u0006A!f\u0001\n\u0003a\u0005\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011B'\t\u000bU\u0003A\u0011\u0001,\t\u000bU\u0003A\u0011A.\t\u000by\u0003A\u0011\t'\t\u000b}\u0003A\u0011\t'\t\u000b\u0001\u0004A\u0011\t'\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\t6\t\u000bY\u0004A\u0011I<\t\u000by\u0004A\u0011K@\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011q\u0006\u0001\u0005R\u0005E\u0002\"CA \u0001\u0005\u0005I\u0011AA!\u0011%\tI\u0005AI\u0001\n\u0003\tY\u0005C\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002L!I\u00111\r\u0001\u0012\u0002\u0013\u0005\u00111\n\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003OB\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\t\u0013\u0005\u0005\u0005!!A\u0005\u0002\u0005\r\u0005\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\tI\nAA\u0001\n\u0003\tY\nC\u0005\u0002&\u0002\t\t\u0011\"\u0011\u0002(\u001eI\u00111\u001a\u0014\u0002\u0002#\u0005\u0011Q\u001a\u0004\tK\u0019\n\t\u0011#\u0001\u0002P\"1Q+\bC\u0001\u0003;D\u0011\"a8\u001e\u0003\u0003%)%!9\t\u0013\u0005\rX$!A\u0005\u0002\u0006\u0015\b\"CAw;E\u0005I\u0011AA&\u0011%\ty/HA\u0001\n\u0003\u000b\t\u0010C\u0005\u0003\u0004u\t\n\u0011\"\u0001\u0002L!I!QA\u000f\u0002\u0002\u0013%!q\u0001\u0002\u000b'R\u0014\u0018N\\4M!\u0006$'BA\u0014)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005%R\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005-b\u0013aA:rY*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001!\u0004h\u000f\"I!\t)d'D\u0001'\u0013\t9dEA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!N\u001d\n\u0005i2#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005qzdBA\u001b>\u0013\tqd%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\u000b%A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003}\u0019\u0002\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0013&\u0011!\n\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0004gR\u0014X#A'\u0011\u0005Ur\u0015BA('\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0005gR\u0014\b%A\u0002mK:\fA\u0001\\3oA\u0005\u0019\u0001/\u00193\u0002\tA\fG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]C\u0016L\u0017\t\u0003k\u0001AQaS\u0004A\u00025CQ!U\u0004A\u00025CqaU\u0004\u0011\u0002\u0003\u0007Q\nF\u0002X9vCQa\u0013\u0005A\u00025CQ!\u0015\u0005A\u00025\u000bQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a\u0016\u0002\u000bQL\b/Z:\n\u0005!,'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001l!\ra7o\u0019\b\u0003[Jt!A\\9\u000e\u0003=T!\u0001\u001d\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0015B\u0001 E\u0013\t!XOA\u0002TKFT!A\u0010#\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\ta\\H0 \t\u0003\u0007fL!A\u001f#\u0003\u0007\u0005s\u0017\u0010C\u0003L\u001d\u0001\u0007\u0001\u0010C\u0003R\u001d\u0001\u0007\u0001\u0010C\u0003T\u001d\u0001\u0007\u00010A\u0005e_\u001e+gnQ8eKR1\u0011\u0011AA\u0007\u0003/\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f1\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u0017\t)A\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tya\u0004a\u0001\u0003#\t1a\u0019;y!\u0011\t\u0019!a\u0005\n\t\u0005U\u0011Q\u0001\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tIb\u0004a\u0001\u0003\u0003\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002 A!\u0011\u0011EA\u0015\u001d\u0011\t\u0019#!\n\u0011\u00059$\u0015bAA\u0014\t\u00061\u0001K]3eK\u001aLA!a\u000b\u0002.\t11\u000b\u001e:j]\u001eT1!a\nE\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004X\u0003g\t9$a\u000f\t\r\u0005U\u0012\u00031\u0001N\u0003!qWm\u001e$jeN$\bBBA\u001d#\u0001\u0007Q*A\u0005oK^\u001cVmY8oI\"1\u0011QH\tA\u00025\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004X\u0003\u0007\n)%a\u0012\t\u000f-\u0013\u0002\u0013!a\u0001\u001b\"9\u0011K\u0005I\u0001\u0002\u0004i\u0005bB*\u0013!\u0003\u0005\r!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiEK\u0002N\u0003\u001fZ#!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037\"\u0015AC1o]>$\u0018\r^5p]&!\u0011qLA+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\nA\u0001\\1oO*\u0011\u00111O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u00055\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA>!\r\u0019\u0015QP\u0005\u0004\u0003\u007f\"%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001=\u0002\u0006\"I\u0011q\u0011\r\u0002\u0002\u0003\u0007\u00111P\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0005#BAH\u0003+CXBAAI\u0015\r\t\u0019\nR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAL\u0003#\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QTAR!\r\u0019\u0015qT\u0005\u0004\u0003C#%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u000fS\u0012\u0011!a\u0001q\u00061Q-];bYN$B!!(\u0002*\"A\u0011qQ\u000e\u0002\u0002\u0003\u0007\u0001\u0010K\n\u0001\u0003[\u000b\u0019,!.\u0002:\u0006m\u0016qXAa\u0003\u000b\f9\rE\u00026\u0003_K1!!-'\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a.\u0002\u0005;Q\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t7f]nc\u0003\u0005]1e;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011agR\u0014\b\r\f\u0011mK\u001a$X\u0006]1eI\u0016$\u0007e^5uQ\u0002\u0002\u0007/\u00193aAQ|\u0007%\u0019\u0011mK:<G\u000f\u001b\u0011pM\u0002\u0002G.\u001a8a])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y:ue\u0002\u0004\u0013n\u001d\u0011m_:<WM\u001d\u0011uQ\u0006t\u0007\u0005\u00197f]\u0002d\u0003\u0005\u001e5fAI,G/\u001e:oAY\fG.^3!SN\u00043\u000f[8si\u0016tW\r\u001a\u0011u_\u0002\u0002G.\u001a8aA\rD\u0017M]1di\u0016\u00148O\f\u0006!A\u0001\u0002\u0003\u0005I%gA\u0001\u0004\u0018\r\u001a1!SN\u0004cn\u001c;!gB,7-\u001b4jK\u0012d\u0003\u0005Y:ue\u0002\u0004s/\u001b7mA\t,\u0007\u0005]1eI\u0016$\u0007\u0005^8!i\",\u0007\u0005\\3gi\u0002:\u0018\u000e\u001e5!gB\f7-\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feNt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!0\u0002\u0003\u0003R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n5jO1\u0002S\u0007\f\u0011(\u007f}:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011@\u007f}B\u0017N\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(Q&<C\u0006I\u0019-A\u001dzthJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A!T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n5jO1\u0002S'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003.\u001b\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111Y\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0013\fAb\u001d;sS:<wLZ;oGN\f!b\u0015;sS:<G\nU1e!\t)Td\u0005\u0003\u001e\u0003#D\u0005\u0003CAj\u00033lU*T,\u000e\u0005\u0005U'bAAl\t\u00069!/\u001e8uS6,\u0017\u0002BAn\u0003+\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\ti-\u0001\u0005u_N#(/\u001b8h)\t\tI'A\u0003baBd\u0017\u0010F\u0004X\u0003O\fI/a;\t\u000b-\u0003\u0003\u0019A'\t\u000bE\u0003\u0003\u0019A'\t\u000fM\u0003\u0003\u0013!a\u0001\u001b\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005M\u0018q \t\u0006\u0007\u0006U\u0018\u0011`\u0005\u0004\u0003o$%AB(qi&|g\u000e\u0005\u0004D\u0003wlU*T\u0005\u0004\u0003{$%A\u0002+va2,7\u0007\u0003\u0005\u0003\u0002\t\n\t\u00111\u0001X\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0013\u0001B!a\u001b\u0003\f%!!QBA7\u0005\u0019y%M[3di\u0002")
public class StringLPad
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Expression $lessinit$greater$default$3() {
        return StringLPad$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringLPad stringLPad) {
        return StringLPad$.MODULE$.unapply(stringLPad);
    }

    public static Expression apply$default$3() {
        return StringLPad$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringLPad> tupled() {
        return StringLPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringLPad>>> curried() {
        return StringLPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.len();
    }

    @Override
    public Expression third() {
        return this.pad();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).lpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".lpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "lpad";
    }

    @Override
    public StringLPad withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringLPad copy(Expression str, Expression len, Expression pad) {
        return new StringLPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringLPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.len();
                break;
            }
            case 2: {
                expression = this.pad();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringLPad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringLPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringLPad stringLPad = (StringLPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringLPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringLPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringLPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringLPad.canEqual(this)) return false;
        return true;
    }

    public StringLPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }

    public StringLPad(Expression str, Expression len) {
        this(str, len, Literal$.MODULE$.apply(" "));
    }
}

