/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.SerializerBuildHelper;
import org.apache.spark.sql.catalyst.expressions.CheckOverflow;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.objects.ExternalMapToCatalyst$;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.MapObjects$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class SerializerBuildHelper$ {
    public static SerializerBuildHelper$ MODULE$;

    static {
        new SerializerBuildHelper$();
    }

    private boolean nullOnOverflow() {
        return !SQLConf$.MODULE$.get().ansiEnabled();
    }

    public Expression createSerializerForBoolean(Expression inputObject) {
        return new Invoke(inputObject, "booleanValue", BooleanType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForByte(Expression inputObject) {
        return new Invoke(inputObject, "byteValue", ByteType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForShort(Expression inputObject) {
        return new Invoke(inputObject, "shortValue", ShortType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForInteger(Expression inputObject) {
        return new Invoke(inputObject, "intValue", IntegerType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForLong(Expression inputObject) {
        return new Invoke(inputObject, "longValue", LongType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForFloat(Expression inputObject) {
        return new Invoke(inputObject, "floatValue", FloatType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForDouble(Expression inputObject) {
        return new Invoke(inputObject, "doubleValue", DoubleType$.MODULE$, Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    public Expression createSerializerForString(Expression inputObject) {
        Class<UTF8String> x$1 = UTF8String.class;
        StringType$ x$2 = StringType$.MODULE$;
        String x$3 = "fromString";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForJavaInstant(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimestampType$ x$2 = TimestampType$.MODULE$;
        String x$3 = "instantToMicros";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForJavaEnum(Expression inputObject) {
        return this.createSerializerForString(new Invoke(inputObject, "name", new ObjectType(String.class), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()));
    }

    public Expression createSerializerForSqlTimestamp(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimestampType$ x$2 = TimestampType$.MODULE$;
        String x$3 = "fromJavaTimestamp";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForLocalDateTime(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        TimestampNTZType$ x$2 = TimestampNTZType$.MODULE$;
        String x$3 = "localDateTimeToMicros";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForJavaLocalDate(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        DateType$ x$2 = DateType$.MODULE$;
        String x$3 = "localDateToDays";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForSqlDate(Expression inputObject) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        DateType$ x$2 = DateType$.MODULE$;
        String x$3 = "fromJavaDate";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForJavaDuration(Expression inputObject) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        DayTimeIntervalType x$2 = DayTimeIntervalType$.MODULE$.apply();
        String x$3 = "durationToMicros";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForJavaPeriod(Expression inputObject) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        YearMonthIntervalType x$2 = YearMonthIntervalType$.MODULE$.apply();
        String x$3 = "periodToMonths";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForJavaBigDecimal(Expression inputObject) {
        Class<?> x$1 = Decimal$.MODULE$.getClass();
        DecimalType x$2 = DecimalType$.MODULE$.SYSTEM_DEFAULT();
        String x$3 = "apply";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new CheckOverflow(new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8), DecimalType$.MODULE$.SYSTEM_DEFAULT(), this.nullOnOverflow());
    }

    public Expression createSerializerForScalaBigDecimal(Expression inputObject) {
        return this.createSerializerForJavaBigDecimal(inputObject);
    }

    public Expression createSerializerForJavaBigInteger(Expression inputObject) {
        Class<?> x$1 = Decimal$.MODULE$.getClass();
        DecimalType x$2 = DecimalType$.MODULE$.BigIntDecimal();
        String x$3 = "apply";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new CheckOverflow(new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8), DecimalType$.MODULE$.BigIntDecimal(), this.nullOnOverflow());
    }

    public Expression createSerializerForScalaBigInt(Expression inputObject) {
        return this.createSerializerForJavaBigInteger(inputObject);
    }

    public Expression createSerializerForPrimitiveArray(Expression inputObject, DataType dataType) {
        Class<UnsafeArrayData> x$1 = UnsafeArrayData.class;
        ArrayType x$2 = new ArrayType(dataType, false);
        String x$3 = "fromPrimitiveArray";
        Expression expression = inputObject;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        return new StaticInvoke(x$1, x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, x$5, x$8);
    }

    public Expression createSerializerForGenericArray(Expression inputObject, DataType dataType, boolean nullable) {
        Expression expression = inputObject;
        return NewInstance$.MODULE$.apply(GenericArrayData.class, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), new ArrayType(dataType, nullable), NewInstance$.MODULE$.apply$default$4());
    }

    public Expression createSerializerForMapObjects(Expression inputObject, ObjectType dataType, Function1<Expression, Expression> funcForNewExpr) {
        return MapObjects$.MODULE$.apply(funcForNewExpr, inputObject, dataType, MapObjects$.MODULE$.apply$default$4(), MapObjects$.MODULE$.apply$default$5());
    }

    public Expression createSerializerForMap(Expression inputObject, SerializerBuildHelper.MapElementInformation keyInformation, SerializerBuildHelper.MapElementInformation valueInformation) {
        return ExternalMapToCatalyst$.MODULE$.apply(inputObject, keyInformation.dataType(), keyInformation.funcForNewExpr(), keyInformation.nullable(), valueInformation.dataType(), valueInformation.funcForNewExpr(), valueInformation.nullable());
    }

    private Seq<Expression> argumentsForFieldSerializer(String fieldName, Expression serializerForFieldValue) {
        Literal literal = Literal$.MODULE$.apply(fieldName);
        Expression expression = serializerForFieldValue;
        return Nil$.MODULE$.$colon$colon((Object)expression).$colon$colon((Object)literal);
    }

    /*
     * WARNING - void declaration
     */
    public Expression createSerializerForObject(Expression inputObject, Seq<Tuple2<String, Expression>> fields) {
        If if_;
        CreateNamedStruct nonNullOutput = new CreateNamedStruct((Seq<Expression>)((Seq)fields.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fieldName = (String)tuple2._1();
            Expression fieldExpr = (Expression)tuple2._2();
            Seq<Expression> seq = MODULE$.argumentsForFieldSerializer(fieldName, fieldExpr);
            return seq;
        }, Seq$.MODULE$.canBuildFrom())));
        if (inputObject.nullable()) {
            Literal nullOutput = Literal$.MODULE$.create(null, nonNullOutput.dataType());
            if_ = new If(new IsNull(inputObject), nullOutput, nonNullOutput);
        } else {
            void var3_3;
            if_ = var3_3;
        }
        return if_;
    }

    public Expression createSerializerForUserDefinedType(Expression inputObject, UserDefinedType<?> udt, Class<?> udtClass) {
        NewInstance obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, new ObjectType(udtClass), NewInstance$.MODULE$.apply$default$4());
        Expression expression = inputObject;
        return new Invoke(obj, "serialize", udt, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    private SerializerBuildHelper$() {
        MODULE$ = this;
    }
}

