/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathFloat$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a float value, the value zero if no match is found, or NaN if a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3.0\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\u000e\u001c\u0001*B\u0001\u0002\b\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005s!Aa\b\u0001BK\u0002\u0013\u0005\u0001\b\u0003\u0005@\u0001\tE\t\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u001d9\u0007!!A\u0005\u0002!Dqa\u001b\u0001\u0012\u0002\u0013\u0005A\u000eC\u0004x\u0001E\u0005I\u0011\u00017\t\u000fa\u0004\u0011\u0011!C!s\"I\u00111\u0001\u0001\u0002\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0001\u0003\u001fA\u0011\"!\u0006\u0001\u0003\u0003%\t%a\u0006\t\u0013\u0005\u0015\u0002!!A\u0005\u0002\u0005\u001d\u0002\"CA\u0019\u0001\u0005\u0005I\u0011IA\u001a\u000f%\t9fGA\u0001\u0012\u0003\tIF\u0002\u0005\u001b7\u0005\u0005\t\u0012AA.\u0011\u0019\u0001E\u0003\"\u0001\u0002j!I\u00111\u000e\u000b\u0002\u0002\u0013\u0015\u0013Q\u000e\u0005\n\u0003_\"\u0012\u0011!CA\u0003cB\u0011\"a\u001e\u0015\u0003\u0003%\t)!\u001f\t\u0013\u0005-E#!A\u0005\n\u00055%A\u0003-QCRDg\t\\8bi*\u0011A$H\u0001\u0004q6d'B\u0001\u0010 \u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0001\n\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Ys&\u000e\t\u0003Y5j\u0011aG\u0005\u0003]m\u0011A\u0002\u0017)bi\",\u0005\u0010\u001e:bGR\u0004\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00021m%\u0011q'\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0002sA\u0011!hO\u0007\u0002;%\u0011A(\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\u0002=nY\u0002\nA\u0001]1uQ\u0006)\u0001/\u0019;iA\u00051A(\u001b8jiz\"2AQ\"E!\ta\u0003\u0001C\u0003\u001d\u000b\u0001\u0007\u0011\bC\u0003?\u000b\u0001\u0007\u0011(\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a\u0012\t\u0003\u0011>s!!S'\u0011\u0005)\u000bT\"A&\u000b\u00051K\u0013A\u0002\u001fs_>$h(\u0003\u0002Oc\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0015'\u0001\u0005eCR\fG+\u001f9f+\u0005!\u0006CA+Y\u001b\u00051&BA,\"\u0003\u0015!\u0018\u0010]3t\u0013\tIfK\u0001\u0005ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\rav\f\u0019\t\u0003auK!AX\u0019\u0003\u0007\u0005s\u0017\u0010C\u0003\u001d\u0011\u0001\u0007A\fC\u0003?\u0011\u0001\u0007A,A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019!iY3\t\u000b\u0011L\u0001\u0019A\u001d\u0002\u000f9,w\u000fT3gi\")a-\u0003a\u0001s\u0005Aa.Z<SS\u001eDG/\u0001\u0003d_BLHc\u0001\"jU\"9AD\u0003I\u0001\u0002\u0004I\u0004b\u0002 \u000b!\u0003\u0005\r!O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005i'FA\u001doW\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003%)hn\u00195fG.,GM\u0003\u0002uc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\f(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0005Y\u0006twMC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0005Ac\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0004!\r\u0001\u0014\u0011B\u0005\u0004\u0003\u0017\t$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001/\u0002\u0012!I\u00111C\b\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0001#BA\u000e\u0003CaVBAA\u000f\u0015\r\ty\"M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0012\u0003;\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011FA\u0018!\r\u0001\u00141F\u0005\u0004\u0003[\t$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003'\t\u0012\u0011!a\u00019\u00061Q-];bYN$B!!\u000b\u00026!A\u00111\u0003\n\u0002\u0002\u0003\u0007A\fK\n\u0001\u0003s\ty$!\u0011\u0002F\u0005\u001d\u00131JA'\u0003#\n\u0019\u0006E\u0002;\u0003wI1!!\u0010\u001e\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u0011\u0002\u0003'yf)\u0016(D?\"BX\u000e\u001c\u0017!qB\fG\u000f[\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t4m_\u0006$\bE^1mk\u0016d\u0003\u0005\u001e5fAY\fG.^3!u\u0016\u0014x\u000eI5gA9|\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\f\u0011pe\u0002r\u0015M\u0014\u0011jM\u0002\n\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\t2vi\u0002\"\b.\u001a\u0011wC2,X\rI5tA9|g.\f8v[\u0016\u0014\u0018n\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u0013\u00025*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005P1?y\tt\u0014\u0007P\u0018c}q\u0012gH\r\u001f0Ezbt&\u0019 (Y\u0001:3/^7)C>\u0012\u0017fJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0003G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ty%A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002V\u0005I\u00010\u001c7`MVt7m]\u0001\u000b1B\u000bG\u000f\u001b$m_\u0006$\bC\u0001\u0017\u0015'\u0011!\u0012QL\u001b\u0011\u000f\u0005}\u0013QM\u001d:\u00056\u0011\u0011\u0011\r\u0006\u0004\u0003G\n\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003O\n\tGA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!\u0017\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A_\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0005\u0006M\u0014Q\u000f\u0005\u00069]\u0001\r!\u000f\u0005\u0006}]\u0001\r!O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY(a\"\u0011\u000bA\ni(!!\n\u0007\u0005}\u0014G\u0001\u0004PaRLwN\u001c\t\u0006a\u0005\r\u0015(O\u0005\u0004\u0003\u000b\u000b$A\u0002+va2,'\u0007\u0003\u0005\u0002\nb\t\t\u00111\u0001C\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0010B\u001910!%\n\u0007\u0005MEP\u0001\u0004PE*,7\r\u001e")
public class XPathFloat
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathFloat xPathFloat) {
        return XPathFloat$.MODULE$.unapply(xPathFloat);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathFloat> tupled() {
        return XPathFloat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathFloat>> curried() {
        return XPathFloat$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_float";
    }

    @Override
    public DataType dataType() {
        return FloatType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToFloat((float)ret.floatValue());
    }

    @Override
    public XPathFloat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathFloat copy(Expression xml, Expression path) {
        return new XPathFloat(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathFloat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathFloat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathFloat)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathFloat xPathFloat = (XPathFloat)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathFloat.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathFloat.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathFloat.canEqual(this)) return false;
        return true;
    }

    public XPathFloat(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

