/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.DefaultValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.NullValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.NumericValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;

public final class ValueInterval$ {
    public static ValueInterval$ MODULE$;

    static {
        new ValueInterval$();
    }

    public ValueInterval apply(Option<Object> min, Option<Object> max, DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = StringType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2);
        ValueInterval valueInterval = bl ? new DefaultValueInterval() : (min.isEmpty() || max.isEmpty() ? new NullValueInterval() : new NumericValueInterval(EstimationUtils$.MODULE$.toDouble(min.get(), dataType), EstimationUtils$.MODULE$.toDouble(max.get(), dataType)));
        return valueInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIntersected(ValueInterval r1, ValueInterval r2) {
        Tuple2 tuple2 = new Tuple2((Object)r1, (Object)r2);
        if (tuple2 != null && tuple2._2() instanceof DefaultValueInterval) {
            return true;
        }
        if (tuple2 != null && tuple2._1() instanceof DefaultValueInterval) {
            return true;
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        if (tuple2 != null && tuple2._2() instanceof NullValueInterval) {
            return false;
        }
        if (tuple2 != null && tuple2._1() instanceof NullValueInterval) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) {
            return false;
        }
        if (tuple2 == null) throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "isIntersected");
        ValueInterval n1 = (ValueInterval)tuple2._1();
        ValueInterval n2 = (ValueInterval)tuple2._2();
        if (!(n1 instanceof NumericValueInterval)) throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "isIntersected");
        NumericValueInterval numericValueInterval = (NumericValueInterval)n1;
        if (!(n2 instanceof NumericValueInterval)) throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "isIntersected");
        NumericValueInterval numericValueInterval2 = (NumericValueInterval)n2;
        if (Predef$.MODULE$.double2Double(numericValueInterval.min()).compareTo(Predef$.MODULE$.double2Double(numericValueInterval2.max())) > 0) return false;
        if (Predef$.MODULE$.double2Double(numericValueInterval.max()).compareTo(Predef$.MODULE$.double2Double(numericValueInterval2.min())) < 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Option<Object>, Option<Object>> intersect(ValueInterval r1, ValueInterval r2, DataType dt) {
        Tuple2 tuple2 = new Tuple2((Object)r1, (Object)r2);
        boolean bl = tuple2 != null && tuple2._2() instanceof DefaultValueInterval ? true : tuple2 != null && tuple2._1() instanceof DefaultValueInterval;
        if (bl) {
            return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 == null) throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "intersect");
        ValueInterval n1 = (ValueInterval)tuple2._1();
        ValueInterval n2 = (ValueInterval)tuple2._2();
        if (!(n1 instanceof NumericValueInterval)) throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "intersect");
        NumericValueInterval numericValueInterval = (NumericValueInterval)n1;
        if (!(n2 instanceof NumericValueInterval)) throw QueryExecutionErrors$.MODULE$.pairUnsupportedAtFunctionError(r1, r2, "intersect");
        NumericValueInterval numericValueInterval2 = (NumericValueInterval)n2;
        double newMin = numericValueInterval.min() <= numericValueInterval2.min() ? numericValueInterval2.min() : numericValueInterval.min();
        double newMax = numericValueInterval.max() <= numericValueInterval2.max() ? numericValueInterval.max() : numericValueInterval2.max();
        return new Tuple2((Object)new Some(EstimationUtils$.MODULE$.fromDouble(newMin, dt)), (Object)new Some(EstimationUtils$.MODULE$.fromDouble(newMax, dt)));
    }

    private ValueInterval$() {
        MODULE$ = this;
    }
}

