/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;

public final class DateTimeTestUtils$ {
    public static DateTimeTestUtils$ MODULE$;
    private final ZoneId CEST;
    private final ZoneId CET;
    private final ZoneId JST;
    private final ZoneId LA;
    private final ZoneId MIT;
    private final ZoneId PST;
    private final ZoneId UTC;
    private final Option<String> UTC_OPT;
    private final Seq<ZoneId> ALL_TIMEZONES;
    private final Seq<String> outstandingTimezonesIds;
    private final Seq<ZoneId> outstandingZoneIds;

    static {
        new DateTimeTestUtils$();
    }

    public ZoneId CEST() {
        return this.CEST;
    }

    public ZoneId CET() {
        return this.CET;
    }

    public ZoneId JST() {
        return this.JST;
    }

    public ZoneId LA() {
        return this.LA;
    }

    public ZoneId MIT() {
        return this.MIT;
    }

    public ZoneId PST() {
        return this.PST;
    }

    public ZoneId UTC() {
        return this.UTC;
    }

    public Option<String> UTC_OPT() {
        return this.UTC_OPT;
    }

    public Seq<ZoneId> ALL_TIMEZONES() {
        return this.ALL_TIMEZONES;
    }

    public Seq<String> outstandingTimezonesIds() {
        return this.outstandingTimezonesIds;
    }

    public Seq<ZoneId> outstandingZoneIds() {
        return this.outstandingZoneIds;
    }

    public <T> T withDefaultTimeZone(ZoneId newDefaultTimeZone, Function0<T> block) {
        Object object;
        ZoneId originalDefaultTimeZone = ZoneId.systemDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone(newDefaultTimeZone));
            object = block.apply();
        }
        finally {
            TimeZone.setDefault(TimeZone.getTimeZone(originalDefaultTimeZone));
        }
        return (T)object;
    }

    public long localDateTimeToMicros(LocalDateTime localDateTime, ZoneId zoneId) {
        Instant instant = localDateTime.atZone(zoneId).toInstant();
        return DateTimeUtils$.MODULE$.instantToMicros(instant);
    }

    public long date(int year, byte month, byte day, byte hour, byte minute, byte sec, int micros, ZoneId zid) {
        int nanos = (int)TimeUnit.MICROSECONDS.toNanos(micros);
        LocalDateTime localDateTime = LocalDateTime.of(year, month, (int)day, (int)hour, (int)minute, (int)sec, nanos);
        return this.localDateTimeToMicros(localDateTime, zid);
    }

    public byte date$default$2() {
        return 1;
    }

    public byte date$default$3() {
        return 1;
    }

    public byte date$default$4() {
        return 0;
    }

    public byte date$default$5() {
        return 0;
    }

    public byte date$default$6() {
        return 0;
    }

    public int date$default$7() {
        return 0;
    }

    public ZoneId date$default$8() {
        return ZoneOffset.UTC;
    }

    public int days(int year, byte month, byte day) {
        return (int)LocalDate.of(year, month, (int)day).toEpochDay();
    }

    public byte days$default$2() {
        return 1;
    }

    public byte days$default$3() {
        return 1;
    }

    public long time(byte hour, byte minute, byte sec, int micros, ZoneId zid) {
        int nanos = (int)TimeUnit.MICROSECONDS.toNanos(micros);
        LocalDate localDate = LocalDate.now(zid);
        LocalTime localTime = LocalTime.of(hour, minute, sec, nanos);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return this.localDateTimeToMicros(localDateTime, zid);
    }

    public byte time$default$1() {
        return 0;
    }

    public byte time$default$2() {
        return 0;
    }

    public byte time$default$3() {
        return 0;
    }

    public int time$default$4() {
        return 0;
    }

    public ZoneId time$default$5() {
        return ZoneOffset.UTC;
    }

    public long secFrac(int seconds, int milliseconds, int microseconds) {
        long result = microseconds;
        result = Math.addExact(result, Math.multiplyExact((long)milliseconds, 1000L));
        result = Math.addExact(result, Math.multiplyExact((long)seconds, 1000000L));
        return result;
    }

    private DateTimeTestUtils$() {
        MODULE$ = this;
        this.CEST = DateTimeUtils$.MODULE$.getZoneId("+02:00");
        this.CET = DateTimeUtils$.MODULE$.getZoneId("+01:00");
        this.JST = DateTimeUtils$.MODULE$.getZoneId("+09:00");
        this.LA = DateTimeUtils$.MODULE$.getZoneId("America/Los_Angeles");
        this.MIT = DateTimeUtils$.MODULE$.getZoneId("-09:30");
        this.PST = DateTimeUtils$.MODULE$.getZoneId("-08:00");
        this.UTC = DateTimeUtils$.MODULE$.getZoneId("+00:00");
        this.UTC_OPT = Option$.MODULE$.apply((Object)"UTC");
        this.ALL_TIMEZONES = ((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(ZoneId.getAvailableZoneIds()).asScala()).map((Function1 & Serializable & scala.Serializable)timeZoneId -> DateTimeUtils$.MODULE$.getZoneId(timeZoneId), Set$.MODULE$.canBuildFrom())).toSeq();
        this.outstandingTimezonesIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UTC", this.PST().getId(), this.CET().getId(), "Africa/Dakar", this.LA().getId(), "Antarctica/Vostok", "Asia/Hong_Kong", "Europe/Amsterdam"}));
        this.outstandingZoneIds = (Seq)this.outstandingTimezonesIds().map((Function1 & Serializable & scala.Serializable)timeZoneId -> DateTimeUtils$.MODULE$.getZoneId(timeZoneId), Seq$.MODULE$.canBuildFrom());
    }
}

