/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.time.DateTimeException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper$;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.matchers.must.Matchers;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}4qAC\u0006\u0011\u0002\u0007\u0005\u0001\u0004C\u0003.\u0001\u0011\u0005a\u0006C\u00036\u0001\u0019\u0005a\u0007C\u0003J\u0001\u0011%!\nC\u0004Z\u0001E\u0005I\u0011\u0002.\t\u000b\u0015\u0004A\u0011\u00024\t\u000f1\u0004\u0011\u0013!C\u00055\")Q\u000e\u0001D\t]\")q\u000e\u0001C\u0005a\")\u0011\u0010\u0001C\u0005u\n1B)\u0019;fi&lWMR8s[\u0006$H/\u001a:Tk&$XM\u0003\u0002\r\u001b\u0005!Q\u000f^5m\u0015\tqq\"\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011$H\u0012\u0011\u0005iYR\"A\t\n\u0005q\t\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001fC5\tqD\u0003\u0002!\u001b\u0005)\u0001\u000f\\1og&\u0011!e\b\u0002\n'Fc\u0005*\u001a7qKJ\u0004\"\u0001J\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\t5,8\u000f\u001e\u0006\u0003Q%\n\u0001\"\\1uG\",'o\u001d\u0006\u0003UU\t\u0011b]2bY\u0006$Xm\u001d;\n\u00051*#\u0001C'bi\u000eDWM]:\u0002\r\u0011Jg.\u001b;%)\u0005y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$\u0001B+oSR\fac\u00195fG.4uN]7biR,'o\u0011:fCRLwN\u001c\u000b\u0004_]\"\u0005\"\u0002\u001d\u0003\u0001\u0004I\u0014a\u00029biR,'O\u001c\t\u0003u\u0005s!aO \u0011\u0005q\nT\"A\u001f\u000b\u0005y:\u0012A\u0002\u001fs_>$h(\u0003\u0002Ac\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001\u0015\u0007C\u0003F\u0005\u0001\u0007a)A\u0005jgB\u000b'o]5oOB\u0011\u0001gR\u0005\u0003\u0011F\u0012qAQ8pY\u0016\fg.A\u0007eCR,gi\u001c:nCR$XM\u001d\u000b\u0004\u0017>\u0003\u0006C\u0001'N\u001b\u0005Y\u0011B\u0001(\f\u00055!\u0015\r^3G_Jl\u0017\r\u001e;fe\")\u0001h\u0001a\u0001s!9\u0011k\u0001I\u0001\u0002\u0004\u0011\u0016a\u00017eMB\u00111K\u0016\b\u0003\u0019RK!!V\u0006\u0002#1+w-Y2z\t\u0006$XMR8s[\u0006$8/\u0003\u0002X1\n\u0001B*Z4bGf$\u0015\r^3G_Jl\u0017\r\u001e\u0006\u0003+.\tq\u0003Z1uK\u001a{'/\\1ui\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003mS#A\u0015/,\u0003u\u0003\"AX2\u000e\u0003}S!\u0001Y1\u0002\u0013Ut7\r[3dW\u0016$'B\u000122\u0003)\tgN\\8uCRLwN\\\u0005\u0003I~\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0015\u0007\u001dT7\u000e\u0005\u0002MQ&\u0011\u0011n\u0003\u0002\u0013)&lWm\u001d;b[B4uN]7biR,'\u000fC\u00039\u000b\u0001\u0007\u0011\bC\u0004R\u000bA\u0005\t\u0019\u0001*\u00029QLW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0001Ro]3ECR,gi\u001c:nCR$XM]\u000b\u0002\r\u0006Y\u0011m]:feR,\u0015/^1m)\u0011y\u0013O\u001d;\t\u000baB\u0001\u0019A\u001d\t\u000bMD\u0001\u0019A\u001d\u0002\u0017\u0011\fG/\u001a;j[\u0016\u001cFO\u001d\u0005\u0006k\"\u0001\rA^\u0001\tKb\u0004Xm\u0019;fIB\u0011\u0001g^\u0005\u0003qF\u0012A\u0001T8oO\u0006Y\u0011m]:feR,%O]8s)\u0011y3\u0010`?\t\u000baJ\u0001\u0019A\u001d\t\u000bML\u0001\u0019A\u001d\t\u000byL\u0001\u0019A\u001d\u0002\u0017\u0015D\b/Z2uK\u0012l5o\u001a")
public interface DatetimeFormatterSuite
extends SQLHelper,
Matchers {
    public void checkFormatterCreation(String var1, boolean var2);

    private DateFormatter dateFormatter(String pattern, Enumeration.Value ldf) {
        return DateFormatter$.MODULE$.apply(pattern, DateFormatter$.MODULE$.defaultLocale(), ldf, true);
    }

    private Enumeration.Value dateFormatter$default$2() {
        return LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT();
    }

    private TimestampFormatter timestampFormatter(String pattern, Enumeration.Value ldf) {
        return TimestampFormatter$.MODULE$.apply(pattern, DateTimeTestUtils$.MODULE$.UTC(), ldf, true);
    }

    private Enumeration.Value timestampFormatter$default$2() {
        return LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT();
    }

    public boolean useDateFormatter();

    private void assertEqual(String pattern, String datetimeStr, long expected) {
        if (this.useDateFormatter()) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.dateFormatter(pattern, this.dateFormatter$default$2()).parse(datetimeStr)));
            int $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.microsToDays(expected, DateTimeTestUtils$.MODULE$.UTC());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        } else {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.timestampFormatter(pattern, this.timestampFormatter$default$2()).parse(datetimeStr)));
            long $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }
    }

    private void assertError(String pattern, String datetimeStr, String expectedMsg) {
        if (this.useDateFormatter()) {
            LegacyDateFormats$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)ldf -> {
                SparkUpgradeException e = (SparkUpgradeException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.dateFormatter(pattern, (Enumeration.Value)ldf).parse(datetimeStr), ClassTag$.MODULE$.apply(SparkUpgradeException.class), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
                String $org_scalatest_assert_macro_left = e.getCause().getMessage();
                String $org_scalatest_assert_macro_right = expectedMsg;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            });
        } else {
            DateTimeException e = (DateTimeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.timestampFormatter(pattern, this.timestampFormatter$default$2()).parse(datetimeStr), ClassTag$.MODULE$.apply(DateTimeException.class), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = expectedMsg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            ((IterableLike)new .colon.colon((Object)LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), (List)new .colon.colon((Object)LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)ldf -> {
                SparkUpgradeException e = (SparkUpgradeException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.timestampFormatter(pattern, (Enumeration.Value)ldf).parse(datetimeStr), ClassTag$.MODULE$.apply(SparkUpgradeException.class), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                String $org_scalatest_assert_macro_left = e.getCause().getMessage();
                String $org_scalatest_assert_macro_right = expectedMsg;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            });
        }
    }

    public static /* synthetic */ String $anonfun$$init$$5(char x$1) {
        return Character.toString(x$1);
    }

    public static /* synthetic */ void $anonfun$$init$$2(DatetimeFormatterSuite $this, boolean isParsing) {
        Seq unsupportedBoth = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"QQQQQ", "qqqqq", "eeeee", "A", "B", "c", "n", "N", "p", "e"}));
        unsupportedBoth.foreach((Function1 & Serializable & scala.Serializable)pattern -> (IllegalArgumentException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkFormatterCreation((String)pattern, isParsing), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81)));
        ((IterableLike)((SetLike)DateTimeFormatterHelper$.MODULE$.weekBasedLetters().$plus$plus((GenTraversableOnce)DateTimeFormatterHelper$.MODULE$.unsupportedLetters()).map((Function1 & Serializable & scala.Serializable)x$1 -> DatetimeFormatterSuite.$anonfun$$init$$5(BoxesRunTime.unboxToChar((Object)x$1)), Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)DateTimeFormatterHelper$.MODULE$.unsupportedPatternLengths()).$minus$minus((GenTraversableOnce)unsupportedBoth)).foreach((Function1 & Serializable & scala.Serializable)pattern -> (SparkUpgradeException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkFormatterCreation((String)pattern, isParsing), ClassTag$.MODULE$.apply(SparkUpgradeException.class), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86)));
    }

    public static /* synthetic */ String $anonfun$$init$$10(char x$2) {
        return Character.toString(x$2);
    }

    public static void $init$(DatetimeFormatterSuite $this) {
        ((AnyFunSuiteLike)$this).test("explicitly forbidden datetime patterns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)isParsing -> {
                DatetimeFormatterSuite.$anonfun$$init$$2($this, BoxesRunTime.unboxToBoolean((Object)isParsing));
                return BoxedUnit.UNIT;
            });
            Seq unsupportedBoth = (Seq)new .colon.colon((Object)"q", (List)new .colon.colon((Object)"Q", (List)Nil$.MODULE$));
            unsupportedBoth.foreach((Function1 & Serializable & scala.Serializable)pattern -> (IllegalArgumentException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkFormatterCreation((String)pattern, true), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93)));
            ((IterableLike)((Subtractable)DateTimeFormatterHelper$.MODULE$.unsupportedLettersForParsing().map((Function1 & Serializable & scala.Serializable)x$2 -> DatetimeFormatterSuite.$anonfun$$init$$10(BoxesRunTime.unboxToChar((Object)x$2)), Set$.MODULE$.canBuildFrom())).$minus$minus((GenTraversableOnce)unsupportedBoth)).foreach((Function1 & Serializable & scala.Serializable)pattern -> (SparkUpgradeException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkFormatterCreation((String)pattern, true), ClassTag$.MODULE$.apply(SparkUpgradeException.class), new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97)));
        }, new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        ((AnyFunSuiteLike)$this).test("SPARK-31939: Fix Parsing day of year when year field pattern is missing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.assertEqual("yyyy-dd-DD", "2020-29-60", DateTimeTestUtils$.MODULE$.date(2020, (byte)2, (byte)29, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("yyyy-dd-DD", "2020-02-60", "Field DayOfMonth 29 differs from DayOfMonth 2 derived from 2020-02-29");
            $this.assertEqual("yyyy-MM-DD", "2020-02-60", DateTimeTestUtils$.MODULE$.date(2020, (byte)2, (byte)29, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("yyyy-MM-DD", "2020-03-60", "Field MonthOfYear 2 differs from MonthOfYear 3 derived from 2020-02-29");
            $this.assertEqual("yyyy-MM-dd-DD", "2020-02-29-60", DateTimeTestUtils$.MODULE$.date(2020, (byte)2, (byte)29, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("yyyy-MM-dd-DD", "2020-03-01-60", "Field DayOfYear 61 differs from DayOfYear 60 derived from 2020-03-01");
            $this.assertEqual("yyyy-DDD", "2020-366", DateTimeTestUtils$.MODULE$.date(2020, (byte)12, (byte)31, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("yyyy-DDD", "2019-366", "Invalid date 'DayOfYear 366' as '2019' is not a leap year");
            $this.assertEqual("DDD", "365", DateTimeTestUtils$.MODULE$.date(1970, (byte)12, (byte)31, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("DDD", "366", "Invalid date 'DayOfYear 366' as '1970' is not a leap year");
            $this.assertEqual("MM-DD", "03-60", DateTimeTestUtils$.MODULE$.date(1970, (byte)3, DateTimeTestUtils$.MODULE$.date$default$3(), DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("MM-DD", "02-60", "Field MonthOfYear 2 differs from MonthOfYear 3 derived from 1970-03-01");
            $this.assertEqual("MM-dd-DD", "02-28-59", DateTimeTestUtils$.MODULE$.date(1970, (byte)2, (byte)28, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("MM-dd-DD", "02-28-60", "Field MonthOfYear 2 differs from MonthOfYear 3 derived from 1970-03-01");
            $this.assertError("MM-dd-DD", "02-28-58", "Field DayOfMonth 28 differs from DayOfMonth 27 derived from 1970-02-27");
            $this.assertEqual("dd-DD", "28-59", DateTimeTestUtils$.MODULE$.date(1970, (byte)2, (byte)28, DateTimeTestUtils$.MODULE$.date$default$4(), DateTimeTestUtils$.MODULE$.date$default$5(), DateTimeTestUtils$.MODULE$.date$default$6(), DateTimeTestUtils$.MODULE$.date$default$7(), DateTimeTestUtils$.MODULE$.date$default$8()));
            $this.assertError("dd-DD", "27-59", "Field DayOfMonth 27 differs from DayOfMonth 28 derived from 1970-02-28");
        }, new Position("DatetimeFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
    }
}

