/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\t\u0013\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013%\u0011\u0006\u0003\u00042\u0001\u0001\u0006IA\u000b\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u0019A\u0004\u0001)A\u0005i!9\u0011\b\u0001b\u0001\n\u0013Q\u0004BB)\u0001A\u0003%1\bC\u0004S\u0001\t\u0007I\u0011\u0002\u001e\t\rM\u0003\u0001\u0015!\u0003<\u0011\u001d!\u0006A1A\u0005\nUCaa\u0017\u0001!\u0002\u00131\u0006\"\u0002/\u0001\t\u0013i\u0006\"\u0002:\u0001\t\u0013\u0019\b\"B<\u0001\t\u0013A\bbBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003#\u0001A\u0011BA\n\u0005Y\tV/\u00198uS2,7+^7nCJLWm]*vSR,'BA\n\u0015\u0003\u0011)H/\u001b7\u000b\u0005U1\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005]A\u0012aA:rY*\u0011\u0011DG\u0001\u0006gB\f'o\u001b\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011#\u001b\u0005A\u0012BA\u0012\u0019\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\n\t\u0003O\u0001i\u0011AE\u0001\u0002eV\t!\u0006\u0005\u0002,_5\tAF\u0003\u0002\u0014[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021Y\t1!+\u00198e_6\f!A\u001d\u0011\u0002\u00039,\u0012\u0001\u000e\t\u0003kYj\u0011!L\u0005\u0003o5\u00121!\u00138u\u0003\tq\u0007%\u0001\u0006j]\u000e\u0014X-Y:j]\u001e,\u0012a\u000f\t\u0005kqrd)\u0003\u0002>[\t1A+\u001e9mKJ\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005I\u0001\u0004TiJLgn\u001a\t\u0004\u000f2sU\"\u0001%\u000b\u0005%S\u0015!C5n[V$\u0018M\u00197f\u0015\tYU&\u0001\u0006d_2dWm\u0019;j_:L!!\u0014%\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u00026\u001f&\u0011\u0001+\f\u0002\u0007\t>,(\r\\3\u0002\u0017%t7M]3bg&tw\rI\u0001\u000bI\u0016\u001c'/Z1tS:<\u0017a\u00033fGJ,\u0017m]5oO\u0002\naA]1oI>lW#\u0001,\u0011\tUbdh\u0016\t\u00041fsU\"\u0001&\n\u0005iS%aA*fc\u00069!/\u00198e_6\u0004\u0013\u0001\u00042vS2$7+^7nCJLH\u0003\u00020b]B\u0004\"aJ0\n\u0005\u0001\u0014\"!E)vC:$\u0018\u000e\\3Tk6l\u0017M]5fg\")!\r\u0004a\u0001G\u0006!A-\u0019;b!\r!GN\u0014\b\u0003K*t!AZ5\u000e\u0003\u001dT!\u0001\u001b\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013BA6.\u0003\u001d\u0001\u0018mY6bO\u0016L!AW7\u000b\u0005-l\u0003\"B8\r\u0001\u0004q\u0015\u0001B3qg&DQ!\u001d\u0007A\u0002Q\n\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0002)\t,\u0018\u000e\u001c3D_6\u0004(/Z:t'VlW.\u0019:z)\u0011qF/\u001e<\t\u000b\tl\u0001\u0019A2\t\u000b=l\u0001\u0019\u0001(\t\u000bEl\u0001\u0019\u0001\u001b\u0002;Y\fG.\u001b3bi\u0016\fV/\u00198uS2,\u0017\t\u001d9s_bLW.\u0019;j_:$r!\u001f?\u007f\u0003\u0003\t\u0019\u0001\u0005\u00026u&\u001110\f\u0002\u0005+:LG\u000fC\u0003~\u001d\u0001\u0007a*\u0001\u0004baB\u0014x\u000e\u001f\u0005\u0006\u007f:\u0001\rAT\u0001\u000ba\u0016\u00148-\u001a8uS2,\u0007\"\u00022\u000f\u0001\u0004\u0019\u0007BBA\u0003\u001d\u0001\u0007a,A\u0004tk6l\u0017M]=\u0002\u001b\rDWmY6Rk\u0006tG/\u001b7f)\u001dI\u00181BA\u0007\u0003\u001fAQa`\bA\u00029CQAY\bA\u0002\rDa!!\u0002\u0010\u0001\u0004q\u0016AD2iK\u000e\\\u0017+^1oi&dWm\u001d\u000b\bs\u0006U\u0011\u0011DA\u000e\u0011\u0019\t9\u0002\u0005a\u0001G\u0006Y\u0001/\u001a:dK:$\u0018\u000e\\3t\u0011\u0015\u0011\u0007\u00031\u0001d\u0011\u0019\t)\u0001\u0005a\u0001=\u0002")
public class QuantileSummariesSuite
extends SparkFunSuite {
    private final Random r = new Random(1);
    private final int n;
    private final Tuple2<String, IndexedSeq<Object>> increasing = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"increasing"), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.n()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$1 -> x$1, IndexedSeq$.MODULE$.canBuildFrom()));
    private final Tuple2<String, IndexedSeq<Object>> decreasing = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"decreasing"), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.n()), 0).by(-1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> x$2, IndexedSeq$.MODULE$.canBuildFrom()));
    private final Tuple2<String, Seq<Object>> random = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"random"), (Object)Seq$.MODULE$.fill(this.n(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> package$.MODULE$.ceil(this.r().nextDouble() * (double)1000)));

    private Random r() {
        return this.r;
    }

    private int n() {
        return this.n;
    }

    private Tuple2<String, IndexedSeq<Object>> increasing() {
        return this.increasing;
    }

    private Tuple2<String, IndexedSeq<Object>> decreasing() {
        return this.decreasing;
    }

    private Tuple2<String, Seq<Object>> random() {
        return this.random;
    }

    private QuantileSummaries buildSummary(Seq<Object> data, double epsi, int threshold) {
        ObjectRef summary = ObjectRef.create((Object)new QuantileSummaries(threshold, epsi, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4(), QuantileSummaries$.MODULE$.$lessinit$greater$default$5()));
        data.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)x -> {
            summary$1.elem = ((QuantileSummaries)summary$1.elem).insert(x);
        });
        return ((QuantileSummaries)summary.elem).compress();
    }

    private QuantileSummaries buildCompressSummary(Seq<Object> data, double epsi, int threshold) {
        ObjectRef summary = ObjectRef.create((Object)new QuantileSummaries(threshold, epsi, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4(), QuantileSummaries$.MODULE$.$lessinit$greater$default$5()));
        data.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)x -> {
            summary$2.elem = ((QuantileSummaries)summary$2.elem).insert(x).compress();
        });
        return (QuantileSummaries)summary.elem;
    }

    private void validateQuantileApproximation(double approx, double percentile, Seq<Object> data, QuantileSummaries summary) {
        Seq<Object> $org_scalatest_assert_macro_left = data;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        int rankOfValue = data.count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 <= approx);
        int rankOfPreValue = data.count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 < approx);
        double rank = package$.MODULE$.ceil((double)(rankOfValue + rankOfPreValue) / 2.0);
        double lower = package$.MODULE$.floor((percentile - summary.relativeError()) * (double)data.size());
        double upper = package$.MODULE$.ceil((percentile + summary.relativeError()) * (double)data.size());
        String msg = new StringBuilder(54).append(rank).append(" not in [").append(lower).append(" ").append(upper).append("], requested percentile: ").append(percentile).append(", approx returned: ").append(approx).toString();
        double $org_scalatest_assert_macro_left2 = rank;
        double $org_scalatest_assert_macro_right = lower;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2 >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)msg, Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        double $org_scalatest_assert_macro_left3 = rank;
        double $org_scalatest_assert_macro_right2 = upper;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)msg, Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
    }

    private void checkQuantile(double percentile, Seq<Object> data, QuantileSummaries summary) {
        if (data.nonEmpty()) {
            double approx = BoxesRunTime.unboxToDouble((Object)summary.query(percentile).get());
            this.validateQuantileApproximation(approx, percentile, data, summary);
        } else {
            Option $org_scalatest_assert_macro_left = summary.query(percentile);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }
    }

    private void checkQuantiles(Seq<Object> percentiles, Seq<Object> data, QuantileSummaries summary) {
        if (data.nonEmpty()) {
            Seq approx = (Seq)summary.query(percentiles).get();
            ((TraversableLike)percentiles.zip((GenIterable)approx, Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$checkQuantiles$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                QuantileSummariesSuite.$anonfun$checkQuantiles$2(this, data, summary, x$5);
                return BoxedUnit.UNIT;
            });
        } else {
            Option $org_scalatest_assert_macro_left = summary.query(percentiles);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkQuantiles$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkQuantiles$2(QuantileSummariesSuite $this, Seq data$1, QuantileSummaries summary$3, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double q = tuple2._1$mcD$sp();
        double a = tuple2._2$mcD$sp();
        $this.validateQuantileApproximation(a, q, (Seq<Object>)data$1, summary$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$new$2(QuantileSummariesSuite $this, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String seq_name = (String)tuple2._1();
        Seq data = (Seq)tuple2._2();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 1.0E-4}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)epsi -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1000, 10}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)compression -> {
            $this.test(new StringBuilder(42).append("Extremas with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                double max_approx;
                double min_approx;
                QuantileSummaries s = $this.buildSummary((Seq<Object>)data, epsi, compression);
                double $org_scalatest_assert_macro_left = min_approx = BoxesRunTime.unboxToDouble((Object)s.query(0.0).get());
                double $org_scalatest_assert_macro_right = BoxesRunTime.unboxToDouble((Object)data.min((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(34).append("Did not return the min: min=").append(data.min((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(min_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                double $org_scalatest_assert_macro_left2 = max_approx = BoxesRunTime.unboxToDouble((Object)s.query(1.0).get());
                double $org_scalatest_assert_macro_right2 = BoxesRunTime.unboxToDouble((Object)data.max((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(34).append("Did not return the max: max=").append(data.max((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(max_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            $this.test(new StringBuilder(54).append("Some quantile values with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                QuantileSummaries s = $this.buildSummary((Seq<Object>)data, epsi, compression);
                long $org_scalatest_assert_macro_left = s.count();
                int $org_scalatest_assert_macro_right = data.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(27).append("Found count=").append(s.count()).append(" but data size=").append(data.size()).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.001, 0.1, 0.5, 0.9, 0.9999}))), (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.9999, 0.9, 0.5, 0.1, 0.001}))), (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            $this.test(new StringBuilder(68).append("Some quantile values with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).append(" ").append("(interleaved)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                QuantileSummaries s = $this.buildCompressSummary((Seq<Object>)data, epsi, compression);
                long $org_scalatest_assert_macro_left = s.count();
                int $org_scalatest_assert_macro_right = data.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(27).append("Found count=").append(s.count()).append(" but data size=").append(data.size()).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.001, 0.1, 0.5, 0.9, 0.9999}))), (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.9999, 0.9, 0.5, 0.1, 0.001}))), (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            $this.test(new StringBuilder(53).append("Tests on empty data with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq emptyData = (Seq)Nil$.MODULE$;
                QuantileSummaries s = $this.buildSummary((Seq<Object>)emptyData, epsi, compression);
                long $org_scalatest_assert_macro_left = s.count();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(28).append("Found count=").append(s.count()).append(" but data size=0").toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])s.sampled());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"if QuantileSummaries is empty, sampled should be empty", Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                $this.checkQuantile(0.9999, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.9, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.5, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.1, (Seq<Object>)emptyData, s);
                $this.checkQuantile(0.001, (Seq<Object>)emptyData, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.001, 0.1, 0.5, 0.9, 0.9999}))), (Seq<Object>)emptyData, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.9999, 0.9, 0.5, 0.1, 0.001}))), (Seq<Object>)emptyData, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        }));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$new$14(Seq x$8) {
        return BoxesRunTime.unboxToDouble((Object)x$8.head());
    }

    public static final /* synthetic */ double $anonfun$new$15(Seq x$9) {
        return BoxesRunTime.unboxToDouble((Object)x$9.last());
    }

    public static final /* synthetic */ boolean $anonfun$new$17(Tuple2 x$11) {
        return x$11._2$mcI$sp() % 5 != 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$19(Tuple2 x$13) {
        return x$13._2$mcI$sp() % 5 == 0;
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$new$22(QuantileSummariesSuite $this, Seq data$3, QuantileSummaries s$1, ArrayBuffer percentiles$1, int queryRank) {
        double percentile = (double)queryRank / (double)$this.n();
        $this.checkQuantile(percentile, (Seq<Object>)data$3, s$1);
        return percentiles$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)percentile));
    }

    public static final /* synthetic */ void $anonfun$new$10(QuantileSummariesSuite $this, Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String seq_name = (String)tuple2._1();
        Seq data = (Seq)tuple2._2();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 1.0E-4}))).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)epsi -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1000, 10}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)compression -> {
            int l = data.size();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(data.take(l / 2)), data.drop(l / 2));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq data1 = (Seq)tuple2._1();
            Seq data2 = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)data1, (Object)data2);
            Tuple2 tuple23 = tuple22;
            Seq data12 = (Seq)tuple23._1();
            Seq data22 = (Seq)tuple23._2();
            $this.test(new StringBuilder(55).append("Merging ordered lists with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                double max_approx;
                double min_approx;
                QuantileSummaries s1 = $this.buildSummary((Seq<Object>)data12, epsi, compression);
                QuantileSummaries s2 = $this.buildSummary((Seq<Object>)data22, epsi, compression);
                QuantileSummaries s = s1.merge(s2);
                double $org_scalatest_assert_macro_left = min_approx = BoxesRunTime.unboxToDouble((Object)s.query(0.0).get());
                double $org_scalatest_assert_macro_right = BoxesRunTime.unboxToDouble((Object)data.min((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(34).append("Did not return the min: min=").append(data.min((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(min_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
                double $org_scalatest_assert_macro_left2 = max_approx = BoxesRunTime.unboxToDouble((Object)s.query(1.0).get());
                double $org_scalatest_assert_macro_right2 = BoxesRunTime.unboxToDouble((Object)data.max((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(34).append("Did not return the max: max=").append(data.max((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(max_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.001, 0.1, 0.5, 0.9, 0.9999}))), (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.9999, 0.9, 0.5, 0.1, 0.001}))), (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            Tuple2 tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data.sliding(2).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)QuantileSummariesSuite.$anonfun$new$14(x$8))).toSeq()), (Object)data.sliding(2).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)QuantileSummariesSuite.$anonfun$new$15(x$9))).toSeq());
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Seq data11 = (Seq)tuple24._1();
            Seq data122 = (Seq)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)data11, (Object)data122);
            Tuple2 tuple26 = tuple25;
            Seq data112 = (Seq)tuple26._1();
            Seq data123 = (Seq)tuple26._2();
            $this.test(new StringBuilder(59).append("Merging interleaved lists with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                double max_approx;
                double min_approx;
                QuantileSummaries s1 = $this.buildSummary((Seq<Object>)data112, epsi, compression);
                QuantileSummaries s2 = $this.buildSummary((Seq<Object>)data123, epsi, compression);
                QuantileSummaries s = s1.merge(s2);
                double $org_scalatest_assert_macro_left = min_approx = BoxesRunTime.unboxToDouble((Object)s.query(0.0).get());
                double $org_scalatest_assert_macro_right = BoxesRunTime.unboxToDouble((Object)data.min((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(34).append("Did not return the min: min=").append(data.min((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(min_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
                double $org_scalatest_assert_macro_left2 = max_approx = BoxesRunTime.unboxToDouble((Object)s.query(1.0).get());
                double $org_scalatest_assert_macro_right2 = BoxesRunTime.unboxToDouble((Object)data.max((Ordering)Ordering.Double$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(34).append("Did not return the max: max=").append(data.max((Ordering)Ordering.Double$.MODULE$)).append(", got ").append(max_approx).toString(), Prettifier$.MODULE$.default(), new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
                $this.checkQuantile(0.9999, (Seq<Object>)data, s);
                $this.checkQuantile(0.9, (Seq<Object>)data, s);
                $this.checkQuantile(0.5, (Seq<Object>)data, s);
                $this.checkQuantile(0.1, (Seq<Object>)data, s);
                $this.checkQuantile(0.001, (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.001, 0.1, 0.5, 0.9, 0.9999}))), (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.9999, 0.9, 0.5, 0.1, 0.001}))), (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            Seq data21 = ((SeqLike)((TraversableLike)((TraversableLike)data.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$17(x$11)))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12._1$mcD$sp()), Seq$.MODULE$.canBuildFrom())).toSeq();
            Seq data222 = ((SeqLike)((TraversableLike)((TraversableLike)data.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$19(x$13)))).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14._1$mcD$sp()), Seq$.MODULE$.canBuildFrom())).toSeq();
            $this.test(new StringBuilder(70).append("Merging unbalanced interleaved lists with epsi=").append(epsi).append(" and seq=").append(seq_name).append(", ").append("compression=").append(compression).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                QuantileSummaries s1 = $this.buildSummary((Seq<Object>)data21, epsi, compression);
                QuantileSummaries s2 = $this.buildSummary((Seq<Object>)data222, epsi, compression);
                QuantileSummaries s = s1.merge(s2);
                ArrayBuffer percentiles = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.n()).foreach((Function1 & Serializable & scala.Serializable)queryRank -> QuantileSummariesSuite.$anonfun$new$22($this, data, s, percentiles, BoxesRunTime.unboxToInt((Object)queryRank)));
                $this.checkQuantiles((Seq<Object>)percentiles.toSeq(), (Seq<Object>)data, s);
                $this.checkQuantiles((Seq<Object>)((SeqLike)percentiles.reverse()).toSeq(), (Seq<Object>)data, s);
            }, new Position("QuantileSummariesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        }));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public QuantileSummariesSuite() {
        this.n = 100;
        ((TraversableLike)new .colon.colon(this.increasing(), (List)new .colon.colon(this.decreasing(), (List)new .colon.colon(this.random(), (List)Nil$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            QuantileSummariesSuite.$anonfun$new$2(this, x$6);
            return BoxedUnit.UNIT;
        });
        ((TraversableLike)new .colon.colon(this.increasing(), (List)new .colon.colon(this.decreasing(), (List)new .colon.colon(this.random(), (List)Nil$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)QuantileSummariesSuite.$anonfun$new$9(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            QuantileSummariesSuite.$anonfun$new$10(this, x$15);
            return BoxedUnit.UNIT;
        });
    }
}

