/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a set of unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0014)\u0001^B\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005%\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005]\u0001\tE\t\u0015!\u0003Z\u0011!i\u0006A!f\u0001\n\u0003A\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011B-\t\u000b}\u0003A\u0011\u00011\t\u000b}\u0003A\u0011A3\t\u0011\u001d\u0004\u0001R1A\u0005B!DQa\u001c\u0001\u0005BADQa\u001d\u0001\u0005BQDQa\u001e\u0001\u0005BaDaa \u0001\u0005B\u0005\u0005\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\r\u0001\t#\n)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0001\u0002>!I\u0011Q\t\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003;\u0002\u0011\u0013!C\u0001\u0003?B\u0011\"a\u0019\u0001#\u0003%\t!a\u0018\t\u0013\u0005\u0015\u0004!!A\u0005B\u0005\u001d\u0004\u0002CA<\u0001\u0005\u0005I\u0011\u0001-\t\u0013\u0005e\u0004!!A\u0005\u0002\u0005m\u0004\"CAA\u0001\u0005\u0005I\u0011IAB\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0011\u0002\u001c\u001eI\u0011Q\u0019\u0015\u0002\u0002#\u0005\u0011q\u0019\u0004\tO!\n\t\u0011#\u0001\u0002J\"1q,\bC\u0001\u0003/D\u0011\"!7\u001e\u0003\u0003%)%a7\t\u0013\u0005uW$!A\u0005\u0002\u0006}\u0007\"CAt;E\u0005I\u0011AA0\u0011%\tI/HI\u0001\n\u0003\ty\u0006C\u0005\u0002lv\t\t\u0011\"!\u0002n\"I\u0011q`\u000f\u0012\u0002\u0013\u0005\u0011q\f\u0005\n\u0005\u0003i\u0012\u0013!C\u0001\u0003?B\u0011Ba\u0001\u001e\u0003\u0003%IA!\u0002\u0003\u0015\r{G\u000e\\3diN+GO\u0003\u0002*U\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003W1\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QFL\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0006M\u0001\u0004gFd'BA\u00193\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u000f&N!\rI$\bP\u0007\u0002Q%\u00111\b\u000b\u0002\b\u0007>dG.Z2u!\riDIR\u0007\u0002})\u0011q\bQ\u0001\b[V$\u0018M\u00197f\u0015\t\t%)\u0001\u0006d_2dWm\u0019;j_:T\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000bz\u0012q\u0001S1tQN+G\u000f\u0005\u0002H\u00116\t!)\u0003\u0002J\u0005\n\u0019\u0011I\\=\u0011\u0005\u001d[\u0015B\u0001'C\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u0012(\n\u0005=\u0013%\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001*\u0011\u0005M#V\"\u0001\u0016\n\u0005US#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u00023B\u0011qIW\u0005\u00037\n\u00131!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}Q!\u0011MY2e!\tI\u0004\u0001C\u0003Q\u000f\u0001\u0007!\u000bC\u0004X\u000fA\u0005\t\u0019A-\t\u000fu;\u0001\u0013!a\u00013R\u0011\u0011M\u001a\u0005\u0006!\"\u0001\rAU\u0001\u0012EV4g-\u001a:FY\u0016lWM\u001c;UsB,W#A5\u0011\u0005)lW\"A6\u000b\u00051t\u0013!\u0002;za\u0016\u001c\u0018B\u00018l\u0005!!\u0015\r^1UsB,\u0017AF2p]Z,'\u000f\u001e+p\u0005V4g-\u001a:FY\u0016lWM\u001c;\u0015\u0005\u0019\u000b\b\"\u0002:\u000b\u0001\u00041\u0015!\u0002<bYV,\u0017\u0001B3wC2$\"AR;\t\u000bY\\\u0001\u0019\u0001\u001f\u0002\r\t,hMZ3s\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?-\u0003!\tg.\u00197zg&\u001c\u0018B\u0001@|\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004s\u0005\u0015\u0011bAA\u0004Q\t\u0019\u0012*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uK\"1\u00111B\u0007A\u0002e\u000b\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$B!a\u0001\u0002\u0012!1\u00111\u0003\bA\u0002e\u000bqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u001aA!\u00111DA\u0015\u001d\u0011\ti\"!\n\u0011\u0007\u0005}!)\u0004\u0002\u0002\")\u0019\u00111\u0005\u001c\u0002\rq\u0012xn\u001c;?\u0013\r\t9CQ\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d\")A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\tA(\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004C\u0006]\u0002BBA\u001d#\u0001\u0007!+\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u000f\u0005\fy$!\u0011\u0002D!9\u0001K\u0005I\u0001\u0002\u0004\u0011\u0006bB,\u0013!\u0003\u0005\r!\u0017\u0005\b;J\u0001\n\u00111\u0001Z\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0013+\u0007I\u000bYe\u000b\u0002\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013!C;oG\",7m[3e\u0015\r\t9FQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA.\u0003#\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0019+\u0007e\u000bY%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0003g\nAA[1wC&!\u00111FA7\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ARA?\u0011!\ty\bGA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0006B)\u0011qQAE\r6\t\u0001)C\u0002\u0002\f\u0002\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011SAL!\r9\u00151S\u0005\u0004\u0003+\u0013%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u007fR\u0012\u0011!a\u0001\r\u00061Q-];bYN$B!!%\u0002\u001e\"A\u0011qP\u000e\u0002\u0002\u0003\u0007a\tK\f\u0001\u0003C\u000b9+!+\u0002.\u0006=\u00161WA[\u0003s\u000bY,a0\u0002BB\u00191+a)\n\u0007\u0005\u0015&FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005-\u0016!P0G+:\u001bu\fK3yaJL\u0003%\f\u0011D_2dWm\u0019;tA\u0005tG\r\t:fiV\u0014hn\u001d\u0011bAM,G\u000fI8gAUt\u0017.];fA\u0015dW-\\3oiNt\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0016\u0001\u0019\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>d\u0017\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&M\u0015-A!\u0012\u0014\u0006\f\u0011)c%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007\f\u001a^\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!a.\u0002\u0003\u0017R\u0001\u0005\t\u0011!)\",\u0007EZ;oGRLwN\u001c\u0011jg\u0002rwN\\\u0017eKR,'/\\5oSN$\u0018n\u0019\u0011cK\u000e\fWo]3!i\",\u0007e\u001c:eKJ\u0004sN\u001a\u0011d_2dWm\u0019;fI\u0002\u0012Xm];miN\u0004C-\u001a9f]\u0012\u001c(\u0002\t\u0011!A=t\u0007\u0005\u001e5fA=\u0014H-\u001a:!_\u001a\u0004C\u000f[3!e><8\u000fI<iS\u000eD\u0007%\\1zA\t,\u0007E\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA\u00054G/\u001a:!C\u0002\u001a\b.\u001e4gY\u0016t#\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005u\u0016!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019-A\u00033]Ar\u0003'\u0001\u0006D_2dWm\u0019;TKR\u0004\"!O\u000f\u0014\tu\tY-\u0014\t\t\u0003\u001b\f\u0019NU-ZC6\u0011\u0011q\u001a\u0006\u0004\u0003#\u0014\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003+\fyMA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!a2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0005\f\t/a9\u0002f\")\u0001\u000b\ta\u0001%\"9q\u000b\tI\u0001\u0002\u0004I\u0006bB/!!\u0003\u0005\r!W\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005=\u00181 \t\u0006\u000f\u0006E\u0018Q_\u0005\u0004\u0003g\u0014%AB(qi&|g\u000e\u0005\u0004H\u0003o\u0014\u0016,W\u0005\u0004\u0003s\u0014%A\u0002+va2,7\u0007\u0003\u0005\u0002~\u000e\n\t\u00111\u0001b\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0001\u0003BA6\u0005\u0013IAAa\u0003\u0002n\t1qJ\u00196fGR\u0004")
public class CollectSet
extends Collect<HashSet<Object>>
implements scala.Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return CollectSet$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectSet$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectSet collectSet) {
        return CollectSet$.MODULE$.unapply(collectSet);
    }

    public static int apply$default$3() {
        return CollectSet$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectSet$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectSet> tupled() {
        return CollectSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectSet>>> curried() {
        return CollectSet$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectSet collectSet = this;
        synchronized (collectSet) {
            if (!this.bitmap$0) {
                DataType dataType = this.child().dataType();
                DataType dataType2 = BinaryType$.MODULE$.equals(dataType) ? ArrayType$.MODULE$.apply(ByteType$.MODULE$) : dataType;
                this.bufferElementType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        return !this.bitmap$0 ? this.bufferElementType$lzycompute() : this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        DataType dataType = this.child().dataType();
        Object object = BinaryType$.MODULE$.equals(dataType) ? UnsafeArrayData.fromPrimitiveArray((byte[])value) : InternalRow$.MODULE$.copyValue(value);
        return object;
    }

    @Override
    public Object eval(HashSet<Object> buffer) {
        DataType dataType = this.child().dataType();
        Object object = BinaryType$.MODULE$.equals(dataType) ? buffer.iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> ((ArrayData)x$2).toByteArray()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))) : buffer.toArray(ClassTag$.MODULE$.Any());
        Object array = object;
        return new GenericArrayData(array);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return !this.child().dataType().existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CollectSet.$anonfun$checkInputDataTypes$1(x$3))) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("collect_set() cannot have map type data");
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public String prettyName() {
        return "collect_set";
    }

    @Override
    public HashSet<Object> createAggregationBuffer() {
        return HashSet$.MODULE$.empty();
    }

    @Override
    public CollectSet withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectSet copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectSet(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectSet";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectSet collectSet = (CollectSet)x$1;
        Expression expression = this.child();
        Expression expression2 = collectSet.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.mutableAggBufferOffset() != collectSet.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectSet.inputAggBufferOffset()) return false;
        if (!collectSet.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(DataType x$3) {
        return x$3 instanceof MapType;
    }

    public CollectSet(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public CollectSet(Expression child) {
        this(child, 0, 0);
    }
}

