/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Flatten$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(arrayOfArrays) - Transforms an array of arrays into a single array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(array(1, 2), array(3, 4)));\n       [1,2,3,4]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u0010 \u00012B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\")q\t\u0001C\u0001\u0011\")1\n\u0001C\u0005\u0019\")1\u000b\u0001C!)\"A\u0001\f\u0001EC\u0002\u0013\u0005\u0013\f\u0003\u0005b\u0001!\u0015\r\u0011\"\u0003Z\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\t\b\u0001\"\u0011s\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!a\n\u0001\t\u0013\tI\u0003C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005]\u0002\u0001\"\u0015\u0002:!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u000b\u0002\u0011\u0013!C\u0001\u0003\u000fB\u0011\"!\u0018\u0001\u0003\u0003%\t%a\u0018\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\t\t\tAA\u0001\n\u0003\n\u0019\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0001\u0002\u0014\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0013\u0011T\u0004\n\u0003{{\u0012\u0011!E\u0001\u0003\u007f3\u0001BH\u0010\u0002\u0002#\u0005\u0011\u0011\u0019\u0005\u0007\u000fb!\t!a4\t\u0013\u0005E\u0007$!A\u0005F\u0005M\u0007\"CAk1\u0005\u0005I\u0011QAl\u0011%\tY\u000eGA\u0001\n\u0003\u000bi\u000eC\u0005\u0002jb\t\t\u0011\"\u0003\u0002l\n9a\t\\1ui\u0016t'B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001i\u0013\u0007\u000f \u0011\u00059zS\"A\u0010\n\u0005Az\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I*dB\u0001\u00184\u0013\t!t$A\u0004qC\u000e\\\u0017mZ3\n\u0005Y:$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003i}\u0001\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002:\u007f%\u0011\u0001I\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0007B\u0011a\u0006R\u0005\u0003\u000b~\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"!\u0013&\u0011\u00059\u0002\u0001\"B!\u0004\u0001\u0004\u0019\u0015!D2iS2$G)\u0019;b)f\u0004X-F\u0001N!\tq\u0015+D\u0001P\u0015\t\u00016%A\u0003usB,7/\u0003\u0002S\u001f\nI\u0011I\u001d:bsRK\b/Z\u0001\t]VdG.\u00192mKV\tQ\u000b\u0005\u0002:-&\u0011qK\u000f\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,W#\u0001.\u0011\u00059[\u0016B\u0001/P\u0005!!\u0015\r^1UsB,\u0007F\u0001\u0004_!\tIt,\u0003\u0002au\tIAO]1og&,g\u000e^\u0001\fK2,W.\u001a8u)f\u0004X\r\u000b\u0002\b=\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\tQ\r\u0005\u0002gS6\tqM\u0003\u0002iC\u0005A\u0011M\\1msNL7/\u0003\u0002kO\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002naB\u0011\u0011H\\\u0005\u0003_j\u00121!\u00118z\u0011\u0015\t\u0015\u00021\u0001n\u0003%!wnR3o\u0007>$W\rF\u0002tsz\u0004\"\u0001^<\u000e\u0003UT!A^\u0010\u0002\u000f\r|G-Z4f]&\u0011\u00010\u001e\u0002\t\u000bb\u0004(oQ8eK\")!P\u0003a\u0001w\u0006\u00191\r\u001e=\u0011\u0005Qd\u0018BA?v\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa \u0006A\u0002M\f!!\u001a<\u00025\u001d,gnQ8eK\u001a{'OT;nE\u0016\u0014xJZ#mK6,g\u000e^:\u0015\r\u0005\u0015\u0011\u0011EA\u0012!\u001dI\u0014qAA\u0006\u0003\u0017I1!!\u0003;\u0005\u0019!V\u000f\u001d7feA!\u0011QBA\u000e\u001d\u0011\ty!a\u0006\u0011\u0007\u0005E!(\u0004\u0002\u0002\u0014)\u0019\u0011QC\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\tIBO\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0011q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e!\bC\u0003{\u0017\u0001\u00071\u0010C\u0004\u0002&-\u0001\r!a\u0003\u0002#\rD\u0017\u000e\u001c3WCJL\u0017M\u00197f\u001d\u0006lW-A\thK:\u001cu\u000eZ3G_J4E.\u0019;uK:$\u0002\"a\u0003\u0002,\u00055\u0012q\u0006\u0005\u0006u2\u0001\ra\u001f\u0005\b\u0003Ka\u0001\u0019AA\u0006\u0011\u001d\t\t\u0004\u0004a\u0001\u0003\u0017\tQ\"\u0019:sCf$\u0015\r^1OC6,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u00111B\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007%\u000bY\u0004\u0003\u0004\u0002>9\u0001\raQ\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\rI\u00151\t\u0005\b\u0003>\u0001\n\u00111\u0001D\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0013+\u0007\r\u000bYe\u000b\u0002\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013!C;oG\",7m[3e\u0015\r\t9FO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA.\u0003#\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\r\t\u0005\u0003G\ni'\u0004\u0002\u0002f)!\u0011qMA5\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0014\u0001\u00026bm\u0006LA!!\b\u0002f\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u000f\t\u0004s\u0005U\u0014bAA<u\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q.! \t\u0013\u0005}4#!AA\u0002\u0005M\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0006B)\u0011qQAG[6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017S\u0014AC2pY2,7\r^5p]&!\u0011qRAE\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007U\u000b)\n\u0003\u0005\u0002\u0000U\t\t\u00111\u0001n\u0003\u0019)\u0017/^1mgR\u0019Q+a'\t\u0011\u0005}d#!AA\u00025D3\u0003AAP\u0003K\u000b9+a+\u0002.\u0006E\u00161WA\\\u0003s\u00032ALAQ\u0013\r\t\u0019k\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI+\u0001&`\rVs5i\u0018\u0015beJ\f\u0017p\u00144BeJ\f\u0017p]\u0015![\u0001\"&/\u00198tM>\u0014Xn\u001d\u0011b]\u0002\n'O]1zA=4\u0007%\u0019:sCf\u001c\b%\u001b8u_\u0002\n\u0007e]5oO2,\u0007%\u0019:sCft\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005=\u0016A\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u0015beJ\f\u0017\u0010K\u0019-AIJC\u0006I1se\u0006L\bf\r\u0017!i%J\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012Df\r\u00175;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u00026\u0006Y\u0011M\u001d:bs~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\tY,A\u00033]Qr\u0003'A\u0004GY\u0006$H/\u001a8\u0011\u00059B2\u0003\u0002\r\u0002Dz\u0002b!!2\u0002L\u000eKUBAAd\u0015\r\tIMO\u0001\beVtG/[7f\u0013\u0011\ti-a2\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002@\u0006AAo\\*ue&tw\r\u0006\u0002\u0002b\u0005)\u0011\r\u001d9msR\u0019\u0011*!7\t\u000b\u0005[\u0002\u0019A\"\u0002\u000fUt\u0017\r\u001d9msR!\u0011q\\As!\u0011I\u0014\u0011]\"\n\u0007\u0005\r(H\u0001\u0004PaRLwN\u001c\u0005\t\u0003Od\u0012\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u0004B!a\u0019\u0002p&!\u0011\u0011_A3\u0005\u0019y%M[3di\u0002")
public class Flatten
extends UnaryExpression
implements package.NullIntolerant,
scala.Serializable {
    private transient DataType dataType;
    private transient DataType elementType;
    private final Expression child;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(Flatten flatten) {
        return Flatten$.MODULE$.unapply(flatten);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Flatten, A> function1) {
        return Flatten$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Flatten> compose(Function1<A, Expression> function1) {
        return Flatten$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private ArrayType childDataType() {
        return (ArrayType)this.child().dataType();
    }

    @Override
    public boolean nullable() {
        return this.child().nullable() || this.childDataType().containsNull();
    }

    private DataType dataType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.childDataType().elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    private DataType elementType$lzycompute() {
        Flatten flatten = this;
        synchronized (flatten) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ArrayType arrayType;
        DataType dataType = this.child().dataType();
        TypeCheckResult typeCheckResult = dataType instanceof ArrayType && (arrayType = (ArrayType)dataType).elementType() instanceof ArrayType ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(62).append("The argument should be an array of arrays, ").append("but '").append(this.child().sql()).append("' is of ").append(this.child().dataType().catalogString()).append(" type.").toString());
        return typeCheckResult;
    }

    @Override
    public Object nullSafeEval(Object child) {
        GenericArrayData genericArrayData;
        Object[] elements = ((ArrayData)child).toObjectArray(this.dataType());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).contains(null)) {
            genericArrayData = null;
        } else {
            ArrayData[] arrayData = (ArrayData[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(elements)).map((Function1 & Serializable & scala.Serializable)x$61 -> (ArrayData)x$61, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayData.class)));
            long numberOfElements = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(sum, e) -> BoxesRunTime.boxToLong((long)Flatten.$anonfun$nullSafeEval$6(BoxesRunTime.unboxToLong((Object)sum), e))));
            if (numberOfElements > 0x7FFFFFF0L) {
                throw QueryExecutionErrors$.MODULE$.flattenArraysWithElementsExceedLimitError(numberOfElements);
            }
            Object[] flattenedData = (Object[])ClassTag$.MODULE$.Nothing().newArray((int)numberOfElements);
            IntRef position = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData)).foreach((Function1 & Serializable & scala.Serializable)ad -> {
                Flatten.$anonfun$nullSafeEval$7(this, flattenedData, position, ad);
                return BoxedUnit.UNIT;
            });
            genericArrayData = new GenericArrayData((Object)flattenedData);
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String code = this.genCodeForFlatten(ctx, (String)c, ExprValue$.MODULE$.exprValueToString(ev.value()));
            return ctx.nullArrayElementsSaveExec(this.childDataType().containsNull(), ExprValue$.MODULE$.exprValueToString(ev.isNull()), (String)c, code);
        });
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String childVariableName) {
        String variableName = ctx.freshName("numElements");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(125).append("\n      |long ").append(variableName).append(" = 0;\n      |for (int z = 0; z < ").append(childVariableName).append(".numElements(); z++) {\n      |  ").append(variableName).append(" += ").append(childVariableName).append(".getArray(z).numElements();\n      |}\n      ").toString())).stripMargin();
        return new Tuple2((Object)code, (Object)variableName);
    }

    private String genCodeForFlatten(CodegenContext ctx, String childVariableName, String arrayDataName) {
        String counter = ctx.freshName("counter");
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        String l = ctx.freshName("l");
        String arr = ctx.freshName("arr");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, childVariableName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        Tuple2 tuple23 = tuple22;
        String numElemCode2 = (String)tuple23._1();
        String numElemName2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, this.elementType(), numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(tempArrayDataName, this.elementType(), arr, counter, l, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n    |").append(numElemCode2).append("\n    |").append(allocation).append("\n    |int ").append(counter).append(" = 0;\n    |for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(childVariableName).append(".numElements(); ").append(k).append("++) {\n    |  ArrayData ").append(arr).append(" = ").append(childVariableName).append(".getArray(").append(k).append(");\n    |  for (int ").append(l).append(" = 0; ").append(l).append(" < ").append(arr).append(".numElements(); ").append(l).append("++) {\n    |   ").append(assignment).append("\n    |   ").append(counter).append("++;\n    | }\n    |}\n    |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n    ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "flatten";
    }

    @Override
    public Flatten withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Flatten copy(Expression child) {
        return new Flatten(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Flatten";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Flatten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Flatten)) return false;
        boolean bl = true;
        if (!bl) return false;
        Flatten flatten = (Flatten)x$1;
        Expression expression = this.child();
        Expression expression2 = flatten.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!flatten.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$nullSafeEval$6(long sum, ArrayData e) {
        return sum + (long)e.numElements();
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$7(Flatten $this, Object[] flattenedData$1, IntRef position$2, ArrayData ad) {
        Object[] arr = ad.toObjectArray($this.elementType());
        Array$.MODULE$.copy((Object)arr, 0, (Object)flattenedData$1, position$2.elem, arr.length);
        position$2.elem += arr.length;
    }

    public Flatten(Expression child) {
        this.child = child;
    }
}

