/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.aggregate.HistogramNumeric$;
import org.apache.spark.sql.catalyst.expressions.aggregate.NumericHistogramSerializer$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.sql.util.NumericHistogram;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, nb) - Computes a histogram on numeric 'expr' using nb bins.\n      The return value is an array of (x,y) pairs representing the centers of the\n      histogram's bins. As the value of 'nb' is increased, the histogram approximation\n      gets finer-grained, but may yield artifacts around outliers. In practice, 20-40\n      histogram bins appear to work well, with more bins being required for skewed or\n      smaller datasets. Note that this function creates a histogram with non-uniform\n      bin widths. It offers no guarantees in terms of the mean-squared-error of the\n      histogram, but in practice is comparable to the histograms produced by the R/S-Plus\n      statistical computing packages. Note: the output type of the 'x' field in the return value is\n      propagated from the input value consumed in the aggregate function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 5) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [{\"x\":0,\"y\":1.0},{\"x\":1,\"y\":1.0},{\"x\":2,\"y\":1.0},{\"x\":10,\"y\":1.0}]\n  ", group="agg_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u00181\u0001~B\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tE\u0002\u0011\t\u0012)A\u0005)\"A1\r\u0001BK\u0002\u0013\u0005\u0011\r\u0003\u0005e\u0001\tE\t\u0015!\u0003U\u0011!)\u0007A!f\u0001\n\u00032\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B4\t\u0011-\u0004!Q3A\u0005B\u0019D\u0001\u0002\u001c\u0001\u0003\u0012\u0003\u0006Ia\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\u0006[\u0002!\t\u0001\u001e\u0005\to\u0002A)\u0019!C\u0005q\"AA\u0010\u0001EC\u0002\u0013%Q\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u00111\b\u0001\u0005B\u0005u\u0002bBA \u0001\u0011\u0005\u0013\u0011\t\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\ti\u0006\u0001C!\u0003?Bq!a\u0019\u0001\t\u0003\n)\u0007C\u0004\u0002x\u0001!\t%!\u001f\t\r\u0005}\u0004\u0001\"\u0011b\u0011\u0019\t\t\t\u0001C!C\"9\u00111\u0011\u0001\u0005R\u0005\u0015\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003/\u0003A\u0011IAM\u0011\u0019\ti\n\u0001C!{\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBAU\u0001\u0011\u0005\u00131\u0016\u0005\n\u0003{\u0003\u0011\u0011!C\u0001\u0003\u007fC\u0011\"!3\u0001#\u0003%\t!a3\t\u0013\u0005\u0005\b!%A\u0005\u0002\u0005-\u0007\"CAr\u0001E\u0005I\u0011AAs\u0011%\tI\u000fAI\u0001\n\u0003\t)\u000fC\u0005\u0002l\u0002\t\t\u0011\"\u0011\u0002n\"A\u0011Q \u0001\u0002\u0002\u0013\u0005a\rC\u0005\u0002\u0000\u0002\t\t\u0011\"\u0001\u0003\u0002!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005/\u0001\u0011\u0011!C\u0001\u00053A\u0011B!\b\u0001\u0003\u0003%\tEa\b\b\u0013\t\r\u0003'!A\t\u0002\t\u0015c\u0001C\u00181\u0003\u0003E\tAa\u0012\t\r5LC\u0011\u0001B+\u0011%\u00119&KA\u0001\n\u000b\u0012I\u0006C\u0005\u0003\\%\n\t\u0011\"!\u0003^!I!qM\u0015\u0002\u0002\u0013\u0005%\u0011\u000e\u0005\n\u0005wJ\u0013\u0011!C\u0005\u0005{\u0012\u0001\u0003S5ti><'/Y7Ok6,'/[2\u000b\u0005E\u0012\u0014!C1hOJ,w-\u0019;f\u0015\t\u0019D'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001b7\u0003!\u0019\u0017\r^1msN$(BA\u001c9\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003si\nQa\u001d9be.T!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO\u000e\u00011C\u0002\u0001A\u0015:;V\fE\u0002B\u0005\u0012k\u0011\u0001M\u0005\u0003\u0007B\u0012\u0001\u0004V=qK\u0012LU\u000e]3sCRLg/Z!hOJ,w-\u0019;f!\t)\u0005*D\u0001G\u0015\t9e'\u0001\u0003vi&d\u0017BA%G\u0005AqU/\\3sS\u000eD\u0015n\u001d;pOJ\fW\u000e\u0005\u0002L\u00196\t!'\u0003\u0002Ne\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002P%Rk\u0011\u0001\u0015\u0006\u0003#R\nQ\u0001\u001e:fKNL!a\u0015)\u0003\u0015\tKg.\u0019:z\u0019&\\W\r\u0005\u0002L+&\u0011aK\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001-\\\u001b\u0005I&\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK&a\u0002)s_\u0012,8\r\u001e\t\u00031zK!aX-\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003Q\u000baa\u00195jY\u0012\u0004\u0013!\u00028CS:\u001c\u0018A\u00028CS:\u001c\b%\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\u00059\u0007C\u0001-i\u0013\tI\u0017LA\u0002J]R\fq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002)%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003UIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\na\u0001P5oSRtD#B8qcJ\u001c\bCA!\u0001\u0011\u0015\u0001\u0017\u00021\u0001U\u0011\u0015\u0019\u0017\u00021\u0001U\u0011\u0015)\u0017\u00021\u0001h\u0011\u0015Y\u0017\u00021\u0001h)\ryWO\u001e\u0005\u0006A*\u0001\r\u0001\u0016\u0005\u0006G*\u0001\r\u0001V\u0001\u0003]\n,\u0012!\u001f\t\u00031jL!a_-\u0003\u0007\u0005s\u00170\u0001\nqe>\u0004\u0018mZ1uK&s\u0007/\u001e;UsB,W#\u0001@\u0011\u0005a{\u0018bAA\u00013\n9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\u0011\u0011q\u0001\t\u0007\u0003\u0013\tI\"a\b\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003 \u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0016bAA\f3\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u00111aU3r\u0015\r\t9\"\u0017\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u001c\u0002\u000bQL\b/Z:\n\t\u0005%\u00121\u0005\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a\f\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e5\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\u001d\u0003g\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0018GJ,\u0017\r^3BO\u001e\u0014XmZ1uS>t')\u001e4gKJ$\u0012\u0001R\u0001\u0007kB$\u0017\r^3\u0015\u000b\u0011\u000b\u0019%a\u0012\t\r\u0005\u0015\u0003\u00031\u0001E\u0003\u0019\u0011WO\u001a4fe\"9\u0011\u0011\n\tA\u0002\u0005-\u0013\u0001C5oaV$(k\\<\u0011\t\u00055\u0013qJ\u0007\u0002i%\u0019\u0011\u0011\u000b\u001b\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0006\t\u0006]\u0013\u0011\f\u0005\u0007\u0003\u000b\n\u0002\u0019\u0001#\t\r\u0005m\u0013\u00031\u0001E\u0003\u0015yG\u000f[3s\u0003\u0011)g/\u00197\u0015\u0007e\f\t\u0007\u0003\u0004\u0002FI\u0001\r\u0001R\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$B!a\u001a\u0002tA)\u0001,!\u001b\u0002n%\u0019\u00111N-\u0003\u000b\u0005\u0013(/Y=\u0011\u0007a\u000by'C\u0002\u0002re\u0013AAQ=uK\"1\u0011QO\nA\u0002\u0011\u000b1a\u001c2k\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0007\u0011\u000bY\bC\u0004\u0002~Q\u0001\r!a\u001a\u0002\u000b\tLH/Z:\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$Ra\\AD\u0003\u0017Ca!!#\u0018\u0001\u0004!\u0016a\u00028fo2+g\r\u001e\u0005\u0007\u0003\u001b;\u0002\u0019\u0001+\u0002\u00119,wOU5hQR\fQd^5uQ:+w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0004_\u0006M\u0005BBAK1\u0001\u0007q-A\u0005oK^|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2a\\AN\u0011\u0019\t)*\u0007a\u0001O\u0006Aa.\u001e7mC\ndW-\u0001\u0005eCR\fG+\u001f9f+\t\t\u0019\u000b\u0005\u0003\u0002\"\u0005\u0015\u0016\u0002BAT\u0003G\u0011\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,WCAAW!\u0011\ty+a.\u000f\t\u0005E\u00161\u0017\t\u0004\u0003\u001bI\u0016bAA[3\u00061\u0001K]3eK\u001aLA!!/\u0002<\n11\u000b\u001e:j]\u001eT1!!.Z\u0003\u0011\u0019w\u000e]=\u0015\u0013=\f\t-a1\u0002F\u0006\u001d\u0007b\u00021\u001e!\u0003\u0005\r\u0001\u0016\u0005\bGv\u0001\n\u00111\u0001U\u0011\u001d)W\u0004%AA\u0002\u001dDqa[\u000f\u0011\u0002\u0003\u0007q-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055'f\u0001+\u0002P.\u0012\u0011\u0011\u001b\t\u0005\u0003'\fi.\u0004\u0002\u0002V*!\u0011q[Am\u0003%)hn\u00195fG.,GMC\u0002\u0002\\f\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty.!6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001d\u0016\u0004O\u0006=\u0017AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\b\u0003BAy\u0003wl!!a=\u000b\t\u0005U\u0018q_\u0001\u0005Y\u0006twM\u0003\u0002\u0002z\u0006!!.\u0019<b\u0013\u0011\tI,a=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0011Pa\u0001\t\u0011\t\u0015A%!AA\u0002\u001d\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0006!\u0015\u0011iAa\u0005z\u001b\t\u0011yAC\u0002\u0003\u0012e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ba\u0004\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004}\nm\u0001\u0002\u0003B\u0003M\u0005\u0005\t\u0019A=\u0002\r\u0015\fX/\u00197t)\rq(\u0011\u0005\u0005\t\u0005\u000b9\u0013\u0011!a\u0001s\"\u001a\u0002A!\n\u0003,\t5\"\u0011\u0007B\u001a\u0005o\u0011ID!\u0010\u0003@A\u00191Ja\n\n\u0007\t%\"GA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t=\u0012A\"-\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qe2\u0002cNY\u0015![\u0001\u001au.\u001c9vi\u0016\u001c\b%\u0019\u0011iSN$xn\u001a:b[\u0002zg\u000e\t8v[\u0016\u0014\u0018n\u0019\u0011(Kb\u0004(o\n\u0011vg&tw\r\t8cA\tLgn\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004#/\u001a;ve:\u0004c/\u00197vK\u0002J7\u000fI1oA\u0005\u0014(/Y=!_\u001a\u0004\u0003\u0006\u001f\u0017zS\u0001\u0002\u0018-\u001b:tAI,\u0007O]3tK:$\u0018N\\4!i\",\u0007eY3oi\u0016\u00148\u000fI8gAQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005[5ti><'/Y7(g\u0002\u0012\u0017N\\:/A\u0005\u001b\b\u0005\u001e5fAY\fG.^3!_\u001a\u0004sE\u001c2(A%\u001c\b%\u001b8de\u0016\f7/\u001a3-AQDW\r\t5jgR|wM]1nA\u0005\u0004\bO]8yS6\fG/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!O\u0016$8\u000f\t4j]\u0016\u0014Xf\u001a:bS:,G\r\f\u0011ckR\u0004S.Y=!s&,G\u000e\u001a\u0011beRLg-Y2ug\u0002\n'o\\;oI\u0002zW\u000f\u001e7jKJ\u001ch\u0006I%oAA\u0014\u0018m\u0019;jG\u0016d\u0003E\r\u0019.iAR\u0001\u0005\t\u0011!A\u0001B\u0017n\u001d;pOJ\fW\u000e\t2j]N\u0004\u0013\r\u001d9fCJ\u0004Co\u001c\u0011x_J\\\u0007e^3mY2\u0002s/\u001b;iA5|'/\u001a\u0011cS:\u001c\bEY3j]\u001e\u0004#/Z9vSJ,G\r\t4pe\u0002\u001a8.Z<fI\u0002z'O\u0003\u0011!A\u0001\u0002\u0003e]7bY2,'\u000f\t3bi\u0006\u001cX\r^:/A9{G/\u001a\u0011uQ\u0006$\b\u0005\u001e5jg\u00022WO\\2uS>t\u0007e\u0019:fCR,7\u000fI1!Q&\u001cHo\\4sC6\u0004s/\u001b;iA9|g.L;oS\u001a|'/\u001c\u0006!A\u0001\u0002\u0003\u0005\t2j]\u0002:\u0018\u000e\u001a;ig:\u0002\u0013\n\u001e\u0011pM\u001a,'o\u001d\u0011o_\u0002:W/\u0019:b]R,Wm\u001d\u0011j]\u0002\"XM]7tA=4\u0007\u0005\u001e5fA5,\u0017M\\\u0017tcV\f'/\u001a3.KJ\u0014xN\u001d\u0011pM\u0002\"\b.\u001a\u0006!A\u0001\u0002\u0003\u0005\t5jgR|wM]1nY\u0001\u0012W\u000f\u001e\u0011j]\u0002\u0002(/Y2uS\u000e,\u0007%[:!G>l\u0007/\u0019:bE2,\u0007\u0005^8!i\",\u0007\u0005[5ti><'/Y7tAA\u0014x\u000eZ;dK\u0012\u0004#-\u001f\u0011uQ\u0016\u0004#kL*.!2,8O\u0003\u0011!A\u0001\u0002\u0003e\u001d;bi&\u001cH/[2bY\u0002\u001aw.\u001c9vi&tw\r\t9bG.\fw-Z:/A9{G/\u001a\u001e!i\",\u0007e\\;uaV$\b\u0005^=qK\u0002zg\r\t;iK\u0002:\u0003p\n\u0011gS\u0016dG\rI5oAQDW\r\t:fiV\u0014h\u000e\t<bYV,\u0007%[:\u000bA\u0001\u0002\u0003\u0005\t\u0011qe>\u0004\u0018mZ1uK\u0012\u0004cM]8nAQDW\rI5oaV$\bE^1mk\u0016\u00043m\u001c8tk6,G\rI5oAQDW\rI1hOJ,w-\u0019;fA\u0019,hn\u0019;j_:t#\u0002\t\u0011!A\u0005AQ\r_1na2,7/\t\u0002\u00036\u0005\tiE\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003%N\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00151S1\u0002\u0003&M\u0015-A!\u0012\u0014\u0006\f\u0011)cAJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u00023l\u001f\u0012yEi\u0002DFI=#uEr\u0003' \u0017|Ea\u0014#(\r\u0017#s\nR\u0014G\f\u0019~Ym\u0014\u0003P\t\u001e3Y\tJ(EO\u0019/aud3P\t=#uE\u0002DFI=#uEr\u0003'`/\u000bA\u0001\nQa\u001a:pkB\f#Aa\u000f\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B!\u0003\u0015\u0019df\r\u00181\u0003AA\u0015n\u001d;pOJ\fWNT;nKJL7\r\u0005\u0002BSM!\u0011F!\u0013^!%\u0011YE!\u0015U)\u001e<w.\u0004\u0002\u0003N)\u0019!qJ-\u0002\u000fI,h\u000e^5nK&!!1\u000bB'\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0005\u000b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003_\fQ!\u00199qYf$\u0012b\u001cB0\u0005C\u0012\u0019G!\u001a\t\u000b\u0001d\u0003\u0019\u0001+\t\u000b\rd\u0003\u0019\u0001+\t\u000b\u0015d\u0003\u0019A4\t\u000b-d\u0003\u0019A4\u0002\u000fUt\u0017\r\u001d9msR!!1\u000eB<!\u0015A&Q\u000eB9\u0013\r\u0011y'\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fa\u0013\u0019\b\u0016+hO&\u0019!QO-\u0003\rQ+\b\u000f\\35\u0011!\u0011I(LA\u0001\u0002\u0004y\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\b\u0005\u0003\u0002r\n\u0005\u0015\u0002\u0002BB\u0003g\u0014aa\u00142kK\u000e$\b")
public class HistogramNumeric
extends TypedImperativeAggregate<NumericHistogram>
implements ImplicitCastInputTypes,
BinaryLike<Expression>,
scala.Serializable {
    private Object nb;
    private boolean propagateInputType;
    private final Expression child;
    private final Expression nBins;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HistogramNumeric histogramNumeric) {
        return HistogramNumeric$.MODULE$.unapply(histogramNumeric);
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, HistogramNumeric> tupled() {
        return HistogramNumeric$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, HistogramNumeric>>>> curried() {
        return HistogramNumeric$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression nBins() {
        return this.nBins;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private Object nb$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Integer n;
                Object object = this.nBins().eval(this.nBins().eval$default$1());
                if (object == null) {
                    n = null;
                } else if (object instanceof Integer) {
                    int n2 = BoxesRunTime.unboxToInt((Object)object);
                    n = BoxesRunTime.boxToInteger((int)n2);
                } else {
                    throw new MatchError(object);
                }
                this.nb = n;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.nb;
    }

    private Object nb() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.nb$lzycompute() : this.nb;
    }

    private boolean propagateInputType$lzycompute() {
        HistogramNumeric histogramNumeric = this;
        synchronized (histogramNumeric) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.propagateInputType = SQLConf$.MODULE$.get().histogramNumericPropagateInputType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.propagateInputType;
    }

    private boolean propagateInputType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.propagateInputType$lzycompute() : this.propagateInputType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.nBins().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(53).append(this.prettyName()).append(" needs the nBins provided must be a constant literal.").toString()) : (this.nb() == null ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(36).append(this.prettyName()).append(" needs nBins value must not be null.").toString()) : (BoxesRunTime.unboxToInt((Object)this.nb()) < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(49).append(this.prettyName()).append(" needs nBins to be at least 2, but you supplied ").append(this.nb()).append(".").toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NumericHistogram createAggregationBuffer() {
        void var1_1;
        NumericHistogram buffer = new NumericHistogram();
        buffer.allocate(BoxesRunTime.unboxToInt((Object)this.nb()));
        return var1_1;
    }

    @Override
    public NumericHistogram update(NumericHistogram buffer, InternalRow inputRow) {
        block0: {
            Object value = this.child().eval(inputRow);
            if (value == null) break block0;
            double doubleValue = ((Number)value).doubleValue();
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public NumericHistogram merge(NumericHistogram buffer, NumericHistogram other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(NumericHistogram buffer) {
        GenericArrayData genericArrayData;
        if (buffer.getUsedBins() < 1) {
            genericArrayData = null;
        } else {
            scala.collection.immutable.IndexedSeq result = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.getUsedBins()).map((Function1 & Serializable & scala.Serializable)index -> HistogramNumeric.$anonfun$eval$1(this, buffer, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
            genericArrayData = new GenericArrayData((Seq<Object>)result);
        }
        return genericArrayData;
    }

    @Override
    public byte[] serialize(NumericHistogram obj) {
        return NumericHistogramSerializer$.MODULE$.serialize(obj);
    }

    @Override
    public NumericHistogram deserialize(byte[] bytes) {
        return NumericHistogramSerializer$.MODULE$.deserialize(bytes);
    }

    @Override
    public Expression left() {
        return this.child();
    }

    @Override
    public Expression right() {
        return this.nBins();
    }

    @Override
    public HistogramNumeric withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public HistogramNumeric withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HistogramNumeric withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return new ArrayType(new StructType((StructField[])((Object[])new StructField[]{new StructField("x", this.propagateInputType() ? this.left().dataType() : DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("y", DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})), true);
    }

    @Override
    public String prettyName() {
        return "histogram_numeric";
    }

    public HistogramNumeric copy(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HistogramNumeric(child, nBins, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.nBins();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HistogramNumeric";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.nBins();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HistogramNumeric;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HistogramNumeric)) return false;
        boolean bl = true;
        if (!bl) return false;
        HistogramNumeric histogramNumeric = (HistogramNumeric)x$1;
        Expression expression = this.child();
        Expression expression2 = histogramNumeric.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.nBins();
        Expression expression4 = histogramNumeric.nBins();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.mutableAggBufferOffset() != histogramNumeric.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != histogramNumeric.inputAggBufferOffset()) return false;
        if (!histogramNumeric.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ InternalRow $anonfun$eval$1(HistogramNumeric $this, NumericHistogram buffer$1, int index) {
        InternalRow internalRow;
        NumericHistogram.Coord coord = buffer$1.getBin(index);
        if ($this.propagateInputType()) {
            Number number;
            DataType dataType = $this.left().dataType();
            if (ByteType$.MODULE$.equals(dataType)) {
                number = BoxesRunTime.boxToByte((byte)((byte)coord.x));
            } else {
                boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType);
                if (bl) {
                    number = BoxesRunTime.boxToInteger((int)((int)coord.x));
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    number = BoxesRunTime.boxToFloat((float)((float)coord.x));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    number = BoxesRunTime.boxToShort((short)((short)coord.x));
                } else {
                    boolean bl2 = dataType instanceof DayTimeIntervalType ? true : (LongType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)));
                    number = bl2 ? (Number)BoxesRunTime.boxToLong((long)((long)coord.x)) : (Number)BoxesRunTime.boxToDouble((double)coord.x);
                }
            }
            Byte result = number;
            internalRow = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result, BoxesRunTime.boxToDouble((double)coord.y)}));
        } else {
            internalRow = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)coord.x), BoxesRunTime.boxToDouble((double)coord.y)}));
        }
        return internalRow;
    }

    public HistogramNumeric(Expression child, Expression nBins, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.nBins = nBins;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
    }

    public HistogramNumeric(Expression child, Expression nBins) {
        this(child, nBins, 0, 0);
    }
}

