/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003Q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B&\t\u000bM\u0003A\u0011\u0001+\t\u000bM\u0003A\u0011A-\t\u000bq\u0003A\u0011I/\t\u000b\u001d\u0004A\u0011\t5\t\u000bY\u0004A\u0011I<\t\u000by\u0004A\u0011I@\t\r\u0005]\u0001\u0001\"\u0011K\u0011\u0019\tI\u0002\u0001C!\u0015\"1\u00111\u0004\u0001\u0005B)Cq!!\b\u0001\t\u0003\ny\u0002C\u0004\u00022\u0001!\t&a\r\t\u0013\u0005\u0005\u0003!!A\u0005\u0002\u0005\r\u0003\"CA&\u0001E\u0005I\u0011AA'\u0011%\t\u0019\u0007AI\u0001\n\u0003\ti\u0005C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002N!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u000e\u0005\n\u0003s\u0002\u0011\u0011!C\u0001\u0003wB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u0005-\u0005!!A\u0005B\u00055\u0005\"CAN\u0001\u0005\u0005I\u0011AAO\u0011%\t9\u000bAA\u0001\n\u0003\nIkB\u0005\u0002T\u0012\n\t\u0011#\u0001\u0002V\u001aA1\u0005JA\u0001\u0012\u0003\t9\u000e\u0003\u0004T;\u0011\u0005\u0011Q\u001d\u0005\n\u0003Ol\u0012\u0011!C#\u0003SD\u0011\"a;\u001e\u0003\u0003%\t)!<\t\u0013\u0005UX$!A\u0005\u0002\u0006]\b\"\u0003B\u0005;\u0005\u0005I\u0011\u0002B\u0006\u00055\u0019FO]5oOJ+\u0007\u000f\\1dK*\u0011QEJ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002(Q\u0005A1-\u0019;bYf\u001cHO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001eYJ\u0004I\u0012\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\u0019t'\u0003\u00029I\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002;{9\u00111gO\u0005\u0003y\u0011\nq\u0001]1dW\u0006<W-\u0003\u0002?\u007f\tqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001\u001f%!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Q$\n\u0005!\u0013%\u0001D*fe&\fG.\u001b>bE2,\u0017aB:sG\u0016C\bO]\u000b\u0002\u0017B\u00111\u0007T\u0005\u0003\u001b\u0012\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003!\u0019(oY#yaJ\u0004\u0013AC:fCJ\u001c\u0007.\u0012=qe\u0006Y1/Z1sG\",\u0005\u0010\u001d:!\u0003-\u0011X\r\u001d7bG\u0016,\u0005\u0010\u001d:\u0002\u0019I,\u0007\u000f\\1dK\u0016C\bO\u001d\u0011\u0002\rqJg.\u001b;?)\u0011)fk\u0016-\u0011\u0005M\u0002\u0001\"B%\b\u0001\u0004Y\u0005\"B(\b\u0001\u0004Y\u0005\"B)\b\u0001\u0004YEcA+[7\")\u0011\n\u0003a\u0001\u0017\")q\n\u0003a\u0001\u0017\u0006aa.\u001e7m'\u00064W-\u0012<bYR!a,Y2f!\t\tu,\u0003\u0002a\u0005\n\u0019\u0011I\\=\t\u000b\tL\u0001\u0019\u00010\u0002\u000fM\u00148-\u0012<bY\")A-\u0003a\u0001=\u0006Q1/Z1sG\",e/\u00197\t\u000b\u0019L\u0001\u0019\u00010\u0002\u0017I,\u0007\u000f\\1dK\u00163\u0018\r\\\u0001\nI><UM\\\"pI\u0016$2![8u!\tQW.D\u0001l\u0015\taG%A\u0004d_\u0012,w-\u001a8\n\u00059\\'\u0001C#yaJ\u001cu\u000eZ3\t\u000bAT\u0001\u0019A9\u0002\u0007\r$\b\u0010\u0005\u0002ke&\u00111o\u001b\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015)(\u00021\u0001j\u0003\t)g/\u0001\u0005eCR\fG+\u001f9f+\u0005A\bCA=}\u001b\u0005Q(BA>)\u0003\u0015!\u0018\u0010]3t\u0013\ti(P\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u0003\u0001R!a\u0001\u0002\u0012atA!!\u0002\u0002\u00109!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fA\na\u0001\u0010:p_Rt\u0014\"A\"\n\u0005q\u0012\u0015\u0002BA\n\u0003+\u00111aU3r\u0015\ta$)A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u000baJ,G\u000f^=OC6,WCAA\u0011!\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012q\u0005\t\u0004\u0003\u000f\u0011\u0015bAA\u0015\u0005\u00061\u0001K]3eK\u001aLA!!\f\u00020\t11\u000b\u001e:j]\u001eT1!!\u000bC\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004V\u0003k\tI$!\u0010\t\r\u0005]\u0012\u00031\u0001L\u0003!qWm\u001e$jeN$\bBBA\u001e#\u0001\u00071*A\u0005oK^\u001cVmY8oI\"1\u0011qH\tA\u0002-\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004V\u0003\u000b\n9%!\u0013\t\u000f%\u0013\u0002\u0013!a\u0001\u0017\"9qJ\u0005I\u0001\u0002\u0004Y\u0005bB)\u0013!\u0003\u0005\raS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyEK\u0002L\u0003#Z#!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\u0012\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011MA,\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\nA\u0001\\1oO*\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002.\u0005=\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA?!\r\t\u0015qP\u0005\u0004\u0003\u0003\u0013%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00010\u0002\b\"I\u0011\u0011\u0012\r\u0002\u0002\u0003\u0007\u0011QP\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0005#BAI\u0003/sVBAAJ\u0015\r\t)JQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAM\u0003'\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qTAS!\r\t\u0015\u0011U\u0005\u0004\u0003G\u0013%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0013S\u0012\u0011!a\u0001=\u00061Q-];bYN$B!a(\u0002,\"A\u0011\u0011R\u000e\u0002\u0002\u0003\u0007a\fK\f\u0001\u0003_\u000b),a.\u0002<\u0006u\u0016\u0011YAb\u0003\u000f\fI-!4\u0002PB\u00191'!-\n\u0007\u0005MFEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0016!V0G+:\u001bu\fK:ue2\u00023/Z1sG\"\\F\u0006\t:fa2\f7-Z/*A5\u0002#+\u001a9mC\u000e,7\u000fI1mY\u0002z7mY;se\u0016t7-Z:!_\u001a\u0004\u0003m]3be\u000eD\u0007\rI<ji\"\u0004\u0003M]3qY\u0006\u001cW\r\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA`\u0003\tE$\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t'\u0002\t\u0011!A\u0001\u0002#\u0006I:fCJ\u001c\u0007\u000eI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!\u0013\u001a\u0004\u0003m]3be\u000eD\u0007\rI5tA9|G\u000f\t4pk:$\u0007%\u001b8!AN$(\u000f\u0019\u0017!AN$(\u000f\u0019\u0011jg\u0002\u0012X\r^;s]\u0016$\u0007%\u001e8dQ\u0006tw-\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0012X\r\u001d7bG\u0016\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>tg\u0006I%gA\u0001\u0014X\r\u001d7bG\u0016\u0004\u0007%[:!]>$\be\u001d9fG&4\u0017.\u001a3!_J\u0004\u0013n\u001d\u0011b]\u0002*W\u000e\u001d;zAM$(/\u001b8hY\u0001rw\u000e\u001e5j]\u001e\u0004#/\u001a9mC\u000e,7O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQDW\rI:ue&tw\r\t;iCR\u0004\u0013n\u001d\u0011sK6|g/\u001a3!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAc\u00039S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ!C\u0007\u0006\u00147m\n\u0017!O\u0005\u00147m\n\u0017!O\u0011+eiJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u00135\tR#G\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAf\u0003\u0015\u0011df\r\u00181\u0003\u00159'o\\;qC\t\t\t.\u0001\u0007tiJLgnZ0gk:\u001c7/A\u0007TiJLgn\u001a*fa2\f7-\u001a\t\u0003gu\u0019B!HAm\rBA\u00111\\Aq\u0017.[U+\u0004\u0002\u0002^*\u0019\u0011q\u001c\"\u0002\u000fI,h\u000e^5nK&!\u00111]Ao\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003+\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003W\nQ!\u00199qYf$r!VAx\u0003c\f\u0019\u0010C\u0003JA\u0001\u00071\nC\u0003PA\u0001\u00071\nC\u0003RA\u0001\u00071*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e(Q\u0001\t\u0006\u0003\u0006m\u0018q`\u0005\u0004\u0003{\u0014%AB(qi&|g\u000e\u0005\u0004B\u0005\u0003Y5jS\u0005\u0004\u0005\u0007\u0011%A\u0002+va2,7\u0007\u0003\u0005\u0003\b\u0005\n\t\u00111\u0001V\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u000eA!\u0011Q\u000eB\b\u0013\u0011\u0011\t\"a\u001c\u0003\r=\u0013'.Z2u\u0001")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace stringReplace) {
        return StringReplace$.MODULE$.unapply(stringReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(src, search, replace) -> new StringBuilder(16).append(ev.value()).append(" = ").append((String)src).append(".replace(").append((String)search).append(", ").append((String)replace).append(");").toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.srcExpr();
    }

    @Override
    public Expression second() {
        return this.searchExpr();
    }

    @Override
    public Expression third() {
        return this.replaceExpr();
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    @Override
    public StringReplace withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.srcExpr();
                break;
            }
            case 1: {
                expression = this.searchExpr();
                break;
            }
            case 2: {
                expression = this.replaceExpr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

