/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.NoThrow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.0.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0013'\u0001NB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t%\u0002\u0011\t\u0012)A\u0005\r\"A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003V\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015I\u0006\u0001\"\u0001_\u0011!\u0001\u0007\u0001#b\u0001\n\u0003\t\u0007\u0002\u00036\u0001\u0011\u000b\u0007I\u0011A1\t\u000f-\u0004!\u0019!C\u0005Y\"11\u000f\u0001Q\u0001\n5DQ\u0001\u001e\u0001\u0005BQCQ!\u001e\u0001\u0005BYDQ! \u0001\u0005ByD!\"a\u0003\u0001\u0011\u000b\u0007I\u0011IA\u0007\u0011\u0019\t)\u0002\u0001C!)\"Q\u0011q\u0003\u0001\t\u0006\u0004%I!!\u0007\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003S\u0002A\u0011KA6\u0011%\t)\bAA\u0001\n\u0003\t9\bC\u0005\u0002~\u0001\t\n\u0011\"\u0001\u0002\u0000!I\u0011Q\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u00037\u0003\u0011\u0011!C!\u0003;C\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005]\u0006!!A\u0005\u0002\u0005e\u0006\"CA`\u0001\u0005\u0005I\u0011IAa\u0011%\tI\rAA\u0001\n\u0003\tY\rC\u0005\u0002P\u0002\t\t\u0011\"\u0011\u0002R\u001e9\u0011Q\u001f\u0014\t\u0002\u0005]hAB\u0013'\u0011\u0003\tI\u0010\u0003\u0004Z?\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0007yB\u0011\u0001B\u0003\u0011%\u0011\u0019aHA\u0001\n\u0003\u0013I\u0001C\u0005\u0003\u0010}\t\t\u0011\"!\u0003\u0012!I!1E\u0010\u0002\u0002\u0013%!Q\u0005\u0002\n\u0007J,\u0017\r^3NCBT!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S)\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003W1\n1a]9m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0006\u0001QB4(\u0011\t\u0003kYj\u0011AJ\u0005\u0003o\u0019\u0012!\"\u0012=qe\u0016\u001c8/[8o!\t)\u0014(\u0003\u0002;M\t9aj\u001c+ie><\bC\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003y\tK!aQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A\u0012\t\u0004\u000f>#dB\u0001%N\u001d\tIE*D\u0001K\u0015\tY%'\u0001\u0004=e>|GOP\u0005\u0002}%\u0011a*P\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u001f\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013AF;tKN#(/\u001b8h)f\u0004Xm\u00165f]\u0016k\u0007\u000f^=\u0016\u0003U\u0003\"\u0001\u0010,\n\u0005]k$a\u0002\"p_2,\u0017M\\\u0001\u0018kN,7\u000b\u001e:j]\u001e$\u0016\u0010]3XQ\u0016tW)\u001c9us\u0002\na\u0001P5oSRtDcA.];B\u0011Q\u0007\u0001\u0005\u0006\t\u0016\u0001\rA\u0012\u0005\u0006'\u0016\u0001\r!\u0016\u000b\u00037~CQ\u0001\u0012\u0004A\u0002\u0019\u000bAa[3zgV\t!\rE\u0002dQRj\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001dl\u0014AC2pY2,7\r^5p]&\u0011\u0011\u000e\u001a\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018A\u0002<bYV,7/\u0001\neK\u001a\fW\u000f\u001c;FY\u0016lWM\u001c;UsB,W#A7\u0011\u00059\fX\"A8\u000b\u0005AT\u0013!\u0002;za\u0016\u001c\u0018B\u0001:p\u0005!!\u0015\r^1UsB,\u0017a\u00053fM\u0006,H\u000e^#mK6,g\u000e\u001e+za\u0016\u0004\u0013\u0001\u00034pY\u0012\f'\r\\3\u0002\u0015M$(/\u001b8h\u0003J<7/F\u0001x!\r9\u0005P_\u0005\u0003sF\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0003ymL!\u0001`\u001f\u0003\u0007\u0005s\u00170A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003Q\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\n\u0005\r!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0004\u0011\u00079\f\t\"C\u0002\u0002\u0014=\u0014q!T1q)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u0003)i\u0017\r\u001d\"vS2$WM]\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003CA\u0013\u0001B;uS2LA!!\n\u0002 \t!\u0012I\u001d:bs\n\u000b7/\u001a3NCB\u0014U/\u001b7eKJ\fA!\u001a<bYR\u0019!0a\u000b\t\u0013\u00055\u0012\u0003%AA\u0002\u0005=\u0012!B5oaV$\b\u0003BA\u0019\u0003gi\u0011\u0001K\u0005\u0004\u0003kA#aC%oi\u0016\u0014h.\u00197S_^\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005m\u0012qIA)!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!M\u000591m\u001c3fO\u0016t\u0017\u0002BA#\u0003\u007f\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u0013\u0012\u0002\u0019AA&\u0003\r\u0019G\u000f\u001f\t\u0005\u0003{\ti%\u0003\u0003\u0002P\u0005}\"AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003'\u0012\u0002\u0019AA\u001e\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0017\u0011\t\u0005m\u00131\r\b\u0005\u0003;\ny\u0006\u0005\u0002J{%\u0019\u0011\u0011M\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\t)'a\u001a\u0003\rM#(/\u001b8h\u0015\r\t\t'P\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2aWA7\u0011\u001d\ty\u0007\u0006a\u0001\u0003c\n1B\\3x\u0007\"LG\u000e\u001a:f]B!q)a\u001d5\u0013\tI\u0017+\u0001\u0003d_BLH#B.\u0002z\u0005m\u0004b\u0002#\u0016!\u0003\u0005\rA\u0012\u0005\b'V\u0001\n\u00111\u0001V\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!!+\u0007\u0019\u000b\u0019i\u000b\u0002\u0002\u0006B!\u0011qQAI\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015!C;oG\",7m[3e\u0015\r\ty)P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAJ\u0003\u0013\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!'+\u0007U\u000b\u0019)A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\u0003B!!)\u0002,6\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0003mC:<'BAAU\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00141U\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00032\u0001PAZ\u0013\r\t),\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004u\u0006m\u0006\"CA_5\u0005\u0005\t\u0019AAY\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0019\t\u0006\u0003\u000b\f9M_\u0007\u0002M&\u0011\u0011PZ\u0001\tG\u0006tW)];bYR\u0019Q+!4\t\u0011\u0005uF$!AA\u0002i\fa!Z9vC2\u001cHcA+\u0002T\"A\u0011QX\u000f\u0002\u0002\u0003\u0007!\u0010K\n\u0001\u0003/\fi.a8\u0002d\u0006\u0015\u0018\u0011^Av\u0003_\f\t\u0010E\u00026\u00033L1!a7'\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!9\u0002/~3UKT\"`Q-,\u0017\u0010\r\u0017!m\u0006dW/\u001a\u0019-A-,\u00170\r\u0017!m\u0006dW/Z\u0019-A9rc&\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA]LG\u000f\u001b\u0011uQ\u0016\u0004s-\u001b<f]\u0002ZW-_\u0018wC2,X\r\t9bSJ\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9/A+\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QEr\u0003\u0007\f\u0011(e\u001db\u0003e\r\u00181Y\u0001:CgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\fd\u0006\r\u001e#e\tb3G\f\u0019;EQ\u0012SP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti/A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002t\u0006IQ.\u00199`MVt7m]\u0001\n\u0007J,\u0017\r^3NCB\u0004\"!N\u0010\u0014\t}\tY0\u0011\t\u0004y\u0005u\u0018bAA\u0000{\t1\u0011I\\=SK\u001a$\"!a>\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007m\u00139\u0001C\u0003EC\u0001\u0007a\tF\u0003\\\u0005\u0017\u0011i\u0001C\u0003EE\u0001\u0007a\tC\u0003TE\u0001\u0007Q+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM!q\u0004\t\u0006y\tU!\u0011D\u0005\u0004\u0005/i$AB(qi&|g\u000eE\u0003=\u000571U+C\u0002\u0003\u001eu\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u0011G\u0005\u0005\t\u0019A.\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0014!\u0011\t\tK!\u000b\n\t\t-\u00121\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class CreateMap
extends Expression
implements NoThrow,
scala.Serializable {
    private scala.collection.immutable.IndexedSeq<Expression> keys;
    private scala.collection.immutable.IndexedSeq<Expression> values;
    private MapType dataType;
    private ArrayBasedMapBuilder mapBuilder;
    private final Seq<Expression> children;
    private final boolean useStringTypeWhenEmpty;
    private final DataType defaultElementType;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CreateMap createMap) {
        return CreateMap$.MODULE$.unapply(createMap);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean useStringTypeWhenEmpty() {
        return this.useStringTypeWhenEmpty;
    }

    private scala.collection.immutable.IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (scala.collection.immutable.IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 % 2 == 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public scala.collection.immutable.IndexedSeq<Expression> keys() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.keys$lzycompute() : this.keys;
    }

    private scala.collection.immutable.IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (scala.collection.immutable.IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 % 2 != 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public scala.collection.immutable.IndexedSeq<Expression> values() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.values$lzycompute() : this.values;
    }

    private DataType defaultElementType() {
        return this.defaultElementType;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.foldable()));
    }

    @Override
    public Iterator<Object> stringArgs() {
        return super.stringArgs().take(1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() % 2 != 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append(this.prettyName()).append(" expects a positive even number of arguments.").toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(73).append("The given keys of function map should all be the same type, but they are ").append(((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The given values of function map should all be the same type, but they are ").append(((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : TypeUtils$.MODULE$.checkForMapKeyType(this.dataType().keyType())));
    }

    private MapType dataType$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dataType = new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultElementType()), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultElementType()), this.values().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.nullable())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dataType;
    }

    @Override
    public MapType dataType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object eval(InternalRow input) {
        for (int i = 0; i < this.keys().length(); ++i) {
            this.mapBuilder().put(((Expression)this.keys().apply(i)).eval(input), ((Expression)this.values().apply(i)).eval(input));
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        MapType mapType = this.dataType();
        if (mapType == null) {
            throw new MatchError((Object)mapType);
        }
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        Tuple2 tuple22 = tuple2;
        DataType keyDt2 = (DataType)tuple22._1();
        DataType valueDt2 = (DataType)tuple22._2();
        Tuple3<String, String, String> tuple3 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<Expression>)this.keys(), "createMap");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String allocationKeyData = (String)tuple3._1();
        String assignKeys = (String)tuple3._2();
        String keyArrayData = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)allocationKeyData, (Object)assignKeys, (Object)keyArrayData);
        Tuple3 tuple33 = tuple32;
        String allocationKeyData2 = (String)tuple33._1();
        String assignKeys2 = (String)tuple33._2();
        String keyArrayData2 = (String)tuple33._3();
        Tuple3<String, String, String> tuple34 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<Expression>)this.values(), "createMap");
        if (tuple34 == null) {
            throw new MatchError(tuple34);
        }
        String allocationValueData = (String)tuple34._1();
        String assignValues = (String)tuple34._2();
        String valueArrayData = (String)tuple34._3();
        Tuple3 tuple35 = new Tuple3((Object)allocationValueData, (Object)assignValues, (Object)valueArrayData);
        Tuple3 tuple36 = tuple35;
        String allocationValueData2 = (String)tuple36._1();
        String assignValues2 = (String)tuple36._2();
        String valueArrayData2 = (String)tuple36._3();
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = ", ".from(", ", ", ");\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allocationKeyData2, assignKeys2, allocationValueData2, assignValues2, ev.value(), builderTerm, keyArrayData2, valueArrayData2}));
        return ev.copy(code, FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    @Override
    public CreateMap withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public CreateMap copy(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        return new CreateMap(children2, useStringTypeWhenEmpty);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.useStringTypeWhenEmpty();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.useStringTypeWhenEmpty());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.useStringTypeWhenEmpty() != createMap.useStringTypeWhenEmpty()) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        this.children = children2;
        this.useStringTypeWhenEmpty = useStringTypeWhenEmpty;
        this.defaultElementType = useStringTypeWhenEmpty ? StringType$.MODULE$ : NullType$.MODULE$;
    }

    public CreateMap(Seq<Expression> children2) {
        this(children2, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_CREATE_EMPTY_COLLECTION_USING_STRING_TYPE())));
    }
}

