/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.MaxMinBy;
import org.apache.spark.sql.catalyst.expressions.aggregate.MinBy$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(x, y) - Returns the value of `x` associated with the minimum value of `y`.", examples="\n    Examples:\n      > SELECT _FUNC_(x, y) FROM VALUES (('a', 10)), (('b', 50)), (('c', 20)) AS tab(x, y);\n       a\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\u000e\u001c\u0001*B\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\t}\u0001\u0011\t\u0012)A\u0005u!Aq\b\u0001BK\u0002\u0013\u0005\u0011\b\u0003\u0005A\u0001\tE\t\u0015!\u0003;\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u00151\u0005\u0001\"\u0011H\u0011\u0015\u0019\u0006\u0001\"\u0015U\u0011\u0015I\u0006\u0001\"\u0015[\u0011\u0015i\u0006\u0001\"\u0015_\u0011\u001d\u0019\u0007!!A\u0005\u0002\u0011Dqa\u001a\u0001\u0012\u0002\u0013\u0005\u0001\u000eC\u0004t\u0001E\u0005I\u0011\u00015\t\u000fQ\u0004\u0011\u0011!C!k\"9Q\u0010AA\u0001\n\u0003q\b\"CA\u0003\u0001\u0005\u0005I\u0011AA\u0004\u0011%\t\u0019\u0002AA\u0001\n\u0003\n)\u0002C\u0005\u0002$\u0001\t\t\u0011\"\u0001\u0002&!I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0013\u0011G\u0004\n\u0003+Z\u0012\u0011!E\u0001\u0003/2\u0001BG\u000e\u0002\u0002#\u0005\u0011\u0011\f\u0005\u0007\u0003R!\t!a\u001a\t\u0013\u0005%D#!A\u0005F\u0005-\u0004\"CA7)\u0005\u0005I\u0011QA8\u0011%\t)\bFA\u0001\n\u0003\u000b9\bC\u0005\u0002\nR\t\t\u0011\"\u0003\u0002\f\n)Q*\u001b8Cs*\u0011A$H\u0001\nC\u001e<'/Z4bi\u0016T!AH\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003A\u0005\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003E\r\n1a]9m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0005\u0001-zS\u0007\u0005\u0002-[5\t1$\u0003\u0002/7\tAQ*\u0019=NS:\u0014\u0015\u0010\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0004Qe>$Wo\u0019;\u0011\u0005A2\u0014BA\u001c2\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003%1\u0018\r\\;f\u000bb\u0004(/F\u0001;!\tYD(D\u0001\u001e\u0013\tiTD\u0001\u0006FqB\u0014Xm]:j_:\f!B^1mk\u0016,\u0005\u0010\u001d:!\u00031y'\u000fZ3sS:<W\t\u001f9s\u00035y'\u000fZ3sS:<W\t\u001f9sA\u00051A(\u001b8jiz\"2a\u0011#F!\ta\u0003\u0001C\u00039\u000b\u0001\u0007!\bC\u0003@\u000b\u0001\u0007!(\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001\u0013\t\u0003\u0013Bs!A\u0013(\u0011\u0005-\u000bT\"\u0001'\u000b\u00055K\u0013A\u0002\u001fs_>$h(\u0003\u0002Pc\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\ty\u0015'A\u0005qe\u0016$\u0017nY1uKR\u0019!(V,\t\u000bY;\u0001\u0019\u0001\u001e\u0002\u000f=dG-\u0012=qe\")\u0001l\u0002a\u0001u\u00059a.Z<FqB\u0014\u0018aD8sI\u0016\u0014\u0018N\\4Va\u0012\fG/\u001a:\u0015\u0007iZF\fC\u0003W\u0011\u0001\u0007!\bC\u0003Y\u0011\u0001\u0007!(A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00191iX1\t\u000b\u0001L\u0001\u0019\u0001\u001e\u0002\u000f9,w\u000fT3gi\")!-\u0003a\u0001u\u0005Aa.Z<SS\u001eDG/\u0001\u0003d_BLHcA\"fM\"9\u0001H\u0003I\u0001\u0002\u0004Q\u0004bB \u000b!\u0003\u0005\rAO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005I'F\u0001\u001ekW\u0005Y\u0007C\u00017r\u001b\u0005i'B\u00018p\u0003%)hn\u00195fG.,GM\u0003\u0002qc\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Il'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001w!\t9H0D\u0001y\u0015\tI(0\u0001\u0003mC:<'\"A>\u0002\t)\fg/Y\u0005\u0003#b\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a \t\u0004a\u0005\u0005\u0011bAA\u0002c\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011BA\b!\r\u0001\u00141B\u0005\u0004\u0003\u001b\t$aA!os\"A\u0011\u0011C\b\u0002\u0002\u0003\u0007q0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003/\u0001b!!\u0007\u0002 \u0005%QBAA\u000e\u0015\r\ti\"M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0011\u00037\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qEA\u0017!\r\u0001\u0014\u0011F\u0005\u0004\u0003W\t$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003#\t\u0012\u0011!a\u0001\u0003\u0013\ta!Z9vC2\u001cH\u0003BA\u0014\u0003gA\u0011\"!\u0005\u0013\u0003\u0003\u0005\r!!\u0003)'\u0001\t9$!\u0010\u0002@\u0005\r\u0013QIA%\u0003\u0017\ny%!\u0015\u0011\u0007m\nI$C\u0002\u0002<u\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002B\u0005\tvLR+O\u0007~C\u0003\u0010\f\u0011zS\u0001j\u0003EU3ukJt7\u000f\t;iK\u00022\u0018\r\\;fA=4\u0007\u0005\u0019=aA\u0005\u001c8o\\2jCR,G\rI<ji\"\u0004C\u000f[3![&t\u0017.\\;nAY\fG.^3!_\u001a\u0004\u0003-\u001f1/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA$\u0003YT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\u001f\u0017!s&\u0002cIU(NAY\u000bE*V#TA!Bs%Y\u0014-AE\u0002\u0014&\u000b\u0017!Q!:#m\n\u0017!kAJ\u0013\u0006\f\u0011)Q\u001d\u001aw\u0005\f\u00113a%J\u0003%Q*!i\u0006\u0014\u0007\u0006\u001f\u0017!s&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u0019\u0006!A\u0005)qM]8va\u0006\u0012\u0011QJ\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#!a\u0015\u0002\u000bMr\u0003G\f\u0019\u0002\u000b5KgNQ=\u0011\u00051\"2\u0003\u0002\u000b\u0002\\U\u0002r!!\u0018\u0002diR4)\u0004\u0002\u0002`)\u0019\u0011\u0011M\u0019\u0002\u000fI,h\u000e^5nK&!\u0011QMA0\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003/\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002m\u0006)\u0011\r\u001d9msR)1)!\u001d\u0002t!)\u0001h\u0006a\u0001u!)qh\u0006a\u0001u\u00059QO\\1qa2LH\u0003BA=\u0003\u000b\u0003R\u0001MA>\u0003\u007fJ1!! 2\u0005\u0019y\u0005\u000f^5p]B)\u0001'!!;u%\u0019\u00111Q\u0019\u0003\rQ+\b\u000f\\33\u0011!\t9\tGA\u0001\u0002\u0004\u0019\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\tE\u0002x\u0003\u001fK1!!%y\u0005\u0019y%M[3di\u0002")
public class MinBy
extends MaxMinBy {
    private final Expression valueExpr;
    private final Expression orderingExpr;

    public static Option<Tuple2<Expression, Expression>> unapply(MinBy minBy) {
        return MinBy$.MODULE$.unapply(minBy);
    }

    public static Function1<Tuple2<Expression, Expression>, MinBy> tupled() {
        return MinBy$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, MinBy>> curried() {
        return MinBy$.MODULE$.curried();
    }

    @Override
    public Expression valueExpr() {
        return this.valueExpr;
    }

    @Override
    public Expression orderingExpr() {
        return this.orderingExpr;
    }

    @Override
    public String prettyName() {
        return "min_by";
    }

    @Override
    public Expression predicate(Expression oldExpr, Expression newExpr) {
        return (Expression)((Object)package$expressions$.MODULE$.DslExpression(oldExpr).$less(newExpr));
    }

    @Override
    public Expression orderingUpdater(Expression oldExpr, Expression newExpr) {
        return package$expressions$.MODULE$.least((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{oldExpr, newExpr}));
    }

    @Override
    public MinBy withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public MinBy copy(Expression valueExpr, Expression orderingExpr) {
        return new MinBy(valueExpr, orderingExpr);
    }

    public Expression copy$default$1() {
        return this.valueExpr();
    }

    public Expression copy$default$2() {
        return this.orderingExpr();
    }

    @Override
    public String productPrefix() {
        return "MinBy";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.valueExpr();
            }
            case 1: {
                return this.orderingExpr();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MinBy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MinBy)) return false;
        boolean bl = true;
        if (!bl) return false;
        MinBy minBy = (MinBy)x$1;
        Expression expression = this.valueExpr();
        Expression expression2 = minBy.valueExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.orderingExpr();
        Expression expression4 = minBy.orderingExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!minBy.canEqual(this)) return false;
        return true;
    }

    public MinBy(Expression valueExpr, Expression orderingExpr) {
        this.valueExpr = valueExpr;
        this.orderingExpr = orderingExpr;
    }
}

