/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayBasedSimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.SimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr, func) - Sorts the input array. If func is omitted, sort\n    in ascending order. The elements of the input array must be orderable.\n    NaN is greater than any non-NaN elements for double/float type.\n    Null elements will be placed at the end of the returned array.\n    Since 3.0.0 this function also sorts and returns the array based on the\n    given comparator function. The comparator will take two arguments representing\n    two elements of the array.\n    It returns a negative integer, 0, or a positive integer as the first element is less than,\n    equal to, or greater than the second element. If the comparator function returns null,\n    the function will fail and raise an error.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(5, 6, 1), (left, right) -> case when left < right then -1 when left > right then 1 else 0 end);\n       [1,5,6]\n      > SELECT _FUNC_(array('bc', 'ab', 'dc'), (left, right) -> case when left is null and right is null then 0 when left is null then -1 when right is null then 1 when left < right then 1 when left > right then -1 else 0 end);\n       [\"dc\",\"bc\",\"ab\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0015+\u0001^B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005q!A\u0011\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005S\u0001\tE\t\u0015!\u00039\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B+\t\u000be\u0003A\u0011\u0001.\t\u000be\u0003A\u0011A0\t\u000be\u0003A\u0011\u00012\t\u0011\u0011\u0004\u0001R1A\u0005\u0002\u0015DQ\u0001\u001d\u0001\u0005BEDQ!\u001e\u0001\u0005BYDQ! \u0001\u0005RyDA\"!\f\u0001!\u0003E9\u0019)C\u0005\u0003_A!\"!\u000f\u0001\u0011\u000b\u0007I\u0011AA\u001e\u0011)\ty\u0004\u0001EC\u0002\u0013\u0005\u00111\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\b\u0002!\t&!#\t\u0013\u0005M\u0005!!A\u0005\u0002\u0005U\u0005\"CAO\u0001E\u0005I\u0011AAP\u0011%\t)\fAI\u0001\n\u0003\ty\nC\u0005\u00028\u0002\t\n\u0011\"\u0001\u0002:\"I\u0011Q\u0018\u0001\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\n\u0003\u0017\u0004\u0011\u0011!C\u0001\u0003\u001bD\u0011\"!6\u0001\u0003\u0003%\t!a6\t\u0013\u0005u\u0007!!A\u0005B\u0005}\u0007\"CAw\u0001\u0005\u0005I\u0011AAx\u0011%\t\u0019\u0010AA\u0001\n\u0003\n)pB\u0004\u0003\u001a)B\tAa\u0007\u0007\r%R\u0003\u0012\u0001B\u000f\u0011\u0019I\u0006\u0005\"\u0001\u0003&!9!q\u0005\u0011\u0005\u0002\t%\u0002bBA\"A\u0011\u0005!q\u0006\u0005\n\u0005s\u0001#\u0019!C\u0001\u0005wA\u0001B!\u0010!A\u0003%\u0011q\u0005\u0005\n\u0005O\u0001\u0013\u0011!CA\u0005\u007fA\u0011Ba\u0012!\u0003\u0003%\tI!\u0013\t\u0013\tm\u0003%!A\u0005\n\tu#!C!se\u0006L8k\u001c:u\u0015\tYC&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0017/\u0003!\u0019\u0017\r^1msN$(BA\u00181\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003cI\nQa\u001d9be.T!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sO\u000e\u00011C\u0002\u00019y}*5\n\u0005\u0002:u5\t!&\u0003\u0002<U\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ej\u0014B\u0001 +\u0005\r\n%O]1z\u0005\u0006\u001cX\rZ*j[BdW\rS5hQ\u0016\u0014xJ\u001d3fe\u001a+hn\u0019;j_:\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0016\u0002\u000f\r|G-Z4f]&\u0011A)\u0011\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n9\u0001K]8ek\u000e$\bC\u0001$M\u0013\tiuI\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005be\u001e,X.\u001a8u+\u0005A\u0014!C1sOVlWM\u001c;!\u0003!1WO\\2uS>t\u0017!\u00034v]\u000e$\u0018n\u001c8!\u0003e\tG\u000e\\8x\u001dVdGnQ8na\u0006\u0014\u0018n]8o%\u0016\u001cX\u000f\u001c;\u0016\u0003U\u0003\"A\u0012,\n\u0005];%a\u0002\"p_2,\u0017M\\\u0001\u001bC2dwn\u001e(vY2\u001cu.\u001c9be&\u001cxN\u001c*fgVdG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmcVL\u0018\t\u0003s\u0001AQAT\u0004A\u0002aBQ!U\u0004A\u0002aBQaU\u0004A\u0002U#2a\u00171b\u0011\u0015q\u0005\u00021\u00019\u0011\u0015\t\u0006\u00021\u00019)\tY6\rC\u0003O\u0013\u0001\u0007\u0001(A\u0006fY\u0016lWM\u001c;UsB,W#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%t\u0013!\u0002;za\u0016\u001c\u0018BA6i\u0005!!\u0015\r^1UsB,\u0007F\u0001\u0006n!\t1e.\u0003\u0002p\u000f\nIAO]1og&,g\u000e^\u0001\tI\u0006$\u0018\rV=qKV\t!\u000f\u0005\u0002hg&\u0011A\u000f\u001b\u0002\n\u0003J\u0014\u0018-\u001f+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u2\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003yf\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\rE&tG-\u00138uKJt\u0017\r\u001c\u000b\u00037~Dq!!\u0001\u000e\u0001\u0004\t\u0019!A\u0001g!!1\u0015Q\u0001\u001d\u0002\n\u0005\u001d\u0012bAA\u0004\u000f\nIa)\u001e8di&|gN\r\t\u0007\u0003\u0017\tY\"!\t\u000f\t\u00055\u0011q\u0003\b\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015bAA\r\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000f\u0003?\u00111aU3r\u0015\r\tIb\u0012\t\u0006\r\u0006\rb-V\u0005\u0004\u0003K9%A\u0002+va2,'\u0007E\u0002:\u0003SI1!a\u000b+\u00059a\u0015-\u001c2eC\u001a+hn\u0019;j_:\fA\u0001\u001f\u00133cU\u0011\u0011\u0011\u0007\t\b\r\u0006\r\u00121GA\u001a!\rI\u0014QG\u0005\u0004\u0003oQ#a\u0005(b[\u0016$G*Y7cI\u00064\u0016M]5bE2,\u0017\u0001\u00044jeN$X\t\\3n-\u0006\u0014XCAA\u001aQ\tyQ.A\u0007tK\u000e|g\u000eZ#mK64\u0016M\u001d\u0015\u0003!5\f!bY8na\u0006\u0014\u0018\r^8s)\u0011\t9%!\u0018\u0011\r\u0005%\u00131KA,\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013\u0001B;uS2T!!!\u0015\u0002\t)\fg/Y\u0005\u0005\u0003+\nYE\u0001\u0006D_6\u0004\u0018M]1u_J\u00042ARA-\u0013\r\tYf\u0012\u0002\u0004\u0003:L\bbBA0#\u0001\u0007\u0011\u0011M\u0001\tS:\u0004X\u000f\u001e*poB!\u00111MA3\u001b\u0005a\u0013bAA4Y\tY\u0011J\u001c;fe:\fGNU8x\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\t9&!\u001c\u0002p!9\u0011q\f\nA\u0002\u0005\u0005\u0004bBA9%\u0001\u0007\u0011qK\u0001\u000eCJ<W/\\3oiZ\u000bG.^3\u0002\u00119|G-\u001a(b[\u0016,\"!a\u001e\u0011\t\u0005e\u0014\u0011\u0011\b\u0005\u0003w\ni\bE\u0002\u0002\u0010\u001dK1!a H\u0003\u0019\u0001&/\u001a3fM&!\u00111QAC\u0005\u0019\u0019FO]5oO*\u0019\u0011qP$\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#B.\u0002\f\u0006=\u0005BBAG)\u0001\u0007\u0001(A\u0004oK^dUM\u001a;\t\r\u0005EE\u00031\u00019\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$raWAL\u00033\u000bY\nC\u0004O+A\u0005\t\u0019\u0001\u001d\t\u000fE+\u0002\u0013!a\u0001q!91+\u0006I\u0001\u0002\u0004)\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CS3\u0001OARW\t\t)\u000b\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\u0013Ut7\r[3dW\u0016$'bAAX\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0016\u0011\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYLK\u0002V\u0003G\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAa!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u001f\nA\u0001\\1oO&!\u00111QAc\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\rE\u0002G\u0003#L1!a5H\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9&!7\t\u0013\u0005m7$!AA\u0002\u0005=\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002bB1\u00111]Au\u0003/j!!!:\u000b\u0007\u0005\u001dx)\u0001\u0006d_2dWm\u0019;j_:LA!a;\u0002f\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r)\u0016\u0011\u001f\u0005\n\u00037l\u0012\u0011!a\u0001\u0003/\na!Z9vC2\u001cHcA+\u0002x\"I\u00111\u001c\u0010\u0002\u0002\u0003\u0007\u0011q\u000b\u0015\u0014\u0001\u0005m(\u0011\u0001B\u0002\u0005\u000f\u0011IA!\u0004\u0003\u0010\tM!Q\u0003\t\u0004s\u0005u\u0018bAA\u0000U\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0003\u0003\u0015\u0015uLR+O\u0007~CS\r\u001f9sY\u00012WO\\2*A5\u00023k\u001c:ug\u0002\"\b.\u001a\u0011j]B,H\u000fI1se\u0006Lh\u0006I%gA\u0019,hn\u0019\u0011jg\u0002zW.\u001b;uK\u0012d\u0003e]8si*\u0001\u0003\u0005\t\u0011j]\u0002\n7oY3oI&tw\rI8sI\u0016\u0014h\u0006\t+iK\u0002*G.Z7f]R\u001c\be\u001c4!i\",\u0007%\u001b8qkR\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0018\u000bA\u0001\u0002\u0003ET1OA%\u001c\be\u001a:fCR,'\u000f\t;iC:\u0004\u0013M\\=!]>tWFT1OA\u0015dW-\\3oiN\u0004cm\u001c:!I>,(\r\\30M2|\u0017\r\u001e\u0011usB,gF\u0003\u0011!A\u0001rU\u000f\u001c7!K2,W.\u001a8ug\u0002:\u0018\u000e\u001c7!E\u0016\u0004\u0003\u000f\\1dK\u0012\u0004\u0013\r\u001e\u0011uQ\u0016\u0004SM\u001c3!_\u001a\u0004C\u000f[3!e\u0016$XO\u001d8fI\u0002\n'O]1z])\u0001\u0003\u0005\t\u0011TS:\u001cW\rI\u001a/a9\u0002\u0004\u0005\u001e5jg\u00022WO\\2uS>t\u0007%\u00197t_\u0002\u001axN\u001d;tA\u0005tG\r\t:fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013M\u001d:bs\u0002\u0012\u0017m]3eA=t\u0007\u0005\u001e5f\u0015\u0001\u0002\u0003\u0005I4jm\u0016t\u0007eY8na\u0006\u0014\u0018\r^8sA\u0019,hn\u0019;j_:t\u0003\u0005\u00165fA\r|W\u000e]1sCR|'\u000fI<jY2\u0004C/Y6fAQ<x\u000eI1sOVlWM\u001c;tAI,\u0007O]3tK:$\u0018N\\4\u000bA\u0001\u0002\u0003\u0005^<pA\u0015dW-\\3oiN\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M\u001d:bs:R\u0001\u0005\t\u0011!\u0013R\u0004#/\u001a;ve:\u001c\b%\u0019\u0011oK\u001e\fG/\u001b<fA%tG/Z4fe2\u0002\u0003\u0007\f\u0011pe\u0002\n\u0007\u0005]8tSRLg/\u001a\u0011j]R,w-\u001a:!CN\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011fY\u0016lWM\u001c;!SN\u0004C.Z:tAQD\u0017M\u001c\u0017\u000bA\u0001\u0002\u0003%Z9vC2\u0004Co\u001c\u0017!_J\u0004sM]3bi\u0016\u0014\b\u0005\u001e5b]\u0002\"\b.\u001a\u0011tK\u000e|g\u000e\u001a\u0011fY\u0016lWM\u001c;/A%3\u0007\u0005\u001e5fA\r|W\u000e]1sCR|'\u000f\t4v]\u000e$\u0018n\u001c8!e\u0016$XO\u001d8tA9,H\u000e\u001c\u0017\u000bA\u0001\u0002\u0003\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004s/\u001b7mA\u0019\f\u0017\u000e\u001c\u0011b]\u0012\u0004#/Y5tK\u0002\ng\u000eI3se>\u0014hF\u0003\u0011!A\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0017\t1Q\u001c\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00156Y\u00012D\u0006I\u0019*Y\u0001BC.\u001a4uY\u0001\u0012\u0018n\u001a5uS\u0001jc\bI2bg\u0016\u0004s\u000f[3oA1,g\r\u001e\u0011=AILw\r\u001b;!i\",g\u000eI\u00172A]DWM\u001c\u0011mK\u001a$\bE\u0010\u0011sS\u001eDG\u000f\t;iK:\u0004\u0013\u0007I3mg\u0016\u0004\u0003\u0007I3oI&Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-k12TL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014cG\u001eb\u0003eJ1cO1\u0002s\u0005Z2(S1\u0002\u0003\u0006\\3gi2\u0002#/[4ii&\u0002SF\u0010\u0011dCN,\u0007e\u001e5f]\u0002bWM\u001a;!SN\u0004c.\u001e7mA\u0005tG\r\t:jO\"$\b%[:!]VdG\u000e\t;iK:\u0004\u0003\u0007I<iK:\u0004C.\u001a4uA%\u001c\bE\\;mY\u0002\"\b.\u001a8![E\u0002s\u000f[3oAILw\r\u001b;!SN\u0004c.\u001e7mAQDWM\u001c\u00112A]DWM\u001c\u0011mK\u001a$\b\u0005\u0010\u0011sS\u001eDG\u000f\t;iK:\u0004\u0013\u0007I<iK:\u0004C.\u001a4uAy\u0002#/[4ii\u0002\"\b.\u001a8![E\u0002S\r\\:fAA\u0002SM\u001c3*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&\u0005Z2#Y\t\u00127M\t\u0017#C\n\u0014SL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0014cO1\u0002s\u0005Z\u0014-A9,H\u000e\u001c\u0017!O\r<C\u0006I\u0014bO%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.#C\nb#E\u0019\u0012-E\r\u0014CF\t3#Y9,H\u000e\\/\u000bA\u0001\nQa]5oG\u0016\f#A!\u0005\u0002\u000bIrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t]\u0011\u0001\u00047b[\n$\u0017m\u00184v]\u000e\u001c\u0018!C!se\u0006L8k\u001c:u!\tI\u0004e\u0005\u0003!\u0005?Y\u0005c\u0001$\u0003\"%\u0019!1E$\u0003\r\u0005s\u0017PU3g)\t\u0011Y\"A\u0003baBd\u0017\u0010F\u0003\\\u0005W\u0011i\u0003C\u0003OE\u0001\u0007\u0001\bC\u0003RE\u0001\u0007\u0001\bF\u00039\u0005c\u0011)\u0004\u0003\u0004\u00034\r\u0002\r\u0001O\u0001\u0005Y\u00164G\u000f\u0003\u0004\u00038\r\u0002\r\u0001O\u0001\u0006e&<\u0007\u000e^\u0001\u0012I\u00164\u0017-\u001e7u\u0007>l\u0007/\u0019:bi>\u0014XCAA\u0014\u0003I!WMZ1vYR\u001cu.\u001c9be\u0006$xN\u001d\u0011\u0015\u000fm\u0013\tEa\u0011\u0003F!)aJ\na\u0001q!)\u0011K\na\u0001q!)1K\na\u0001+\u00069QO\\1qa2LH\u0003\u0002B&\u0005/\u0002RA\u0012B'\u0005#J1Aa\u0014H\u0005\u0019y\u0005\u000f^5p]B1aIa\u00159qUK1A!\u0016H\u0005\u0019!V\u000f\u001d7fg!A!\u0011L\u0014\u0002\u0002\u0003\u00071,A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!q\f\t\u0005\u0003\u0007\u0014\t'\u0003\u0003\u0003d\u0005\u0015'AB(cU\u0016\u001cG\u000f")
public class ArraySort
extends Expression
implements ArrayBasedSimpleHigherOrderFunction,
CodegenFallback,
Serializable {
    private transient DataType elementType;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21;
    private transient NamedLambdaVariable firstElemVar;
    private transient NamedLambdaVariable secondElemVar;
    private final Expression argument;
    private final Expression function;
    private final boolean allowNullComparisonResult;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static LambdaFunction defaultComparator() {
        return ArraySort$.MODULE$.defaultComparator();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public AbstractDataType argumentType() {
        return ArrayBasedSimpleHigherOrderFunction.argumentType$(this);
    }

    @Override
    public Seq<Expression> arguments() {
        return SimpleHigherOrderFunction.arguments$(this);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        return SimpleHigherOrderFunction.argumentTypes$(this);
    }

    @Override
    public Seq<Expression> functions() {
        return SimpleHigherOrderFunction.functions$(this);
    }

    @Override
    public AbstractDataType functionType() {
        return SimpleHigherOrderFunction.functionType$(this);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        return SimpleHigherOrderFunction.functionTypes$(this);
    }

    @Override
    public Expression functionForEval() {
        return SimpleHigherOrderFunction.functionForEval$(this);
    }

    @Override
    public Expression left() {
        return SimpleHigherOrderFunction.left$(this);
    }

    @Override
    public Expression right() {
        return SimpleHigherOrderFunction.right$(this);
    }

    @Override
    public Object eval(InternalRow inputRow) {
        return SimpleHigherOrderFunction.eval$(this, inputRow);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public final HigherOrderFunction bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        return HigherOrderFunction.bind$(this, f);
    }

    private Seq<Expression> children$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.argumentsResolved$lzycompute();
        }
        return this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.functionsForEval$lzycompute();
        }
        return this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression argument() {
        return this.argument;
    }

    @Override
    public Expression function() {
        return this.function;
    }

    public boolean allowNullComparisonResult() {
        return this.allowNullComparisonResult;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.argument().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public ArrayType dataType() {
        return (ArrayType)this.argument().dataType();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = this.checkArgumentDataTypes();
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            DataType dataType = this.argument().dataType();
            if (dataType instanceof ArrayType) {
                DataType dataType2 = this.function().dataType();
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (!(dataType2 != null ? !dataType2.equals(integerType$) : integerType$ != null)) {
                    return TypeCheckResult$TypeCheckSuccess$.MODULE$;
                }
                return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_RETURN_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)Cast$.MODULE$.toSQLId(this.function().prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedType"), (Object)Cast$.MODULE$.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualType"), (Object)Cast$.MODULE$.toSQLType(this.function().dataType()))}))));
            }
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType(ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.argument())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType(this.argument().dataType()))}))));
        }
        return typeCheckResult;
    }

    @Override
    public ArraySort bindInternal(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        DataType elementType2 = (DataType)tuple2._1();
        boolean containsNull2 = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22));
        Expression x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21$lzycompute() {
        block5: {
            ArraySort arraySort = this;
            synchronized (arraySort) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression secondElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block6;
                        NamedExpression firstElemVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        secondElemVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                        if (!(firstElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)firstElemVar;
                        if (secondElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)secondElemVar;
                this.x$21 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$21;
    }

    private /* synthetic */ Tuple2 x$21() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$21$lzycompute();
        }
        return this.x$21;
    }

    private NamedLambdaVariable firstElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.firstElemVar = (NamedLambdaVariable)this.x$21()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.firstElemVar;
    }

    public NamedLambdaVariable firstElemVar() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.firstElemVar$lzycompute();
        }
        return this.firstElemVar;
    }

    private NamedLambdaVariable secondElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.secondElemVar = (NamedLambdaVariable)this.x$21()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.secondElemVar;
    }

    public NamedLambdaVariable secondElemVar() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.secondElemVar$lzycompute();
        }
        return this.secondElemVar;
    }

    public Comparator<Object> comparator(InternalRow inputRow) {
        Expression f = this.functionForEval();
        return (o1, o2) -> {
            this.firstElemVar().value().set(o1);
            this.secondElemVar().value().set(o2);
            Object cmp = f.eval(inputRow);
            if (!this.allowNullComparisonResult() && cmp == null) {
                throw QueryExecutionErrors$.MODULE$.comparatorReturnsNull(o1.toString(), o1.toString());
            }
            return BoxesRunTime.unboxToInt((Object)cmp);
        };
    }

    @Override
    public Object nullSafeEval(InternalRow inputRow, Object argumentValue) {
        Object[] arr = (Object[])((ArrayData)argumentValue).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(arr, this.comparator(inputRow));
        }
        return new GenericArrayData(arr);
    }

    @Override
    public String nodeName() {
        return "array_sort";
    }

    @Override
    public ArraySort withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public ArraySort copy(Expression argument, Expression function, boolean allowNullComparisonResult) {
        return new ArraySort(argument, function, allowNullComparisonResult);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.function();
    }

    public boolean copy$default$3() {
        return this.allowNullComparisonResult();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.argument();
            }
            case 1: {
                return this.function();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.allowNullComparisonResult());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.argument();
        Expression expression2 = arraySort.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.function();
        Expression expression4 = arraySort.function();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.allowNullComparisonResult() != arraySort.allowNullComparisonResult()) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression argument, Expression function, boolean allowNullComparisonResult) {
        this.argument = argument;
        this.function = function;
        this.allowNullComparisonResult = allowNullComparisonResult;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        BinaryLike.$init$(this);
        SimpleHigherOrderFunction.$init$(this);
        ArrayBasedSimpleHigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ArraySort(Expression argument, Expression function) {
        this(argument, function, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_ALLOW_NULL_COMPARISON_RESULT_IN_ARRAY_SORT())));
    }

    public ArraySort(Expression argument) {
        this(argument, ArraySort$.MODULE$.defaultComparator());
    }
}

