/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.TableAsserting$;
import org.scalatest.prop.TableDrivenPropertyChecks$;
import org.scalatest.prop.TableFor3;
import scala.Function0;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Q2A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002BB\u001a\u0001A\u0003%QDA\tD'Z+\u0005\u0010\u001d:Vi&d7oU;ji\u0016T!AB\u0004\u0002\u0007\r\u001chO\u0003\u0002\t\u0013\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u0017%\u0011ac\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005)\u0011!\u0003;fgR\u001c\u0015m]3t+\u0005i\u0002#\u0002\u0010$K5jS\"A\u0010\u000b\u0005\u0001\n\u0013\u0001\u00029s_BT!AI\b\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u0013 \u0005%!\u0016M\u00197f\r>\u00148\u0007\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\rM#(/\u001b8h!\rq\u0013'J\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1q\n\u001d;j_:\f!\u0002^3ti\u000e\u000b7/Z:!\u0001")
public class CSVExprUtilsSuite
extends SparkFunSuite {
    private final TableFor3<String, Option<String>, Option<String>> testCases;

    public TableFor3<String, Option<String>, Option<String>> testCases() {
        return this.testCases;
    }

    public CSVExprUtilsSuite() {
        this.test("Can parse escaped characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\\t")));
            char $org_scalatest_assert_macro_right = '\t';
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\\r")));
            char $org_scalatest_assert_macro_right2 = '\r';
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\\b")));
            char $org_scalatest_assert_macro_right3 = '\b';
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\\f")));
            char $org_scalatest_assert_macro_right4 = '\f';
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\\\"")));
            char $org_scalatest_assert_macro_right5 = '\"';
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\\'")));
            char $org_scalatest_assert_macro_right6 = '\'';
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\u0000")));
            char $org_scalatest_assert_macro_right7 = '\u0000';
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToCharacter((char)CSVExprUtils$.MODULE$.toChar("\\\\")));
            char $org_scalatest_assert_macro_right8 = '\\';
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToCharacter((char)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        }, new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("Does not accept delimiter larger than one character", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> CSVExprUtils$.MODULE$.toChar("ab"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "cannot be more than one character";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        }, new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Throws exception for unsupported escaped characters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> CSVExprUtils$.MODULE$.toChar("\\1"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Unsupported special character for delimiter";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }, new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("string with one backward slash is prohibited", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> CSVExprUtils$.MODULE$.toChar("\\"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Single backslash is prohibited";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        }, new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("output proper error message for empty string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            IllegalArgumentException exception = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> CSVExprUtils$.MODULE$.toChar(""), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Delimiter cannot be empty string";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        }, new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.testCases = TableDrivenPropertyChecks$.MODULE$.Table().apply(new Tuple3((Object)"input", (Object)"separatorStr", (Object)"expectedErrorMsg"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"\\t", (Object)new Some((Object)"\t"), (Object)None$.MODULE$), new Tuple3((Object)"\\\\t", (Object)new Some((Object)"\\t"), (Object)None$.MODULE$), new Tuple3((Object)"\\.", (Object)None$.MODULE$, (Object)new Some((Object)"Unsupported special character for delimiter")), new Tuple3((Object)"\\\\.", (Object)new Some((Object)"\\."), (Object)None$.MODULE$), new Tuple3((Object)"foo", (Object)new Some((Object)"foo"), (Object)None$.MODULE$), new Tuple3((Object)"ba\\tr", (Object)new Some((Object)"ba\tr"), (Object)None$.MODULE$), new Tuple3((Object)"\u0000", (Object)new Some((Object)"\u0000"), (Object)None$.MODULE$), new Tuple3((Object)"\u0000", (Object)new Some((Object)"\u0000"), (Object)None$.MODULE$)}));
        this.test("should correctly produce separator strings, or exceptions, from input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)TableDrivenPropertyChecks$.MODULE$.forAll(this.testCases(), (Function3 & Serializable & scala.Serializable)(input, separatorStr, expectedErrorMsg) -> {
            Assertion assertion;
            try {
                String separator = CSVExprUtils$.MODULE$.toDelimiterStr(input);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(separatorStr.isDefined(), "separatorStr.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
                Option $org_scalatest_assert_macro_left = expectedErrorMsg;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(separator.equals(separatorStr.get()), "separator.equals(separatorStr.get)", Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            }
            catch (IllegalArgumentException e) {
                Option $org_scalatest_assert_macro_left = separatorStr;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(expectedErrorMsg.isDefined(), "expectedErrorMsg.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                String $org_scalatest_assert_macro_left2 = e.getMessage();
                String $org_scalatest_assert_macro_right = (String)expectedErrorMsg.get();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            }
            return assertion;
        }, TableAsserting$.MODULE$.assertingNatureOfAssertion(), Prettifier$.MODULE$.default(), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85)), new Position("CSVExprUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }
}

