/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.Iso8601TimestampFormatter$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\u000b\u0017\u0001\rB\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005}!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\"\u00023\u0001\t\u0003)\u0007\u0002\u00037\u0001\u0011\u000b\u0007I\u0011C7\t\u0011a\u0004\u0001R1A\u0005\u0012eDQa\u001f\u0001\u0005BqDq!!\u0002\u0001\t\u0003\n9\u0001\u0003\u0004r\u0001\u0011\u0005\u0013q\u0002\u0005\u0007c\u0002!\t%a\u0007\t\rE\u0004A\u0011IA\u0011\u0011\u0019\t\b\u0001\"\u0011\u00022!9\u0011Q\b\u0001\u0005B\u0005}r!CA&-\u0005\u0005\t\u0012AA'\r!)b#!A\t\u0002\u0005=\u0003B\u00023\u0012\t\u0003\t9\u0006C\u0005\u0002ZE\t\n\u0011\"\u0001\u0002\\!I\u0011\u0011O\t\u0002\u0002\u0013%\u00111\u000f\u0002\u001a\u0013N|\u0007H\u000e\u00192)&lWm\u001d;b[B4uN]7biR,'O\u0003\u0002\u00181\u0005!Q\u000f^5m\u0015\tI\"$\u0001\u0005dCR\fG._:u\u0015\tYB$A\u0002tc2T!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0002\u0001'\u0011\u0001AE\u000b\u0018\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tYC&D\u0001\u0017\u0013\ticC\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\bCA\u00160\u0013\t\u0001dCA\fECR,G+[7f\r>\u0014X.\u0019;uKJDU\r\u001c9fe\u00069\u0001/\u0019;uKJt\u0007CA\u001a;\u001d\t!\u0004\b\u0005\u00026M5\taG\u0003\u00028E\u00051AH]8pizJ!!\u000f\u0014\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003s\u0019\naA_8oK&#\u0007CA E\u001b\u0005\u0001%BA!C\u0003\u0011!\u0018.\\3\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0011\u0002\u00075>tW-\u00133\u0002\r1|7-\u00197f!\tA%*D\u0001J\u0015\t9\")\u0003\u0002L\u0013\n1Aj\\2bY\u0016\fA\u0002\\3hC\u000eLhi\u001c:nCR\u0004\"AT/\u000f\u0005=[fB\u0001)[\u001d\t\t\u0016L\u0004\u0002S1:\u00111k\u0016\b\u0003)Zs!!N+\n\u0003\u0005J!a\b\u0011\n\u0005uq\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002\u00181%\u0011ALF\u0001\u0012\u0019\u0016<\u0017mY=ECR,gi\u001c:nCR\u001c\u0018B\u00010`\u0005AaUmZ1ds\u0012\u000bG/\u001a$pe6\fGO\u0003\u0002]-\u0005I\u0011n\u001d)beNLgn\u001a\t\u0003K\tL!a\u0019\u0014\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"bAZ4iS*\\\u0007CA\u0016\u0001\u0011\u0015\td\u00011\u00013\u0011\u0015id\u00011\u0001?\u0011\u00151e\u00011\u0001H\u0011\u001dae\u0001%AA\u00025CQ\u0001\u0019\u0004A\u0002\u0005\f\u0011BZ8s[\u0006$H/\u001a:\u0016\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d!\u0002\r\u0019|'/\\1u\u0013\t\u0019\bOA\tECR,G+[7f\r>\u0014X.\u0019;uKJD#aB;\u0011\u0005\u00152\u0018BA<'\u0005%!(/\u00198tS\u0016tG/A\bmK\u001e\f7-\u001f$pe6\fG\u000f^3s+\u0005Q\u0003F\u0001\u0005v\u0003\u0015\u0001\u0018M]:f)\ri\u0018\u0011\u0001\t\u0003KyL!a \u0014\u0003\t1{gn\u001a\u0005\u0007\u0003\u0007I\u0001\u0019\u0001\u001a\u0002\u0003M\fA\u0003]1sg\u0016<\u0016\u000e\u001e5pkR$\u0016.\\3[_:,G#B?\u0002\n\u0005-\u0001BBA\u0002\u0015\u0001\u0007!\u0007\u0003\u0004\u0002\u000e)\u0001\r!Y\u0001\u000eC2dwn\u001e+j[\u0016TvN\\3\u0015\u0007I\n\t\u0002C\u0004\u0002\u0014-\u0001\r!!\u0006\u0002\u000f%t7\u000f^1oiB\u0019q(a\u0006\n\u0007\u0005e\u0001IA\u0004J]N$\u0018M\u001c;\u0015\u0007I\ni\u0002\u0003\u0004\u0002 1\u0001\r!`\u0001\u0003kN$2AMA\u0012\u0011\u001d\t)#\u0004a\u0001\u0003O\t!\u0001^:\u0011\t\u0005%\u0012QF\u0007\u0003\u0003WQ!a\u0007\"\n\t\u0005=\u00121\u0006\u0002\n)&lWm\u001d;b[B$2AMA\u001a\u0011\u001d\t)D\u0004a\u0001\u0003o\tQ\u0002\\8dC2$\u0015\r^3US6,\u0007cA \u0002:%\u0019\u00111\b!\u0003\u001b1{7-\u00197ECR,G+[7f\u0003U1\u0018\r\\5eCR,\u0007+\u0019;uKJt7\u000b\u001e:j]\u001e$B!!\u0011\u0002HA\u0019Q%a\u0011\n\u0007\u0005\u0015cE\u0001\u0003V]&$\bBBA%\u001f\u0001\u0007\u0011-A\u0006dQ\u0016\u001c7\u000eT3hC\u000eL\u0018!G%t_b2\u0004'\r+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\"aK\t\u0014\tE!\u0013\u0011\u000b\t\u0004K\u0005M\u0013bAA+M\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011QJ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005u#fA'\u0002`-\u0012\u0011\u0011\r\t\u0005\u0003G\ni'\u0004\u0002\u0002f)!\u0011qMA5\u0003%)hn\u00195fG.,GMC\u0002\u0002l\u0019\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty'!\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006sK\u0006$'+Z:pYZ,GCAA;!\u0011\t9(! \u000e\u0005\u0005e$bAA>\u0005\u0006!A.\u00198h\u0013\u0011\ty(!\u001f\u0003\r=\u0013'.Z2u\u0001")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private transient TimestampFormatter legacyFormatter;
    private final String pattern;
    private final ZoneId zoneId;
    private final Locale locale;
    private final Enumeration.Value legacyFormat;
    private final boolean isParsing;
    private volatile transient byte bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$4() {
        return Iso8601TimestampFormatter$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public LocalDate toLocalDate(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalDate$(this, accessor);
    }

    @Override
    public LocalTime toLocalTime(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalTime$(this, accessor);
    }

    @Override
    public ZonedDateTime toZonedDateTime(TemporalAccessor accessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toZonedDateTime$(this, accessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale, boolean isParsing) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale, isParsing);
    }

    @Override
    public <T> PartialFunction<Throwable, T> checkParsedDiff(String s, Function1<String, T> legacyParseFunc) {
        return DateTimeFormatterHelper.checkParsedDiff$(this, s, legacyParseFunc);
    }

    @Override
    public <T extends Date> PartialFunction<Throwable, String> checkFormattedDiff(T d, Function1<T, String> legacyFormatFunc) {
        return DateTimeFormatterHelper.checkFormattedDiff$(this, d, legacyFormatFunc);
    }

    @Override
    public PartialFunction<Throwable, DateTimeFormatter> checkLegacyFormatter(String pattern, Function0<BoxedUnit> tryLegacyFormatter) {
        return DateTimeFormatterHelper.checkLegacyFormatter$(this, pattern, tryLegacyFormatter);
    }

    @Override
    public PartialFunction<Throwable, Nothing$> checkInvalidPattern(String pattern) {
        return DateTimeFormatterHelper.checkInvalidPattern$(this, pattern);
    }

    @Override
    public Option<Object> parseOptional(String s) throws ParseException, DateTimeParseException, DateTimeException {
        return TimestampFormatter.parseOptional$(this, s);
    }

    @Override
    public Option<Object> parseWithoutTimeZoneOptional(String s, boolean allowTimeZone) throws ParseException, DateTimeParseException, DateTimeException, IllegalStateException {
        return TimestampFormatter.parseWithoutTimeZoneOptional$(this, s, allowTimeZone);
    }

    @Override
    public final long parseWithoutTimeZone(String s) throws ParseException, DateTimeParseException, DateTimeException, IllegalStateException {
        return TimestampFormatter.parseWithoutTimeZone$(this, s);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale, this.isParsing);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatter;
    }

    public DateTimeFormatter formatter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.formatter$lzycompute();
        }
        return this.formatter;
    }

    private TimestampFormatter legacyFormatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.legacyFormatter = TimestampFormatter$.MODULE$.getLegacyFormatter(this.pattern, this.zoneId, this.locale, this.legacyFormat);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.legacyFormatter;
    }

    public TimestampFormatter legacyFormatter() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.legacyFormatter$lzycompute();
        }
        return this.legacyFormatter;
    }

    @Override
    public long parse(String s2) {
        long l;
        try {
            TemporalAccessor parsed = this.formatter().parse(s2);
            ZoneId parsedZoneId = parsed.query(TemporalQueries.zone());
            ZoneId timeZoneId = parsedZoneId == null ? this.zoneId : parsedZoneId;
            ZonedDateTime zonedDateTime = this.toZonedDateTime(parsed, timeZoneId);
            long epochSeconds = zonedDateTime.toEpochSecond();
            int microsOfSecond = zonedDateTime.get(ChronoField.MICRO_OF_SECOND);
            l = Math.addExact(Math.multiplyExact(epochSeconds, 1000000L), (long)microsOfSecond);
        }
        catch (Throwable x$1) {
            PartialFunction catchExpr$1 = this.checkParsedDiff(s2, (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToLong((long)Iso8601TimestampFormatter.$anonfun$parse$1(this, s)));
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                l = BoxesRunTime.unboxToLong((Object)catchExpr$1.apply((Object)x$1));
            }
            throw x$1;
        }
        return l;
    }

    @Override
    public long parseWithoutTimeZone(String s2, boolean allowTimeZone) {
        long l;
        try {
            TemporalAccessor parsed = this.formatter().parse(s2);
            if (!allowTimeZone && parsed.query(TemporalQueries.zone()) != null) {
                throw QueryExecutionErrors$.MODULE$.cannotParseStringAsDataTypeError(this.pattern, s2, (DataType)TimestampNTZType$.MODULE$);
            }
            LocalDate localDate = this.toLocalDate(parsed);
            LocalTime localTime = this.toLocalTime(parsed);
            l = DateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.of(localDate, localTime));
        }
        catch (Throwable x$2) {
            PartialFunction catchExpr$2 = this.checkParsedDiff(s2, (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToLong((long)Iso8601TimestampFormatter.$anonfun$parseWithoutTimeZone$1(this, s)));
            if (catchExpr$2.isDefinedAt((Object)x$2)) {
                l = BoxesRunTime.unboxToLong((Object)catchExpr$2.apply((Object)x$2));
            }
            throw x$2;
        }
        return l;
    }

    @Override
    public String format(Instant instant) {
        String string;
        try {
            string = this.formatter().withZone(this.zoneId).format(instant);
        }
        catch (Throwable x$3) {
            PartialFunction<Throwable, String> catchExpr$3 = this.checkFormattedDiff(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.instantToMicros(instant)), (Function1 & Serializable & scala.Serializable)t -> this.format((Timestamp)t));
            if (catchExpr$3.isDefinedAt((Object)x$3)) {
                string = (String)catchExpr$3.apply((Object)x$3);
            }
            throw x$3;
        }
        return string;
    }

    @Override
    public String format(long us) {
        Instant instant = DateTimeUtils$.MODULE$.microsToInstant(us);
        return this.format(instant);
    }

    @Override
    public String format(Timestamp ts) {
        return this.legacyFormatter().format(ts);
    }

    @Override
    public String format(LocalDateTime localDateTime) {
        return localDateTime.format(this.formatter());
    }

    @Override
    public void validatePatternString(boolean checkLegacy) {
        if (checkLegacy) {
            Object object;
            try {
                object = this.formatter();
            }
            catch (Throwable x$4) {
                PartialFunction<Throwable, DateTimeFormatter> catchExpr$4 = this.checkLegacyFormatter(this.pattern, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.legacyFormatter().validatePatternString(true));
                if (catchExpr$4.isDefinedAt((Object)x$4)) {
                    object = catchExpr$4.apply((Object)x$4);
                }
                throw x$4;
            }
            return;
        }
        try {
            this.formatter();
        }
        catch (Throwable x$5) {
            PartialFunction<Throwable, Nothing$> catchExpr$5 = this.checkInvalidPattern(this.pattern);
            if (catchExpr$5.isDefinedAt((Object)x$5)) {
                catchExpr$5.apply((Object)x$5);
            }
            throw x$5;
        }
    }

    public static final /* synthetic */ long $anonfun$parse$1(Iso8601TimestampFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public static final /* synthetic */ long $anonfun$parseWithoutTimeZone$1(Iso8601TimestampFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public Iso8601TimestampFormatter(String pattern, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        this.pattern = pattern;
        this.zoneId = zoneId;
        this.locale = locale;
        this.legacyFormat = legacyFormat;
        this.isParsing = isParsing;
        TimestampFormatter.$init$(this);
        DateTimeFormatterHelper.$init$(this);
    }
}

