/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.catalyst.analysis.TypeCoercionRule;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison$;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.DecimalLiteral$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.rules.RuleId;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalExpression$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.IntegralTypeExpression$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class DecimalPrecision$
extends Rule<LogicalPlan>
implements TypeCoercionRule {
    public static DecimalPrecision$ MODULE$;
    private final PartialFunction<Expression, Expression> integralAndDecimalLiteral;

    static {
        new DecimalPrecision$();
    }

    @Override
    public /* synthetic */ RuleId org$apache$spark$sql$catalyst$analysis$TypeCoercionRule$$super$ruleId() {
        return super.ruleId();
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return TypeCoercionRule.apply$(this, plan2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$catalyst$analysis$DecimalPrecision$$isFloat(DataType t) {
        DataType dataType = t;
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (dataType == null) {
            if (floatType$ == null) return true;
        } else if (dataType.equals(floatType$)) return true;
        DataType dataType2 = t;
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        if (dataType2 != null) {
            if (!dataType2.equals(doubleType$)) return false;
            return true;
        }
        if (doubleType$ == null) return true;
        return false;
    }

    public DecimalType widerDecimalType(DecimalType d1, DecimalType d2) {
        return this.widerDecimalType(d1.precision(), d1.scale(), d2.precision(), d2.scale());
    }

    public DecimalType widerDecimalType(int p1, int s1, int p2, int s2) {
        int scale = package$.MODULE$.max(s1, s2);
        int range = package$.MODULE$.max(p1 - s1, p2 - s2);
        return DecimalType$.MODULE$.bounded(range + scale, scale);
    }

    @Override
    public PartialFunction<Expression, Expression> transform() {
        return this.decimalAndDecimal().orElse(this.integralAndDecimalLiteral()).orElse(this.nondecimalAndDecimal(this.conf().literalPickMinimumPrecision()));
    }

    private PartialFunction<Expression, Expression> decimalAndDecimal() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BinaryComparison binaryComparison;
                Option<Tuple2<Expression, Expression>> option;
                A1 A1 = x1;
                if (!A1.childrenResolved()) {
                    return (B1)A1;
                }
                if (A1 instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)A1)).isEmpty()) {
                    Expression e1 = (Expression)((Tuple2)option.get())._1();
                    Expression e2 = (Expression)((Tuple2)option.get())._2();
                    Option<Tuple2<Object, Object>> option2 = DecimalExpression$.MODULE$.unapply(e1);
                    if (!option2.isEmpty()) {
                        int p1 = ((Tuple2)option2.get())._1$mcI$sp();
                        int s1 = ((Tuple2)option2.get())._2$mcI$sp();
                        Option<Tuple2<Object, Object>> option3 = DecimalExpression$.MODULE$.unapply(e2);
                        if (!option3.isEmpty()) {
                            int p2 = ((Tuple2)option3.get())._1$mcI$sp();
                            int s2 = ((Tuple2)option3.get())._2$mcI$sp();
                            if (p1 != p2 || s1 != s2) {
                                DecimalType resultType = DecimalPrecision$.MODULE$.widerDecimalType(p1, s1, p2, s2);
                                DataType dataType = e1.dataType();
                                DecimalType decimalType = resultType;
                                Expression newE1 = !(dataType != null ? !dataType.equals(decimalType) : decimalType != null) ? e1 : new Cast(e1, (DataType)resultType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                                DataType dataType2 = e2.dataType();
                                DecimalType decimalType2 = resultType;
                                Expression newE2 = !(dataType2 != null ? !dataType2.equals(decimalType2) : decimalType2 != null) ? e2 : new Cast(e2, (DataType)resultType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                                return (B1)binaryComparison.makeCopy(new Object[]{newE1, newE2});
                            }
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                BinaryComparison binaryComparison;
                Option<Tuple2<Expression, Expression>> option;
                Expression expression = x1;
                if (!expression.childrenResolved()) {
                    return true;
                }
                if (expression instanceof BinaryComparison && !(option = BinaryComparison$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
                    Expression e1 = (Expression)((Tuple2)option.get())._1();
                    Expression e2 = (Expression)((Tuple2)option.get())._2();
                    Option<Tuple2<Object, Object>> option2 = DecimalExpression$.MODULE$.unapply(e1);
                    if (!option2.isEmpty()) {
                        int p1 = ((Tuple2)option2.get())._1$mcI$sp();
                        int s1 = ((Tuple2)option2.get())._2$mcI$sp();
                        Option<Tuple2<Object, Object>> option3 = DecimalExpression$.MODULE$.unapply(e2);
                        if (!option3.isEmpty()) {
                            int p2 = ((Tuple2)option3.get())._1$mcI$sp();
                            int s2 = ((Tuple2)option3.get())._2$mcI$sp();
                            if (p1 != p2 || s1 != s2) {
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
        };
    }

    private PartialFunction<Expression, Expression> integralAndDecimalLiteral() {
        return this.integralAndDecimalLiteral;
    }

    private PartialFunction<Expression, Expression> nondecimalAndDecimal(boolean literalPickMinimumPrecision) {
        return new Serializable(literalPickMinimumPrecision){
            public static final long serialVersionUID = 0L;
            private final boolean literalPickMinimumPrecision$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BinaryOperator binaryOperator;
                Option<Tuple2<Expression, Expression>> option;
                A1 A1 = x1;
                if (A1 instanceof BinaryOperator && !(option = BinaryOperator$.MODULE$.unapply(binaryOperator = (BinaryOperator)A1)).isEmpty()) {
                    Expression left = (Expression)((Tuple2)option.get())._1();
                    Expression right = (Expression)((Tuple2)option.get())._2();
                    DataType dataType = left.dataType();
                    DataType dataType2 = right.dataType();
                    if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                        Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
                        if (tuple2 != null) {
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            if (l instanceof Literal) {
                                Literal literal = (Literal)l;
                                if (r.dataType() instanceof DecimalType && literal.dataType() instanceof IntegralType && this.literalPickMinimumPrecision$1) {
                                    return (B1)((Expression)binaryOperator.makeCopy(new Object[]{new Cast(literal, (DataType)DataTypeUtils$.MODULE$.fromLiteral(literal), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), r}));
                                }
                            }
                        }
                        if (tuple2 != null) {
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            if (r instanceof Literal) {
                                Literal literal = (Literal)r;
                                if (l.dataType() instanceof DecimalType && literal.dataType() instanceof IntegralType && this.literalPickMinimumPrecision$1) {
                                    return (B1)((Expression)binaryOperator.makeCopy(new Object[]{l, new Cast(literal, (DataType)DataTypeUtils$.MODULE$.fromLiteral(literal), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())}));
                                }
                            }
                        }
                        if (tuple2 != null) {
                            Option<Tuple2<Object, Object>> option2;
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            if (IntegralTypeExpression$.MODULE$.unapply(l) && !(option2 = DecimalExpression$.MODULE$.unapply(r)).isEmpty()) {
                                return (B1)((Expression)binaryOperator.makeCopy(new Object[]{new Cast(l, (DataType)DecimalType$.MODULE$.forType(l.dataType()), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), r}));
                            }
                        }
                        if (tuple2 != null) {
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            Option<Tuple2<Object, Object>> option3 = DecimalExpression$.MODULE$.unapply(l);
                            if (!option3.isEmpty() && IntegralTypeExpression$.MODULE$.unapply(r)) {
                                return (B1)((Expression)binaryOperator.makeCopy(new Object[]{l, new Cast(r, (DataType)DecimalType$.MODULE$.forType(r.dataType()), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())}));
                            }
                        }
                        if (tuple2 != null) {
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            Option<Tuple2<Object, Object>> option4 = DecimalExpression$.MODULE$.unapply(r);
                            if (!option4.isEmpty() && DecimalPrecision$.MODULE$.org$apache$spark$sql$catalyst$analysis$DecimalPrecision$$isFloat(l.dataType())) {
                                return (B1)((Expression)binaryOperator.makeCopy(new Object[]{l, new Cast(r, (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())}));
                            }
                        }
                        if (tuple2 != null) {
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            Option<Tuple2<Object, Object>> option5 = DecimalExpression$.MODULE$.unapply(l);
                            if (!option5.isEmpty() && DecimalPrecision$.MODULE$.org$apache$spark$sql$catalyst$analysis$DecimalPrecision$$isFloat(r.dataType())) {
                                return (B1)((Expression)binaryOperator.makeCopy(new Object[]{new Cast(l, (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()), r}));
                            }
                        }
                        return (B1)binaryOperator;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                BinaryOperator binaryOperator;
                Option<Tuple2<Expression, Expression>> option;
                Expression expression = x1;
                if (expression instanceof BinaryOperator && !(option = BinaryOperator$.MODULE$.unapply(binaryOperator = (BinaryOperator)expression)).isEmpty()) {
                    Expression left = (Expression)((Tuple2)option.get())._1();
                    Expression right = (Expression)((Tuple2)option.get())._2();
                    DataType dataType = left.dataType();
                    DataType dataType2 = right.dataType();
                    if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.literalPickMinimumPrecision$1 = literalPickMinimumPrecision$1;
            }
        };
    }

    private DecimalPrecision$() {
        MODULE$ = this;
        TypeCoercionRule.$init$(this);
        this.integralAndDecimalLiteral = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                GreaterThan greaterThan = null;
                boolean bl2 = false;
                GreaterThanOrEqual greaterThanOrEqual = null;
                boolean bl3 = false;
                LessThan lessThan = null;
                boolean bl4 = false;
                LessThanOrEqual lessThanOrEqual = null;
                A1 A1 = x1;
                if (A1 instanceof GreaterThan) {
                    Option<Decimal> option;
                    bl = true;
                    greaterThan = (GreaterThan)A1;
                    Expression i = greaterThan.left();
                    Expression expression = greaterThan.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression)).isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                            return (B1)Literal$.MODULE$.TrueLiteral();
                        }
                        if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                            return (B1)Literal$.MODULE$.FalseLiteral();
                        }
                        return (B1)new GreaterThan(i, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.floor().toLong())));
                    }
                }
                if (A1 instanceof GreaterThanOrEqual) {
                    Option<Decimal> option;
                    bl2 = true;
                    greaterThanOrEqual = (GreaterThanOrEqual)A1;
                    Expression i = greaterThanOrEqual.left();
                    Expression expression = greaterThanOrEqual.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression)).isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                            return (B1)Literal$.MODULE$.TrueLiteral();
                        }
                        if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                            return (B1)Literal$.MODULE$.FalseLiteral();
                        }
                        return (B1)new GreaterThanOrEqual(i, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.ceil().toLong())));
                    }
                }
                if (A1 instanceof LessThan) {
                    Option<Decimal> option;
                    bl3 = true;
                    lessThan = (LessThan)A1;
                    Expression i = lessThan.left();
                    Expression expression = lessThan.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression)).isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                            return (B1)Literal$.MODULE$.FalseLiteral();
                        }
                        if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                            return (B1)Literal$.MODULE$.TrueLiteral();
                        }
                        return (B1)new LessThan(i, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.ceil().toLong())));
                    }
                }
                if (A1 instanceof LessThanOrEqual) {
                    Option<Decimal> option;
                    bl4 = true;
                    lessThanOrEqual = (LessThanOrEqual)A1;
                    Expression i = lessThanOrEqual.left();
                    Expression expression = lessThanOrEqual.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression)).isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                            return (B1)Literal$.MODULE$.FalseLiteral();
                        }
                        if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                            return (B1)Literal$.MODULE$.TrueLiteral();
                        }
                        return (B1)new LessThanOrEqual(i, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.floor().toLong())));
                    }
                }
                if (bl) {
                    Expression expression = greaterThan.left();
                    Expression i = greaterThan.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression);
                    if (!option.isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (IntegralTypeExpression$.MODULE$.unapply(i)) {
                            if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                                return (B1)Literal$.MODULE$.FalseLiteral();
                            }
                            if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                                return (B1)Literal$.MODULE$.TrueLiteral();
                            }
                            return (B1)new GreaterThan(Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.ceil().toLong())), i);
                        }
                    }
                }
                if (bl2) {
                    Expression expression = greaterThanOrEqual.left();
                    Expression i = greaterThanOrEqual.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression);
                    if (!option.isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (IntegralTypeExpression$.MODULE$.unapply(i)) {
                            if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                                return (B1)Literal$.MODULE$.FalseLiteral();
                            }
                            if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                                return (B1)Literal$.MODULE$.TrueLiteral();
                            }
                            return (B1)new GreaterThanOrEqual(Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.floor().toLong())), i);
                        }
                    }
                }
                if (bl3) {
                    Expression expression = lessThan.left();
                    Expression i = lessThan.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression);
                    if (!option.isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (IntegralTypeExpression$.MODULE$.unapply(i)) {
                            if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                                return (B1)Literal$.MODULE$.TrueLiteral();
                            }
                            if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                                return (B1)Literal$.MODULE$.FalseLiteral();
                            }
                            return (B1)new LessThan(Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.floor().toLong())), i);
                        }
                    }
                }
                if (bl4) {
                    Expression expression = lessThanOrEqual.left();
                    Expression i = lessThanOrEqual.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression);
                    if (!option.isEmpty()) {
                        Decimal value = (Decimal)option.get();
                        if (IntegralTypeExpression$.MODULE$.unapply(i)) {
                            if (DecimalLiteral$.MODULE$.smallerThanSmallestLong(value)) {
                                return (B1)Literal$.MODULE$.TrueLiteral();
                            }
                            if (DecimalLiteral$.MODULE$.largerThanLargestLong(value)) {
                                return (B1)Literal$.MODULE$.FalseLiteral();
                            }
                            return (B1)new LessThanOrEqual(Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)value.ceil().toLong())), i);
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                GreaterThan greaterThan = null;
                boolean bl2 = false;
                GreaterThanOrEqual greaterThanOrEqual = null;
                boolean bl3 = false;
                LessThan lessThan = null;
                boolean bl4 = false;
                LessThanOrEqual lessThanOrEqual = null;
                Expression expression = x1;
                if (expression instanceof GreaterThan) {
                    Option<Decimal> option;
                    bl = true;
                    greaterThan = (GreaterThan)expression;
                    Expression i = greaterThan.left();
                    Expression expression2 = greaterThan.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression2)).isEmpty()) {
                        return true;
                    }
                }
                if (expression instanceof GreaterThanOrEqual) {
                    Option<Decimal> option;
                    bl2 = true;
                    greaterThanOrEqual = (GreaterThanOrEqual)expression;
                    Expression i = greaterThanOrEqual.left();
                    Expression expression3 = greaterThanOrEqual.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression3)).isEmpty()) {
                        return true;
                    }
                }
                if (expression instanceof LessThan) {
                    Option<Decimal> option;
                    bl3 = true;
                    lessThan = (LessThan)expression;
                    Expression i = lessThan.left();
                    Expression expression4 = lessThan.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression4)).isEmpty()) {
                        return true;
                    }
                }
                if (expression instanceof LessThanOrEqual) {
                    Option<Decimal> option;
                    bl4 = true;
                    lessThanOrEqual = (LessThanOrEqual)expression;
                    Expression i = lessThanOrEqual.left();
                    Expression expression5 = lessThanOrEqual.right();
                    if (IntegralTypeExpression$.MODULE$.unapply(i) && !(option = DecimalLiteral$.MODULE$.unapply(expression5)).isEmpty()) {
                        return true;
                    }
                }
                if (bl) {
                    Expression expression6 = greaterThan.left();
                    Expression i = greaterThan.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression6);
                    if (!option.isEmpty() && IntegralTypeExpression$.MODULE$.unapply(i)) {
                        return true;
                    }
                }
                if (bl2) {
                    Expression expression7 = greaterThanOrEqual.left();
                    Expression i = greaterThanOrEqual.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression7);
                    if (!option.isEmpty() && IntegralTypeExpression$.MODULE$.unapply(i)) {
                        return true;
                    }
                }
                if (bl3) {
                    Expression expression8 = lessThan.left();
                    Expression i = lessThan.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression8);
                    if (!option.isEmpty() && IntegralTypeExpression$.MODULE$.unapply(i)) {
                        return true;
                    }
                }
                if (bl4) {
                    Expression expression9 = lessThanOrEqual.left();
                    Expression i = lessThanOrEqual.right();
                    Option<Decimal> option = DecimalLiteral$.MODULE$.unapply(expression9);
                    if (!option.isEmpty() && IntegralTypeExpression$.MODULE$.unapply(i)) {
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

