/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestampLTZExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp with local time zone. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp with local time zone.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\nA\u0005U1sg\u0016$v\u000eV5nKN$\u0018-\u001c9M)j+\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM\u001d\u0006\u0003\r\u001d\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001\"C\u0001\tG\u0006$\u0018\r\\=ti*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001A\u00111#A\u0007\u0002\u000b\t!\u0003+\u0019:tKR{G+[7fgR\fW\u000e\u001d'U5\u0016C\bO]3tg&|gNQ;jY\u0012,'oE\u0002\u0002-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f!\u001b\u0005q\"BA\u0010\b\u0003!\tg.\u00197zg&\u001c\u0018BA\u0011\u001f\u0005E)\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\tQAY;jY\u0012$2AJ\u00157!\t\u0019r%\u0003\u0002)\u000b\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000b)\u001a\u0001\u0019A\u0016\u0002\u0011\u0019,hn\u0019(b[\u0016\u0004\"\u0001L\u001a\u000f\u00055\n\u0004C\u0001\u0018\u0019\u001b\u0005y#B\u0001\u0019\u0012\u0003\u0019a$o\\8u}%\u0011!\u0007G\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u000231!)aa\u0001a\u0001oA\u0019\u0001(\u0010\u0014\u000f\u0005eZdB\u0001\u0018;\u0013\u0005I\u0012B\u0001\u001f\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0007M+\u0017O\u0003\u0002=1!b\u0011!\u0011#F\u000f\"S5*\u0014(Q#B\u00111CQ\u0005\u0003\u0007\u0016\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-I\u0001G\u0003\t-!\u0002\t\u0011!A}3UKT\"`QQLW.Z:uC6\u0004xl\u001d;s72\u0002c-\u001c;^S\u0001j\u0003\u0005U1sg\u0016\u001c\b\u0005\u001e5fA\u0001$\u0018.\\3ti\u0006l\u0007oX:ue\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!o&$\b\u000e\t;iK\u0002\u0002g-\u001c;aA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003\u0005^8!C\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI<ji\"\u0004Cn\\2bY\u0002\"\u0018.\\3!u>tWM\f\u0011SKR,(O\\:!]VdG\u000eI<ji\"\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkRt\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001JG\u000f\t4pY2|wo\u001d\u0011dCN$\u0018N\\4!eVdWm\u001d\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C/[7fgR\fW\u000e\u001d\u0011jM\u0002\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f\u0013!S\u0001\u0003h)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^5nKN$\u0018-\u001c9`gR\u0014\b%\f\u0011BAM$(/\u001b8hAQ|\u0007EY3!a\u0006\u00148/\u001a3!i>\u0004C/[7fgR\fW\u000e\u001d\u0011xSRD\u0007\u0005\\8dC2\u0004C/[7fAi|g.\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0019lG\u000fI\u0017!)&lWm\u001d;b[B\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt\u0007\u0005^8!M>dGn\\</AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC-\u0019;fi&lW-\f9biR,'O\u001c\u0018ii6d'E\u0010#bi\u0016$\u0018.\\3!!\u0006$H/\u001a:ogrz\u0013M\u0010\u0011g_J\u0004c/\u00197jI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018%\u0001'\u0002\u0003#R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u0001\u0002\u0004GO\u00193uA\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n\u0004\u0005\r\u0019;cIR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00172e5\u001a\u0014g\n\u0017!OeL\u00180_\u0017N\u001b6\"GmJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014GN\u00172e5\u001a\u0014\u0007\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\nQa\u001a:pkB\f\u0013aT\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\u0005\u0011\u0016!B\u001a/i9\u0002\u0004\u0006\u0004\u0001B\t\u0016;\u0005JS&N\u001dB\u000b\u0006")
public final class ParseToTimestampLTZExpressionBuilder {
    public static Expression build(String string, Seq<Expression> seq) {
        return ParseToTimestampLTZExpressionBuilder$.MODULE$.build(string, (Seq)seq);
    }

    public static Seq<Expression> rearrange(FunctionSignature functionSignature, Seq<Expression> seq, String string) {
        return ParseToTimestampLTZExpressionBuilder$.MODULE$.rearrange(functionSignature, seq, string);
    }

    public static Option<FunctionSignature> functionSignature() {
        return ParseToTimestampLTZExpressionBuilder$.MODULE$.functionSignature();
    }
}

