/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y2A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)\u0011\u0007\u0001C\u0001e\t1B+\u00192mKN\u001b\u0007.Z7b!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\u0007\u000f\u00051\u0001/\u0019:tKJT!\u0001C\u0005\u0002\u0011\r\fG/\u00197zgRT!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0006\n\u0005YY!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u000b\u0005)\u0001/\u0019:tKR\u0011Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0003A%\tQ\u0001^=qKNL!AI\u0010\u0003\u0015M#(/^2u)f\u0004X\rC\u0003\u000b\u0005\u0001\u0007A\u0005\u0005\u0002&]9\u0011a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SE\ta\u0001\u0010:p_Rt$\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R\u0013A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0016\u0002!\rDWmY6UC\ndWmU2iK6\fGcA\u001a8sA\u0011A'N\u0007\u0002U%\u0011aG\u000b\u0002\u0005+:LG\u000fC\u00039\u0007\u0001\u0007A%A\tuC\ndWmU2iK6\f7\u000b\u001e:j]\u001eDQAO\u0002A\u0002m\n\u0001#\u001a=qK\u000e$X\r\u001a#bi\u0006$\u0016\u0010]3\u0011\u0005ya\u0014BA\u001f \u0005!!\u0015\r^1UsB,\u0007")
public class TableSchemaParserSuite
extends SparkFunSuite {
    public StructType parse(String sql) {
        return CatalystSqlParser$.MODULE$.parseTableSchema(sql);
    }

    public void checkTableSchema(String tableSchemaString, DataType expectedDataType) {
        this.test(new StringBuilder(6).append("parse ").append(tableSchemaString).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parse(tableSchemaString));
            DataType $org_scalatest_assert_macro_right = expectedDataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
    }

    private final SparkThrowable parseException$1(String sql) {
        return (SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parseTableSchema(sql), ClassTag$.MODULE$.apply(ParseException.class), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    public TableSchemaParserSuite() {
        this.checkTableSchema("a int", (DataType)new StructType().add("a", "int"));
        this.checkTableSchema("A int", (DataType)new StructType().add("A", "int"));
        this.checkTableSchema("a INT", (DataType)new StructType().add("a", "int"));
        this.checkTableSchema("`!@#$%.^&*()` string", (DataType)new StructType().add("!@#$%.^&*()", "string"));
        this.checkTableSchema("a int, b long", (DataType)new StructType().add("a", "int").add("b", "long"));
        StructField structField = new StructField("intType", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("ts", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("a", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.checkTableSchema("a STRUCT<intType: int, ts:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3)));
        this.checkTableSchema("a int comment 'test'", (DataType)new StructType().add("a", "int", true, "test"));
        this.test("complex hive type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String tableSchemaString = new StringOps(Predef$.MODULE$.augmentString("\n        |complexStructCol struct<\n        |struct:struct<deciMal:DECimal, anotherDecimal:decimAL(5,2)>,\n        |MAP:Map<timestamp, varchar(10)>,\n        |arrAy:Array<double>,\n        |anotherArray:Array<char(9)>>\n      ")).stripMargin().replace("\n", "");
            StructField structField = new StructField("deciMal", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("anotherDecimal", (DataType)new DecimalType(5, 2), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField3 = new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField4 = new StructField("MAP", (DataType)MapType$.MODULE$.apply((DataType)TimestampType$.MODULE$, (DataType)new VarcharType(10)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField5 = new StructField("arrAy", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField6 = new StructField("anotherArray", (DataType)ArrayType$.MODULE$.apply((DataType)new CharType(9)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField7 = new StructField("complexStructCol", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType expectedDataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.parse(tableSchemaString));
            StructType $org_scalatest_assert_macro_right = expectedDataType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("Negative cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkError(this.parseException$1(""), "PARSE_EMPTY_STATEMENT", this.checkError$default$3(), this.checkError$default$4(), this.checkError$default$5(), this.checkError$default$6());
            SparkThrowable x$1 = this.parseException$1("a");
            String x$2 = "PARSE_SYNTAX_ERROR";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"end of input"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError(x$1, x$2, x$4, x$3, x$5, x$6);
            SparkThrowable x$7 = this.parseException$1("a INT b long");
            String x$8 = "PARSE_SYNTAX_ERROR";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'b'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            QueryContext[] x$12 = this.checkError$default$6();
            this.checkError(x$7, x$8, x$10, x$9, x$11, x$12);
            SparkThrowable x$13 = this.parseException$1("a INT,, b long");
            String x$14 = "PARSE_SYNTAX_ERROR";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"','"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            QueryContext[] x$18 = this.checkError$default$6();
            this.checkError(x$13, x$14, x$16, x$15, x$17, x$18);
            SparkThrowable x$19 = this.parseException$1("a INT, b long,,");
            String x$20 = "PARSE_SYNTAX_ERROR";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"','"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            QueryContext[] x$24 = this.checkError$default$6();
            this.checkError(x$19, x$20, x$22, x$21, x$23, x$24);
            SparkThrowable x$25 = this.parseException$1("a INT, b long, c int,");
            String x$26 = "PARSE_SYNTAX_ERROR";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"end of input"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            QueryContext[] x$30 = this.checkError$default$6();
            this.checkError(x$25, x$26, x$28, x$27, x$29, x$30);
        }, new Position("TableSchemaParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }
}

