/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.NumberConverter$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!1A\u0004\u0001Q\u0005\nuAa\u0001\b\u0001!\n\u0013Q\u0004\"\u0002#\u0001\t\u0003)%\u0001\u0006(v[\n,'oQ8om\u0016\u0014H/\u001a:Tk&$XM\u0003\u0002\b\u0011\u0005!Q\u000f^5m\u0015\tI!\"\u0001\u0005dCR\fG._:u\u0015\tYA\"A\u0002tc2T!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\tA\"\u0003\u0002\u0018\u0019\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0004\u0002\u0013\rDWmY6D_:4H#\u0002\u0010%cYB\u0004CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRDQ!\n\u0002A\u0002\u0019\n\u0011A\u001c\t\u0003O9r!\u0001\u000b\u0017\u0011\u0005%\u0002S\"\u0001\u0016\u000b\u0005-\u0012\u0012A\u0002\u001fs_>$h(\u0003\u0002.A\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\ti\u0003\u0005C\u00033\u0005\u0001\u00071'\u0001\u0005ge>l')Y:f!\tyB'\u0003\u00026A\t\u0019\u0011J\u001c;\t\u000b]\u0012\u0001\u0019A\u001a\u0002\rQ|')Y:f\u0011\u0015I$\u00011\u0001'\u0003!)\u0007\u0010]3di\u0016$GC\u0002\u0010<yurt\bC\u0003&\u0007\u0001\u0007a\u0005C\u00033\u0007\u0001\u00071\u0007C\u00038\u0007\u0001\u00071\u0007C\u0003:\u0007\u0001\u0007a\u0005C\u0003A\u0007\u0001\u0007\u0011)A\u0006b]NLWI\\1cY\u0016$\u0007CA\u0010C\u0013\t\u0019\u0005EA\u0004C_>dW-\u00198\u0002\u001b\rDWmY6U_\nKg.\u0019:z+\t15\n\u0006\u0002\u001f\u000f\")\u0001\n\u0002a\u0001\u0013\u0006\u0011\u0011N\u001c\t\u0003\u0015.c\u0001\u0001B\u0003M\t\t\u0007QJA\u0001U#\tq\u0015\u000b\u0005\u0002 \u001f&\u0011\u0001\u000b\t\u0002\b\u001d>$\b.\u001b8h!\ty\"+\u0003\u0002TA\t\u0019\u0011I\\=")
public class NumberConverterSuite
extends SparkFunSuite {
    private void checkConv(String n, int fromBase, int toBase, String expected) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)ansiEnabled -> {
            this.checkConv(n, fromBase, toBase, expected, BoxesRunTime.unboxToBoolean((Object)ansiEnabled));
            return BoxedUnit.UNIT;
        });
    }

    private void checkConv(String n, int fromBase, int toBase, String expected, boolean ansiEnabled) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.convert(UTF8String.fromString((String)n).getBytes(), fromBase, toBase, ansiEnabled, null));
        UTF8String $org_scalatest_assert_macro_right = UTF8String.fromString((String)expected);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public <T> void checkToBinary(T in) {
        T t = in;
        if (t instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(by));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(1).order(ByteOrder.BIG_ENDIAN).put(by).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            return;
        }
        if (t instanceof Short) {
            short s = BoxesRunTime.unboxToShort(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(s));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort(s).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            return;
        }
        if (t instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(n));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(n).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            return;
        }
        if (t instanceof Long) {
            long l = BoxesRunTime.unboxToLong(t);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(NumberConverter$.MODULE$.toBinary(l));
            byte[] $org_scalatest_assert_macro_right = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l).array();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            return;
        }
        throw new MatchError(t);
    }

    public NumberConverterSuite() {
        this.test("convert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkConv("3", 10, 2, "11");
            this.checkConv("-15", 10, -16, "-F");
            this.checkConv("-15", 10, 16, "FFFFFFFFFFFFFFF1");
            this.checkConv("big", 36, 16, "3A48");
            this.checkConv("9223372036854775807", 36, 16, "FFFFFFFFFFFFFFFF", false);
            this.checkConv("11abc", 10, 16, "B");
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("SPARK-34909: convert negative to unsigned", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkConv("-10", 11, 7, "45012021522523134134555"), new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("SPARK-44973: conv must allocate enough space for all digits plus negative sign", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkConv(String.valueOf(BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), 10, -2, package$.MODULE$.BigInt().apply(Long.MIN_VALUE).toString(2));
            this.checkConv(package$.MODULE$.BigInt().apply(Long.MAX_VALUE).$plus(BigInt$.MODULE$.int2bigInt(1)).toString(16), 16, -2, package$.MODULE$.BigInt().apply(Long.MIN_VALUE).toString(2));
            this.checkConv(package$.MODULE$.BigInt().apply(Long.MIN_VALUE).toString(16), 16, -2, package$.MODULE$.BigInt().apply(Long.MIN_VALUE).toString(2));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("byte to binary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToByte((byte)((byte)0)));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)((byte)1)));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)((byte)-1)));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)127));
            this.checkToBinary(BoxesRunTime.boxToByte((byte)-128));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("short to binary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToShort((short)((short)0)));
            this.checkToBinary(BoxesRunTime.boxToShort((short)((short)1)));
            this.checkToBinary(BoxesRunTime.boxToShort((short)((short)-1)));
            this.checkToBinary(BoxesRunTime.boxToShort((short)Short.MAX_VALUE));
            this.checkToBinary(BoxesRunTime.boxToShort((short)Short.MIN_VALUE));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("integer to binary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToInteger((int)0));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)1));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)-1));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
            this.checkToBinary(BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("long to binary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkToBinary(BoxesRunTime.boxToLong((long)0L));
            this.checkToBinary(BoxesRunTime.boxToLong((long)1L));
            this.checkToBinary(BoxesRunTime.boxToLong((long)-1L));
            this.checkToBinary(BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            this.checkToBinary(BoxesRunTime.boxToLong((long)Long.MIN_VALUE));
        }, new Position("NumberConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
    }
}

