/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I2A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002BB\u0019\u0001A\u0003%QD\u0001\rBiR\u0014\u0018NY;uKJ+7o\u001c7vi&|gnU;ji\u0016T!AB\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\u000b\u000e\u0003-I!AF\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\tQ!\u0001\u0005sKN|GN^3s+\u0005i\u0002#\u0002\u0010\"G\rrS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\u0013,\u001d\t)\u0013\u0006\u0005\u0002'?5\tqE\u0003\u0002)#\u00051AH]8pizJ!AK\u0010\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003U}\u0001\"AH\u0018\n\u0005Az\"a\u0002\"p_2,\u0017M\\\u0001\ne\u0016\u001cx\u000e\u001c<fe\u0002\u0002")
public class AttributeResolutionSuite
extends SparkFunSuite {
    private final Function2<String, String, Object> resolver = org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseInsensitiveResolution();

    public Function2<String, String, Object> resolver() {
        return this.resolver;
    }

    public AttributeResolutionSuite() {
        this.test("basic attribute resolution with namespaces", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = "a";
            IntegerType$ x$2 = IntegerType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$5 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)));
            ExprId x$6 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
            String x$7 = "a";
            IntegerType$ x$8 = IntegerType$.MODULE$;
            boolean x$9 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$11 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"ns3", (List)new .colon.colon((Object)"t2", (List)Nil$.MODULE$))));
            ExprId x$12 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$6, x$5), (List)new .colon.colon((Object)new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$12, x$11), (List)Nil$.MODULE$));
            ((IterableLike)new .colon.colon((Object)((Seq)new .colon.colon((Object)"t1", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t1", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t1", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$))))), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)nameParts -> {
                Option option = package$.MODULE$.AttributeSeq(attrs).resolve(nameParts, this.resolver());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    NamedExpression attr = (NamedExpression)some.value();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((Expression)attr).semanticEquals((Expression)attrs.apply(0)), "attr.semanticEquals(attrs.apply(0))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
                }
                throw this.fail(new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            });
            ((IterableLike)new .colon.colon((Object)((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$))), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)nameParts -> {
                Option $org_scalatest_assert_macro_left = package$.MODULE$.AttributeSeq(attrs).resolve(nameParts, this.resolver());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            });
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("attribute resolution where table and attribute names are the same", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String x$13 = "t";
            IntegerType$ x$14 = IntegerType$.MODULE$;
            boolean x$15 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$17 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$)));
            ExprId x$18 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$18, x$17), (List)Nil$.MODULE$);
            ((IterableLike)new .colon.colon((Object)((Seq)new .colon.colon((Object)"t", (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)"t", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$)))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ns1", "ns2", "t", "t"}))), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)nameParts -> {
                Option option = package$.MODULE$.AttributeSeq(attrs).resolve(nameParts, this.resolver());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    NamedExpression attr = (NamedExpression)some.value();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((Expression)attr).semanticEquals((Expression)attrs.apply(0)), "attr.semanticEquals(attrs.apply(0))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
                }
                throw this.fail(new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            });
            Option $org_scalatest_assert_macro_left = package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$))), this.resolver());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("attribute resolution ambiguity at the attribute name level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$19 = "a";
            IntegerType$ x$20 = IntegerType$.MODULE$;
            boolean x$21 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$23 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t1", (List)Nil$.MODULE$));
            ExprId x$24 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
            String x$25 = "a";
            IntegerType$ x$26 = IntegerType$.MODULE$;
            boolean x$27 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$28 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$29 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"t2", (List)Nil$.MODULE$)));
            ExprId x$30 = AttributeReference$.MODULE$.apply$default$5(x$25, (DataType)x$26, x$27, x$28);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$24, x$23), (List)new .colon.colon((Object)new AttributeReference(x$25, (DataType)x$26, x$27, x$28, x$30, x$29), (List)Nil$.MODULE$));
            AnalysisException x$31 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"a", (List)Nil$.MODULE$), this.resolver()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            String x$32 = "AMBIGUOUS_REFERENCE";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"`a`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"referenceNames"), (Object)"[`ns1`.`ns2`.`t2`.`a`, `ns1`.`t1`.`a`]")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            QueryContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, x$32, x$34, x$33, x$35, x$36);
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("attribute resolution ambiguity at the qualifier level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$37 = "a";
            IntegerType$ x$38 = IntegerType$.MODULE$;
            boolean x$39 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$40 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$41 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$));
            ExprId x$42 = AttributeReference$.MODULE$.apply$default$5(x$37, (DataType)x$38, x$39, x$40);
            String x$43 = "a";
            IntegerType$ x$44 = IntegerType$.MODULE$;
            boolean x$45 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$46 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$47 = (Seq)new .colon.colon((Object)"ns2", (List)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$)));
            ExprId x$48 = AttributeReference$.MODULE$.apply$default$5(x$43, (DataType)x$44, x$45, x$46);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$37, (DataType)x$38, x$39, x$40, x$42, x$41), (List)new .colon.colon((Object)new AttributeReference(x$43, (DataType)x$44, x$45, x$46, x$48, x$47), (List)Nil$.MODULE$));
            AnalysisException x$49 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$))), this.resolver()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            String x$50 = "AMBIGUOUS_REFERENCE";
            Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"`ns1`.`t`.`a`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"referenceNames"), (Object)"[`ns1`.`t`.`a`, `ns2`.`ns1`.`t`.`a`]")}));
            Option x$52 = this.checkError$default$3();
            boolean x$53 = this.checkError$default$5();
            QueryContext[] x$54 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$49, x$50, x$52, x$51, x$53, x$54);
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("attribute resolution with nested fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String name;
            Some some;
            NamedExpression namedExpression;
            StructType attrType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("aa", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("bb", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
            String x$55 = "a";
            StructType x$56 = attrType;
            boolean x$57 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$58 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$59 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$));
            ExprId x$60 = AttributeReference$.MODULE$.apply$default$5(x$55, (DataType)x$56, x$57, x$58);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$55, (DataType)x$56, x$57, x$58, x$60, x$59), (List)Nil$.MODULE$);
            Option resolved = package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"aa", (List)Nil$.MODULE$)))), this.resolver());
            Option option = resolved;
            if (!(option instanceof Some) || !((namedExpression = (NamedExpression)(some = (Some)option).value()) instanceof Alias)) {
                throw this.fail(new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            }
            Alias alias = (Alias)namedExpression;
            String $org_scalatest_assert_macro_left = name = alias.name();
            String $org_scalatest_assert_macro_right = "aa";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            AnalysisException x$61 = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"cc", (List)Nil$.MODULE$)))), this.resolver()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            String x$62 = "FIELD_NOT_FOUND";
            Map x$63 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"`cc`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fields"), (Object)"`aa`, `bb`")}));
            Option x$64 = this.checkError$default$3();
            boolean x$65 = this.checkError$default$5();
            QueryContext[] x$66 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$61, x$62, x$64, x$63, x$65, x$66);
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("attribute resolution with case insensitive resolver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String x$67 = "a";
            IntegerType$ x$68 = IntegerType$.MODULE$;
            boolean x$69 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$70 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$71 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$));
            ExprId x$72 = AttributeReference$.MODULE$.apply$default$5(x$67, (DataType)x$68, x$69, x$70);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$67, (DataType)x$68, x$69, x$70, x$72, x$71), (List)Nil$.MODULE$);
            Option option = package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"Ns1", (List)new .colon.colon((Object)"T", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$))), org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseInsensitiveResolution());
            if (option instanceof Some) {
                Bool bool;
                Some some = (Some)option;
                NamedExpression attr = (NamedExpression)some.value();
                Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(((Expression)attr).semanticEquals((Expression)attrs.apply(0)), "attr.semanticEquals(attrs.apply(0))", Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left.value()) {
                    String $org_scalatest_assert_macro_left2 = attr.name();
                    String $org_scalatest_assert_macro_right = "A";
                    String string = $org_scalatest_assert_macro_left2;
                    String string2 = $org_scalatest_assert_macro_right;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            }
            throw this.fail(new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("attribute resolution with case sensitive resolver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String x$73 = "a";
            IntegerType$ x$74 = IntegerType$.MODULE$;
            boolean x$75 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$76 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$77 = (Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$));
            ExprId x$78 = AttributeReference$.MODULE$.apply$default$5(x$73, (DataType)x$74, x$75, x$76);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$73, (DataType)x$74, x$75, x$76, x$78, x$77), (List)Nil$.MODULE$);
            Option $org_scalatest_assert_macro_left = package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"Ns1", (List)new .colon.colon((Object)"T", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$))), org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseSensitiveResolution());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Option $org_scalatest_assert_macro_left2 = package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$))), org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseSensitiveResolution());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            Option option = package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"ns1", (List)new .colon.colon((Object)"t", (List)new .colon.colon((Object)"a", (List)Nil$.MODULE$))), org.apache.spark.sql.catalyst.analysis.package$.MODULE$.caseSensitiveResolution());
            if (option instanceof Some) {
                Some some = (Some)option;
                NamedExpression attr = (NamedExpression)some.value();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((Expression)attr).semanticEquals((Expression)attrs.apply(0)), "attr.semanticEquals(attrs.apply(0))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            }
            throw this.fail(new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("attribute resolution should try to match the longest qualifier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType a1Type = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            StructType a2Type = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
            String x$79 = "a";
            StructType x$80 = a1Type;
            boolean x$81 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$82 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$83 = AttributeReference$.MODULE$.apply$default$5(x$79, (DataType)x$80, x$81, x$82);
            Seq x$84 = AttributeReference$.MODULE$.apply$default$6(x$79, (DataType)x$80, x$81, x$82);
            String x$85 = "b";
            StructType x$86 = a2Type;
            boolean x$87 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$88 = AttributeReference$.MODULE$.apply$default$4();
            Seq x$89 = (Seq)new .colon.colon((Object)"a", (List)Nil$.MODULE$);
            ExprId x$90 = AttributeReference$.MODULE$.apply$default$5(x$85, (DataType)x$86, x$87, x$88);
            Seq attrs = (Seq)new .colon.colon((Object)new AttributeReference(x$79, (DataType)x$80, x$81, x$82, x$83, x$84), (List)new .colon.colon((Object)new AttributeReference(x$85, (DataType)x$86, x$87, x$88, x$90, x$89), (List)Nil$.MODULE$));
            Option option = package$.MODULE$.AttributeSeq(attrs).resolve((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), this.resolver());
            if (option instanceof Some) {
                Some some = (Some)option;
                NamedExpression attr = (NamedExpression)some.value();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((Expression)attr).semanticEquals((Expression)attrs.apply(1)), "attr.semanticEquals(attrs.apply(1))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            }
            throw this.fail(new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        }, new Position("AttributeResolutionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
    }
}

