/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.NamedParameter;
import org.apache.spark.sql.catalyst.analysis.PosParameter;
import org.apache.spark.sql.catalyst.analysis.RelationTimeTravel;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedGenerator;
import org.apache.spark.sql.catalyst.analysis.UnresolvedInlineTable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSubqueryColumnAliases;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTVFAliases$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTableValuedFunction$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Cube$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.FunctionTableSubqueryArgumentExpression;
import org.apache.spark.sql.catalyst.expressions.FunctionTableSubqueryArgumentExpression$;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GroupingSets$;
import org.apache.spark.sql.catalyst.expressions.LateralSubquery;
import org.apache.spark.sql.catalyst.expressions.LateralSubquery$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedArgumentExpression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Overlay;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.Rollup$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileCont;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileCont$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileDisc;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileDisc$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.NaturalJoin;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.UsingJoin;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Distinct;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement$;
import org.apache.spark.sql.catalyst.plans.logical.LateralJoin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.ScriptInputOutputSchema;
import org.apache.spark.sql.catalyst.plans.logical.ScriptTransformation;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias$;
import org.apache.spark.sql.catalyst.plans.logical.Union$;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedWith;
import org.apache.spark.sql.catalyst.plans.logical.WithWindowDefinition;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0005G!)\u0011\t\u0001C\u0005\u0005\")\u0001\n\u0001C\u0005\u0013\ny\u0001\u000b\\1o!\u0006\u00148/\u001a:Tk&$XM\u0003\u0002\b\u0011\u00051\u0001/\u0019:tKJT!!\u0003\u0006\u0002\u0011\r\fG/\u00197zgRT!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u000b\u0019!\t)b#D\u0001\r\u0013\t9BBA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00033qi\u0011A\u0007\u0006\u00037!\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003;i\u0011A\"\u00118bYf\u001c\u0018n\u001d+fgR\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0004\u0002\u0017\u0005\u001c8/\u001a:u\u000bF,\u0018\r\u001c\u000b\u0004I):\u0004CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#\u0001B+oSRDQa\u000b\u0002A\u00021\n!b]9m\u0007>lW.\u00198e!\tiCG\u0004\u0002/eA\u0011qFJ\u0007\u0002a)\u0011\u0011GE\u0001\u0007yI|w\u000e\u001e \n\u0005M2\u0013A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!a\r\u0014\t\u000ba\u0012\u0001\u0019A\u001d\u0002\tAd\u0017M\u001c\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nq\u0001\\8hS\u000e\fGN\u0003\u0002?\u0011\u0005)\u0001\u000f\\1og&\u0011\u0001i\u000f\u0002\f\u0019><\u0017nY1m!2\fg.\u0001\bqCJ\u001cX-\u0012=dKB$\u0018n\u001c8\u0015\u0005\r3\u0005CA\u000bE\u0013\t)EB\u0001\bTa\u0006\u00148\u000e\u00165s_^\f'\r\\3\t\u000b\u001d\u001b\u0001\u0019\u0001\u0017\u0002\u000fM\fH\u000eV3yi\u0006\u00191\r^3\u0015\u0007)ke\n\u0005\u0002;\u0017&\u0011Aj\u000f\u0002\u000f+:\u0014Xm]8mm\u0016$w+\u001b;i\u0011\u0015AD\u00011\u0001:\u0011\u0015yE\u00011\u0001Q\u0003)q\u0017-\\3e!2\fgn\u001d\t\u0004KE\u001b\u0016B\u0001*'\u0005)a$/\u001a9fCR,GM\u0010\t\u0005KQcc+\u0003\u0002VM\t1A+\u001e9mKJ\u0002B!\n+:/B\u0019\u0001,\u0018\u0017\u000f\u0005e[fBA\u0018[\u0013\u00059\u0013B\u0001/'\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0007M+\u0017O\u0003\u0002]M\u0001")
public class PlanParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public /* synthetic */ Option org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError$default$3() {
        return super.checkError$default$3();
    }

    @Override
    public /* synthetic */ boolean org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError$default$5() {
        return super.checkError$default$5();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError(SparkThrowable exception, String errorClass, Option sqlState, Map parameters, boolean matchPVals, QueryContext[] queryContext) {
        super.checkError(exception, errorClass, sqlState, parameters, matchPVals, queryContext);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorClass(LogicalPlan inputPlan, String expectedErrorClass, Map<String, String> expectedMessageParameters, QueryContext[] queryContext, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorClass$(this, inputPlan, expectedErrorClass, expectedMessageParameters, queryContext, caseSensitive);
    }

    @Override
    public QueryContext[] assertAnalysisErrorClass$default$4() {
        return AnalysisTest.assertAnalysisErrorClass$default$4$(this);
    }

    @Override
    public boolean assertAnalysisErrorClass$default$5() {
        return AnalysisTest.assertAnalysisErrorClass$default$5$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> errorClass) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, errorClass);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public ParseException parseException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.parseException$(this, parser, sqlText);
    }

    @Override
    public SparkException internalException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.internalException$(this, parser, sqlText);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        PlanParserSuite planParserSuite = this;
        synchronized (planParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(sqlCommand), plan, false);
    }

    private SparkThrowable parseException(String sqlText2) {
        return AnalysisTest.parseException$(this, (Function1 & Serializable & scala.Serializable)sqlText -> CatalystSqlParser$.MODULE$.parsePlan(sqlText), sqlText2);
    }

    private UnresolvedWith cte(LogicalPlan plan, Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>> namedPlans) {
        Seq ctes = (Seq)namedPlans.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    LogicalPlan cte = (LogicalPlan)tuple22._1();
                    Seq columnAliases = (Seq)tuple22._2();
                    LogicalPlan subquery = columnAliases.isEmpty() ? cte : new UnresolvedSubqueryColumnAliases(columnAliases, cte);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)SubqueryAlias$.MODULE$.apply(name, subquery));
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return new UnresolvedWith(plan, ctes);
    }

    public static final /* synthetic */ void $anonfun$new$28(PlanParserSuite $this, String baseSql$1, String s1$1, LogicalPlan p1$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String s2 = (String)tuple2._1();
            Function1 pf2 = (Function1)tuple2._2();
            $this.assertEqual(new StringBuilder(0).append(baseSql$1).append(s1$1).append(s2).toString(), (LogicalPlan)pf2.apply((Object)p1$1));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$27(PlanParserSuite $this, Seq limitWindowClauses$1, String baseSql$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String s1 = (String)tuple2._1();
            LogicalPlan p1 = (LogicalPlan)tuple2._2();
            limitWindowClauses$1.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                PlanParserSuite.$anonfun$new$28($this, baseSql$1, s1, p1, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final LogicalPlan insert$1(Map partition, boolean overwrite, boolean ifPartitionNotExists, LogicalPlan plan$1) {
        return new InsertIntoStatement(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"})), partition, (Seq)Nil$.MODULE$, plan$1, overwrite, ifPartitionNotExists, InsertIntoStatement$.MODULE$.apply$default$7());
    }

    private static final boolean insert$default$2$1() {
        return false;
    }

    private static final boolean insert$default$3$1() {
        return false;
    }

    private static final void test$1(String sql, JoinType jt, Seq tests) {
        tests.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.apply((Object)sql, (Object)jt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Seq $anonfun$new$53(int x) {
        return (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x)), (List)Nil$.MODULE$);
    }

    private final void assertTrimPlans$1(String inputSQL, Expression expectedExpression) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(inputSQL), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias(expectedExpression, UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
    }

    private final void assertOverlayPlans$1(String inputSQL, Expression expectedExpression) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(inputSQL), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias(expectedExpression, UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
    }

    public static final /* synthetic */ void $anonfun$new$72(PlanParserSuite $this, String version$1, LogicalPlan plan$2, String keyword) {
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(27).append("SELECT * FROM a.b.c ").append(keyword).append(" AS OF ").append(version$1).toString()), plan$2, $this.comparePlans$default$3());
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(31).append("SELECT * FROM a.b.c FOR ").append(keyword).append(" AS OF ").append(version$1).toString()), plan$2, $this.comparePlans$default$3());
    }

    private final void testVersion$1(String version, LogicalPlan plan) {
        ((IterableLike)new .colon.colon((Object)"VERSION", (List)new .colon.colon((Object)"SYSTEM_VERSION", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)keyword -> {
            PlanParserSuite.$anonfun$new$72(this, version, plan, keyword);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$73(PlanParserSuite $this, String timestamp$1, LogicalPlan plan$3, String keyword) {
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(27).append("SELECT * FROM a.b.c ").append(keyword).append(" AS OF ").append(timestamp$1).toString()), plan$3, $this.comparePlans$default$3());
        $this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringBuilder(31).append("SELECT * FROM a.b.c FOR ").append(keyword).append(" AS OF ").append(timestamp$1).toString()), plan$3, $this.comparePlans$default$3());
    }

    private final void testTimestamp$1(String timestamp, LogicalPlan plan) {
        ((IterableLike)new .colon.colon((Object)"TIMESTAMP", (List)new .colon.colon((Object)"SYSTEM_TIME", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)keyword -> {
            PlanParserSuite.$anonfun$new$73(this, timestamp, plan, keyword);
            return BoxedUnit.UNIT;
        });
    }

    private final void assertPercentilePlans$1(String inputSQL, Expression expectedExpression) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(inputSQL), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias(expectedExpression, UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
    }

    public PlanParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("single comment case one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("-- single comment\nSELECT * FROM a", plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("single comment case two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("-- single comment\\\nwith line continuity\nSELECT * FROM a", plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("bracketed comment case one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/* This is an example of SQL which should not execute:\n        | * select 'multi-line';\n        | */\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("bracketed comment case two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*\n        |SELECT 'trailing' as x1; -- inside block comment\n        |*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("nested bracketed comment case one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/* This block comment surrounds a query which itself has a block comment...\n        |SELECT /* embedded single line */ 'embedded' AS x2;\n        |*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("nested bracketed comment case two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT -- continued after the following block comments...\n        |/* Deeply nested comment.\n        |   This includes a single apostrophe to make sure we aren't decoding this part as a string.\n        |SELECT 'deep nest' AS n1;\n        |/* Second level of nesting...\n        |SELECT 'deeper nest' as n2;\n        |/* Third level of nesting...\n        |SELECT 'deepest nest' as n3;\n        |*/\n        |Hoo boy. Still two deep...\n        |*/\n        |Now just one deep...\n        |*/\n        |* FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("nested bracketed comment case three", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/* This block comment surrounds a query which itself has a block comment...\n        |//* I am a nested bracketed comment.\n        |*/\n        |*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("nested bracketed comment case four", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*/**/*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("nested bracketed comment case five", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*/*abc*/*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("nested bracketed comment case six", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*/*foo*//*bar*/*/\n        |SELECT * FROM a\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("nested bracketed comment case seven", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).as("a")}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |/*abc*/\n        |select 1 as a\n        |/*\n        |\n        |2 as b\n        |/*abc */\n        |, 3 as c\n        |\n        |/**/\n        |*/\n      ")).stripMargin(), plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("unclosed bracketed comment one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String query = new StringOps(Predef$.MODULE$.augmentString("/*abc*/\n                  |select 1 as a\n                  |/*\n                  |\n                  |2 as b\n                  |/*abc */\n                  |, 3 as c\n                  |\n                  |/**/\n                  |")).stripMargin();
            SparkThrowable x$1 = this.parseException(query);
            String x$2 = "UNCLOSED_BRACKETED_COMMENT";
            Map x$3 = Predef$.MODULE$.Map().empty();
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError(x$1, x$2, x$4, x$3, x$5, x$6);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("unclosed bracketed comment two", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String query = new StringOps(Predef$.MODULE$.augmentString("/*abc*/\n                  |select 1 as a\n                  |/*\n                  |\n                  |2 as b\n                  |/*abc */\n                  |, 3 as c\n                  |\n                  |/**/\n                  |select 4 as d\n                  |")).stripMargin();
            SparkThrowable x$7 = this.parseException(query);
            String x$8 = "UNCLOSED_BRACKETED_COMMENT";
            Map x$9 = Predef$.MODULE$.Map().empty();
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            QueryContext[] x$12 = this.checkError$default$6();
            this.checkError(x$7, x$8, x$10, x$9, x$11, x$12);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("case insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("sELEct * FroM a", plan);
            this.assertEqual("select * fRoM a", plan);
            this.assertEqual("SELECT * FROM a", plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("explain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql1 = "EXPLAIN logical SELECT 1";
            this.checkError(this.parseException(sql1), "_LEGACY_ERROR_TEMP_0039", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply(sql1, 0, 23));
            String sql2 = "EXPLAIN formatted SELECT 1";
            this.checkError(this.parseException(sql2), "_LEGACY_ERROR_TEMP_0039", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply(sql2, 0, 25));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("SPARK-42552: select and union without parentheses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Distinct plan = new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))}))).union(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))}))));
            this.assertEqual("select 1 union select 1", (LogicalPlan)plan);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
        this.test("set operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan a = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan b = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("select * from a union select * from b", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b)));
            this.assertEqual("select * from a union distinct select * from b", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b)));
            this.assertEqual("select * from a union all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).union(b));
            this.assertEqual("select * from a except select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a except distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a except all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, true));
            this.assertEqual("select * from a minus select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a minus all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, true));
            this.assertEqual("select * from a minus distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).except(b, false));
            this.assertEqual("select * from a intersect select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, false));
            this.assertEqual("select * from a intersect distinct select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, false));
            this.assertEqual("select * from a intersect all select * from b", package.plans$.MODULE$.DslLogicalPlan(a).intersect(b, true));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("common table expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("with cte1 as (select * from a) select * from cte1", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Object)Nil$.MODULE$))})));
            this.assertEqual("with cte1 (select 1) select * from cte1", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), (Object)Nil$.MODULE$))})));
            this.assertEqual("with cte1 (select 1), cte2 as (select * from cte1) select * from cte2", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte2"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})), (Object)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte2"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Object)Nil$.MODULE$))})));
            String sql = "with cte1 (select 1), cte1 as (select 1 from cte1) select * from cte1";
            this.checkError(this.parseException(sql), "_LEGACY_ERROR_TEMP_0038", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicateNames"), (Object)"'cte1'")})), (QueryContext)this.ExpectedContext().apply(sql, 0, 68));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("simple select query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select 1", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})));
            this.assertEqual("select a, b", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("select a, b from db.c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("select a, b from db.c where x < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("select a, b from db.c having x < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).having((Seq)Nil$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}), (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(1))));
            this.assertEqual("select distinct a, b from db.c", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))));
            this.assertEqual("select all a, b from db.c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("select from tbl", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from"}))).$((Seq)Nil$.MODULE$)).as("tbl")})));
            this.assertEqual("select a from 1k.2m", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1k", "2m"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("hive-style single-FROM statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("from a select b, c", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("from db.a select b, c where d < 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "a"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("from a select distinct b, c", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))));
            String sql1 = "from a";
            SparkThrowable x$13 = this.parseException(sql1);
            String x$14 = "PARSE_SYNTAX_ERROR";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"end of input"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            QueryContext[] x$18 = this.checkError$default$6();
            this.checkError(x$13, x$14, x$16, x$15, x$17, x$18);
            String sql2 = "from (from a union all from b) c select *";
            SparkThrowable x$19 = this.parseException(sql2);
            String x$20 = "PARSE_SYNTAX_ERROR";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'union'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            QueryContext[] x$24 = this.checkError$default$6();
            this.checkError(x$19, x$20, x$22, x$21, x$23, x$24);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("multi select query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("from a select * select * where s < 10", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))));
            String sql1 = "from a select * select * from x where a.s < 10";
            SparkThrowable x$25 = this.parseException(sql1);
            String x$26 = "PARSE_SYNTAX_ERROR";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'from'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            QueryContext[] x$30 = this.checkError$default$6();
            this.checkError(x$25, x$26, x$28, x$27, x$29, x$30);
            String sql2 = "from a select * from b";
            SparkThrowable x$31 = this.parseException(sql2);
            String x$32 = "PARSE_SYNTAX_ERROR";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'from'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            QueryContext[] x$36 = this.checkError$default$6();
            this.checkError(x$31, x$32, x$34, x$33, x$35, x$36);
            this.assertEqual("from a insert into tbl1 select * insert into tbl2 select * where s < 10", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("tbl1")).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("tbl2")));
            this.assertEqual("select * from (from a select * select *)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))).as("__auto_generated_subquery_name")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("query organization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String baseSql = "select * from t";
            LogicalPlan basePlan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            Map ws = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w1"), (Object)new WindowSpecDefinition((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (WindowFrame)UnspecifiedFrame$.MODULE$))}));
            Seq limitWindowClauses = (Seq)new .colon.colon((Object)new Tuple2((Object)"", (Function1 & Serializable & scala.Serializable)p -> p), (List)new .colon.colon((Object)new Tuple2((Object)" limit 10", (Function1 & Serializable & scala.Serializable)p -> package.plans$.MODULE$.DslLogicalPlan(p).limit((Expression)package.expressions$.MODULE$.intToLiteral(10))), (List)new .colon.colon((Object)new Tuple2((Object)" window w1 as ()", (Function1 & Serializable & scala.Serializable)p -> new WithWindowDefinition(ws, p)), (List)new .colon.colon((Object)new Tuple2((Object)" window w1 as () limit 10", (Function1 & Serializable & scala.Serializable)p -> package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new WithWindowDefinition(ws, p)).limit((Expression)package.expressions$.MODULE$.intToLiteral(10))), (List)Nil$.MODULE$))));
            Seq orderSortDistrClusterClauses = (Seq)new .colon.colon((Object)new Tuple2((Object)"", (Object)basePlan), (List)new .colon.colon((Object)new Tuple2((Object)" order by a, b desc", (Object)package.plans$.MODULE$.DslLogicalPlan(basePlan).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).asc(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).desc()}))), (List)new .colon.colon((Object)new Tuple2((Object)" sort by a, b desc", (Object)package.plans$.MODULE$.DslLogicalPlan(basePlan).sortBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).asc(), package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).desc()}))), (List)Nil$.MODULE$)));
            orderSortDistrClusterClauses.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PlanParserSuite.$anonfun$new$27(this, limitWindowClauses, baseSql, x0$1);
                return BoxedUnit.UNIT;
            });
            String sql1 = new StringBuilder(21).append(baseSql).append(" order by a sort by a").toString();
            this.checkError(this.parseException(sql1), "UNSUPPORTED_FEATURE.COMBINATION_QUERY_RESULT_CLAUSES", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("order by a sort by a", 16, 35));
            String sql2 = new StringBuilder(29).append(baseSql).append(" cluster by a distribute by a").toString();
            this.checkError(this.parseException(sql2), "UNSUPPORTED_FEATURE.COMBINATION_QUERY_RESULT_CLAUSES", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("cluster by a distribute by a", 16, 43));
            String sql3 = new StringBuilder(24).append(baseSql).append(" order by a cluster by a").toString();
            this.checkError(this.parseException(sql3), "UNSUPPORTED_FEATURE.COMBINATION_QUERY_RESULT_CLAUSES", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("order by a cluster by a", 16, 38));
            String sql4 = new StringBuilder(27).append(baseSql).append(" order by a distribute by a").toString();
            this.checkError(this.parseException(sql4), "UNSUPPORTED_FEATURE.COMBINATION_QUERY_RESULT_CLAUSES", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("order by a distribute by a", 16, 41));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        this.test("insert into", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringBuilder(25).append("insert overwrite table s ").append(sql).toString(), PlanParserSuite.insert$1(Predef$.MODULE$.Map().empty(), true, PlanParserSuite.insert$default$3$1(), plan));
            this.assertEqual(new StringBuilder(57).append("insert overwrite table s partition (e = 1) if not exists ").append(sql).toString(), PlanParserSuite.insert$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)Option$.MODULE$.apply((Object)"1"))})), true, true, plan));
            this.assertEqual(new StringBuilder(14).append("insert into s ").append(sql).toString(), PlanParserSuite.insert$1(Predef$.MODULE$.Map().empty(), PlanParserSuite.insert$default$2$1(), PlanParserSuite.insert$default$3$1(), plan));
            this.assertEqual(new StringBuilder(47).append("insert into table s partition (c = 'd', e = 1) ").append(sql).toString(), PlanParserSuite.insert$1((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Option$.MODULE$.apply((Object)"d")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)Option$.MODULE$.apply((Object)"1"))})), PlanParserSuite.insert$default$2$1(), PlanParserSuite.insert$default$3$1(), plan));
            LogicalPlan plan2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)package.expressions$.MODULE$.intToLiteral(5)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("from t insert into s select * limit 1 insert into u select * where x > 5", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)package.expressions$.MODULE$.intToLiteral(1))).insertInto("s")).union(package.plans$.MODULE$.DslLogicalPlan(plan2).insertInto("u")));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        this.test("aggregation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select a, b, sum(c) as c from d group by a, b";
            String sqlWithoutGroupBy = "select a, b, sum(c) as c from d";
            this.assertEqual(sql, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c")})));
            this.assertEqual(new StringBuilder(10).append(sql).append(" with cube").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Cube$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c")})));
            this.assertEqual(new StringBuilder(20).append(sqlWithoutGroupBy).append(" group by cube(a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Cube$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c")})));
            this.assertEqual(new StringBuilder(21).append(sqlWithoutGroupBy).append(" group by cube (a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Cube$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c")})));
            this.assertEqual(new StringBuilder(12).append(sql).append(" with rollup").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Rollup$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c")})));
            this.assertEqual(new StringBuilder(22).append(sqlWithoutGroupBy).append(" group by rollup(a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Rollup$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c")})));
            this.assertEqual(new StringBuilder(23).append(sqlWithoutGroupBy).append(" group by rollup (a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Rollup$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c")})));
            this.assertEqual(new StringBuilder(31).append(sql).append(" grouping sets((a, b), (a), ())").toString(), (LogicalPlan)new Aggregate((Seq)new .colon.colon((Object)GroupingSets$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c"), (List)Nil$.MODULE$))), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))));
            this.assertEqual(new StringBuilder(40).append(sqlWithoutGroupBy).append(" group by grouping sets((a, b), (a), ())").toString(), (LogicalPlan)new Aggregate((Seq)new .colon.colon((Object)GroupingSets$.MODULE$.apply((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)}))).as("c"), (List)Nil$.MODULE$))), package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))));
            String sql1 = "SELECT a, b, count(distinct a, distinct b) as c FROM d GROUP BY a, b";
            SparkThrowable x$37 = this.parseException(sql1);
            String x$38 = "PARSE_SYNTAX_ERROR";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'b'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)": extra input 'b'")}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            QueryContext[] x$42 = this.checkError$default$6();
            this.checkError(x$37, x$38, x$40, x$39, x$41, x$42);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual(new StringBuilder(9).append(sql).append(" limit 10").toString(), package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)package.expressions$.MODULE$.intToLiteral(10)));
            this.assertEqual(new StringBuilder(25).append(sql).append(" limit cast(9 / 4 as int)").toString(), package.plans$.MODULE$.DslLogicalPlan(plan).limit((Expression)new Cast(package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)9))).$div((Expression)package.expressions$.MODULE$.intToLiteral(4)), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4())));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        this.test("window spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            WindowSpecDefinition spec = new WindowSpecDefinition((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).asc(), (List)Nil$.MODULE$), (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, package.expressions$.MODULE$.DslExpression((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).unary_$minus(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
            Map ws1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w1"), (Object)spec), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w2"), (Object)spec), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"w3"), (Object)spec)}));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(149).append(sql).append("\n         |window w1 as (partition by a, b order by c rows between 1 preceding and 1 following),\n         |       w2 as w1,\n         |       w3 as w1").toString())).stripMargin(), (LogicalPlan)new WithWindowDefinition(ws1, plan));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        this.test("lateral view", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedGenerator explode = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("explode"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$));
            UnresolvedGenerator jsonTuple = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("json_tuple"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"y"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)));
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            UnresolvedGenerator x$43 = explode;
            Some x$44 = new Some((Object)"expl");
            Seq x$45 = (Seq)new .colon.colon((Object)"x", (List)Nil$.MODULE$);
            Seq x$46 = qual$1.generate$default$2();
            boolean x$47 = qual$1.generate$default$3();
            this.assertEqual("select * from t lateral view explode(x) expl as x", package.plans$.MODULE$.DslLogicalPlan(qual$1.generate((Generator)x$43, x$46, x$47, (Option)x$44, x$45)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            UnresolvedGenerator x$48 = explode;
            Some x$49 = new Some((Object)"expl");
            Seq x$50 = qual$2.generate$default$2();
            boolean x$51 = qual$2.generate$default$3();
            Seq x$52 = qual$2.generate$default$5();
            package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(qual$2.generate((Generator)x$48, x$50, x$51, (Option)x$49, x$52));
            UnresolvedGenerator x$53 = jsonTuple;
            boolean x$54 = true;
            Some x$55 = new Some((Object)"jtup");
            Seq x$56 = (Seq)new .colon.colon((Object)"q", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$));
            Seq x$57 = qual$3.generate$default$2();
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |lateral view outer json_tuple(x, y) jtup q, z")).stripMargin(), package.plans$.MODULE$.DslLogicalPlan(qual$3.generate((Generator)x$53, x$57, x$54, (Option)x$55, x$56)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            UnresolvedGenerator x$58 = explode;
            Some x$59 = new Some((Object)"expl");
            Seq x$60 = (Seq)new .colon.colon((Object)"x", (List)Nil$.MODULE$);
            Seq x$61 = qual$4.generate$default$2();
            boolean x$62 = qual$4.generate$default$3();
            LogicalPlan from = qual$4.generate((Generator)x$58, x$61, x$62, (Option)x$59, x$60);
            package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(from);
            UnresolvedGenerator x$63 = jsonTuple;
            Some x$64 = new Some((Object)"jtup");
            Seq x$65 = (Seq)new .colon.colon((Object)"q", (List)new .colon.colon((Object)"z", (List)Nil$.MODULE$));
            Seq x$66 = qual$5.generate$default$2();
            boolean x$67 = qual$5.generate$default$3();
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("from t1\n        |lateral view explode(x) expl as x\n        |insert into t2\n        |select *\n        |lateral view json_tuple(x, y) jtup q, z\n        |insert into t3\n        |select *\n        |where s < 10\n      ")).stripMargin(), (LogicalPlan)Union$.MODULE$.apply(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$5.generate((Generator)x$63, x$66, x$67, (Option)x$64, x$65)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("t2"), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(from).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).$((Seq)Nil$.MODULE$)).$less((Expression)package.expressions$.MODULE$.intToLiteral(10)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).insertInto("t3")));
            package.plans$.DslLogicalPlan qual$6 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            UnresolvedGenerator x$68 = new UnresolvedGenerator(FunctionIdentifier$.MODULE$.apply("posexplode"), (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$));
            Some x$69 = new Some((Object)"posexpl");
            Seq x$70 = (Seq)new .colon.colon((Object)"x", (List)new .colon.colon((Object)"y", (List)Nil$.MODULE$));
            Seq x$71 = qual$6.generate$default$2();
            boolean x$72 = qual$6.generate$default$3();
            LogicalPlan expected = package.plans$.MODULE$.DslLogicalPlan(qual$6.generate((Generator)x$68, x$71, x$72, (Option)x$69, x$70)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            this.assertEqual("select * from t lateral view posexplode(x) posexpl as x, y", expected);
            String sql1 = new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |pivot (\n        |  sum(x)\n        |  FOR y IN ('a', 'b')\n        |)")).stripMargin();
            String fragment1 = new StringOps(Predef$.MODULE$.augmentString("from t\n        |lateral view explode(x) expl\n        |pivot (\n        |  sum(x)\n        |  FOR y IN ('a', 'b')\n        |)")).stripMargin();
            this.checkError(this.parseException(sql1), "NOT_ALLOWED_IN_FROM.LATERAL_WITH_PIVOT", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply(fragment1, 9, 84));
            String sql2 = new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |unpivot (\n        |  val FOR y IN (x)\n        |)")).stripMargin();
            String fragment2 = new StringOps(Predef$.MODULE$.augmentString("from t\n        |lateral view explode(x) expl\n        |unpivot (\n        |  val FOR y IN (x)\n        |)")).stripMargin();
            this.checkError(this.parseException(sql2), "NOT_ALLOWED_IN_FROM.LATERAL_WITH_UNPIVOT", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply(fragment2, 9, 74));
            String sql3 = new StringOps(Predef$.MODULE$.augmentString("select *\n        |from t\n        |lateral view explode(x) expl\n        |pivot (\n        |  sum(x)\n        |  FOR y IN ('a', 'b')\n        |)\n        |unpivot (\n        |  val FOR y IN (x)\n        |)")).stripMargin();
            String fragment3 = new StringOps(Predef$.MODULE$.augmentString("from t\n        |lateral view explode(x) expl\n        |pivot (\n        |  sum(x)\n        |  FOR y IN ('a', 'b')\n        |)\n        |unpivot (\n        |  val FOR y IN (x)\n        |)")).stripMargin();
            this.checkError(this.parseException(sql3), "NOT_ALLOWED_IN_FROM.UNPIVOT_WITH_PIVOT", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply(fragment3, 9, 115));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
        this.test("joins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable testUnconditionalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(24).append("select * from t as tt ").append(sql).append(" u").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("tt")).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"})), jt, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testConditionalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(33).append("select * from t ").append(sql).append(" u as uu on a = b").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).as("uu"), jt, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testNaturalJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(35).append("select * from t tt natural ").append(sql).append(" u as uu").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("tt")).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).as("uu"), (JoinType)new NaturalJoin(jt), (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testUsingJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(30).append("select * from t ").append(sql).append(" u using(a, b)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"})), (JoinType)new UsingJoin(jt, (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$))), (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Function2 & Serializable & scala.Serializable testLateralJoin = (Function2 & Serializable & scala.Serializable)(sql, jt) -> {
                this.assertEqual(new StringBuilder(45).append("select * from t ").append(sql).append(" lateral (select * from u) uu").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LateralJoin(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("uu"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4(), LateralSubquery$.MODULE$.apply$default$5()), jt, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                return BoxedUnit.UNIT;
            };
            Seq testAllExceptLateral = (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testConditionalJoin, (List)new .colon.colon((Object)testNaturalJoin, (List)new .colon.colon((Object)testUsingJoin, (List)Nil$.MODULE$))));
            Seq testAll = (Seq)testAllExceptLateral.$colon$plus((Object)testLateralJoin, Seq$.MODULE$.canBuildFrom());
            Seq testExistence = (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testConditionalJoin, (List)new .colon.colon((Object)testUsingJoin, (List)Nil$.MODULE$)));
            PlanParserSuite.test$1("cross join", (JoinType)Cross$.MODULE$, (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testLateralJoin, (List)Nil$.MODULE$)));
            PlanParserSuite.test$1(",", (JoinType)Inner$.MODULE$, (Seq)new .colon.colon((Object)testUnconditionalJoin, (List)new .colon.colon((Object)testLateralJoin, (List)Nil$.MODULE$)));
            PlanParserSuite.test$1("join", (JoinType)Inner$.MODULE$, testAll);
            PlanParserSuite.test$1("inner join", (JoinType)Inner$.MODULE$, testAll);
            PlanParserSuite.test$1("left join", (JoinType)LeftOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("left outer join", (JoinType)LeftOuter$.MODULE$, testAll);
            PlanParserSuite.test$1("right join", (JoinType)RightOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("right outer join", (JoinType)RightOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("full join", (JoinType)FullOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("full outer join", (JoinType)FullOuter$.MODULE$, testAllExceptLateral);
            PlanParserSuite.test$1("left semi join", (JoinType)LeftSemi$.MODULE$, testExistence);
            PlanParserSuite.test$1("semi join", (JoinType)LeftSemi$.MODULE$, testExistence);
            PlanParserSuite.test$1("left anti join", (JoinType)LeftAnti$.MODULE$, testExistence);
            PlanParserSuite.test$1("anti join", (JoinType)LeftAnti$.MODULE$, testExistence);
            String sql1 = "select * from a natural cross join b";
            SparkThrowable x$73 = this.parseException(sql1);
            String x$74 = "INCOMPATIBLE_JOIN_TYPES";
            Map x$75 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType1"), (Object)"NATURAL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType2"), (Object)"CROSS")}));
            String x$76 = "42613";
            SparkFunSuite.ExpectedContext x$77 = this.ExpectedContext().apply("natural cross join b", 16, 35);
            this.checkError(x$73, x$74, x$76, x$75, (QueryContext)x$77);
            String sql2 = "select * from a natural join b on a.id = b.id";
            SparkThrowable x$78 = this.parseException(sql2);
            String x$79 = "PARSE_SYNTAX_ERROR";
            Map x$80 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'on'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$81 = this.checkError$default$3();
            boolean x$82 = this.checkError$default$5();
            QueryContext[] x$83 = this.checkError$default$6();
            this.checkError(x$78, x$79, x$81, x$80, x$82, x$83);
            package.plans$.DslLogicalPlan qual$7 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
            LogicalPlan x$84 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
            JoinType x$85 = qual$7.join$default$2();
            Option x$86 = qual$7.join$default$3();
            package.plans$.DslLogicalPlan qual$8 = package.plans$.MODULE$.DslLogicalPlan(qual$7.join(x$84, x$85, x$86));
            LogicalPlan x$87 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}));
            JoinType x$88 = qual$8.join$default$2();
            Option x$89 = qual$8.join$default$3();
            package.plans$.DslLogicalPlan qual$9 = package.plans$.MODULE$.DslLogicalPlan(qual$8.join(x$87, x$88, x$89));
            LogicalPlan x$90 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}));
            RightOuter$ x$91 = RightOuter$.MODULE$;
            Option x$92 = qual$9.join$default$3();
            this.assertEqual("select * from a join b join c right join d", package.plans$.MODULE$.DslLogicalPlan(qual$9.join(x$90, (JoinType)x$91, x$92)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$10 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$93 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            Cross$ x$94 = Cross$.MODULE$;
            Option x$95 = qual$10.join$default$3();
            this.assertEqual("select * from t1 cross join t2 join t3 on t3.id = t1.id join t4 on t4.id = t1.id", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$10.join(x$93, (JoinType)x$94, x$95)).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3.id"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.id"}))).$((Seq)Nil$.MODULE$))))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t4.id"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.id"}))).$((Seq)Nil$.MODULE$))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String sql3 = "select * from t1 inner join t2 inner join t3 on col3 = col2 on col3 = col1";
            SparkThrowable x$96 = this.parseException(sql3);
            String x$97 = "PARSE_SYNTAX_ERROR";
            Map x$98 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'on'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$99 = this.checkError$default$3();
            boolean x$100 = this.checkError$default$5();
            QueryContext[] x$101 = this.checkError$default$6();
            this.checkError(x$96, x$97, x$99, x$98, x$100, x$101);
            this.assertEqual("select * from t1 inner join (t2 inner join t3 on col3 = col2) on col3 = col1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col3"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)))), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col3"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from t1 inner join (t2 inner join t3) on col3 = col2", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col3"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from t1 inner join (t2 inner join t3 on col3 = col2)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).join(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col3"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col2"}))).$((Seq)Nil$.MODULE$)))), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$11 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$102 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"}));
            JoinType x$103 = qual$11.join$default$2();
            Option x$104 = qual$11.join$default$3();
            this.assertEqual("select * from t1, t3 join t2 on t1.col1 = t2.col2", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$11.join(x$102, x$103, x$104)).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2.col2"}))).$((Seq)Nil$.MODULE$))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$12 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$105 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            JoinType x$106 = qual$12.join$default$2();
            Option x$107 = qual$12.join$default$3();
            package.plans$.DslLogicalPlan qual$13 = package.plans$.MODULE$.DslLogicalPlan(qual$12.join(x$105, x$106, x$107));
            LogicalPlan x$108 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"}));
            JoinType x$109 = qual$13.join$default$2();
            Option x$110 = qual$13.join$default$3();
            this.assertEqual("select * from t1 JOIN t2, t3 join t2 on t1.col1 = t2.col2", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(qual$13.join(x$108, x$109, x$110)).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2.col2"}))).$((Seq)Nil$.MODULE$))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_RELATION_PRECEDENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                package.plans$.DslLogicalPlan qual$14 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
                LogicalPlan x$111 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2.col2"}))).$((Seq)Nil$.MODULE$))));
                JoinType x$112 = qual$14.join$default$2();
                Option x$113 = qual$14.join$default$3();
                this.assertEqual("select * from t1, t3 join t2 on t1.col1 = t2.col2", package.plans$.MODULE$.DslLogicalPlan(qual$14.join(x$111, x$112, x$113)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
                package.plans$.DslLogicalPlan qual$15 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
                LogicalPlan x$114 = package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
                JoinType x$115 = qual$15.join$default$2();
                Option x$116 = qual$15.join$default$3();
                package.plans$.DslLogicalPlan qual$16 = package.plans$.MODULE$.DslLogicalPlan(qual$15.join(x$114, x$115, x$116));
                LogicalPlan x$117 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t3"}))).join(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.col1"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2.col2"}))).$((Seq)Nil$.MODULE$))));
                JoinType x$118 = qual$16.join$default$2();
                Option x$119 = qual$16.join$default$3();
                this.assertEqual("select * from t1 JOIN t2, t3 join t2 on t1.col1 = t2.col2", package.plans$.MODULE$.DslLogicalPlan(qual$16.join(x$117, x$118, x$119)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            });
            this.assertEqual("select * from t join lateral (select * from u) uu on true", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LateralJoin(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("uu"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4(), LateralSubquery$.MODULE$.apply$default$5()), (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.booleanToLiteral(true)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select * from a, lateral (select * from b) bb, lateral (select * from c) cc", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new LateralJoin((LogicalPlan)new LateralJoin(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("bb"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4(), LateralSubquery$.MODULE$.apply$default$5()), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$), new LateralSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).as("cc"), LateralSubquery$.MODULE$.apply$default$2(), LateralSubquery$.MODULE$.apply$default$3(), LateralSubquery$.MODULE$.apply$default$4(), LateralSubquery$.MODULE$.apply$default$5()), (JoinType)Inner$.MODULE$, (Option)None$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        this.test("sampled relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql = "select * from t";
            this.assertEqual(new StringBuilder(22).append(sql).append(" tablesample(100 rows)").toString(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).limit((Expression)package.expressions$.MODULE$.intToLiteral(100))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringBuilder(29).append(sql).append(" tablesample(43 percent) as x").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Sample(0.0, 0.43, false, 10L, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("x"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringBuilder(37).append(sql).append(" tablesample(bucket 4 out of 10) as x").toString(), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Sample(0.0, 0.4, false, 10L, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).as("x"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String sql1 = new StringBuilder(42).append(sql).append(" tablesample(bucket 4 out of 10 on x) as x").toString();
            String fragment1 = "tablesample(bucket 4 out of 10 on x)";
            this.checkError(this.parseException(sql1), "_LEGACY_ERROR_TEMP_0015", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"BUCKET x OUT OF y ON colname")})), (QueryContext)this.ExpectedContext().apply(fragment1, 16, 51));
            String sql2 = new StringBuilder(38).append(sql).append(" tablesample(bucket 11 out of 10) as x").toString();
            String fragment2 = "tablesample(bucket 11 out of 10)";
            this.checkError(this.parseException(sql2), "_LEGACY_ERROR_TEMP_0064", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"Sampling fraction (1.1) must be on interval [0, 1]")})), (QueryContext)this.ExpectedContext().apply(fragment2, 16, 47));
            String sql3 = "SELECT * FROM parquet_t0 TABLESAMPLE(300M) s";
            String fragment3 = "TABLESAMPLE(300M)";
            this.checkError(this.parseException(sql3), "_LEGACY_ERROR_TEMP_0015", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"byteLengthLiteral")})), (QueryContext)this.ExpectedContext().apply(fragment3, 25, 41));
            String sql4 = "SELECT * FROM parquet_t0 TABLESAMPLE(BUCKET 3 OUT OF 32 ON rand()) s";
            String fragment4 = "TABLESAMPLE(BUCKET 3 OUT OF 32 ON rand())";
            this.checkError(this.parseException(sql4), "_LEGACY_ERROR_TEMP_0015", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"BUCKET x OUT OF y ON function")})), (QueryContext)this.ExpectedContext().apply(fragment4, 25, 65));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
        this.test("sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan plan = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t0"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)}));
            this.assertEqual("select id from (t0)", plan);
            this.assertEqual("select id from ((((((t0))))))", plan);
            this.assertEqual("(select * from t1) union distinct (select * from t2)", (LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))));
            this.assertEqual("select * from ((select * from t1) union (select * from t2)) t", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).union(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))).as("t")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("select  id\n        |from (((select id from t0)\n        |       union all\n        |       (select  id from t0))\n        |      union all\n        |      (select id from t0)) as u_1\n      ")).stripMargin(), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(plan).union(plan)).union(plan)).as("u_1")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 868));
        this.test("scalar sub-query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select (select max(b) from s) ss from t", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max"}))).$((Seq)Nil$.MODULE$)).function((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4(), ScalarSubquery$.MODULE$.apply$default$5(), ScalarSubquery$.MODULE$.apply$default$6())).as("ss")})));
            this.assertEqual("select * from t where a = (select b from s)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4(), ScalarSubquery$.MODULE$.apply$default$5(), ScalarSubquery$.MODULE$.apply$default$6())))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual("select g from t group by g having a > (select b from s)", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).having((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).$((Seq)Nil$.MODULE$)}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"g"}))).$((Seq)Nil$.MODULE$)}), (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$greater((Expression)new ScalarSubquery(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4(), ScalarSubquery$.MODULE$.apply$default$5(), ScalarSubquery$.MODULE$.apply$default$6()))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
        this.test("table reference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("table t", package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"})));
            this.assertEqual("table d.t", package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d", "t"})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
        this.test("table valued function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            this.assertEqual("select * from range(2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String sql1 = "select * from default.range(2)";
            String fragment1 = "default.range(2)";
            this.checkError(this.parseException(sql1), "INVALID_SQL_SYNTAX.INVALID_TABLE_VALUED_FUNC_NAME", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)"`default`.`range`")})), (QueryContext)this.ExpectedContext().apply(fragment1, 14, 29));
            String sql2 = "select * from spark_catalog.default.range(2)";
            String fragment2 = "spark_catalog.default.range(2)";
            this.checkError(this.parseException(sql2), "INVALID_SQL_SYNTAX.INVALID_TABLE_VALUED_FUNC_NAME", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)"`spark_catalog`.`default`.`range`")})), (QueryContext)this.ExpectedContext().apply(fragment2, 14, 43));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
        this.test("SPARK-20311 range(N) as alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10));
            this.assertEqual("SELECT * FROM range(10) AS t", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7));
            String string = "a";
            this.assertEqual("SELECT * FROM range(7) AS t(a)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)UnresolvedTVFAliases$.MODULE$.apply("range", (LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("range", (Seq)Nil$.MODULE$.$colon$colon((Object)literal2)), (Seq)Nil$.MODULE$.$colon$colon((Object)string)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
        this.test("SPARK-20841 Support table column aliases in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT * FROM testData AS t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$)), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 951));
        this.test("SPARK-20962 Support subquery column aliases in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT * FROM (SELECT a AS x, b AS y FROM t) t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("t"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).as("x"), (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).as("y")}))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
        this.test("SPARK-20963 Support aliases for join relations in FROM clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan src1 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("src1"))).as("s1");
            LogicalPlan src2 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("src2"))).as("s2");
            this.assertEqual("SELECT * FROM (src1 s1 INNER JOIN src2 s2 ON s1.id = s2.id) dst(a, b, c, d)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("dst", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$)))), package.plans$.MODULE$.DslLogicalPlan(src1).join(src2, (JoinType)Inner$.MODULE$, Option$.MODULE$.apply((Object)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s1.id"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s2.id"}))).$((Seq)Nil$.MODULE$))))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        this.test("SPARK-34335 Support referencing subquery with column aliases by table alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("SELECT t.col1, t.col2 FROM (SELECT a AS x, b AS y FROM t) t(col1, col2)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)SubqueryAlias$.MODULE$.apply("t", (LogicalPlan)new UnresolvedSubqueryColumnAliases((Seq)new .colon.colon((Object)"col1", (List)new .colon.colon((Object)"col2", (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("t"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).as("x"), (Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)).as("y")}))))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.col1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t.col2"}))).$((Seq)Nil$.MODULE$)}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989));
        this.test("inline table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("values 1, 2, 3, 4", (LogicalPlan)new UnresolvedInlineTable((Seq)new .colon.colon((Object)"col1", (List)Nil$.MODULE$), (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).map((Function1 & Serializable & scala.Serializable)x -> PlanParserSuite.$anonfun$new$53(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())));
            Seq seq = (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)Nil$.MODULE$));
            Seq seq2 = (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"b"), (List)Nil$.MODULE$));
            this.assertEqual("values (1, 'a'), (2, 'b') as tbl(a, b)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedInlineTable((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)), (Seq)Nil$.MODULE$.$colon$colon((Object)seq2).$colon$colon((Object)seq))).as("tbl"));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001));
        this.test("simple select query with !> and !<", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select a, b from db.c where x !< 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).$greater$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("select a, b from db.c where x !> 1", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).where((Expression)package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))).$((Seq)Nil$.MODULE$)).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1012));
        this.test("select hint syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql1 = "SELECT /*+ HINT() */ * FROM t";
            SparkThrowable x$120 = this.parseException(sql1);
            String x$121 = "PARSE_SYNTAX_ERROR";
            Map x$122 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"')'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$123 = this.checkError$default$3();
            boolean x$124 = this.checkError$default$5();
            QueryContext[] x$125 = this.checkError$default$6();
            this.checkError(x$120, x$121, x$123, x$122, x$124, x$125);
            String sql2 = "SELECT /*+ INDEX(a b c) */ * from default.t";
            SparkThrowable x$126 = this.parseException(sql2);
            String x$127 = "PARSE_SYNTAX_ERROR";
            Map x$128 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'b'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$129 = this.checkError$default$3();
            boolean x$130 = this.checkError$default$5();
            QueryContext[] x$131 = this.checkError$default$6();
            this.checkError(x$126, x$127, x$129, x$128, x$130, x$131);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT */ * FROM t"), (LogicalPlan)new UnresolvedHint("HINT", (Seq)Nil$.MODULE$, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ BROADCASTJOIN(u) */ * FROM t"), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(u) */ * FROM t"), (LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ STREAMTABLE(a,b,c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("STREAMTABLE", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ INDEX(t, emp_job_ix) */ * FROM t"), (LogicalPlan)new UnresolvedHint("INDEX", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"emp_job_ix"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(`default.t`) */ * from `default.t`"), (LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.quoted("default.t"), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default.t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ MAPJOIN(t) */ a from t where true group by a order by a"), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedHint("MAPJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).asc()})), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ COALESCE(10) */ * FROM t"), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("INSERT INTO s SELECT /*+ REPARTITION(100), COALESCE(500), COALESCE(10) */ * FROM t"), (LogicalPlan)new InsertIntoStatement(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"})), Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$, (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)500)), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), false, false, InsertIntoStatement$.MODULE$.apply$default$7()), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ BROADCASTJOIN(u), REPARTITION(100) */ * FROM t"), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            String sql3 = "SELECT /*+ COALESCE(30 + 50) */ * FROM t";
            SparkThrowable x$132 = this.parseException(sql3);
            String x$133 = "PARSE_SYNTAX_ERROR";
            Map x$134 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'+'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$135 = this.checkError$default$3();
            boolean x$136 = this.checkError$default$5();
            QueryContext[] x$137 = this.checkError$default$6();
            this.checkError(x$132, x$133, x$135, x$134, x$136, x$137);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100, c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100, c), COALESCE(50) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)50)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION(100, c), BROADCASTJOIN(u), COALESCE(50) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)50)), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT\n          |/*+ REPARTITION(100, c), BROADCASTJOIN(u), COALESCE(50), REPARTITION(300, c) */\n          |* FROM t\n        ")).stripMargin()), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("BROADCASTJOIN", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"u"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("COALESCE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)50)), (List)Nil$.MODULE$), (LogicalPlan)new UnresolvedHint("REPARTITION", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)300)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION_BY_RANGE(c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ REPARTITION_BY_RANGE(100, c) */ * FROM t"), (LogicalPlan)new UnresolvedHint("REPARTITION_BY_RANGE", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)), (List)new .colon.colon((Object)UnresolvedAttribute$.MODULE$.apply("c"), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1021));
        this.test("SPARK-20854: select hint syntax with expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            Literal literal3 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, array(1, 2, 3)) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)UnresolvedFunction$.MODULE$.apply("array", (Seq)Nil$.MODULE$.$colon$colon((Object)literal3).$colon$colon((Object)literal2).$colon$colon((Object)literal), false), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 5, 'a', b) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5)), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
            UnresolvedAttribute unresolvedAttribute = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$);
            UnresolvedAttribute unresolvedAttribute2 = package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$);
            Literal literal4 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            Literal literal5 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1('a', (b, c), (1, 2)) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"a"), (List)new .colon.colon((Object)CreateStruct$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute)), (List)new .colon.colon((Object)CreateStruct$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)literal5).$colon$colon((Object)literal4)), (List)Nil$.MODULE$))), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1144));
        this.test("SPARK-20854: multiple hints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1) hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1),hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1) */ /*+ hint2(b, 2) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})))), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT /*+ HINT1(a, 1), hint2(b, 2) */ /*+ hint3(c, 3) */ * from t"), (LogicalPlan)new UnresolvedHint("HINT1", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint2", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), (LogicalPlan)new UnresolvedHint("hint3", (Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)3)), (List)Nil$.MODULE$)), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))))), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1171));
        this.test("TRIM function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql1 = "select ltrim(both 'S' from 'SS abc S'";
            SparkThrowable x$138 = this.parseException(sql1);
            String x$139 = "PARSE_SYNTAX_ERROR";
            Map x$140 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'from'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$141 = this.checkError$default$3();
            boolean x$142 = this.checkError$default$5();
            QueryContext[] x$143 = this.checkError$default$6();
            this.checkError(x$138, x$139, x$141, x$140, x$142, x$143);
            String sql2 = "select rtrim(trailing 'S' from 'SS abc S'";
            SparkThrowable x$144 = this.parseException(sql2);
            String x$145 = "PARSE_SYNTAX_ERROR";
            Map x$146 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'from'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$147 = this.checkError$default$3();
            boolean x$148 = this.checkError$default$5();
            QueryContext[] x$149 = this.checkError$default$6();
            this.checkError(x$144, x$145, x$147, x$146, x$148, x$149);
            this.assertTrimPlans$1("SELECT TRIM(BOTH '@$%&( )abc' FROM '@ $ % & ()abc ' )", (Expression)new StringTrim((Expression)Literal$.MODULE$.apply((Object)"@ $ % & ()abc "), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"@$%&( )abc"))));
            this.assertTrimPlans$1("SELECT TRIM(LEADING 'c []' FROM '[ ccccbcc ')", (Expression)new StringTrimLeft((Expression)Literal$.MODULE$.apply((Object)"[ ccccbcc "), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"c []"))));
            this.assertTrimPlans$1("SELECT TRIM(TRAILING 'c&^,.' FROM 'bc...,,,&&&ccc')", (Expression)new StringTrimRight((Expression)Literal$.MODULE$.apply((Object)"bc...,,,&&&ccc"), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"c&^,."))));
            this.assertTrimPlans$1("SELECT TRIM(BOTH FROM '  bunch o blanks  ')", (Expression)new StringTrim((Expression)Literal$.MODULE$.apply((Object)"  bunch o blanks  "), (Option)None$.MODULE$));
            this.assertTrimPlans$1("SELECT TRIM(LEADING FROM '  bunch o blanks  ')", (Expression)new StringTrimLeft((Expression)Literal$.MODULE$.apply((Object)"  bunch o blanks  "), (Option)None$.MODULE$));
            this.assertTrimPlans$1("SELECT TRIM(TRAILING FROM '  bunch o blanks  ')", (Expression)new StringTrimRight((Expression)Literal$.MODULE$.apply((Object)"  bunch o blanks  "), (Option)None$.MODULE$));
            this.assertTrimPlans$1("SELECT TRIM('xyz' FROM 'yxTomxx')", (Expression)new StringTrim((Expression)Literal$.MODULE$.apply((Object)"yxTomxx"), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"xyz"))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1211));
        this.test("OVERLAY function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING '_' FROM 6)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"_"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)6))));
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING 'CORE' FROM 7)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"CORE"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7))));
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING 'ANSI ' FROM 7 FOR 0)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"ANSI "), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)7)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0))));
            this.assertOverlayPlans$1("SELECT OVERLAY('Spark SQL' PLACING 'tructured' FROM 2 FOR 4)", (Expression)new Overlay((Expression)Literal$.MODULE$.apply((Object)"Spark SQL"), (Expression)Literal$.MODULE$.apply((Object)"tructured"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1263));
        this.test("precedence of set operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            LogicalPlan a = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan b = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan c = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            LogicalPlan d = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}));
            String query1 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM a\n        |UNION\n        |SELECT * FROM b\n        |EXCEPT\n        |SELECT * FROM c\n        |INTERSECT\n        |SELECT * FROM d\n      ")).stripMargin();
            String query2 = new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT * FROM a\n        |UNION\n        |SELECT * FROM b\n        |EXCEPT ALL\n        |SELECT * FROM c\n        |INTERSECT ALL\n        |SELECT * FROM d\n      ")).stripMargin();
            this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, false), false));
            this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, true), true));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_SETOPS_PRECEDENCE_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(c, false)).intersect(d, false));
                this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(c, true)).intersect(d, true));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_SETOPS_PRECEDENCE_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.assertEqual(query1, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, false), false));
                this.assertEqual(query2, package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Distinct(package.plans$.MODULE$.DslLogicalPlan(a).union(b))).except(package.plans$.MODULE$.DslLogicalPlan(c).intersect(d, true), true));
            });
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1292));
        this.test("create/alter view as insert into table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql1 = "CREATE VIEW testView AS INSERT INTO jt VALUES(1, 1)";
            SparkThrowable x$150 = this.parseException(sql1);
            String x$151 = "PARSE_SYNTAX_ERROR";
            Map x$152 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'INSERT'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$153 = this.checkError$default$3();
            boolean x$154 = this.checkError$default$5();
            QueryContext[] x$155 = this.checkError$default$6();
            this.checkError(x$150, x$151, x$153, x$152, x$154, x$155);
            String sql2 = new StringOps(Predef$.MODULE$.augmentString("CREATE VIEW testView AS FROM jt\n        |INSERT INTO tbl1 SELECT * WHERE jt.id < 5\n        |INSERT INTO tbl2 SELECT * WHERE jt.id > 4")).stripMargin();
            SparkThrowable x$156 = this.parseException(sql2);
            String x$157 = "PARSE_SYNTAX_ERROR";
            Map x$158 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'INSERT'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$159 = this.checkError$default$3();
            boolean x$160 = this.checkError$default$5();
            QueryContext[] x$161 = this.checkError$default$6();
            this.checkError(x$156, x$157, x$159, x$158, x$160, x$161);
            String sql3 = "ALTER VIEW testView AS INSERT INTO jt VALUES(1, 1)";
            SparkThrowable x$162 = this.parseException(sql3);
            String x$163 = "PARSE_SYNTAX_ERROR";
            Map x$164 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'INSERT'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$165 = this.checkError$default$3();
            boolean x$166 = this.checkError$default$5();
            QueryContext[] x$167 = this.checkError$default$6();
            this.checkError(x$162, x$163, x$165, x$164, x$166, x$167);
            String sql4 = new StringOps(Predef$.MODULE$.augmentString("ALTER VIEW testView AS FROM jt\n        |INSERT INTO tbl1 SELECT * WHERE jt.id < 5\n        |INSERT INTO tbl2 SELECT * WHERE jt.id > 4")).stripMargin();
            SparkThrowable x$168 = this.parseException(sql4);
            String x$169 = "PARSE_SYNTAX_ERROR";
            Map x$170 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'INSERT'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$171 = this.checkError$default$3();
            boolean x$172 = this.checkError$default$5();
            QueryContext[] x$173 = this.checkError$default$6();
            this.checkError(x$168, x$169, x$171, x$170, x$172, x$173);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1338));
        this.test("Invalid insert constructs in the query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String sql1 = "SELECT * FROM (INSERT INTO BAR VALUES (2))";
            SparkThrowable x$174 = this.parseException(sql1);
            String x$175 = "PARSE_SYNTAX_ERROR";
            Map x$176 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'BAR'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)": missing ')'")}));
            Option x$177 = this.checkError$default$3();
            boolean x$178 = this.checkError$default$5();
            QueryContext[] x$179 = this.checkError$default$6();
            this.checkError(x$174, x$175, x$177, x$176, x$178, x$179);
            String sql2 = "SELECT * FROM S WHERE C1 IN (INSERT INTO T VALUES (2))";
            SparkThrowable x$180 = this.parseException(sql2);
            String x$181 = "PARSE_SYNTAX_ERROR";
            Map x$182 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'IN'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$183 = this.checkError$default$3();
            boolean x$184 = this.checkError$default$5();
            QueryContext[] x$185 = this.checkError$default$6();
            this.checkError(x$180, x$181, x$183, x$182, x$184, x$185);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1372));
        this.test("relation in v2 catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("TABLE testcat.db.tab", package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"})));
            this.assertEqual("SELECT * FROM testcat.db.tab", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH cte1 AS (SELECT * FROM testcat.db.tab)\n        |SELECT * FROM cte1\n      ")).stripMargin(), (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cte1"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cte1"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Object)Nil$.MODULE$))})));
            this.assertEqual("SELECT /*+ BROADCAST(tab) */ * FROM testcat.db.tab", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat", "db", "tab"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).hint("BROADCAST", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tab"}))).$((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386));
        this.test("CTE with column alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.assertEqual("WITH t(x) AS (SELECT c FROM a) SELECT * FROM t", (LogicalPlan)this.cte(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})), (Seq<Tuple2<String, Tuple2<LogicalPlan, Seq<String>>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t"), (Object)new Tuple2((Object)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)})), (Object)new .colon.colon((Object)"x", (List)Nil$.MODULE$)))}))), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
        this.test("statement containing terminal semicolons", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("select 1;", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.intToLiteral(1)})));
            this.assertEqual("select a, b;", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new OneRowRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("select a, b from db.c;;;", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
            this.assertEqual("select a, b from db.c; ;;  ;", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db", "c"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1409));
        this.test("table valued function with named arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            NamedArgumentExpression namedArgumentExpression = new NamedArgumentExpression("arg1", (Expression)Literal$.MODULE$.apply((Object)"value1"));
            NamedArgumentExpression namedArgumentExpression2 = new NamedArgumentExpression("arg2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.assertEqual("select * from my_tvf(arg1 => 'value1', arg2 => true)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)namedArgumentExpression2).$colon$colon((Object)namedArgumentExpression))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            NamedArgumentExpression namedArgumentExpression3 = new NamedArgumentExpression("arg1", (Expression)Literal$.MODULE$.apply((Object)"value1"));
            NamedArgumentExpression namedArgumentExpression4 = new NamedArgumentExpression("arg2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.assertEqual("select * from my_tvf(2, arg1 => 'value1', arg2 => true)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)namedArgumentExpression4).$colon$colon((Object)namedArgumentExpression3).$colon$colon((Object)literal))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            NamedArgumentExpression namedArgumentExpression5 = new NamedArgumentExpression("arg1", (Expression)Literal$.MODULE$.apply((Object)"value1"));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            NamedArgumentExpression namedArgumentExpression6 = new NamedArgumentExpression("arg2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.assertEqual("select * from my_tvf(arg1 => 'value1', 2, arg2 => true)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)namedArgumentExpression6).$colon$colon((Object)literal2).$colon$colon((Object)namedArgumentExpression5))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            NamedArgumentExpression namedArgumentExpression7 = new NamedArgumentExpression("group", (Expression)Literal$.MODULE$.apply((Object)"abc"));
            this.assertEqual("select * from my_tvf(group => 'abc')", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)namedArgumentExpression7))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1416));
        this.test("table valued function with table arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FunctionTableSubqueryArgumentExpression functionTableSubqueryArgumentExpression = new FunctionTableSubqueryArgumentExpression((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"v1", (List)Nil$.MODULE$), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$2(), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$3());
            FunctionTableSubqueryArgumentExpression functionTableSubqueryArgumentExpression2 = new FunctionTableSubqueryArgumentExpression((LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$2(), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$3());
            this.assertEqual("select * from my_tvf(table (v1), table (select 1))", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)functionTableSubqueryArgumentExpression2).$colon$colon((Object)functionTableSubqueryArgumentExpression))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            NamedArgumentExpression namedArgumentExpression = new NamedArgumentExpression("arg1", (Expression)new FunctionTableSubqueryArgumentExpression((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"v1", (List)Nil$.MODULE$), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$2(), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$3()));
            NamedArgumentExpression namedArgumentExpression2 = new NamedArgumentExpression("arg2", (Expression)new FunctionTableSubqueryArgumentExpression((LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$2(), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$3()));
            this.assertEqual("select * from my_tvf(arg1 => table (v1), arg2 => table (select 1))", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)namedArgumentExpression2).$colon$colon((Object)namedArgumentExpression))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            FunctionTableSubqueryArgumentExpression functionTableSubqueryArgumentExpression3 = new FunctionTableSubqueryArgumentExpression((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"v1", (List)Nil$.MODULE$), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$2(), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$3());
            NamedArgumentExpression namedArgumentExpression3 = new NamedArgumentExpression("arg1", (Expression)new FunctionTableSubqueryArgumentExpression((LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedAlias((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), UnresolvedAlias$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$2(), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$3()));
            this.assertEqual("select * from my_tvf(2, table (v1), arg1 => table (select 1))", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)namedArgumentExpression3).$colon$colon((Object)functionTableSubqueryArgumentExpression3).$colon$colon((Object)literal))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            NamedArgumentExpression namedArgumentExpression4 = new NamedArgumentExpression("arg1", (Expression)new FunctionTableSubqueryArgumentExpression((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"v1", (List)Nil$.MODULE$), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$2(), FunctionTableSubqueryArgumentExpression$.MODULE$.apply$default$3()));
            Literal literal2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
            NamedArgumentExpression namedArgumentExpression5 = new NamedArgumentExpression("arg2", (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.assertEqual("select * from my_tvf(arg1 => table (v1), 2, arg2 => true)", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)UnresolvedTableValuedFunction$.MODULE$.apply("my_tvf", (Seq)Nil$.MODULE$.$colon$colon((Object)namedArgumentExpression5).$colon$colon((Object)literal2).$colon$colon((Object)namedArgumentExpression4))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            String sql1 = "select * from my_tvf(arg1 => table v1)";
            this.checkError(this.parseException(sql1), "INVALID_SQL_SYNTAX.INVALID_TABLE_FUNCTION_IDENTIFIER_ARGUMENT_MISSING_PARENTHESES", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"argumentName"), (Object)"`v1`")})), (QueryContext)this.ExpectedContext().apply("table v1", 29, sql1.length() - 2));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1445));
        this.test("SPARK-32106: TRANSFORM plan", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$186 = "key";
            StringType$ x$187 = StringType$.MODULE$;
            boolean x$188 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$189 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$190 = AttributeReference$.MODULE$.apply$default$5(x$186, (DataType)x$187, x$188, x$189);
            Seq x$191 = AttributeReference$.MODULE$.apply$default$6(x$186, (DataType)x$187, x$188, x$189);
            String x$192 = "value";
            StringType$ x$193 = StringType$.MODULE$;
            boolean x$194 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$195 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$196 = AttributeReference$.MODULE$.apply$default$5(x$192, (DataType)x$193, x$194, x$195);
            Seq x$197 = AttributeReference$.MODULE$.apply$default$6(x$192, (DataType)x$193, x$194, x$195);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |USING 'cat'\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$186, (DataType)x$187, x$188, x$189, x$190, x$191), (List)new .colon.colon((Object)new AttributeReference(x$192, (DataType)x$193, x$194, x$195, x$196, x$197), (List)Nil$.MODULE$)), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, true)));
            String x$198 = "a";
            StringType$ x$199 = StringType$.MODULE$;
            boolean x$200 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$201 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$202 = AttributeReference$.MODULE$.apply$default$5(x$198, (DataType)x$199, x$200, x$201);
            Seq x$203 = AttributeReference$.MODULE$.apply$default$6(x$198, (DataType)x$199, x$200, x$201);
            String x$204 = "b";
            StringType$ x$205 = StringType$.MODULE$;
            boolean x$206 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$207 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$208 = AttributeReference$.MODULE$.apply$default$5(x$204, (DataType)x$205, x$206, x$207);
            Seq x$209 = AttributeReference$.MODULE$.apply$default$6(x$204, (DataType)x$205, x$206, x$207);
            String x$210 = "c";
            StringType$ x$211 = StringType$.MODULE$;
            boolean x$212 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$213 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$214 = AttributeReference$.MODULE$.apply$default$5(x$210, (DataType)x$211, x$212, x$213);
            Seq x$215 = AttributeReference$.MODULE$.apply$default$6(x$210, (DataType)x$211, x$212, x$213);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |USING 'cat' AS (a, b, c)\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$198, (DataType)x$199, x$200, x$201, x$202, x$203), (List)new .colon.colon((Object)new AttributeReference(x$204, (DataType)x$205, x$206, x$207, x$208, x$209), (List)new .colon.colon((Object)new AttributeReference(x$210, (DataType)x$211, x$212, x$213, x$214, x$215), (List)Nil$.MODULE$))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)));
            String x$216 = "a";
            IntegerType$ x$217 = IntegerType$.MODULE$;
            boolean x$218 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$219 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$220 = AttributeReference$.MODULE$.apply$default$5(x$216, (DataType)x$217, x$218, x$219);
            Seq x$221 = AttributeReference$.MODULE$.apply$default$6(x$216, (DataType)x$217, x$218, x$219);
            String x$222 = "b";
            StringType$ x$223 = StringType$.MODULE$;
            boolean x$224 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$225 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$226 = AttributeReference$.MODULE$.apply$default$5(x$222, (DataType)x$223, x$224, x$225);
            Seq x$227 = AttributeReference$.MODULE$.apply$default$6(x$222, (DataType)x$223, x$224, x$225);
            String x$228 = "c";
            LongType$ x$229 = LongType$.MODULE$;
            boolean x$230 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$231 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$232 = AttributeReference$.MODULE$.apply$default$5(x$228, (DataType)x$229, x$230, x$231);
            Seq x$233 = AttributeReference$.MODULE$.apply$default$6(x$228, (DataType)x$229, x$230, x$231);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |USING 'cat' AS (a int, b string, c long)\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$216, (DataType)x$217, x$218, x$219, x$220, x$221), (List)new .colon.colon((Object)new AttributeReference(x$222, (DataType)x$223, x$224, x$225, x$226, x$227), (List)new .colon.colon((Object)new AttributeReference(x$228, (DataType)x$229, x$230, x$231, x$232, x$233), (List)Nil$.MODULE$))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)));
            String x$234 = "a";
            StringType$ x$235 = StringType$.MODULE$;
            boolean x$236 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$237 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$238 = AttributeReference$.MODULE$.apply$default$5(x$234, (DataType)x$235, x$236, x$237);
            Seq x$239 = AttributeReference$.MODULE$.apply$default$6(x$234, (DataType)x$235, x$236, x$237);
            String x$240 = "b";
            StringType$ x$241 = StringType$.MODULE$;
            boolean x$242 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$243 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$244 = AttributeReference$.MODULE$.apply$default$5(x$240, (DataType)x$241, x$242, x$243);
            Seq x$245 = AttributeReference$.MODULE$.apply$default$6(x$240, (DataType)x$241, x$242, x$243);
            String x$246 = "c";
            StringType$ x$247 = StringType$.MODULE$;
            boolean x$248 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$249 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$250 = AttributeReference$.MODULE$.apply$default$5(x$246, (DataType)x$247, x$248, x$249);
            Seq x$251 = AttributeReference$.MODULE$.apply$default$6(x$246, (DataType)x$247, x$248, x$249);
            this.assertEqual(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT DELIMITED\n        |  FIELDS TERMINATED BY '\\t'\n        |  COLLECTION ITEMS TERMINATED BY '\u0002'\n        |  MAP KEYS TERMINATED BY '\u0003'\n        |  LINES TERMINATED BY '\\n'\n        |  NULL DEFINED AS 'null'\n        |  USING 'cat' AS (a, b, c)\n        |  ROW FORMAT DELIMITED\n        |  FIELDS TERMINATED BY '\\t'\n        |  COLLECTION ITEMS TERMINATED BY '\u0004'\n        |  MAP KEYS TERMINATED BY '\u0005'\n        |  LINES TERMINATED BY '\\n'\n        |  NULL DEFINED AS 'NULL'\n        |FROM testData\n      ")).stripMargin(), (LogicalPlan)new ScriptTransformation("cat", (Seq)new .colon.colon((Object)new AttributeReference(x$234, (DataType)x$235, x$236, x$237, x$238, x$239), (List)new .colon.colon((Object)new AttributeReference(x$240, (DataType)x$241, x$242, x$243, x$244, x$245), (List)new .colon.colon((Object)new AttributeReference(x$246, (DataType)x$247, x$248, x$249, x$250, x$251), (List)Nil$.MODULE$))), (LogicalPlan)new Project((Seq)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$))), (LogicalPlan)UnresolvedRelation$.MODULE$.apply(TableIdentifier$.MODULE$.apply("testData"))), new ScriptInputOutputSchema((Seq)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATFIELD", (Object)"\t"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATCOLLITEMS", (Object)"\u0002"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATMAPKEYS", (Object)"\u0003"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATNULL", (Object)"null"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATLINES", (Object)"\n"), (List)Nil$.MODULE$))))), (Seq)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATFIELD", (Object)"\t"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATCOLLITEMS", (Object)"\u0004"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATMAPKEYS", (Object)"\u0005"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATNULL", (Object)"NULL"), (List)new .colon.colon((Object)new Tuple2((Object)"TOK_TABLEROWFORMATLINES", (Object)"\n"), (List)Nil$.MODULE$))))), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)List$.MODULE$.empty(), (Seq)List$.MODULE$.empty(), (Option)None$.MODULE$, (Option)None$.MODULE$, false)));
            String sql = new StringOps(Predef$.MODULE$.augmentString("SELECT TRANSFORM(a, b, c)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n        |  WITH SERDEPROPERTIES(\n        |    \"separatorChar\" = \"\\t\",\n        |    \"quoteChar\" = \"'\",\n        |    \"escapeChar\" = \"\\\\\")\n        |  USING 'cat' AS (a, b, c)\n        |  ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n        |  WITH SERDEPROPERTIES(\n        |    \"separatorChar\" = \"\\t\",\n        |    \"quoteChar\" = \"'\",\n        |    \"escapeChar\" = \"\\\\\")\n        |FROM testData")).stripMargin();
            this.checkError(this.parseException(sql), "UNSUPPORTED_FEATURE.TRANSFORM_NON_HIVE", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply(sql, 0, 393));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1496));
        this.test("as of syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testVersion$1("'Snapshot123456789'", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)new Some((Object)"Snapshot123456789"))));
            this.testVersion$1("123456789", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)new Some((Object)"123456789"))));
            this.testTimestamp$1("'2019-01-29 00:37:58'", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)new Some((Object)Literal$.MODULE$.apply((Object)"2019-01-29 00:37:58")), (Option)None$.MODULE$)));
            this.testTimestamp$1("current_date()", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)new Some((Object)new UnresolvedFunction((Seq)new .colon.colon((Object)"current_date", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$, false, UnresolvedFunction$.MODULE$.apply$default$4(), UnresolvedFunction$.MODULE$.apply$default$5())), (Option)None$.MODULE$)));
            UnresolvedAlias unresolvedAlias = new UnresolvedAlias((Expression)new UnresolvedFunction((Seq)new .colon.colon((Object)"current_date", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$, false, UnresolvedFunction$.MODULE$.apply$default$4(), UnresolvedFunction$.MODULE$.apply$default$5()), UnresolvedAlias$.MODULE$.apply$default$2());
            this.testTimestamp$1("(SELECT current_date())", (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)new RelationTimeTravel((LogicalPlan)new UnresolvedRelation((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))), UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3()), (Option)new Some((Object)new ScalarSubquery((LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias), (LogicalPlan)new OneRowRelation()), ScalarSubquery$.MODULE$.apply$default$2(), ScalarSubquery$.MODULE$.apply$default$3(), ScalarSubquery$.MODULE$.apply$default$4(), ScalarSubquery$.MODULE$.apply$default$5(), ScalarSubquery$.MODULE$.apply$default$6())), (Option)None$.MODULE$)));
            String sql = "SELECT * FROM a.b.c TIMESTAMP AS OF col";
            String fragment = "TIMESTAMP AS OF col";
            this.checkError(this.parseException(sql), "_LEGACY_ERROR_TEMP_0056", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)"timestamp expression cannot refer to any columns")})), (QueryContext)this.ExpectedContext().apply(fragment, 20, 38));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1608));
        this.test("PERCENTILE_CONT & PERCENTILE_DISC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertPercentilePlans$1("SELECT PERCENTILE_CONT(0.1) WITHIN GROUP (ORDER BY col)", (Expression)new PercentileCont((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), PercentileCont$.MODULE$.apply$default$3()).toAggregateExpression());
            this.assertPercentilePlans$1("SELECT PERCENTILE_CONT(0.1) WITHIN GROUP (ORDER BY col DESC)", (Expression)new PercentileCont((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), true).toAggregateExpression());
            this.assertPercentilePlans$1("SELECT PERCENTILE_CONT(0.1) WITHIN GROUP (ORDER BY col) FILTER (WHERE id > 10)", (Expression)new PercentileCont((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), PercentileCont$.MODULE$.apply$default$3()).toAggregateExpression(false, (Option)new Some((Object)new GreaterThan((Expression)UnresolvedAttribute$.MODULE$.apply("id"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))));
            this.assertPercentilePlans$1("SELECT PERCENTILE_DISC(0.1) WITHIN GROUP (ORDER BY col)", (Expression)new PercentileDisc((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), PercentileDisc$.MODULE$.apply$default$3(), PercentileDisc$.MODULE$.apply$default$4(), PercentileDisc$.MODULE$.apply$default$5(), PercentileDisc$.MODULE$.apply$default$6()).toAggregateExpression());
            this.assertPercentilePlans$1("SELECT PERCENTILE_DISC(0.1) WITHIN GROUP (ORDER BY col DESC)", (Expression)new PercentileDisc((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), true, PercentileDisc$.MODULE$.apply$default$4(), PercentileDisc$.MODULE$.apply$default$5(), PercentileDisc$.MODULE$.apply$default$6()).toAggregateExpression());
            this.assertPercentilePlans$1("SELECT PERCENTILE_DISC(0.1) WITHIN GROUP (ORDER BY col) FILTER (WHERE id > 10)", (Expression)new PercentileDisc((Expression)UnresolvedAttribute$.MODULE$.apply("col"), (Expression)new Literal((Object)Decimal$.MODULE$.apply(0.1), (DataType)new DecimalType(1, 1)), PercentileDisc$.MODULE$.apply$default$3(), PercentileDisc$.MODULE$.apply$default$4(), PercentileDisc$.MODULE$.apply$default$5(), PercentileDisc$.MODULE$.apply$default$6()).toAggregateExpression(false, (Option)new Some((Object)new GreaterThan((Expression)UnresolvedAttribute$.MODULE$.apply("id"), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10))))));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1666));
        this.test("SPARK-41271: parsing of named parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedAlias unresolvedAlias = new UnresolvedAlias((Expression)new NamedParameter("param_1"), (Option)None$.MODULE$);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT :param_1"), (LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
            String string = "abs";
            NamedParameter namedParameter = new NamedParameter("1Abc");
            UnresolvedAlias unresolvedAlias2 = new UnresolvedAlias((Expression)new UnresolvedFunction((Seq)Nil$.MODULE$.$colon$colon((Object)string), (Seq)Nil$.MODULE$.$colon$colon((Object)namedParameter), false, UnresolvedFunction$.MODULE$.apply$default$4(), UnresolvedFunction$.MODULE$.apply$default$5()), (Option)None$.MODULE$);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT abs(:1Abc)"), (LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias2), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT * FROM a LIMIT :limitA"), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).limit((Expression)new NamedParameter("limitA")), this.comparePlans$default$3());
            SparkThrowable x$252 = this.parseException("SELECT :-");
            String x$253 = "PARSE_SYNTAX_ERROR";
            Map x$254 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"'-'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$255 = this.checkError$default$3();
            boolean x$256 = this.checkError$default$5();
            QueryContext[] x$257 = this.checkError$default$6();
            this.checkError(x$252, x$253, x$255, x$254, x$256, x$257);
            SparkThrowable x$258 = this.parseException("SELECT :");
            String x$259 = "PARSE_SYNTAX_ERROR";
            Map x$260 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)"end of input"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hint"), (Object)"")}));
            Option x$261 = this.checkError$default$3();
            boolean x$262 = this.checkError$default$5();
            QueryContext[] x$263 = this.checkError$default$6();
            this.checkError(x$258, x$259, x$261, x$260, x$262, x$263);
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1711));
        this.test("SPARK-42553: NonReserved keyword 'interval' can be column name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq = (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"abc"), (List)Nil$.MODULE$);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT interval FROM VALUES ('abc') AS tbl(interval);"), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new UnresolvedInlineTable((Seq)new .colon.colon((Object)"interval", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$.$colon$colon((Object)seq))).as("tbl")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interval"}))).$((Seq)Nil$.MODULE$)})), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1737));
        this.test("SPARK-44066: parsing of positional parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedAlias unresolvedAlias = new UnresolvedAlias((Expression)new PosParameter(7), (Option)None$.MODULE$);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT ?"), (LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
            String string = "abs";
            PosParameter posParameter = new PosParameter(11);
            UnresolvedAlias unresolvedAlias2 = new UnresolvedAlias((Expression)new UnresolvedFunction((Seq)Nil$.MODULE$.$colon$colon((Object)string), (Seq)Nil$.MODULE$.$colon$colon((Object)posParameter), false, UnresolvedFunction$.MODULE$.apply$default$4(), UnresolvedFunction$.MODULE$.apply$default$5()), (Option)None$.MODULE$);
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT abs(?)"), (LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias2), (LogicalPlan)new OneRowRelation()), this.comparePlans$default$3());
            this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan("SELECT * FROM a LIMIT ?"), package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))).limit((Expression)new PosParameter(22)), this.comparePlans$default$3());
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1746));
        this.test("SPARK-45189: Creating UnresolvedRelation from TableIdentifier should include the catalog field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TableIdentifier tableId = new TableIdentifier("t", (Option)new Some((Object)"db"), (Option)new Some((Object)"cat"));
            UnresolvedRelation unresolvedRelation = UnresolvedRelation$.MODULE$.apply(tableId);
            Seq $org_scalatest_assert_macro_left = unresolvedRelation.multipartIdentifier();
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"cat", (List)new .colon.colon((Object)"db", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$)));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1767));
            UnresolvedRelation unresolvedRelation2 = UnresolvedRelation$.MODULE$.apply(tableId, CaseInsensitiveStringMap.empty(), true);
            Seq $org_scalatest_assert_macro_left2 = unresolvedRelation2.multipartIdentifier();
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)"cat", (List)new .colon.colon((Object)"db", (List)new .colon.colon((Object)"t", (List)Nil$.MODULE$)));
            Seq seq3 = $org_scalatest_assert_macro_left2;
            Seq seq4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1769));
            CaseInsensitiveStringMap $org_scalatest_assert_macro_left3 = unresolvedRelation2.options();
            CaseInsensitiveStringMap $org_scalatest_assert_macro_right3 = CaseInsensitiveStringMap.empty();
            CaseInsensitiveStringMap caseInsensitiveStringMap = $org_scalatest_assert_macro_left3;
            CaseInsensitiveStringMap caseInsensitiveStringMap2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(caseInsensitiveStringMap != null ? !caseInsensitiveStringMap.equals(caseInsensitiveStringMap2) : caseInsensitiveStringMap2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1770));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(unresolvedRelation2.isStreaming(), "unresolvedRelation2.isStreaming", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1771));
        }, new Position("PlanParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1764));
    }
}

