/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.DivModLike;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.IntegralDivide$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegralType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Divide `expr1` by `expr2`. It returns NULL if an operand is NULL or `expr2` is 0. The result is casted to long.", examples="\n    Examples:\n      > SELECT 3 _FUNC_ 2;\n       1\n      > SELECT INTERVAL '1-1' YEAR TO MONTH _FUNC_ INTERVAL '-1' MONTH;\n       -13\n  ", since="3.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001\u0002\u0015*\u0001ZB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011!y\u0005A!f\u0001\n\u0003\u0001\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011B)\t\u000bi\u0003A\u0011A.\t\u000bi\u0003A\u0011\u00011\t\u000b\r\u0004A\u0011\t3\t\u000b!\u0004A\u0011I5\t\u000bA\u0004A\u0011I9\t\u000bU\u0004A\u0011\t<\t\r\u0005\u0015\u0001\u0001\"\u0011w\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0004\u0001\t\u0003\n\t\u0002\u0003\u0004\u00020\u0001!\tE\u001e\u0005\u000b\u0003c\u0001\u0001R1A\u0005\n\u0005M\u0002bBA!\u0001\u0011\u0005\u00131\t\u0005\b\u0003\u0013\u0002A\u0011KA&\u0011%\t)\u0006AA\u0001\n\u0003\t9\u0006C\u0005\u0002`\u0001\t\n\u0011\"\u0001\u0002b!I\u0011q\u000f\u0001\u0012\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wB\u0011\"a \u0001\u0003\u0003%\t%!!\t\u0013\u0005E\u0005!!A\u0005\u0002\u0005M\u0005\"CAK\u0001\u0005\u0005I\u0011AAL\u0011%\ti\nAA\u0001\n\u0003\ny\nC\u0005\u0002.\u0002\t\t\u0011\"\u0001\u00020\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0013Q\u0017\u0005\u000e\u0003s\u0003\u0001\u0013aA\u0001\u0002\u0013%\u0011/a/\b\u0013\u0005u\u0017&!A\t\u0002\u0005}g\u0001\u0003\u0015*\u0003\u0003E\t!!9\t\ri\u0003C\u0011AAx\u0011%\t\t\u0010IA\u0001\n\u000b\n\u0019\u0010C\u0005\u0002v\u0002\n\t\u0011\"!\u0002x\"I\u0011q \u0011\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0005\u0003\u0001\u0013\u0011!CA\u0005\u0007A\u0011B!\u0006!#\u0003%\t!a\u001f\t\u0013\t]\u0001%!A\u0005\n\te!AD%oi\u0016<'/\u00197ESZLG-\u001a\u0006\u0003U-\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A&L\u0001\tG\u0006$\u0018\r\\=ti*\u0011afL\u0001\u0004gFd'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0004\u0001M)\u0001aN\u001e?\tB\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\u0011\u0005&t\u0017M]=Be&$\b.\\3uS\u000e\u0004\"\u0001\u000f\u001f\n\u0005uJ#A\u0003#jm6{G\rT5lKB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n9\u0001K]8ek\u000e$\bCA F\u0013\t1\u0005I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#A%\u0011\u0005aR\u0015BA&*\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0011\u00154\u0018\r\\'pI\u0016,\u0012!\u0015\t\u0003%Vs!\u0001O*\n\u0005QK\u0013\u0001C#wC2lu\u000eZ3\n\u0005Y;&!\u0002,bYV,\u0017B\u0001-A\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u0013\u00154\u0018\r\\'pI\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003];z{\u0006C\u0001\u001d\u0001\u0011\u00159u\u00011\u0001J\u0011\u0015iu\u00011\u0001J\u0011\u001dyu\u0001%AA\u0002E#2\u0001X1c\u0011\u00159\u0005\u00021\u0001J\u0011\u0015i\u0005\u00021\u0001J\u0003M\u0019\u0007.Z2l\t&4\u0018\u000eZ3Pm\u0016\u0014h\r\\8x+\u0005)\u0007CA g\u0013\t9\u0007IA\u0004C_>dW-\u00198\u0002\u0013%t\u0007/\u001e;UsB,W#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055l\u0013!\u0002;za\u0016\u001c\u0018BA8m\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005\u0011\bCA6t\u0013\t!HN\u0001\u0005ECR\fG+\u001f9f\u0003\u0019\u0019\u00180\u001c2pYV\tq\u000f\u0005\u0002y\u007f:\u0011\u00110 \t\u0003u\u0002k\u0011a\u001f\u0006\u0003yV\na\u0001\u0010:p_Rt\u0014B\u0001@A\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011a\u0010Q\u0001\u000eI\u0016\u001c\u0017.\\1m\u001b\u0016$\bn\u001c3\u00021\u0011,7-[7bYR{G)\u0019;b)f\u0004XmQ8eK\u001e+g\u000eF\u0002x\u0003\u0017Aa!!\u0004\u000f\u0001\u00049\u0018!\u00043fG&l\u0017\r\u001c*fgVdG/A\tsKN,H\u000e\u001e#fG&l\u0017\r\u001c+za\u0016$\"\"a\u0005\u0002\u001a\u0005\r\u0012qEA\u0016!\rY\u0017QC\u0005\u0004\u0003/a'a\u0003#fG&l\u0017\r\u001c+za\u0016Dq!a\u0007\u0010\u0001\u0004\ti\"\u0001\u0002qcA\u0019q(a\b\n\u0007\u0005\u0005\u0002IA\u0002J]RDq!!\n\u0010\u0001\u0004\ti\"\u0001\u0002tc!9\u0011\u0011F\bA\u0002\u0005u\u0011A\u000193\u0011\u001d\tic\u0004a\u0001\u0003;\t!a\u001d\u001a\u0002\u0017M\fHn\u00149fe\u0006$xN]\u0001\u0004I&4XCAA\u001b!%y\u0014qGA\u001e\u0003w\tY$C\u0002\u0002:\u0001\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\u0007}\ni$C\u0002\u0002@\u0001\u00131!\u00118z\u00035)g/\u00197Pa\u0016\u0014\u0018\r^5p]R1\u00111HA#\u0003\u000fBaa\u0012\nA\u0002\u0005m\u0002BB'\u0013\u0001\u0004\tY$A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)A,!\u0014\u0002R!1\u0011qJ\nA\u0002%\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002TM\u0001\r!S\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001da\u0016\u0011LA.\u0003;Bqa\u0012\u000b\u0011\u0002\u0003\u0007\u0011\nC\u0004N)A\u0005\t\u0019A%\t\u000f=#\u0002\u0013!a\u0001#\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA2U\rI\u0015QM\u0016\u0003\u0003O\u0002B!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u000f!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002v\u0005-$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003{R3!UA3\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0011\t\u0005\u0003\u000b\u000by)\u0004\u0002\u0002\b*!\u0011\u0011RAF\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0015\u0001\u00026bm\u0006LA!!\u0001\u0002\b\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011QD\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY$!'\t\u0013\u0005m%$!AA\u0002\u0005u\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"B1\u00111UAU\u0003wi!!!*\u000b\u0007\u0005\u001d\u0006)\u0001\u0006d_2dWm\u0019;j_:LA!a+\u0002&\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r)\u0017\u0011\u0017\u0005\n\u00037c\u0012\u0011!a\u0001\u0003w\ta!Z9vC2\u001cHcA3\u00028\"I\u00111T\u000f\u0002\u0002\u0003\u0007\u00111H\u0001\u000fgV\u0004XM\u001d\u0013eCR\fG+\u001f9f\u0013\t\u0001\u0018\bK\n\u0001\u0003\u007f\u000b)-a2\u0002L\u00065\u0017\u0011[Aj\u0003/\fI\u000eE\u00029\u0003\u0003L1!a1*\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!3\u0002\u0003\u0013)\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\"\u0015N^5eK\u0002\u0002W\r\u001f9sc\u0001\u0004#-\u001f\u0011aKb\u0004(O\r1/A%#\bE]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011b]\u0002z\u0007/\u001a:b]\u0012\u0004\u0013n\u001d\u0011O+2c\u0005e\u001c:!A\u0016D\bO\u001d\u001aaA%\u001c\b\u0005\r\u0018!)\",\u0007E]3tk2$\b%[:!G\u0006\u001cH/\u001a3!i>\u0004Cn\u001c8h]\u0005AQ\r_1na2,7/\t\u0002\u0002P\u0006\t\tB\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00114A}3UKT\"`AIZ$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!\u0013:#VI\u0015,B\u0019\u0002:\u0013'L\u0019(Ae+\u0015I\u0015\u0011U\u001f\u0002juJ\u0014+IA}3UKT\"`A%sE+\u0012*W\u00032\u0003s%L\u0019(A5{e\n\u0016%<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n4G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t).A\u00034]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002\\\u0006QQ.\u0019;i?\u001a,hnY:\u0002\u001d%sG/Z4sC2$\u0015N^5eKB\u0011\u0001\bI\n\u0005A\u0005\rH\t\u0005\u0005\u0002f\u0006-\u0018*S)]\u001b\t\t9OC\u0002\u0002j\u0002\u000bqA];oi&lW-\u0003\u0003\u0002n\u0006\u001d(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u0011q\\\u0001\ti>\u001cFO]5oOR\u0011\u00111Q\u0001\u0006CB\u0004H.\u001f\u000b\b9\u0006e\u00181`A\u007f\u0011\u001595\u00051\u0001J\u0011\u0015i5\u00051\u0001J\u0011\u001dy5\u0005%AA\u0002E\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)A!\u0005\u0011\u000b}\u00129Aa\u0003\n\u0007\t%\u0001I\u0001\u0004PaRLwN\u001c\t\u0007\u007f\t5\u0011*S)\n\u0007\t=\u0001I\u0001\u0004UkBdWm\r\u0005\t\u0005')\u0013\u0011!a\u00019\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0001\u0003BAC\u0005;IAAa\b\u0002\b\n1qJ\u00196fGR\u0004")
public class IntegralDivide
extends BinaryArithmetic
implements DivModLike {
    private Function2<Object, Object, Object> div;
    private final Expression left;
    private final Expression right;
    private final Enumeration.Value evalMode;
    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    private volatile byte bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$3() {
        return IntegralDivide$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Enumeration.Value>> unapply(IntegralDivide integralDivide) {
        return IntegralDivide$.MODULE$.unapply(integralDivide);
    }

    public static Enumeration.Value apply$default$3() {
        return IntegralDivide$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Enumeration.Value>, IntegralDivide> tupled() {
        return IntegralDivide$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Enumeration.Value, IntegralDivide>>> curried() {
        return IntegralDivide$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ DataType org$apache$spark$sql$catalyst$expressions$DivModLike$$super$dataType() {
        return super.dataType();
    }

    @Override
    public boolean nullable() {
        return DivModLike.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return DivModLike.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return DivModLike.doGenCode$(this, ctx, ev);
    }

    private Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero = DivModLike.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    @Override
    public Function1<Object, Object> org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$DivModLike$$isZero;
    }

    private /* synthetic */ DataType super$dataType() {
        return super.dataType();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    @Override
    public boolean checkDivideOverflow() {
        DataType dataType = this.left().dataType();
        return LongType$.MODULE$.equals(dataType) && this.failOnError();
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, DecimalType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String symbol() {
        return "/";
    }

    @Override
    public String decimalMethod() {
        return "quot";
    }

    @Override
    public String decimalToDataTypeCodeGen(String decimalResult) {
        return new StringBuilder(9).append(decimalResult).append(".toLong()").toString();
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int intDig = p1 - s1 + s2;
        return DecimalType$.MODULE$.bounded(intDig == 0 ? 1 : intDig, 0);
    }

    @Override
    public String sqlOperator() {
        return "div";
    }

    private Function2<Object, Object, Object> div$lzycompute() {
        IntegralDivide integralDivide = this;
        synchronized (integralDivide) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DecimalType decimalType;
                Option option;
                Decimal.DecimalAsIfIntegral$ decimalAsIfIntegral$;
                DataType dataType = this.left().dataType();
                if (dataType instanceof IntegralType) {
                    IntegralType integralType = (IntegralType)dataType;
                    decimalAsIfIntegral$ = PhysicalIntegralType$.MODULE$.integral(integralType);
                } else if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    decimalAsIfIntegral$ = PhysicalDecimalType$.MODULE$.apply(p, s).asIntegral();
                } else if (dataType instanceof YearMonthIntervalType) {
                    decimalAsIfIntegral$ = PhysicalIntegerType$.MODULE$.integral();
                } else if (dataType instanceof DayTimeIntervalType) {
                    decimalAsIfIntegral$ = PhysicalLongType$.MODULE$.integral();
                } else {
                    throw new MatchError((Object)dataType);
                }
                Decimal.DecimalAsIfIntegral$ integral = decimalAsIfIntegral$;
                this.div = (Function2 & Serializable & scala.Serializable)(x, y) -> {
                    Object res;
                    Object object;
                    DecimalType decimalType;
                    Option option;
                    DataType dataType = this.super$dataType();
                    if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                        int precision = ((Tuple2)option.get())._1$mcI$sp();
                        int scale = ((Tuple2)option.get())._2$mcI$sp();
                        object = this.checkDecimalOverflow((Decimal)integral.quot(x, y), precision, scale);
                    } else {
                        object = res = integral.quot(x, y);
                    }
                    if (res == null) {
                        return null;
                    }
                    return BoxesRunTime.boxToLong((long)integral.toLong(res));
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.div;
    }

    private Function2<Object, Object, Object> div() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.div$lzycompute();
        }
        return this.div;
    }

    @Override
    public Object evalOperation(Object left, Object right) {
        return this.div().apply(left, right);
    }

    @Override
    public IntegralDivide withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public IntegralDivide copy(Expression left, Expression right, Enumeration.Value evalMode) {
        return new IntegralDivide(left, right, evalMode);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Enumeration.Value copy$default$3() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "IntegralDivide";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalMode();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntegralDivide;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntegralDivide)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntegralDivide integralDivide = (IntegralDivide)x$1;
        Expression expression = this.left();
        Expression expression2 = integralDivide.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = integralDivide.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = integralDivide.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!integralDivide.canEqual(this)) return false;
        return true;
    }

    public IntegralDivide(Expression left, Expression right, Enumeration.Value evalMode) {
        this.left = left;
        this.right = right;
        this.evalMode = evalMode;
        DivModLike.$init$(this);
    }

    public IntegralDivide(Expression left, Expression right) {
        this(left, right, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

