/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M2Aa\u0001\u0003\u0001#!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C\t\u0001RI\u001d:peB\u000b'o]3s'VLG/\u001a\u0006\u0003\u000b\u0019\ta\u0001]1sg\u0016\u0014(BA\u0004\t\u0003!\u0019\u0017\r^1msN$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011c\u0001\u0001\u0013-A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005]QR\"\u0001\r\u000b\u0005e1\u0011\u0001C1oC2L8/[:\n\u0005mA\"\u0001D!oC2L8/[:UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0005\u00039\u0001\u0018M]:f\u000bb\u001cW\r\u001d;j_:$\"AI\u0013\u0011\u0005M\u0019\u0013B\u0001\u0013\u000b\u00059\u0019\u0006/\u0019:l)\"\u0014xn^1cY\u0016DQ!\u0003\u0002A\u0002\u0019\u0002\"a\n\u0019\u000f\u0005!r\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u0011\u0003\u0019a$o\\8u})\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tyC\u0006")
public class ErrorParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public /* synthetic */ Option org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError$default$3() {
        return super.checkError$default$3();
    }

    @Override
    public /* synthetic */ boolean org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError$default$5() {
        return super.checkError$default$5();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$checkError(SparkThrowable exception, String errorClass, Option sqlState, Map parameters, boolean matchPVals, QueryContext[] queryContext) {
        super.checkError(exception, errorClass, sqlState, parameters, matchPVals, queryContext);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorClass(LogicalPlan inputPlan, String expectedErrorClass, Map<String, String> expectedMessageParameters, QueryContext[] queryContext, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorClass$(this, inputPlan, expectedErrorClass, expectedMessageParameters, queryContext, caseSensitive);
    }

    @Override
    public QueryContext[] assertAnalysisErrorClass$default$4() {
        return AnalysisTest.assertAnalysisErrorClass$default$4$(this);
    }

    @Override
    public boolean assertAnalysisErrorClass$default$5() {
        return AnalysisTest.assertAnalysisErrorClass$default$5$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> errorClass) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, errorClass);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public ParseException parseException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.parseException$(this, parser, sqlText);
    }

    @Override
    public SparkException internalException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.internalException$(this, parser, sqlText);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        ErrorParserSuite errorParserSuite = this;
        synchronized (errorParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public SparkThrowable parseException(String sql) {
        return (SparkThrowable)this.intercept((Function0 & Serializable & scala.Serializable)() -> CatalystSqlParser$.MODULE$.parsePlan(sql), ClassTag$.MODULE$.apply(ParseException.class), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
    }

    public ErrorParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("semantic errors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkError(this.parseException("select *\nfrom r\norder by q\ncluster by q"), "UNSUPPORTED_FEATURE.COMBINATION_QUERY_RESULT_CLAUSES", Predef$.MODULE$.Map().empty(), (QueryContext)this.ExpectedContext().apply("order by q\ncluster by q", 16, 38)), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("hyphen in identifier - DDL tests", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkThrowable x$1 = this.parseException("USE test-test");
            String x$2 = "INVALID_IDENTIFIER";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-test")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError(x$1, x$2, x$4, x$3, x$5, x$6);
            SparkThrowable x$7 = this.parseException("CREATE DATABASE IF NOT EXISTS my-database");
            String x$8 = "INVALID_IDENTIFIER";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"my-database")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            QueryContext[] x$12 = this.checkError$default$6();
            this.checkError(x$7, x$8, x$10, x$9, x$11, x$12);
            SparkThrowable x$13 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n        |ALTER DATABASE my-database\n        |SET DBPROPERTIES ('p1'='v1')")).stripMargin());
            String x$14 = "INVALID_IDENTIFIER";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"my-database")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            QueryContext[] x$18 = this.checkError$default$6();
            this.checkError(x$13, x$14, x$16, x$15, x$17, x$18);
            SparkThrowable x$19 = this.parseException("DROP DATABASE my-database");
            String x$20 = "INVALID_IDENTIFIER";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"my-database")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            QueryContext[] x$24 = this.checkError$default$6();
            this.checkError(x$19, x$20, x$22, x$21, x$23, x$24);
            SparkThrowable x$25 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |ALTER TABLE t\n          |CHANGE COLUMN\n          |test-col TYPE BIGINT\n        ")).stripMargin());
            String x$26 = "INVALID_IDENTIFIER";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-col")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            QueryContext[] x$30 = this.checkError$default$6();
            this.checkError(x$25, x$26, x$28, x$27, x$29, x$30);
            SparkThrowable x$31 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |ALTER TABLE t\n          |RENAME COLUMN\n          |test-col TO test\n        ")).stripMargin());
            String x$32 = "INVALID_IDENTIFIER";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-col")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            QueryContext[] x$36 = this.checkError$default$6();
            this.checkError(x$31, x$32, x$34, x$33, x$35, x$36);
            SparkThrowable x$37 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |ALTER TABLE t\n          |RENAME COLUMN\n          |test TO test-col\n        ")).stripMargin());
            String x$38 = "INVALID_IDENTIFIER";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-col")}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            QueryContext[] x$42 = this.checkError$default$6();
            this.checkError(x$37, x$38, x$40, x$39, x$41, x$42);
            SparkThrowable x$43 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |ALTER TABLE t\n          |DROP COLUMN\n          |test-col, test\n        ")).stripMargin());
            String x$44 = "INVALID_IDENTIFIER";
            Map x$45 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-col")}));
            Option x$46 = this.checkError$default$3();
            boolean x$47 = this.checkError$default$5();
            QueryContext[] x$48 = this.checkError$default$6();
            this.checkError(x$43, x$44, x$46, x$45, x$47, x$48);
            SparkThrowable x$49 = this.parseException("CREATE TABLE test (attri-bute INT)");
            String x$50 = "INVALID_IDENTIFIER";
            Map x$51 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"attri-bute")}));
            Option x$52 = this.checkError$default$3();
            boolean x$53 = this.checkError$default$5();
            QueryContext[] x$54 = this.checkError$default$6();
            this.checkError(x$49, x$50, x$52, x$51, x$53, x$54);
            SparkThrowable x$55 = this.parseException("CREATE FUNCTION test-func as org.test.func");
            String x$56 = "INVALID_IDENTIFIER";
            Map x$57 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-func")}));
            Option x$58 = this.checkError$default$3();
            boolean x$59 = this.checkError$default$5();
            QueryContext[] x$60 = this.checkError$default$6();
            this.checkError(x$55, x$56, x$58, x$57, x$59, x$60);
            SparkThrowable x$61 = this.parseException("DROP FUNCTION test-func as org.test.func");
            String x$62 = "INVALID_IDENTIFIER";
            Map x$63 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-func")}));
            Option x$64 = this.checkError$default$3();
            boolean x$65 = this.checkError$default$5();
            QueryContext[] x$66 = this.checkError$default$6();
            this.checkError(x$61, x$62, x$64, x$63, x$65, x$66);
            SparkThrowable x$67 = this.parseException("SHOW FUNCTIONS LIKE test-func");
            String x$68 = "INVALID_IDENTIFIER";
            Map x$69 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-func")}));
            Option x$70 = this.checkError$default$3();
            boolean x$71 = this.checkError$default$5();
            QueryContext[] x$72 = this.checkError$default$6();
            this.checkError(x$67, x$68, x$70, x$69, x$71, x$72);
            SparkThrowable x$73 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE IF NOT EXISTS mydb.page-view\n          |USING parquet\n          |COMMENT 'This is the staging page view table'\n          |LOCATION '/user/external/page_view'\n          |TBLPROPERTIES ('p1'='v1', 'p2'='v2')\n          |AS SELECT * FROM src")).stripMargin());
            String x$74 = "INVALID_IDENTIFIER";
            Map x$75 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"page-view")}));
            Option x$76 = this.checkError$default$3();
            boolean x$77 = this.checkError$default$5();
            QueryContext[] x$78 = this.checkError$default$6();
            this.checkError(x$73, x$74, x$76, x$75, x$77, x$78);
            SparkThrowable x$79 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE IF NOT EXISTS tab\n          |USING test-provider\n          |AS SELECT * FROM src")).stripMargin());
            String x$80 = "INVALID_IDENTIFIER";
            Map x$81 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-provider")}));
            Option x$82 = this.checkError$default$3();
            boolean x$83 = this.checkError$default$5();
            QueryContext[] x$84 = this.checkError$default$6();
            this.checkError(x$79, x$80, x$82, x$81, x$83, x$84);
            SparkThrowable x$85 = this.parseException("SHOW TABLES IN hyphen-database");
            String x$86 = "INVALID_IDENTIFIER";
            Map x$87 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"hyphen-database")}));
            Option x$88 = this.checkError$default$3();
            boolean x$89 = this.checkError$default$5();
            QueryContext[] x$90 = this.checkError$default$6();
            this.checkError(x$85, x$86, x$88, x$87, x$89, x$90);
            SparkThrowable x$91 = this.parseException("SHOW TABLE EXTENDED IN hyphen-db LIKE \"str\"");
            String x$92 = "INVALID_IDENTIFIER";
            Map x$93 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"hyphen-db")}));
            Option x$94 = this.checkError$default$3();
            boolean x$95 = this.checkError$default$5();
            QueryContext[] x$96 = this.checkError$default$6();
            this.checkError(x$91, x$92, x$94, x$93, x$95, x$96);
            SparkThrowable x$97 = this.parseException("SHOW COLUMNS IN t FROM test-db");
            String x$98 = "INVALID_IDENTIFIER";
            Map x$99 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-db")}));
            Option x$100 = this.checkError$default$3();
            boolean x$101 = this.checkError$default$5();
            QueryContext[] x$102 = this.checkError$default$6();
            this.checkError(x$97, x$98, x$100, x$99, x$101, x$102);
            SparkThrowable x$103 = this.parseException("DESC SCHEMA EXTENDED test-db");
            String x$104 = "INVALID_IDENTIFIER";
            Map x$105 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-db")}));
            Option x$106 = this.checkError$default$3();
            boolean x$107 = this.checkError$default$5();
            QueryContext[] x$108 = this.checkError$default$6();
            this.checkError(x$103, x$104, x$106, x$105, x$107, x$108);
            SparkThrowable x$109 = this.parseException("ANALYZE TABLE test-table PARTITION (part1)");
            String x$110 = "INVALID_IDENTIFIER";
            Map x$111 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-table")}));
            Option x$112 = this.checkError$default$3();
            boolean x$113 = this.checkError$default$5();
            QueryContext[] x$114 = this.checkError$default$6();
            this.checkError(x$109, x$110, x$112, x$111, x$113, x$114);
            SparkThrowable x$115 = this.parseException("LOAD DATA INPATH \"path\" INTO TABLE my-tab");
            String x$116 = "INVALID_IDENTIFIER";
            Map x$117 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"my-tab")}));
            Option x$118 = this.checkError$default$3();
            boolean x$119 = this.checkError$default$5();
            QueryContext[] x$120 = this.checkError$default$6();
            this.checkError(x$115, x$116, x$118, x$117, x$119, x$120);
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("hyphen in identifier - DML tests", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkThrowable x$121 = this.parseException("SELECT * FROM table-with-hyphen");
            String x$122 = "INVALID_IDENTIFIER";
            Map x$123 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"table-with-hyphen")}));
            Option x$124 = this.checkError$default$3();
            boolean x$125 = this.checkError$default$5();
            QueryContext[] x$126 = this.checkError$default$6();
            this.checkError(x$121, x$122, x$124, x$123, x$125, x$126);
            SparkThrowable x$127 = this.parseException("SELECT a-b FROM table-with-hyphen");
            String x$128 = "INVALID_IDENTIFIER";
            Map x$129 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"table-with-hyphen")}));
            Option x$130 = this.checkError$default$3();
            boolean x$131 = this.checkError$default$5();
            QueryContext[] x$132 = this.checkError$default$6();
            this.checkError(x$127, x$128, x$130, x$129, x$131, x$132);
            SparkThrowable x$133 = this.parseException("SELECT a-b AS a-b FROM t");
            String x$134 = "INVALID_IDENTIFIER";
            Map x$135 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"a-b")}));
            Option x$136 = this.checkError$default$3();
            boolean x$137 = this.checkError$default$5();
            QueryContext[] x$138 = this.checkError$default$6();
            this.checkError(x$133, x$134, x$136, x$135, x$137, x$138);
            SparkThrowable x$139 = this.parseException("SELECT a-b FROM table-hyphen WHERE a-b = 0");
            String x$140 = "INVALID_IDENTIFIER";
            Map x$141 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"table-hyphen")}));
            Option x$142 = this.checkError$default$3();
            boolean x$143 = this.checkError$default$5();
            QueryContext[] x$144 = this.checkError$default$6();
            this.checkError(x$139, x$140, x$142, x$141, x$143, x$144);
            SparkThrowable x$145 = this.parseException("SELECT (a - test_func(b-c)) FROM test-table");
            String x$146 = "INVALID_IDENTIFIER";
            Map x$147 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-table")}));
            Option x$148 = this.checkError$default$3();
            boolean x$149 = this.checkError$default$5();
            QueryContext[] x$150 = this.checkError$default$6();
            this.checkError(x$145, x$146, x$148, x$147, x$149, x$150);
            SparkThrowable x$151 = this.parseException("WITH a-b AS (SELECT 1 FROM s) SELECT * FROM s;");
            String x$152 = "INVALID_IDENTIFIER";
            Map x$153 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"a-b")}));
            Option x$154 = this.checkError$default$3();
            boolean x$155 = this.checkError$default$5();
            QueryContext[] x$156 = this.checkError$default$6();
            this.checkError(x$151, x$152, x$154, x$153, x$155, x$156);
            SparkThrowable x$157 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT a, b\n          |FROM t1 JOIN t2\n          |USING (a, b, at-tr)\n        ")).stripMargin());
            String x$158 = "INVALID_IDENTIFIER";
            Map x$159 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"at-tr")}));
            Option x$160 = this.checkError$default$3();
            boolean x$161 = this.checkError$default$5();
            QueryContext[] x$162 = this.checkError$default$6();
            this.checkError(x$157, x$158, x$160, x$159, x$161, x$162);
            SparkThrowable x$163 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT product, category, dense_rank()\n          |OVER (PARTITION BY category ORDER BY revenue DESC) as hyphen-rank\n          |FROM productRevenue\n        ")).stripMargin());
            String x$164 = "INVALID_IDENTIFIER";
            Map x$165 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"hyphen-rank")}));
            Option x$166 = this.checkError$default$3();
            boolean x$167 = this.checkError$default$5();
            QueryContext[] x$168 = this.checkError$default$6();
            this.checkError(x$163, x$164, x$166, x$165, x$167, x$168);
            SparkThrowable x$169 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT a, b\n          |FROM grammar-breaker\n          |WHERE a-b > 10\n          |GROUP BY fake-breaker\n          |ORDER BY c\n        ")).stripMargin());
            String x$170 = "INVALID_IDENTIFIER";
            Map x$171 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"grammar-breaker")}));
            Option x$172 = this.checkError$default$3();
            boolean x$173 = this.checkError$default$5();
            QueryContext[] x$174 = this.checkError$default$6();
            this.checkError(x$169, x$170, x$172, x$171, x$173, x$174);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CatalystSqlParser$.MODULE$.parsePlan(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT a, b\n        |FROM t\n        |WHERE a-b > 10\n        |GROUP BY fake-breaker\n        |ORDER BY c\n      ")).stripMargin()));
            LogicalPlan $org_scalatest_assert_macro_right = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)).$minus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$))).$greater((Expression)package.expressions$.MODULE$.intToLiteral(10)))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fake"}))).$((Seq)Nil$.MODULE$)).$minus((Expression)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"breaker"}))).$((Seq)Nil$.MODULE$))}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$)}))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{package.expressions$.MODULE$.DslAttr(package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$)).asc()}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            SparkThrowable x$175 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT * FROM tab\n          |WINDOW hyphen-window AS\n          |  (PARTITION BY a, b ORDER BY c rows BETWEEN 1 PRECEDING AND 1 FOLLOWING)\n        ")).stripMargin());
            String x$176 = "INVALID_IDENTIFIER";
            Map x$177 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"hyphen-window")}));
            Option x$178 = this.checkError$default$3();
            boolean x$179 = this.checkError$default$5();
            QueryContext[] x$180 = this.checkError$default$6();
            this.checkError(x$175, x$176, x$178, x$177, x$179, x$180);
            SparkThrowable x$181 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT * FROM tab\n          |WINDOW window_ref AS window-ref\n        ")).stripMargin());
            String x$182 = "INVALID_IDENTIFIER";
            Map x$183 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"window-ref")}));
            Option x$184 = this.checkError$default$3();
            boolean x$185 = this.checkError$default$5();
            QueryContext[] x$186 = this.checkError$default$6();
            this.checkError(x$181, x$182, x$184, x$183, x$185, x$186);
            SparkThrowable x$187 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |SELECT tb.*\n          |FROM t-a INNER JOIN tb\n          |ON ta.a = tb.a AND ta.tag = tb.tag\n        ")).stripMargin());
            String x$188 = "INVALID_IDENTIFIER";
            Map x$189 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"t-a")}));
            Option x$190 = this.checkError$default$3();
            boolean x$191 = this.checkError$default$5();
            QueryContext[] x$192 = this.checkError$default$6();
            this.checkError(x$187, x$188, x$190, x$189, x$191, x$192);
            SparkThrowable x$193 = this.parseException(new StringOps(Predef$.MODULE$.augmentString("\n          |FROM test-table\n          |SELECT a\n          |SELECT b\n        ")).stripMargin());
            String x$194 = "INVALID_IDENTIFIER";
            Map x$195 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)"test-table")}));
            Option x$196 = this.checkError$default$3();
            boolean x$197 = this.checkError$default$5();
            QueryContext[] x$198 = this.checkError$default$6();
            this.checkError(x$193, x$194, x$196, x$195, x$197, x$198);
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("datatype not supported", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkError(this.parseException("SELECT cast(1 as badtype)"), "UNSUPPORTED_DATATYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)"\"BADTYPE\"")})), (QueryContext)this.ExpectedContext().apply("badtype", 17, 23));
            this.checkError(this.parseException("SELECT cast('a' as CHAR)"), "DATATYPE_MISSING_SIZE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"\"CHAR\"")})), (QueryContext)this.ExpectedContext().apply("CHAR", 19, 22));
            this.checkError(this.parseException("SELECT cast('a' as Varchar)"), "DATATYPE_MISSING_SIZE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"\"VARCHAR\"")})), (QueryContext)this.ExpectedContext().apply("Varchar", 19, 25));
            this.checkError(this.parseException("SELECT cast('a' as Character)"), "DATATYPE_MISSING_SIZE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"\"CHARACTER\"")})), (QueryContext)this.ExpectedContext().apply("Character", 19, 27));
        }, new Position("ErrorParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
    }
}

