/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.MapZipWith$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(map1, map2, function) - Merges two given maps into a single map by applying\n      function to the pair of values with the same key. For keys only presented in one map,\n      NULL will be passed as the value for the missing key. If an input map contains duplicated\n      keys, only the first entry of the duplicated key is passed into the lambda function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), map(1, 'x', 2, 'y'), (k, v1, v2) -> concat(v1, v2));\n       {1:\"ax\",2:\"by\"}\n      > SELECT _FUNC_(map('a', 1, 'b', 2), map('b', 3, 'c', 4), (k, v1, v2) -> coalesce(v1, 0) + coalesce(v2, 0));\n       {\"a\":1,\"b\":5,\"c\":4}\n  ", since="3.0.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0001\rea\u0001B\u001e=\u0001&C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\tQ\u0002\u0011\t\u0012)A\u0005\u0015\"A\u0011\u000e\u0001BK\u0002\u0013\u0005q\r\u0003\u0005k\u0001\tE\t\u0015!\u0003K\u0011!Y\u0007A!f\u0001\n\u00039\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011A4\t\u0015Q\u0004\u0001\u0013!EDB\u0013%Q\u000f\u0003\u0006\u0002\u0006\u0001A)\u0019!C\u0001\u0003\u000fA!\"!\u0005\u0001\u0011\u000b\u0007I\u0011AA\u0004\u0011)\t)\u0002\u0001EC\u0002\u0013\u0005\u0011q\u0003\u0005\f\u00037\u0001\u0001\u0013!EDB\u0013%Q\u000f\u0003\u0006\u0002\u001e\u0001A)\u0019!C\u0001\u0003\u000fA!\"!\t\u0001\u0011\u000b\u0007I\u0011AA\u0004\u0011)\t)\u0003\u0001EC\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003S\u0001\u0001R1A\u0005\u0002\u0005\u001d\u0001BCA\u0017\u0001!\u0015\r\u0011\"\u0001\u00020!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003O\u0002A\u0011IA*\u0011\u001d\tI\u0007\u0001C!\u0003;Bq!a\u001b\u0001\t\u0003\n9\u0001C\u0004\u0002n\u0001!\t&a\u001c\t\u000f\u0005%\u0005\u0001\"\u0011\u0002\f\"9\u0011\u0011\u0014\u0001\u0005B\u0005-\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\r\u0003W\u0003\u0001\u0013!EDB\u0013%\u0011Q\u0016\u0005\u000b\u0003o\u0003\u0001R1A\u0005\u0002\u0005e\u0006BCA_\u0001!\u0015\r\u0011\"\u0001\u0002:\"Q\u0011\u0011\u0019\u0001\t\u0006\u0004%\t!!/\t\u0015\u0005\u0015\u0007\u0001#b\u0001\n\u0013\t9\rC\u0004\u0002~\u0002!I!a@\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!Q\u0004\u0001\u0005\n\t}\u0001b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u0019\u0011y\u0005\u0001C!O\"1!\u0011\u000b\u0001\u0005B\u001dDaAa\u0015\u0001\t\u0003:\u0007b\u0002B+\u0001\u0011E#q\u000b\u0005\n\u0005K\u0002\u0011\u0011!C\u0001\u0005OB\u0011Ba\u001c\u0001#\u0003%\tA!\u001d\t\u0013\t\u001d\u0005!%A\u0005\u0002\tE\u0004\"\u0003BE\u0001E\u0005I\u0011\u0001B9\u0011%\u0011Y\tAA\u0001\n\u0003\u0012i\tC\u0005\u0003\u001e\u0002\t\t\u0011\"\u0001\u0003 \"I!\u0011\u0015\u0001\u0002\u0002\u0013\u0005!1\u0015\u0005\n\u0005S\u0003\u0011\u0011!C!\u0005WC\u0011B!.\u0001\u0003\u0003%\tAa.\t\u0013\tm\u0006!!A\u0005B\tuv!\u0003Bqy\u0005\u0005\t\u0012\u0001Br\r!YD(!A\t\u0002\t\u0015\bBB76\t\u0003\u0011\u0019\u0010C\u0005\u0003vV\n\t\u0011\"\u0012\u0003x\"I!\u0011`\u001b\u0002\u0002\u0013\u0005%1 \u0005\n\u0007\u0007)\u0014\u0011!CA\u0007\u000bA\u0011ba\u00046\u0003\u0003%Ia!\u0005\u0003\u00155\u000b\u0007OW5q/&$\bN\u0003\u0002>}\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\ty\u0004)\u0001\u0005dCR\fG._:u\u0015\t\t%)A\u0002tc2T!a\u0011#\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0002\u0001'\u001d\u0001!JT)X;\u000e\u0004\"a\u0013'\u000e\u0003qJ!!\u0014\u001f\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002L\u001f&\u0011\u0001\u000b\u0010\u0002\u0014\u0011&<\u0007.\u001a:Pe\u0012,'OR;oGRLwN\u001c\t\u0003%Vk\u0011a\u0015\u0006\u0003)r\nqaY8eK\u001e,g.\u0003\u0002W'\ny1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000eE\u0002Y7*k\u0011!\u0017\u0006\u00035z\nQ\u0001\u001e:fKNL!\u0001X-\u0003\u0017Q+'O\\1ss2K7.\u001a\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\b!J|G-^2u!\tqF-\u0003\u0002f?\na1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005Q\u0015!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0005gk:\u001cG/[8o\u0003%1WO\\2uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005_B\f(\u000f\u0005\u0002L\u0001!)am\u0002a\u0001\u0015\")\u0011n\u0002a\u0001\u0015\")1n\u0002a\u0001\u0015\u0006ya-\u001e8di&|gNR8s\u000bZ\fG.\u0001\u0003yIUJT#\u0001<\u0011\u000by;\u00180_@\n\u0005a|&A\u0002+va2,7\u0007\u0005\u0002{{6\t1P\u0003\u0002}\u0001\u0006)A/\u001f9fg&\u0011ap\u001f\u0002\t\t\u0006$\u0018\rV=qKB\u0019a,!\u0001\n\u0007\u0005\rqLA\u0004C_>dW-\u00198\u0002\u00171,g\r^&fsRK\b/Z\u000b\u0002s\"\u001a!\"a\u0003\u0011\u0007y\u000bi!C\u0002\u0002\u0010}\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001b1,g\r\u001e,bYV,G+\u001f9fQ\rY\u00111B\u0001\u0016Y\u00164GOV1mk\u0016\u001cuN\u001c;bS:\u001ch*\u001e7m+\u0005y\bf\u0001\u0007\u0002\f\u0005!\u0001\u0010\n\u001c1\u00031\u0011\u0018n\u001a5u\u0017\u0016LH+\u001f9fQ\rq\u00111B\u0001\u000fe&<\u0007\u000e\u001e,bYV,G+\u001f9fQ\ry\u00111B\u0001\u0017e&<\u0007\u000e\u001e,bYV,7i\u001c8uC&t7OT;mY\"\u001a\u0001#a\u0003\u0002\u000f-,\u0017\u0010V=qK\"\u001a\u0011#a\u0003\u0002\u0011=\u0014H-\u001a:j]\u001e,\"!!\r\u0011\r\u0005M\u00121IA%\u001d\u0011\t)$a\u0010\u000f\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000fI\u0003\u0019a$o\\8u}%\t\u0001-C\u0002\u0002B}\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0007\u0005\u0005s\fE\u0002_\u0003\u0017J1!!\u0014`\u0005\r\te.\u001f\u0015\u0004%\u0005-\u0011!C1sOVlWM\u001c;t+\t\t)\u0006E\u0003\u00024\u0005]#*\u0003\u0003\u0002Z\u0005\u001d#aA*fc\u0006i\u0011M]4v[\u0016tG\u000fV=qKN,\"!a\u0018\u0011\r\u0005M\u0012qKA1!\rQ\u00181M\u0005\u0004\u0003KZ(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003%1WO\\2uS>t7/A\u0007gk:\u001cG/[8o)f\u0004Xm]\u0001\tI\u0006$\u0018\rV=qK\u0006a!-\u001b8e\u0013:$XM\u001d8bYR\u0019q.!\u001d\t\u000f\u0005M\u0004\u00041\u0001\u0002v\u0005\ta\r\u0005\u0005_\u0003oR\u00151PAB\u0013\r\tIh\u0018\u0002\n\rVt7\r^5p]J\u0002b!a\r\u0002X\u0005u\u0004#\u00020\u0002\u0000e|\u0018bAAA?\n1A+\u001e9mKJ\u00022aSAC\u0013\r\t9\t\u0010\u0002\u000f\u0019\u0006l'\rZ1Gk:\u001cG/[8o\u0003Y\u0019\u0007.Z2l\u0003J<W/\\3oi\u0012\u000bG/\u0019+za\u0016\u001cHCAAG!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ}\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u0018\u0006E%a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003\u0013\ny\nC\u0005\u0002\"n\u0001\n\u00111\u0001\u0002$\u0006)\u0011N\u001c9viB!\u0011QUAT\u001b\u0005q\u0014bAAU}\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0011AHEN\u001c\u0016\u0005\u0005=\u0006\u0003\u00030x\u0003c\u000b\t,!-\u0011\u0007-\u000b\u0019,C\u0002\u00026r\u00121CT1nK\u0012d\u0015-\u001c2eCZ\u000b'/[1cY\u0016\faa[3z-\u0006\u0014XCAAYQ\ri\u00121B\u0001\nm\u0006dW/Z\u0019WCJD3AHA\u0006\u0003%1\u0018\r\\;feY\u000b'\u000fK\u0002 \u0003\u0017\tqcZ3u\u0017\u0016L8oV5uQZ\u000bG.^3J]\u0012,\u00070Z:\u0016\u0005\u0005%\u0007#\u00030\u0002x\u0005-\u00171ZAl!\u0011\ti-a5\u000e\u0005\u0005='bAAi}\u0005!Q\u000f^5m\u0013\u0011\t).a4\u0003\u0013\u0005\u0013(/Y=ECR\f\u0007CBAm\u0003G\f9/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003\u001diW\u000f^1cY\u0016T1!!9`\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\fYN\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u001dq\u0016qPA%\u0003S\u0004RAXAv\u0003_L1!!<`\u0005\u0015\t%O]1z!\u0015q\u0016\u0011_A{\u0013\r\t\u0019p\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007y\u000b90C\u0002\u0002z~\u00131!\u00138uQ\r\u0001\u00131B\u0001\u0018CN\u001cXM\u001d;TSj,wJZ!se\u0006L()\u001e4gKJ$BA!\u0001\u0003\bA\u0019aLa\u0001\n\u0007\t\u0015qL\u0001\u0003V]&$\bb\u0002B\u0005C\u0001\u0007\u0011Q_\u0001\u0005g&TX-\u0001\fhKR\\U-_:XSRD\u0017J\u001c3fq\u0016\u001ch)Y:u)\u0019\u0011yA!\u0006\u0003\u001aAA\u0011\u0011\u001cB\t\u0003\u0013\nI/\u0003\u0003\u0003\u0014\u0005m'!\u0004'j].,G\rS1tQ6\u000b\u0007\u000fC\u0004\u0003\u0018\t\u0002\r!a3\u0002\u000b-,\u0017p]\u0019\t\u000f\tm!\u00051\u0001\u0002L\u0006)1.Z=te\u0005ar-\u001a;LKf\u001cx+\u001b;i\u0013:$W\r_3t\u0005J,H/\u001a$pe\u000e,GC\u0002B\u0011\u0005O\u0011I\u0003\u0005\u0004\u0002Z\n\r\u0012q]\u0005\u0005\u0005K\tYNA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bb\u0002B\fG\u0001\u0007\u00111\u001a\u0005\b\u00057\u0019\u0003\u0019AAf\u00031qW\u000f\u001c7TC\u001a,WI^1m)!\tIEa\f\u00034\t]\u0002b\u0002B\u0019I\u0001\u0007\u00111U\u0001\tS:\u0004X\u000f\u001e*po\"9!Q\u0007\u0013A\u0002\u0005%\u0013A\u0002<bYV,\u0017\u0007C\u0004\u0003:\u0011\u0002\r!!\u0013\u0002\rY\fG.^33\u0003!qw\u000eZ3OC6,WC\u0001B !\u0011\u0011\tE!\u0013\u000f\t\t\r#Q\t\t\u0004\u0003oy\u0016b\u0001B$?\u00061\u0001K]3eK\u001aLAAa\u0013\u0003N\t11\u000b\u001e:j]\u001eT1Aa\u0012`\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\b_\ne#Q\fB1\u0011\u0019\u0011Y&\u000ba\u0001\u0015\u0006Aa.Z<GSJ\u001cH\u000f\u0003\u0004\u0003`%\u0002\rAS\u0001\n]\u0016<8+Z2p]\u0012DaAa\u0019*\u0001\u0004Q\u0015\u0001\u00038foRC\u0017N\u001d3\u0002\t\r|\u0007/\u001f\u000b\b_\n%$1\u000eB7\u0011\u001d1'\u0006%AA\u0002)Cq!\u001b\u0016\u0011\u0002\u0003\u0007!\nC\u0004lUA\u0005\t\u0019\u0001&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u000f\u0016\u0004\u0015\nU4F\u0001B<!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005u,\u0001\u0006b]:|G/\u0019;j_:LAA!\"\u0003|\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0010B!!\u0011\u0013BN\u001b\t\u0011\u0019J\u0003\u0003\u0003\u0016\n]\u0015\u0001\u00027b]\u001eT!A!'\u0002\t)\fg/Y\u0005\u0005\u0005\u0017\u0012\u0019*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002v\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA%\u0005KC\u0011Ba*1\u0003\u0003\u0005\r!!>\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u000b\u0005\u0004\u00030\nE\u0016\u0011J\u0007\u0003\u0003?LAAa-\u0002`\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ry(\u0011\u0018\u0005\n\u0005O\u0013\u0014\u0011!a\u0001\u0003\u0013\na!Z9vC2\u001cHcA@\u0003@\"I!qU\u001a\u0002\u0002\u0003\u0007\u0011\u0011\n\u0015\u0014\u0001\t\r'\u0011\u001aBf\u0005\u001f\u0014\tN!6\u0003X\nm'Q\u001c\t\u0004\u0017\n\u0015\u0017b\u0001Bdy\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001Bg\u0003\t-(\u0002\t\u0011!A\u0001\u0002sLR+O\u0007~CS.\u001992Y\u0001j\u0017\r\u001d\u001a-A\u0019,hn\u0019;j_:L\u0003%\f\u0011NKJ<Wm\u001d\u0011uo>\u0004s-\u001b<f]\u0002j\u0017\r]:!S:$x\u000eI1!g&tw\r\\3![\u0006\u0004\bEY=!CB\u0004H._5oO*\u0001\u0003\u0005\t\u0011!A\u0019,hn\u0019;j_:\u0004Co\u001c\u0011uQ\u0016\u0004\u0003/Y5sA=4\u0007E^1mk\u0016\u001c\be^5uQ\u0002\"\b.\u001a\u0011tC6,\u0007e[3z]\u00012uN\u001d\u0011lKf\u001c\be\u001c8ms\u0002\u0002(/Z:f]R,G\rI5oA=tW\rI7ba2R\u0001\u0005\t\u0011!A\u0001rU\u000b\u0014'!o&dG\u000e\t2fAA\f7o]3eA\u0005\u001c\b\u0005\u001e5fAY\fG.^3!M>\u0014\b\u0005\u001e5fA5L7o]5oO\u0002ZW-\u001f\u0018!\u0013\u001a\u0004\u0013M\u001c\u0011j]B,H\u000fI7ba\u0002\u001awN\u001c;bS:\u001c\b\u0005Z;qY&\u001c\u0017\r^3e\u0015\u0001\u0002\u0003\u0005\t\u0011!W\u0016L8\u000f\f\u0011p]2L\b\u0005\u001e5fA\u0019L'o\u001d;!K:$(/\u001f\u0011pM\u0002\"\b.\u001a\u0011ekBd\u0017nY1uK\u0012\u00043.Z=!SN\u0004\u0003/Y:tK\u0012\u0004\u0013N\u001c;pAQDW\r\t7b[\n$\u0017\r\t4v]\u000e$\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1[\u0001\u0003.)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)c1\u0002s%Y\u0014-AIb\u0003e\n2(S1\u0002S.\u00199)c1\u0002s\u0005_\u0014-AIb\u0003eJ=(S1\u0002\u0003f\u001b\u0017!mFb\u0003E\u001e\u001a*A5r\u0004eY8oG\u0006$\bF^\u0019-AY\u0014\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!wFR$%\u0019=#YIR$EY=#{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)O\u0005<C\u0006I\u0019-A\u001d\u0012w\u0005\f\u00113S1\u0002S.\u00199)O\t<C\u0006I\u001a-A\u001d\u001aw\u0005\f\u00115S1\u0002\u0003f\u001b\u0017!mFb\u0003E\u001e\u001a*A5r\u0004eY8bY\u0016\u001c8-\u001a\u0015wc1\u0002\u0003'\u000b\u0011,A\r|\u0017\r\\3tG\u0016DcO\r\u0017!a%J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I>#C\nR\u0014\u0007\f\u0012cEi*DFI2#uQj(\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\te\u0017!B\u001a/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001Bp\u00031a\u0017-\u001c2eC~3WO\\2t\u0003)i\u0015\r\u001d.ja^KG\u000f\u001b\t\u0003\u0017V\u001aB!\u000eBtGBA!\u0011\u001eBx\u0015*Su.\u0004\u0002\u0003l*\u0019!Q^0\u0002\u000fI,h\u000e^5nK&!!\u0011\u001fBv\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005G\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u001f\u000bQ!\u00199qYf$ra\u001cB\u007f\u0005\u007f\u001c\t\u0001C\u0003gq\u0001\u0007!\nC\u0003jq\u0001\u0007!\nC\u0003lq\u0001\u0007!*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\u001d11\u0002\t\u0006=\u0006E8\u0011\u0002\t\u0006=^T%J\u0013\u0005\t\u0007\u001bI\u0014\u0011!a\u0001_\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007'\u0001BA!%\u0004\u0016%!1q\u0003BJ\u0005\u0019y%M[3di\u0002")
public class MapZipWith
extends Expression
implements HigherOrderFunction,
CodegenFallback,
TernaryLike<Expression>,
scala.Serializable {
    private Tuple3<DataType, DataType, Object> x$59;
    private transient DataType leftKeyType;
    private transient DataType leftValueType;
    private transient boolean leftValueContainsNull;
    private Tuple3<DataType, DataType, Object> x$60;
    private transient DataType rightKeyType;
    private transient DataType rightValueType;
    private transient boolean rightValueContainsNull;
    private transient DataType keyType;
    private transient Ordering<Object> ordering;
    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$67;
    private transient NamedLambdaVariable keyVar;
    private transient NamedLambdaVariable value1Var;
    private transient NamedLambdaVariable value2Var;
    private transient Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes;
    private final Expression left;
    private final Expression right;
    private final Expression function;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient int bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(MapZipWith mapZipWith) {
        return MapZipWith$.MODULE$.unapply(mapZipWith);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, MapZipWith> tupled() {
        return MapZipWith$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, MapZipWith>>> curried() {
        return MapZipWith$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public final HigherOrderFunction bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        return HigherOrderFunction.bind$(this, f);
    }

    private Seq<Expression> children$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x1000) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 |= 0x1000;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((this.bitmap$trans$0 & 0x1000) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.argumentsResolved$lzycompute();
        }
        return this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x2000) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 |= 0x2000;
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        if ((this.bitmap$trans$0 & 0x2000) == 0) {
            return this.functionsForEval$lzycompute();
        }
        return this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Expression function() {
        return this.function;
    }

    public Expression functionForEval() {
        return (Expression)this.functionsForEval().head();
    }

    private Tuple3<DataType, DataType, Object> x$59$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType = this.left().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                boolean leftValueContainsNull = mapType.valueContainsNull();
                this.x$59 = new Tuple3((Object)leftKeyType, (Object)leftValueType, (Object)BoxesRunTime.boxToBoolean((boolean)leftValueContainsNull));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$59;
    }

    private /* synthetic */ Tuple3 x$59() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$59$lzycompute();
        }
        return this.x$59;
    }

    private DataType leftKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.leftKeyType = (DataType)this.x$59()._1();
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.leftKeyType;
    }

    public DataType leftKeyType() {
        if ((this.bitmap$trans$0 & 1) == 0) {
            return this.leftKeyType$lzycompute();
        }
        return this.leftKeyType;
    }

    private DataType leftValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.leftValueType = (DataType)this.x$59()._2();
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.leftValueType;
    }

    public DataType leftValueType() {
        if ((this.bitmap$trans$0 & 2) == 0) {
            return this.leftValueType$lzycompute();
        }
        return this.leftValueType;
    }

    private boolean leftValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.leftValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$59()._3());
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.leftValueContainsNull;
    }

    public boolean leftValueContainsNull() {
        if ((this.bitmap$trans$0 & 4) == 0) {
            return this.leftValueContainsNull$lzycompute();
        }
        return this.leftValueContainsNull;
    }

    private Tuple3<DataType, DataType, Object> x$60$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                DataType dataType = this.right().dataType();
                if (!(dataType instanceof MapType)) {
                    throw new MatchError((Object)dataType);
                }
                MapType mapType = (MapType)dataType;
                DataType rightKeyType = mapType.keyType();
                DataType rightValueType = mapType.valueType();
                boolean rightValueContainsNull = mapType.valueContainsNull();
                this.x$60 = new Tuple3((Object)rightKeyType, (Object)rightValueType, (Object)BoxesRunTime.boxToBoolean((boolean)rightValueContainsNull));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.x$60;
    }

    private /* synthetic */ Tuple3 x$60() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.x$60$lzycompute();
        }
        return this.x$60;
    }

    private DataType rightKeyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.rightKeyType = (DataType)this.x$60()._1();
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.rightKeyType;
    }

    public DataType rightKeyType() {
        if ((this.bitmap$trans$0 & 8) == 0) {
            return this.rightKeyType$lzycompute();
        }
        return this.rightKeyType;
    }

    private DataType rightValueType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.rightValueType = (DataType)this.x$60()._2();
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.rightValueType;
    }

    public DataType rightValueType() {
        if ((this.bitmap$trans$0 & 0x10) == 0) {
            return this.rightValueType$lzycompute();
        }
        return this.rightValueType;
    }

    private boolean rightValueContainsNull$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.rightValueContainsNull = BoxesRunTime.unboxToBoolean((Object)this.x$60()._3());
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.rightValueContainsNull;
    }

    public boolean rightValueContainsNull() {
        if ((this.bitmap$trans$0 & 0x20) == 0) {
            return this.rightValueContainsNull$lzycompute();
        }
        return this.rightValueContainsNull;
    }

    private DataType keyType$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.keyType = (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags(this.leftKeyType(), this.rightKeyType()).get();
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.keyType;
    }

    public DataType keyType() {
        if ((this.bitmap$trans$0 & 0x40) == 0) {
            return this.keyType$lzycompute();
        }
        return this.keyType;
    }

    private Ordering<Object> ordering$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.keyType());
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.ordering;
    }

    public Ordering<Object> ordering() {
        if ((this.bitmap$trans$0 & 0x80) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.left();
        Expression expression2 = this.right();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        MapType$ mapType$ = MapType$.MODULE$;
        MapType$ mapType$2 = MapType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)mapType$2).$colon$colon((Object)mapType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.function();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$);
    }

    @Override
    public DataType dataType() {
        return new MapType(this.keyType(), this.function().dataType(), this.function().nullable());
    }

    @Override
    public MapZipWith bindInternal(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        Seq arguments = (Seq)new .colon.colon((Object)new Tuple2((Object)this.keyType(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple2((Object)this.leftValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)this.rightValueType(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)arguments);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        TypeCheckResult typeCheckResult = HigherOrderFunction.checkArgumentDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            if (DataTypeUtils$.MODULE$.sameType(this.leftKeyType(), this.rightKeyType())) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(this.leftKeyType(), this.prettyName());
            }
            return new TypeCheckResult.DataTypeMismatch("MAP_ZIP_WITH_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)Cast$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.leftKeyType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.rightKeyType()))}))));
        }
        return typeCheckResult;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.checkArgumentDataTypes();
    }

    @Override
    public Object eval(InternalRow input) {
        Object value1 = this.left().eval(input);
        if (value1 == null) {
            return null;
        }
        Object value2 = this.right().eval(input);
        if (value2 == null) {
            return null;
        }
        return this.nullSafeEval(input, value1, value2);
    }

    private Tuple3<NamedLambdaVariable, NamedLambdaVariable, NamedLambdaVariable> x$67$lzycompute() {
        block5: {
            MapZipWith mapZipWith = this;
            synchronized (mapZipWith) {
                NamedLambdaVariable namedLambdaVariable;
                NamedLambdaVariable namedLambdaVariable2;
                NamedExpression value2Var;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 4) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block6;
                        NamedExpression keyVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        NamedExpression value1Var = (NamedExpression)((SeqLike)some.get()).apply(1);
                        value2Var = (NamedExpression)((SeqLike)some.get()).apply(2);
                        if (!(keyVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable2 = (NamedLambdaVariable)keyVar;
                        if (!(value1Var instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)value1Var;
                        if (value2Var instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable3 = (NamedLambdaVariable)value2Var;
                this.x$67 = new Tuple3((Object)namedLambdaVariable2, (Object)namedLambdaVariable, (Object)namedLambdaVariable3);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$67;
    }

    private /* synthetic */ Tuple3 x$67() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$67$lzycompute();
        }
        return this.x$67;
    }

    private NamedLambdaVariable keyVar$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.keyVar = (NamedLambdaVariable)this.x$67()._1();
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.keyVar;
    }

    public NamedLambdaVariable keyVar() {
        if ((this.bitmap$trans$0 & 0x100) == 0) {
            return this.keyVar$lzycompute();
        }
        return this.keyVar;
    }

    private NamedLambdaVariable value1Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x200) == 0) {
                this.value1Var = (NamedLambdaVariable)this.x$67()._2();
                this.bitmap$trans$0 |= 0x200;
            }
        }
        return this.value1Var;
    }

    public NamedLambdaVariable value1Var() {
        if ((this.bitmap$trans$0 & 0x200) == 0) {
            return this.value1Var$lzycompute();
        }
        return this.value1Var;
    }

    private NamedLambdaVariable value2Var$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x400) == 0) {
                this.value2Var = (NamedLambdaVariable)this.x$67()._3();
                this.bitmap$trans$0 |= 0x400;
            }
        }
        return this.value2Var;
    }

    public NamedLambdaVariable value2Var() {
        if ((this.bitmap$trans$0 & 0x400) == 0) {
            return this.value2Var$lzycompute();
        }
        return this.value2Var;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes$lzycompute() {
        MapZipWith mapZipWith = this;
        synchronized (mapZipWith) {
            if ((this.bitmap$trans$0 & 0x800) == 0) {
                this.getKeysWithValueIndexes = TypeUtils$.MODULE$.typeWithProperEquals(this.keyType()) ? (Function2 & Serializable & scala.Serializable)(keys1, keys2) -> this.getKeysWithIndexesFast((ArrayData)keys1, (ArrayData)keys2) : (Function2 & Serializable & scala.Serializable)(keys1, keys2) -> this.getKeysWithIndexesBruteForce((ArrayData)keys1, (ArrayData)keys2);
                this.bitmap$trans$0 |= 0x800;
            }
        }
        return this.getKeysWithValueIndexes;
    }

    private Function2<ArrayData, ArrayData, Iterable<Tuple2<Object, Option<Object>[]>>> getKeysWithValueIndexes() {
        if ((this.bitmap$trans$0 & 0x800) == 0) {
            return this.getKeysWithValueIndexes$lzycompute();
        }
        return this.getKeysWithValueIndexes;
    }

    private void assertSizeOfArrayBuffer(int size) {
        if (size > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.mapSizeExceedArraySizeWhenZipMapError(size);
        }
    }

    private LinkedHashMap<Object, Option<Object>[]> getKeysWithIndexesFast(ArrayData keys1, ArrayData keys2) {
        LinkedHashMap hashMap = new LinkedHashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)})).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesFast$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$68 -> {
            MapZipWith.$anonfun$getKeysWithIndexesFast$2(this, hashMap, x$68);
            return BoxedUnit.UNIT;
        });
        return hashMap;
    }

    private ArrayBuffer<Tuple2<Object, Option<Object>[]>> getKeysWithIndexesBruteForce(ArrayData keys1, ArrayData keys2) {
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)keys1), new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)keys2)})).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$getKeysWithIndexesBruteForce$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$70 -> {
            MapZipWith.$anonfun$getKeysWithIndexesBruteForce$2(this, arrayBuffer, x$70);
            return BoxedUnit.UNIT;
        });
        return arrayBuffer;
    }

    private Object nullSafeEval(InternalRow inputRow, Object value1, Object value2) {
        MapData mapData1 = (MapData)value1;
        MapData mapData2 = (MapData)value2;
        Iterable keysWithIndexes = (Iterable)this.getKeysWithValueIndexes().apply((Object)mapData1.keyArray(), (Object)mapData2.keyArray());
        int size = keysWithIndexes.size();
        GenericArrayData keys = new GenericArrayData(new Object[size]);
        GenericArrayData values = new GenericArrayData(new Object[size]);
        ArrayData valueData1 = mapData1.valueArray();
        ArrayData valueData2 = mapData2.valueArray();
        IntRef i = IntRef.create((int)0);
        keysWithIndexes.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapZipWith.$anonfun$nullSafeEval$2(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$73 -> {
            MapZipWith.$anonfun$nullSafeEval$3(this, valueData1, valueData2, keys, i, inputRow, values, x$73);
            return BoxedUnit.UNIT;
        });
        return new ArrayBasedMapData(keys, values);
    }

    @Override
    public String nodeName() {
        return "map_zip_with";
    }

    @Override
    public Expression first() {
        return this.left();
    }

    @Override
    public Expression second() {
        return this.right();
    }

    @Override
    public Expression third() {
        return this.function();
    }

    @Override
    public MapZipWith withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public MapZipWith copy(Expression left, Expression right, Expression function) {
        return new MapZipWith(left, right, function);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "MapZipWith";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.function();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MapZipWith;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MapZipWith)) return false;
        boolean bl = true;
        if (!bl) return false;
        MapZipWith mapZipWith = (MapZipWith)x$1;
        Expression expression = this.left();
        Expression expression2 = mapZipWith.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = mapZipWith.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.function();
        Expression expression6 = mapZipWith.function();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!mapZipWith.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesFast$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesFast$2(MapZipWith $this, LinkedHashMap hashMap$1, Tuple2 x$68) {
        Tuple2 tuple2 = x$68;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                Object key = array.get(i, $this.keyType());
                Option option = hashMap$1.get(key);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Option[] indexes = (Option[])some.value();
                    if (indexes[z].isEmpty()) {
                        indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    }
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    hashMap$1.put(key, (Object)indexes);
                    continue;
                }
                throw new MatchError((Object)option);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getKeysWithIndexesBruteForce$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$getKeysWithIndexesBruteForce$2(MapZipWith $this, ArrayBuffer arrayBuffer$1, Tuple2 x$70) {
        Tuple2 tuple2 = x$70;
        if (tuple2 != null) {
            int z = tuple2._1$mcI$sp();
            ArrayData array = (ArrayData)tuple2._2();
            for (int i = 0; i < array.numElements(); ++i) {
                BoxedUnit boxedUnit;
                Object key = array.get(i, $this.keyType());
                boolean found = false;
                for (int j = 0; !found && j < arrayBuffer$1.size(); ++j) {
                    Tuple2 tuple22 = (Tuple2)arrayBuffer$1.apply(j);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object bufferKey = tuple22._1();
                    Option[] indexes = (Option[])tuple22._2();
                    Tuple2 tuple23 = new Tuple2(bufferKey, (Object)indexes);
                    Object bufferKey2 = tuple23._1();
                    Option[] indexes2 = (Option[])tuple23._2();
                    if (!$this.ordering().equiv(bufferKey2, key)) continue;
                    found = true;
                    if (!indexes2[z].isEmpty()) continue;
                    indexes2[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                }
                if (!found) {
                    $this.assertSizeOfArrayBuffer(arrayBuffer$1.size());
                    Option[] indexes = (Option[])((Object[])new Option[]{None$.MODULE$, None$.MODULE$});
                    indexes[z] = new Some((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = arrayBuffer$1.$plus$eq((Object)new Tuple2(key, (Object)indexes));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$nullSafeEval$2(Tuple2 check$ifrefutable$3) {
        Option[] optionArray;
        Option option;
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null && !(option = Array$.MODULE$.unapplySeq((Object)(optionArray = (Option[])tuple2._2()))).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$3(MapZipWith $this, ArrayData valueData1$1, ArrayData valueData2$1, GenericArrayData keys$1, IntRef i$1, InternalRow inputRow$3, GenericArrayData values$1, Tuple2 x$73) {
        Tuple2 tuple2 = x$73;
        if (tuple2 != null) {
            Object key = tuple2._1();
            Option[] optionArray = (Option[])tuple2._2();
            Option option = Array$.MODULE$.unapplySeq((Object)optionArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                Option index1 = (Option)((SeqLike)option.get()).apply(0);
                Option index2 = (Option)((SeqLike)option.get()).apply(1);
                Object v1 = index1.map((Function1 & Serializable & scala.Serializable)x$71 -> valueData1$1.get(BoxesRunTime.unboxToInt((Object)x$71), $this.leftValueType())).orNull(Predef$.MODULE$.$conforms());
                Object v2 = index2.map((Function1 & Serializable & scala.Serializable)x$72 -> valueData2$1.get(BoxesRunTime.unboxToInt((Object)x$72), $this.rightValueType())).orNull(Predef$.MODULE$.$conforms());
                $this.keyVar().value().set(key);
                $this.value1Var().value().set(v1);
                $this.value2Var().value().set(v2);
                keys$1.update(i$1.elem, key);
                Object v = InternalRow$.MODULE$.copyValue($this.functionForEval().eval(inputRow$3));
                values$1.update(i$1.elem, v);
                ++i$1.elem;
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public MapZipWith(Expression left, Expression right, Expression function) {
        this.left = left;
        this.right = right;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        TernaryLike.$init$(this);
    }
}

