/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkNumberFormatException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Tag;
import scala.Double$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.Statics;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001m4A\u0001C\u0005\u0001)!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003a\u0003B\u0002'\u0001A\u0003%Q\u0006C\u0003N\u0001\u0011%a\nC\u0004j\u0001\t\u0007I\u0011\u00026\t\rI\u0004\u0001\u0015!\u0003l\u0011\u0015\u0019\b\u0001\"\u0003u\u00051!UmY5nC2\u001cV/\u001b;f\u0015\tQ1\"A\u0003usB,7O\u0003\u0002\r\u001b\u0005\u00191/\u001d7\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003\u0019\t\u0007/Y2iK*\t!#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001+ey\u0002C\u0001\f\u0018\u001b\u0005i\u0011B\u0001\r\u000e\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011!$H\u0007\u00027)\u0011A$E\u0001\ng\u000e\fG.\u0019;fgRL!AH\u000e\u0003'A\u0013\u0018N^1uK6+G\u000f[8e)\u0016\u001cH/\u001a:\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013!\u00029mC:\u001c(B\u0001\u0013\f\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0014\"\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u0002\u0013\u00051\u0012\r\u001c7TkB\u0004xN\u001d;fIJ{WO\u001c3N_\u0012,7/F\u0001.!\rq3'N\u0007\u0002_)\u0011\u0001'M\u0001\u000bG>dG.Z2uS>t'\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Qz#aA*fcB\u0011a\u0007\u0013\b\u0003o\rs!\u0001\u000f!\u000f\u0005erdB\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0014\u0003\u0019a$o\\8u}%\t!'\u0003\u0002@c\u00059\u0001/Y2lC\u001e,\u0017BA!C\u0003)\u0011\u0015n\u001a#fG&l\u0017\r\u001c\u0006\u0003\u007fEJ!\u0001R#\u0002\u0019I{WO\u001c3j]\u001elu\u000eZ3\u000b\u0005\u00053%BA$2\u0003\u0011i\u0017\r\u001e5\n\u0005%S%!\u0002,bYV,\u0017BA&2\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002/\u0005dGnU;qa>\u0014H/\u001a3S_VtG-T8eKN\u0004\u0013\u0001D2iK\u000e\\G)Z2j[\u0006dG#B(T1\n<\u0007C\u0001)R\u001b\u0005\t\u0014B\u0001*2\u0005\u0011)f.\u001b;\t\u000bQ#\u0001\u0019A+\u0002\u0003\u0011\u0004\"A\u000b,\n\u0005]K!a\u0002#fG&l\u0017\r\u001c\u0005\u00063\u0012\u0001\rAW\u0001\u0007gR\u0014\u0018N\\4\u0011\u0005m{fB\u0001/^!\tQ\u0014'\u0003\u0002_c\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tq\u0016\u0007C\u0003d\t\u0001\u0007A-A\u0005qe\u0016\u001c\u0017n]5p]B\u0011\u0001+Z\u0005\u0003MF\u00121!\u00138u\u0011\u0015AG\u00011\u0001e\u0003\u0015\u00198-\u00197f\u0003)!WmY5nC24\u0016\r\\\u000b\u0002WB\u0019A.\\8\u000e\u0003\u0001I!A\\\u000f\u0003\u001bA\u0013\u0018N^1uK6+G\u000f[8e!\tA\u0004/\u0003\u0002r\u0005\nQ!)[4EK\u000eLW.\u00197\u0002\u0017\u0011,7-[7bYZ\u000bG\u000eI\u0001\rG\",7m[\"p[B\f7\r\u001e\u000b\u0004\u001fV4\b\"\u0002+\b\u0001\u0004)\u0006\"B<\b\u0001\u0004A\u0018\u0001C3ya\u0016\u001cG/\u001a3\u0011\u0005AK\u0018B\u0001>2\u0005\u001d\u0011un\u001c7fC:\u0004")
public class DecimalSuite
extends SparkFunSuite
implements PrivateMethodTester,
SQLHelper {
    private final Seq<Enumeration.Value> allSupportedRoundModes;
    private final PrivateMethodTester.PrivateMethod<BigDecimal> decimalVal;
    private String sparkHome;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private volatile boolean bitmap$0;

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    private String sparkHome$lzycompute() {
        DecimalSuite decimalSuite = this;
        synchronized (decimalSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    public Seq<Enumeration.Value> allSupportedRoundModes() {
        return this.allSupportedRoundModes;
    }

    private void checkDecimal(Decimal d, String string, int precision, int scale) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(d.toString());
        String $org_scalatest_assert_macro_right = string;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d.precision()));
        int $org_scalatest_assert_macro_right2 = precision;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)d.scale()));
        int $org_scalatest_assert_macro_right3 = scale;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
    }

    private PrivateMethodTester.PrivateMethod<BigDecimal> decimalVal() {
        return this.decimalVal;
    }

    private void checkCompact(Decimal d, boolean expected) {
        boolean isCompact;
        boolean $org_scalatest_assert_macro_left = isCompact = this.anyRefToInvoker(d).invokePrivate(this.decimalVal().apply((Seq)Nil$.MODULE$)) == null;
        boolean $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(9).append(d).append(" ").append((Object)(expected ? "was not" : "was")).append(" compact").toString(), Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    private final void PrivateMethod$lzycompute$1() {
        DecimalSuite decimalSuite = this;
        synchronized (decimalSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void checkNegativeScaleDecimal$1(Function0 d) {
        SparkException x$1 = (SparkException)this.intercept(d, ClassTag$.MODULE$.apply(SparkException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        String x$2 = "INTERNAL_ERROR";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"Negative scale is not allowed: -3. Set the config \"spark.sql.legacy.allowNegativeScaleOfDecimal\" to \"true\" to allow it.")}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private final void checkValues$1(Decimal d, double doubleValue, long longValue) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)d.toDouble()));
        double $org_scalatest_assert_macro_right = doubleValue;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)d.toLong()));
        long $org_scalatest_assert_macro_right2 = longValue;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
    }

    public static final /* synthetic */ void $anonfun$new$31(DecimalSuite $this, Enumeration.Value mode$1, String n) {
        ((IterableLike)new .colon.colon((Object)"", (List)new .colon.colon((Object)"-", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)sign -> {
            BigDecimal bd = package$.MODULE$.BigDecimal().apply(new StringBuilder(0).append((String)sign).append(n).toString());
            long unscaled = bd.$times(BigDecimal$.MODULE$.int2bigDecimal(10)).toLongExact();
            Decimal d = Decimal$.MODULE$.apply(unscaled, 8, 1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(d.changePrecision(10, 0, mode$1), "d.changePrecision(10, 0, mode)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(d.toString());
            String $org_scalatest_assert_macro_right = bd.setScale(0, mode$1).toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(13).append("num: ").append((String)sign).append(n).append(", mode: ").append(mode$1).toString(), Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            Decimal copy = d.toPrecision(10, 0, mode$1, d.toPrecision$default$4(), d.toPrecision$default$5());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(copy);
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", null, $org_scalatest_assert_macro_left2.$bang$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            Decimal $org_scalatest_assert_macro_left3 = d;
            Decimal $org_scalatest_assert_macro_right3 = copy;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(d);
            Decimal $org_scalatest_assert_macro_right4 = copy;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(copy.toString());
            String $org_scalatest_assert_macro_right5 = bd.setScale(0, mode$1).toString();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)new StringBuilder(13).append("num: ").append((String)sign).append(n).append(", mode: ").append(mode$1).toString(), Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(DecimalSuite $this, Enumeration.Value mode) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0.4", "0.5", "0.6", "1.0", "1.1", "1.6", "2.5", "5.5"}))).foreach((Function1 & Serializable & scala.Serializable)n -> {
            DecimalSuite.$anonfun$new$31($this, mode, n);
            return BoxedUnit.UNIT;
        });
    }

    private final void checkFromString$1(String string) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.fromString(UTF8String.fromString((String)string)));
        Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(string);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.fromStringANSI(UTF8String.fromString((String)string), Decimal$.MODULE$.fromStringANSI$default$2(), Decimal$.MODULE$.fromStringANSI$default$3()));
        Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(string);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
    }

    private final void checkOutOfRangeFromString$1(String string) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.fromString(UTF8String.fromString((String)string)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        SparkArithmeticException x$1 = (SparkArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.fromStringANSI(UTF8String.fromString((String)string), Decimal$.MODULE$.fromStringANSI$default$2(), Decimal$.MODULE$.fromStringANSI$default$3()), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        String x$2 = "NUMERIC_OUT_OF_SUPPORTED_RANGE";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)string)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        QueryContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    public static final /* synthetic */ void $anonfun$new$43(DecimalSuite $this, String string) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(Decimal$.MODULE$.fromString(UTF8String.fromString((String)string)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        SparkArithmeticException x$43 = (SparkArithmeticException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.fromStringANSI(UTF8String.fromString((String)string), Decimal$.MODULE$.fromStringANSI$default$2(), Decimal$.MODULE$.fromStringANSI$default$3()), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        String x$44 = "NUMERIC_OUT_OF_SUPPORTED_RANGE";
        Map x$45 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)string)}));
        Option x$46 = $this.checkError$default$3();
        boolean x$47 = $this.checkError$default$5();
        QueryContext[] x$48 = $this.checkError$default$6();
        $this.checkError((SparkThrowable)x$43, x$44, x$46, x$45, x$47, x$48);
    }

    public static final /* synthetic */ Tuple3 $anonfun$new$49(int scale$1, int delta) {
        int a = scale$1;
        int b = scale$1 - delta;
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)delta), (Object)BoxesRunTime.boxToInteger((int)a), (Object)BoxesRunTime.boxToInteger((int)b));
    }

    public static final /* synthetic */ Seq $anonfun$new$48(int scale) {
        return (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{38, 20, 19, 18}))).map((Function1 & Serializable & scala.Serializable)delta -> DecimalSuite.$anonfun$new$49(scale, BoxesRunTime.unboxToInt((Object)delta)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int a = BoxesRunTime.unboxToInt((Object)tuple3._2());
                int b = BoxesRunTime.unboxToInt((Object)tuple3._3());
                return (Seq)new .colon.colon((Object)new Tuple2.mcII.sp(a, b), (List)new .colon.colon((Object)new Tuple2.mcII.sp(-a, -b), (List)new .colon.colon((Object)new Tuple2.mcII.sp(b, a), (List)new .colon.colon((Object)new Tuple2.mcII.sp(-b, -a), (List)Nil$.MODULE$))));
            }
            throw new MatchError((Object)tuple3);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$new$53(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$new$54(DecimalSuite $this, long unscaled$1, Enumeration.Value mode$2, int precision$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            int scaleFrom = tuple2._1$mcI$sp();
            int scaleTo = tuple2._2$mcI$sp();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, -1L}))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)sign -> {
                long unscaledWithSign = unscaled$1 * sign;
                if (scaleFrom < 0 || scaleTo < 0) {
                    $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkScaleChange$1(unscaledWithSign, scaleFrom, scaleTo, mode$2, precision$1));
                    return;
                }
                $this.checkScaleChange$1(unscaledWithSign, scaleFrom, scaleTo, mode$2, precision$1);
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$52(DecimalSuite $this, Seq scalePairs$1, long unscaled$1, int precision$1, Enumeration.Value mode) {
        ((TraversableLike)scalePairs$1.flatten((Function1)Predef$.MODULE$.$conforms())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DecimalSuite.$anonfun$new$53(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            DecimalSuite.$anonfun$new$54($this, unscaled$1, mode, precision$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    private final void checkScaleChange$1(long unscaled, int scaleFrom, int scaleTo, Enumeration.Value roundMode, int precision$1) {
        Decimal decimal = Decimal$.MODULE$.apply(unscaled, precision$1, scaleFrom);
        this.checkCompact(decimal, true);
        decimal.changePrecision(precision$1, scaleTo, roundMode);
        BigDecimal bd = package$.MODULE$.BigDecimal().apply(unscaled, scaleFrom).setScale(scaleTo, roundMode);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(decimal.toBigDecimal());
        BigDecimal $org_scalatest_assert_macro_right = bd;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(42).append("unscaled: ").append(unscaled).append(", scaleFrom: ").append(scaleFrom).append(", scaleTo: ").append(scaleTo).append(", mode: ").append(roundMode).toString(), Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
    }

    public DecimalSuite() {
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        SQLHelper.$init$(this);
        this.allSupportedRoundModes = (Seq)new .colon.colon((Object)Decimal$.MODULE$.ROUND_HALF_UP(), (List)new .colon.colon((Object)Decimal$.MODULE$.ROUND_HALF_EVEN(), (List)new .colon.colon((Object)Decimal$.MODULE$.ROUND_CEILING(), (List)new .colon.colon((Object)Decimal$.MODULE$.ROUND_FLOOR(), (List)Nil$.MODULE$))));
        this.test("creating decimals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkDecimal(new Decimal(), "0", 1, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.09")), "0.09", 2, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.9")), "0.9", 1, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.90")), "0.90", 2, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0.0")), "0.0", 1, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("0")), "0", 1, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("1.0")), "1.0", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-0.09")), "-0.09", 2, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-0.9")), "-0.9", 1, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-0.90")), "-0.90", 2, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-1.0")), "-1.0", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030")), "10.030", 5, 3);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 4, 1), "10.0", 4, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 4, 1), "-10.0", 4, 1);
            this.checkDecimal(Decimal$.MODULE$.apply("10.030"), "10.030", 5, 3);
            this.checkDecimal(Decimal$.MODULE$.apply(10.03), "10.03", 4, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(17L), "17", 20, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(17), "17", 10, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(17L, 2, 1), "1.7", 2, 1);
            this.checkDecimal(Decimal$.MODULE$.apply(170L, 4, 2), "1.70", 4, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(17L, 24, 1), "1.7", 24, 1);
            this.checkDecimal(Decimal$.MODULE$.apply((long)1.0E17, 18, 0), Long.toString((long)1.0E17), 18, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(1000000000000000000L, 20, 2), "10000000000000000.00", 20, 2);
            this.checkDecimal(Decimal$.MODULE$.apply(Long.MAX_VALUE), Long.toString(Long.MAX_VALUE), 20, 0);
            this.checkDecimal(Decimal$.MODULE$.apply(Long.MIN_VALUE), Long.toString(Long.MIN_VALUE), 20, 0);
            SparkArithmeticException x$1 = (SparkArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(170L, 2, 1), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            String x$2 = "NUMERIC_VALUE_OUT_OF_RANGE";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\"")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            QueryContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
            SparkArithmeticException x$7 = (SparkArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(170L, 2, 0), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            String x$8 = "NUMERIC_VALUE_OUT_OF_RANGE";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\"")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            QueryContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, x$8, x$10, x$9, x$11, x$12);
            SparkArithmeticException x$13 = (SparkArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 2, 1), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            String x$14 = "DECIMAL_PRECISION_EXCEEDS_MAX_PRECISION";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxPrecision"), (Object)"2")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            QueryContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, x$14, x$16, x$15, x$17, x$18);
            SparkArithmeticException x$19 = (SparkArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 2, 1), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            String x$20 = "DECIMAL_PRECISION_EXCEEDS_MAX_PRECISION";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxPrecision"), (Object)"2")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            QueryContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, x$20, x$22, x$21, x$23, x$24);
            SparkArithmeticException x$25 = (SparkArithmeticException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply((long)1.0E17, 17, 0), ClassTag$.MODULE$.apply(SparkArithmeticException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            String x$26 = "NUMERIC_VALUE_OUT_OF_RANGE";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)"17"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)"\"spark.sql.ansi.enabled\"")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            QueryContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, x$26, x$28, x$27, x$29, x$30);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("creating decimals with negative scale under legacy mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("98765"), 5, -3), "9.9E+4", 5, -3);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("314.159"), 6, -2), "3E+2", 6, -2);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(1.579E12), 4, -9), "1.579E+12", 4, -9);
            this.checkDecimal(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(1.579E12), 4, -10), "1.58E+12", 4, -10);
            this.checkDecimal(Decimal$.MODULE$.apply(103050709L, 9, -10), "1.03050709E+18", 9, -10);
            this.checkDecimal(Decimal$.MODULE$.apply((long)1.0E8, 10, -10), "1.00000000E+18", 10, -10);
        }), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("SPARK-30252: Negative scale is not allowed by default", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkNegativeScaleDecimal$1((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("98765"), 5, -3));
            this.checkNegativeScaleDecimal$1((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("98765").underlying(), 5, -3));
            this.checkNegativeScaleDecimal$1((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.apply(98765L, 5, -3));
            this.checkNegativeScaleDecimal$1((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.createUnsafe(98765L, 5, -3));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("double and long values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkValues$1(new Decimal(), 0.0, 0L);
            this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030")), 10.03, 10L);
            this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.030"), 4, 1), 10.0, 10L);
            this.checkValues$1(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-9.95"), 4, 1), -10.0, -10L);
            this.checkValues$1(Decimal$.MODULE$.apply(10.03), 10.03, 10L);
            this.checkValues$1(Decimal$.MODULE$.apply(17L), 17.0, 17L);
            this.checkValues$1(Decimal$.MODULE$.apply(17), 17.0, 17L);
            this.checkValues$1(Decimal$.MODULE$.apply(17L, 2, 1), 1.7, 1L);
            this.checkValues$1(Decimal$.MODULE$.apply(170L, 4, 2), 1.7, 1L);
            this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E16), 1.0E16, (long)1.0E16);
            this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E17), 1.0E17, (long)1.0E17);
            this.checkValues$1(Decimal$.MODULE$.apply((long)1.0E18), 1.0E18, (long)1.0E18);
            this.checkValues$1(Decimal$.MODULE$.apply((long)2.0E18), 2.0E18, (long)2.0E18);
            this.checkValues$1(Decimal$.MODULE$.apply(Long.MAX_VALUE), Long.MAX_VALUE, Long.MAX_VALUE);
            this.checkValues$1(Decimal$.MODULE$.apply(Long.MIN_VALUE), Long.MIN_VALUE, Long.MIN_VALUE);
            this.checkValues$1(Decimal$.MODULE$.apply(Double.MAX_VALUE), Double.MAX_VALUE, 0L);
            this.checkValues$1(Decimal$.MODULE$.apply(Double$.MODULE$.MinValue()), Double$.MODULE$.MinValue(), 0L);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.decimalVal = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "decimalVal"));
        this.test("small decimals represented as unscaled long", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkCompact(new Decimal(), true);
            this.checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10.03")), false);
            this.checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("100000000000000000000")), false);
            this.checkCompact(Decimal$.MODULE$.apply(17L), true);
            this.checkCompact(Decimal$.MODULE$.apply(17), true);
            this.checkCompact(Decimal$.MODULE$.apply(17L, 2, 1), true);
            this.checkCompact(Decimal$.MODULE$.apply(170L, 4, 2), true);
            this.checkCompact(Decimal$.MODULE$.apply(17L, 24, 1), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E16), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E17), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18 - 1L), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18 + 1L), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18 - 1L, 30, 10), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18 + 1L, 30, 10), true);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18), false);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18), false);
            this.checkCompact(Decimal$.MODULE$.apply((long)1.0E18, 30, 10), false);
            this.checkCompact(Decimal$.MODULE$.apply((long)-1.0E18, 30, 10), false);
            this.checkCompact(Decimal$.MODULE$.apply(Long.MAX_VALUE), false);
            this.checkCompact(Decimal$.MODULE$.apply(Long.MIN_VALUE), false);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("hash code", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(123).hashCode()));
            int $org_scalatest_assert_macro_right = 123;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(-123).hashCode()));
            int $org_scalatest_assert_macro_right2 = -123;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(Integer.MAX_VALUE).hashCode()));
            int $org_scalatest_assert_macro_right3 = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(Long.MAX_VALUE).hashCode()));
            int $org_scalatest_assert_macro_right4 = Statics.longHash((long)Long.MAX_VALUE);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123)).hashCode()));
            int $org_scalatest_assert_macro_right5 = 123;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            BigDecimal reallyBig = package$.MODULE$.BigDecimal().apply("123182312312313232112312312123.1231231231");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Decimal$.MODULE$.apply(reallyBig).hashCode()));
            int $org_scalatest_assert_macro_right6 = reallyBig.hashCode();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.checkCompact(Decimal$.MODULE$.apply(123), true);
            this.checkCompact(Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123)), false);
            this.checkCompact(Decimal$.MODULE$.apply("123"), false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply(123));
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(123));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply(123));
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("123.00"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply(-123));
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(-123));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply(-123));
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-123.00"));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("isZero", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(0).isZero(), "Decimal.apply(0).isZero", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(0L, 4, 2).isZero(), "Decimal.apply(0L, 4, 2).isZero", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0").isZero(), "Decimal.apply(\"0\").isZero", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0.000").isZero(), "Decimal.apply(\"0.000\").isZero", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(1).isZero(), "Decimal.apply(1).isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply(1L, 4, 2).isZero(), "Decimal.apply(1L, 4, 2).isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("1").isZero(), "Decimal.apply(\"1\").isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Decimal$.MODULE$.apply("0.001").isZero(), "Decimal.apply(\"0.001\").isZero", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        this.test("arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$plus(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$plus(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$times(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(-10000);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply(1.0E13).$times(Decimal$.MODULE$.apply(1.0E13)));
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(1.0E26);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$div(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right5 = Decimal$.MODULE$.apply(-1);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$div(Decimal$.MODULE$.apply(0)));
            Null$ $org_scalatest_assert_macro_right6 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", null, $org_scalatest_assert_macro_left6.$eq$eq$eq($org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right7 = Decimal$.MODULE$.apply(0);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(3)));
            Decimal $org_scalatest_assert_macro_right8 = Decimal$.MODULE$.apply(1);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(Decimal$.MODULE$.apply(-100).$percent(Decimal$.MODULE$.apply(3)));
            Decimal $org_scalatest_assert_macro_right9 = Decimal$.MODULE$.apply(-1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).$percent(Decimal$.MODULE$.apply(0)));
            Null$ $org_scalatest_assert_macro_right10 = null;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", null, $org_scalatest_assert_macro_left10.$eq$eq$eq($org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("longVal arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply(10L, 2, 0).$plus(Decimal$.MODULE$.apply(10L, 2, 0)));
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(20L, 3, 0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply(10L, 2, 0).$plus(Decimal$.MODULE$.apply(90L, 2, 0)));
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(100L, 3, 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply(10L, 2, 0).$minus(Decimal$.MODULE$.apply(-10L, 2, 0)));
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(20L, 3, 0);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply(10L, 2, 0).$minus(Decimal$.MODULE$.apply(-90L, 2, 0)));
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(100L, 3, 0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("quot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply(100).quot(Decimal$.MODULE$.apply(100)));
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).quot(Decimal$.MODULE$.apply(33)));
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("3"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).quot(Decimal$.MODULE$.apply(-100)));
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-1"));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).quot(Decimal$.MODULE$.apply(-33)));
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-3"));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("negate & abs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply(100).unary_$minus());
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-100"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply(-100).unary_$minus());
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("100"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply(100).abs());
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("100"));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply(-100).abs());
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("100"));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.test("floor & ceil", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.apply("10.03").floor());
            Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("10"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.apply("10.03").ceil());
            Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("11"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(Decimal$.MODULE$.apply("-10.03").floor());
            Decimal $org_scalatest_assert_macro_right3 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-11"));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(Decimal$.MODULE$.apply("-10.03").ceil());
            Decimal $org_scalatest_assert_macro_right4 = Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply("-10"));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.test("accurate precision after multiplication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            java.math.BigDecimal decimal = Decimal$.MODULE$.apply(Long.MAX_VALUE, 38, 0).$times(Decimal$.MODULE$.apply(Long.MAX_VALUE, 38, 0)).toJavaBigDecimal();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(decimal.unscaledValue().toString());
            String $org_scalatest_assert_macro_right = "85070591730234615847396907784232501249";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
        this.test("fix non-terminating decimal expansion problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Decimal decimal = Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(1.0), 10, 3).$div(Decimal$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(3.0), 10, 3));
            double $org_scalatest_assert_macro_left = decimal.toDouble() - 0.333;
            double $org_scalatest_assert_macro_right = 0.001;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("fix loss of precision/scale when doing division operation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Bool bool;
            Decimal a = Decimal$.MODULE$.apply(2).$div(Decimal$.MODULE$.apply(3));
            double $org_scalatest_assert_macro_left = a.toDouble();
            double $org_scalatest_assert_macro_right = 1.0;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = a.toDouble();
                double $org_scalatest_assert_macro_right2 = 0.6;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            Decimal b = Decimal$.MODULE$.apply(1).$div(Decimal$.MODULE$.apply(8));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)b.toDouble()));
            double $org_scalatest_assert_macro_right4 = 0.125;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        this.test("set/setOrNull", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)new Decimal().set(10L, 10, 0).toUnscaledLong()));
            long $org_scalatest_assert_macro_right = 10L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)new Decimal().set(100L, 10, 0).toUnscaledLong()));
            long $org_scalatest_assert_macro_right2 = 100L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)Decimal$.MODULE$.apply(Long.MAX_VALUE, 100, 0).toUnscaledLong()));
            long $org_scalatest_assert_macro_right3 = Long.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("changePrecision/toPrecision on compact decimal should respect rounding mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.allSupportedRoundModes().foreach((Function1 & Serializable & scala.Serializable)mode -> {
            DecimalSuite.$anonfun$new$30(this, mode);
            return BoxedUnit.UNIT;
        }), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("Not supported rounding mode: HALF_DOWN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Decimal d = Decimal$.MODULE$.apply(10000L, 100, 80);
            SparkException x$31 = (SparkException)this.intercept((Function0 & Serializable & scala.Serializable)() -> d.toPrecision(5, 50, BigDecimal.RoundingMode$.MODULE$.HALF_DOWN(), d.toPrecision$default$4(), d.toPrecision$default$5()), ClassTag$.MODULE$.apply(SparkException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            String x$32 = "INTERNAL_ERROR";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)"Not supported rounding mode: HALF_DOWN.")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            QueryContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, x$32, x$34, x$33, x$35, x$36);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.test("SPARK-20341: support BigInt's value does not fit in long value range", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BigInt bigInt = BigInt$.MODULE$.apply("9223372036854775808");
            Decimal decimal = Decimal$.MODULE$.apply(bigInt);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(decimal.toJavaBigDecimal().unscaledValue().toString());
            String $org_scalatest_assert_macro_right = "9223372036854775808";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        this.test("SPARK-26038: toScalaBigInt/toJavaBigInteger", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Decimal decimal = Decimal$.MODULE$.apply("1234568790123456789012348790.1234879012345678901234568790");
            BigInt $org_scalatest_assert_macro_left = decimal.toScalaBigInt();
            BigInt $org_scalatest_assert_macro_right = BigInt$.MODULE$.apply("1234568790123456789012348790");
            BigInt bigInt = $org_scalatest_assert_macro_left;
            BigInt bigInt2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            BigInteger $org_scalatest_assert_macro_left2 = decimal.toJavaBigInteger();
            BigInteger $org_scalatest_assert_macro_right2 = new BigInteger("1234568790123456789012348790");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, BoxesRunTime.equalsNumNum((Number)$org_scalatest_assert_macro_left2, (Number)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            Decimal decimalLong = Decimal$.MODULE$.apply(123456789123456789L, 18, 9);
            BigInt $org_scalatest_assert_macro_left3 = decimalLong.toScalaBigInt();
            BigInt $org_scalatest_assert_macro_right3 = BigInt$.MODULE$.apply("123456789");
            BigInt bigInt3 = $org_scalatest_assert_macro_left3;
            BigInt bigInt4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(bigInt3 != null ? !bigInt3.equals(bigInt4) : bigInt4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            BigInteger $org_scalatest_assert_macro_left4 = decimalLong.toJavaBigInteger();
            BigInteger $org_scalatest_assert_macro_right4 = new BigInteger("123456789");
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, BoxesRunTime.equalsNumNum((Number)$org_scalatest_assert_macro_left4, (Number)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        this.test("UTF8String to Decimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkFromString$1("12345678901234567890123456789012345678");
            this.checkOutOfRangeFromString$1("123456789012345678901234567890123456789");
            this.checkFromString$1("0.00000000000000000000000000000000000001");
            this.checkFromString$1("0.000000000000000000000000000000000000000000000001");
            this.checkFromString$1("6E-640");
            this.checkFromString$1("6E+37");
            this.checkOutOfRangeFromString$1("6E+38");
            this.checkOutOfRangeFromString$1("6.0790316E+25569151");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.fromString(UTF8String.fromString((String)"str")));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            SparkNumberFormatException x$37 = (SparkNumberFormatException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Decimal$.MODULE$.fromStringANSI(UTF8String.fromString((String)"str"), Decimal$.MODULE$.fromStringANSI$default$2(), Decimal$.MODULE$.fromStringANSI$default$3()), ClassTag$.MODULE$.apply(SparkNumberFormatException.class), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            String x$38 = "CAST_INVALID_INPUT";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)"'str'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)"\"STRING\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)"\"DECIMAL(10,0)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)"\"spark.sql.ansi.enabled\"")}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            QueryContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, x$38, x$40, x$39, x$41, x$42);
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("SPARK-35841: Casting string to decimal type doesn't work if the sum of the digits is greater than 38", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] values = (String[])((Object[])new String[]{"28.9259999999999983799625624669715762138", "28.925999999999998379962562466971576213", "2.9259999999999983799625624669715762138"});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable & scala.Serializable)string -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.fromString(UTF8String.fromString((String)string)));
                Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(string);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.fromStringANSI(UTF8String.fromString((String)string), Decimal$.MODULE$.fromStringANSI$default$2(), Decimal$.MODULE$.fromStringANSI$default$3()));
                Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(string);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            });
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("SPARK-37451: Performance improvement regressed String to Decimal cast", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String[] values = (String[])((Object[])new String[]{"7.836725755512218E38"});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable & scala.Serializable)string -> {
                DecimalSuite.$anonfun$new$43(this, string);
                return BoxedUnit.UNIT;
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable & scala.Serializable)string -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Decimal$.MODULE$.fromString(UTF8String.fromString((String)string)));
                Decimal $org_scalatest_assert_macro_right = Decimal$.MODULE$.apply(string);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Decimal$.MODULE$.fromStringANSI(UTF8String.fromString((String)string), Decimal$.MODULE$.fromStringANSI$default$2(), Decimal$.MODULE$.fromStringANSI$default$3()));
                Decimal $org_scalatest_assert_macro_right2 = Decimal$.MODULE$.apply(string);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            }));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("SPARK-41554: decrease/increase scale by 18 and more on compact decimal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq unscaledNums = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 10L, 51L, 123L, 523L, 912345678901234567L, 112345678901234567L, 512345678901234567L}));
            int precision = 38;
            Seq scalePairs = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{38, 20, 19, 18}))).flatMap((Function1 & Serializable & scala.Serializable)scale -> DecimalSuite.$anonfun$new$48(BoxesRunTime.unboxToInt((Object)scale)), Seq$.MODULE$.canBuildFrom());
            unscaledNums.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)unscaled -> this.allSupportedRoundModes().foreach((Function1 & Serializable & scala.Serializable)mode -> {
                DecimalSuite.$anonfun$new$52(this, scalePairs, unscaled, precision, mode);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DecimalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
    }
}

