/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLKeywordUtils;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i1AAA\u0002\u0001\u001d!)q\u0003\u0001C\u00011\ty1+\u0015'LKf<xN\u001d3Tk&$XM\u0003\u0002\u0005\u000b\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0007\u000f\u0005\u00191/\u001d7\u000b\u0005!I\u0011!B:qCJ\\'B\u0001\u0006\f\u0003\u0019\t\u0007/Y2iK*\tA\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001fM\u0001\"\u0001E\t\u000e\u0003\u001dI!AE\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t!R#D\u0001\u0004\u0013\t12AA\bT#2[U-_<pe\u0012,F/\u001b7t\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u0015\u0001\u0001")
public class SQLKeywordSuite
extends SparkFunSuite
implements SQLKeywordUtils {
    private String[] sqlSyntaxDefs;
    private String[][] keywordsInDoc;
    private Map<String, Seq<String>> symbolsToExpandIntoDifferentLiterals;
    private Set<String> allCandidateKeywords;
    private Set<String> nonReservedKeywordsInAnsiMode;
    private Set<String> reservedKeywordsInAnsiMode;
    private Set<String> nonReservedKeywordsInDefaultMode;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ Path org$apache$spark$sql$catalyst$SQLKeywordUtils$$super$getWorkspaceFilePath(String first, Seq more) {
        return super.getWorkspaceFilePath(first, more);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    @Override
    public String[] sqlSyntaxDefs() {
        return this.sqlSyntaxDefs;
    }

    @Override
    public String[][] keywordsInDoc() {
        return this.keywordsInDoc;
    }

    @Override
    public Map<String, Seq<String>> symbolsToExpandIntoDifferentLiterals() {
        return this.symbolsToExpandIntoDifferentLiterals;
    }

    @Override
    public Set<String> allCandidateKeywords() {
        return this.allCandidateKeywords;
    }

    @Override
    public Set<String> nonReservedKeywordsInAnsiMode() {
        return this.nonReservedKeywordsInAnsiMode;
    }

    @Override
    public Set<String> reservedKeywordsInAnsiMode() {
        return this.reservedKeywordsInAnsiMode;
    }

    @Override
    public Set<String> nonReservedKeywordsInDefaultMode() {
        return this.nonReservedKeywordsInDefaultMode;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$sqlSyntaxDefs_$eq(String[] x$1) {
        this.sqlSyntaxDefs = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$keywordsInDoc_$eq(String[][] x$1) {
        this.keywordsInDoc = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$symbolsToExpandIntoDifferentLiterals_$eq(Map<String, Seq<String>> x$1) {
        this.symbolsToExpandIntoDifferentLiterals = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$allCandidateKeywords_$eq(Set<String> x$1) {
        this.allCandidateKeywords = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$nonReservedKeywordsInAnsiMode_$eq(Set<String> x$1) {
        this.nonReservedKeywordsInAnsiMode = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$reservedKeywordsInAnsiMode_$eq(Set<String> x$1) {
        this.reservedKeywordsInAnsiMode = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$SQLKeywordUtils$_setter_$nonReservedKeywordsInDefaultMode_$eq(Set<String> x$1) {
        this.nonReservedKeywordsInDefaultMode = x$1;
    }

    private String sparkHome$lzycompute() {
        SQLKeywordSuite sQLKeywordSuite = this;
        synchronized (sQLKeywordSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public static final /* synthetic */ boolean $anonfun$new$7(String[] x$9) {
        String string = x$9[1];
        String string2 = "non-reserved";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$13(String[] x$12) {
        String string = x$12[2];
        String string2 = "non-reserved";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$19(String[] x$16) {
        Object object = ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])x$16));
        String string = "reserved";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$new$16(SQLKeywordSuite $this, File dir) {
        File tmpFile = new File(dir, "tmp");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("ansi-sql-2016-reserved-keywords.txt");
        Files.copy(is, tmpFile.toPath(), new CopyOption[0]);
        Set reservedKeywordsInSql2016 = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(tmpFile.toPath())).asScala()).filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.startsWith("--")))).map((Function1 & Serializable)x$15 -> x$15.trim())).toSet();
        Set documented = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])$this.keywordsInDoc()), (Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)SQLKeywordSuite.$anonfun$new$19(x$16)))), (Function1 & Serializable)x$17 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$17)), ClassTag$.MODULE$.apply(String.class))).toSet();
        Set $org_scalatest_assert_macro_left = (Set)documented.$minus$minus((IterableOnce)reservedKeywordsInSql2016);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
    }

    public SQLKeywordSuite() {
        SQLHelper.$init$(this);
        SQLKeywordUtils.$init$(this);
        this.test("all keywords are documented", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Set documentedKeywords = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.keywordsInDoc()), (Function1 & Serializable)x$7 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$7)), ClassTag$.MODULE$.apply(String.class))).toSet();
            Set<String> set = this.allCandidateKeywords();
            Set set2 = documentedKeywords;
            if (set == null ? set2 != null : !set.equals((Object)set2)) {
                Seq undocumented = (Seq)this.allCandidateKeywords().$minus$minus((IterableOnce)documentedKeywords).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
                throw this.fail(new StringBuilder(34).append("Some keywords are not documented: ").append(undocumented.mkString(", ")).toString(), new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            }
            return BoxedUnit.UNIT;
        }, new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("Spark keywords are documented correctly under ANSI mode", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.keywordsInDoc()), (Function1 & Serializable)x$8 -> x$8[1], ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)desc -> {
                Bool bool;
                String $org_scalatest_assert_macro_left = desc;
                String $org_scalatest_assert_macro_right = "reserved";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left3 = desc;
                    String $org_scalatest_assert_macro_right2 = "non-reserved";
                    String string3 = $org_scalatest_assert_macro_left3;
                    String string4 = $org_scalatest_assert_macro_right2;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            });
            Set nonReservedInDoc = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.keywordsInDoc()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SQLKeywordSuite.$anonfun$new$7(x$9)))), (Function1 & Serializable)x$10 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$10)), ClassTag$.MODULE$.apply(String.class))).toSet();
            Set<String> set = this.nonReservedKeywordsInAnsiMode();
            Set set2 = nonReservedInDoc;
            if (set == null ? set2 != null : !set.equals((Object)set2)) {
                Seq misImplemented = (Seq)nonReservedInDoc.$minus$minus(this.nonReservedKeywordsInAnsiMode()).$plus$plus((IterableOnce)this.nonReservedKeywordsInAnsiMode().$minus$minus((IterableOnce)nonReservedInDoc)).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
                throw this.fail(new StringBuilder(61).append("Some keywords are documented and implemented inconsistently: ").append(misImplemented.mkString(", ")).toString(), new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            }
            return BoxedUnit.UNIT;
        }, new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("Spark keywords are documented correctly under default mode", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.keywordsInDoc()), (Function1 & Serializable)x$11 -> x$11[2], ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)desc -> {
                Bool bool;
                String $org_scalatest_assert_macro_left = desc;
                String $org_scalatest_assert_macro_right = "strict-non-reserved";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left2.value()) {
                    bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                } else {
                    String $org_scalatest_assert_macro_left3 = desc;
                    String $org_scalatest_assert_macro_right2 = "non-reserved";
                    String string3 = $org_scalatest_assert_macro_left3;
                    String string4 = $org_scalatest_assert_macro_right2;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            });
            Set nonReservedInDoc = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.keywordsInDoc()), (Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SQLKeywordSuite.$anonfun$new$13(x$12)))), (Function1 & Serializable)x$13 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$13)), ClassTag$.MODULE$.apply(String.class))).toSet();
            Set<String> set = this.nonReservedKeywordsInDefaultMode();
            Set set2 = nonReservedInDoc;
            if (set == null ? set2 != null : !set.equals((Object)set2)) {
                Seq misImplemented = (Seq)nonReservedInDoc.$minus$minus(this.nonReservedKeywordsInDefaultMode()).$plus$plus((IterableOnce)this.nonReservedKeywordsInDefaultMode().$minus$minus((IterableOnce)nonReservedInDoc)).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
                throw this.fail(new StringBuilder(61).append("Some keywords are documented and implemented inconsistently: ").append(misImplemented.mkString(", ")).toString(), new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            }
            return BoxedUnit.UNIT;
        }, new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        this.test("SQL 2016 keywords are documented correctly", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTempDir((Function1 & Serializable)dir -> {
            SQLKeywordSuite.$anonfun$new$16(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("SQLKeywordSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        Statics.releaseFence();
    }
}

