/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BRound;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseNot;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateArray$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Divide$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Greatest$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Least$;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Multiply$;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash;
import org.apache.spark.sql.catalyst.expressions.PosExplode;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Remainder$;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.expressions.XxHash64;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.BoolAnd;
import org.apache.spark.sql.catalyst.expressions.aggregate.BoolOr;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000513Aa\u0002\u0005\u0001+!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003G\u0001\u0011\u0005q\tC\u0003J\u0001\u0011\u0005!JA\u000eFqB\u0014Xm]:j_:$\u0016\u0010]3DQ\u0016\u001c7.\u001b8h'VLG/\u001a\u0006\u0003\u0013)\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u00171\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u00039I!!\u0007\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\t\u0001\"\u0001\u0007uKN$(+\u001a7bi&|g.F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%A\u0004m_\u001eL7-\u00197\u000b\u0005\u0015R\u0011!\u00029mC:\u001c\u0018BA\u0014#\u00055aunY1m%\u0016d\u0017\r^5p]\u0006iA/Z:u%\u0016d\u0017\r^5p]\u0002\n1\"Y:tKJ$XI\u001d:peR\u00191&M\u001d\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\u0011\u0001\raM\u0001\u0005Kb\u0004(\u000f\u0005\u00025o5\tQG\u0003\u00027\u0015\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\tATG\u0001\u0006FqB\u0014Xm]:j_:DQA\u000f\u0003A\u0002m\nA\"\u001a:s_JlUm]:bO\u0016\u0004\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 .\u001b\u0005y$B\u0001!\u0015\u0003\u0019a$o\\8u}%\u0011!)L\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C[\u0005i\u0011m]:feR\u001cVoY2fgN$\"a\u000b%\t\u000bI*\u0001\u0019A\u001a\u00029\u0005\u001c8/\u001a:u\u000bJ\u0014xN\u001d$pe\u0012KgMZ3sS:<G+\u001f9fgR\u00111f\u0013\u0005\u0006e\u0019\u0001\ra\r")
public class ExpressionTypeCheckingSuite
extends SparkFunSuite {
    private final LocalRelation testRelation = LocalRelation$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).int(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "stringField")).string(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).boolean(), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "decimalField")).decimal(8, 0), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "arrayField")).array((DataType)StringType$.MODULE$), package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "mapField")).map((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$)}));

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public void assertError(Expression expr, String errorMessage) {
        AnalysisException e = (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertSuccess(expr), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = new StringBuilder(44).append("cannot resolve '").append(expr.sql()).append("' due to data type mismatch:").toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        String $org_scalatest_assert_macro_left2 = e.getMessage();
        String $org_scalatest_assert_macro_right2 = errorMessage;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
    }

    public void assertSuccess(Expression expr) {
        LogicalPlan analyzed = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(expr).as("c")}))).analyze();
        SimpleAnalyzer$.MODULE$.checkAnalysis(analyzed);
    }

    public void assertErrorForDifferingTypes(Expression expr) {
        this.assertError(expr, new StringBuilder(21).append("differing types in '").append(expr.sql()).append("'").toString());
    }

    public static final /* synthetic */ void $anonfun$new$10(ExpressionTypeCheckingSuite $this, Function1 operator) {
        $this.assertError((Expression)operator.apply((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))}))), "requires at least two arguments");
        $this.assertError((Expression)operator.apply((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))}))), "should all have the same type");
        $this.assertError((Expression)operator.apply((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))}))), "does not support ordering");
    }

    public ExpressionTypeCheckingSuite() {
        this.test("check types for unary arithmetic", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertError((Expression)new BitwiseNot((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))), "requires integral type"), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("check types for binary arithmetic", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertSuccess((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Add$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Subtract$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Multiply$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Divide$.MODULE$.apply$default$3()));
            this.assertSuccess((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Remainder$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Add$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Subtract$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Multiply$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Divide$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Remainder$.MODULE$.apply$default$3()));
            this.assertErrorForDifferingTypes((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Add$.MODULE$.apply$default$3()), "requires (numeric or interval or interval day to second or interval year to month) type");
            this.assertError((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Subtract$.MODULE$.apply$default$3()), "requires (numeric or interval or interval day to second or interval year to month) type");
            this.assertError((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Multiply$.MODULE$.apply$default$3()), "requires numeric type");
            this.assertError((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Divide$.MODULE$.apply$default$3()), "requires (double or decimal) type");
            this.assertError((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Remainder$.MODULE$.apply$default$3()), "requires numeric type");
            this.assertError((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires integral type");
            this.assertError((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires integral type");
            this.assertError((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires integral type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("check types for predicates", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))));
            this.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))));
            this.assertErrorForDifferingTypes((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))));
            this.assertErrorForDifferingTypes((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertErrorForDifferingTypes((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "EqualTo does not support ordering on type map");
            this.assertError((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "EqualNullSafe does not support ordering on type map");
            this.assertError((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "LessThan does not support ordering on type map");
            this.assertError((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "LessThanOrEqual does not support ordering on type map");
            this.assertError((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "GreaterThan does not support ordering on type map");
            this.assertError((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "GreaterThanOrEqual does not support ordering on type map");
            this.assertError((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))), "type of predicate expression in If should be boolean");
            this.assertErrorForDifferingTypes((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new CaseWhen((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr()), new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "mapField")).attr())})), CaseWhen$.MODULE$.apply$default$2()), "THEN and ELSE expressions should all be same type or coercible to a common type");
            this.assertError((Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))}))), "THEN and ELSE expressions should all be same type or coercible to a common type");
            this.assertError((Expression)new CaseWhen((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr()), new Tuple2((Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr(), (Object)package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "intField")).attr())})), CaseWhen$.MODULE$.apply$default$2()), "WHEN expressions in CaseWhen should all be boolean type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("check types for aggregates", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertSuccess((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Sum$.MODULE$.apply$default$2()));
            this.assertSuccess((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), Average$.MODULE$.apply$default$2()));
            this.assertSuccess((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "arrayField"))));
            this.assertSuccess((Expression)new BoolAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertSuccess((Expression)new BoolOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))));
            this.assertError((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "min does not support ordering on type");
            this.assertError((Expression)new Max((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "max does not support ordering on type");
            this.assertError((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Sum$.MODULE$.apply$default$2()), "function sum requires numeric or interval types");
            this.assertError((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), Average$.MODULE$.apply$default$2()), "function average requires numeric or interval types");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("check types for others", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertError((Expression)CreateArray$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))}))), "input to function array should all be the same type");
            this.assertError((Expression)new Coalesce((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))}))), "input to function coalesce should all be the same type");
            this.assertError((Expression)new Coalesce((Seq)package$.MODULE$.Nil()), "function coalesce requires at least one argument");
            this.assertError((Expression)new Murmur3Hash((Seq)package$.MODULE$.Nil()), "function hash requires at least one argument");
            this.assertError((Expression)new XxHash64((Seq)package$.MODULE$.Nil()), "function xxhash64 requires at least one argument");
            this.assertError((Expression)new Explode((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "input to function explode should be array or map type");
            this.assertError((Expression)new PosExplode((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "input to function explode should be array or map type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("check types for CreateNamedStruct", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertError((Expression)new CreateNamedStruct((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "even number of arguments");
            this.assertError((Expression)new CreateNamedStruct((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "Only foldable string expressions are allowed to appear at odd position");
            this.assertError((Expression)new CreateNamedStruct((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol((Symbol)SymbolLiteral.bootstrap("apply", "a")).string()).at(0), package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "Only foldable string expressions are allowed to appear at odd position");
            this.assertError((Expression)new CreateNamedStruct((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), package.expressions$.MODULE$.stringToLiteral("a")}))), "Field name should not be null");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("check types for CreateMap", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertError((Expression)CreateMap$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "even number of arguments");
            this.assertError((Expression)CreateMap$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField"))}))), "keys of function map should all be the same type");
            this.assertError((Expression)CreateMap$.MODULE$.apply((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "stringField")), package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))}))), "values of function map should all be the same type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("check types for ROUND/BROUND", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.assertSuccess((Expression)new Round((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null)));
            this.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "Only foldable Expression is allowed");
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires int type");
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "requires int type");
            this.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "requires numeric type");
            this.assertSuccess((Expression)new BRound((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null)));
            this.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "Only foldable Expression is allowed");
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField"))), "requires int type");
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "mapField"))), "requires int type");
            this.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "booleanField")), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute((Symbol)SymbolLiteral.bootstrap("apply", "intField"))), "requires numeric type");
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("check types for Greatest/Least", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{Greatest$.MODULE$, Least$.MODULE$})).foreach((Function1 & Serializable)operator -> {
            ExpressionTypeCheckingSuite.$anonfun$new$10(this, operator);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }
}

