/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.encoders;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.RandomDataGenerator$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExamplePointUDT;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.CodegenInterpretedPlanTest;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypeTestUtils$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.funsuite.AnyFunSuiteLike;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005I4Aa\u0005\u000b\u0001C!)A\u0006\u0001C\u0001[!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0004B\u0002\u001d\u0001A\u0003%!\u0007C\u0004:\u0001\t\u0007I\u0011B\u0019\t\ri\u0002\u0001\u0015!\u00033\u0011\u001dY\u0004A1A\u0005\nqBa\u0001\u0011\u0001!\u0002\u0013i\u0004bB!\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001f\t\u000f\r\u0003!\u0019!C\u0005\t\"1\u0001\n\u0001Q\u0001\n\u0015Cq!\u0013\u0001C\u0002\u0013%A\b\u0003\u0004K\u0001\u0001\u0006I!\u0010\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u00069\u0002!I!\u0018\u0005\u0006A\u0002!I!\u0019\u0005\u0006I\u0002!I!\u001a\u0005\u0006_\u0002!I\u0001\u001d\u0002\u0010%><XI\\2pI\u0016\u00148+^5uK*\u0011QCF\u0001\tK:\u001cw\u000eZ3sg*\u0011q\u0003G\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011DG\u0001\u0004gFd'BA\u000e\u001d\u0003\u0015\u0019\b/\u0019:l\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\t\u0014\u0011\u0005\r\"S\"\u0001\u000e\n\u0005\u0015R\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002(U5\t\u0001F\u0003\u0002*-\u0005)\u0001\u000f\\1og&\u00111\u0006\u000b\u0002\u001b\u0007>$WmZ3o\u0013:$XM\u001d9sKR,G\r\u00157b]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u0003Q\tab\u001d;sk\u000e$xJZ*ue&tw-F\u00013!\t\u0019d'D\u00015\u0015\t)\u0004$A\u0003usB,7/\u0003\u00028i\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001fM$(/^2u\u001f\u001a\u001cFO]5oO\u0002\n1b\u001d;sk\u000e$xJZ+E)\u0006a1\u000f\u001e:vGR|e-\u0016#UA\u0005i\u0011M\u001d:bs>37\u000b\u001e:j]\u001e,\u0012!\u0010\t\u0003gyJ!a\u0010\u001b\u0003\u0013\u0005\u0013(/Y=UsB,\u0017AD1se\u0006LxJZ*ue&tw\rI\u0001\fCJ\u0014\u0018-_(g\u001dVdG.\u0001\u0007beJ\f\u0017p\u00144Ok2d\u0007%A\u0006nCB|em\u0015;sS:<W#A#\u0011\u0005M2\u0015BA$5\u0005\u001di\u0015\r\u001d+za\u0016\fA\"\\1q\u001f\u001a\u001cFO]5oO\u0002\n!\"\u0019:sCf|e-\u0016#U\u0003-\t'O]1z\u001f\u001a,F\t\u0016\u0011\u0002\u000bQ|'k\\<\u0015\u00075\u000b&\f\u0005\u0002O\u001f6\ta#\u0003\u0002Q-\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015\u0011f\u00021\u0001T\u0003\u001d)gnY8eKJ\u00042a\f+W\u0013\t)FCA\tFqB\u0014Xm]:j_:,enY8eKJ\u0004\"a\u0016-\u000e\u0003aI!!\u0017\r\u0003\u0007I{w\u000fC\u0003\\\u001d\u0001\u0007a+A\u0002s_^\fqA\u001a:p[J{w\u000fF\u0002W=~CQAU\bA\u0002MCQaW\bA\u00025\u000b\u0011B]8v]\u0012$&/\u001b9\u0015\u0007Y\u00137\rC\u0003S!\u0001\u00071\u000bC\u0003\\!\u0001\u0007a+A\nuKN$H)Z2j[\u0006dwJ^3sM2|w\u000fF\u0002gY:\u0004\"a\u001a6\u000e\u0003!T\u0011![\u0001\u0006g\u000e\fG.Y\u0005\u0003W\"\u0014A!\u00168ji\")Q.\u0005a\u0001e\u000511o\u00195f[\u0006DQaW\tA\u0002Y\u000b\u0001#\u001a8d_\u0012,G)Z2pI\u0016$Vm\u001d;\u0015\u0005\u0019\f\b\"B7\u0013\u0001\u0004\u0011\u0004")
public class RowEncoderSuite
extends SparkFunSuite
implements CodegenInterpretedPlanTest {
    private final StructType structOfString;
    private final StructType structOfUDT;
    private final ArrayType arrayOfString;
    private final ArrayType arrayOfNull;
    private final MapType mapOfString;
    private final ArrayType arrayOfUDT;
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$plans$CodegenInterpretedPlanTest$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        CodegenInterpretedPlanTest.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testFallback(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        CodegenInterpretedPlanTest.testFallback$(this, testName, testTags, testFun, pos);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        RowEncoderSuite rowEncoderSuite = this;
        synchronized (rowEncoderSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private StructType structOfString() {
        return this.structOfString;
    }

    private StructType structOfUDT() {
        return this.structOfUDT;
    }

    private ArrayType arrayOfString() {
        return this.arrayOfString;
    }

    private ArrayType arrayOfNull() {
        return this.arrayOfNull;
    }

    private MapType mapOfString() {
        return this.mapOfString;
    }

    private ArrayType arrayOfUDT() {
        return this.arrayOfUDT;
    }

    private InternalRow toRow(ExpressionEncoder<Row> encoder, Row row) {
        return encoder.createSerializer().apply((Object)row);
    }

    private Row fromRow(ExpressionEncoder<Row> encoder, InternalRow row) {
        return (Row)encoder.createDeserializer().apply(row);
    }

    private Row roundTrip(ExpressionEncoder<Row> encoder, Row row) {
        return this.fromRow(encoder, this.toRow(encoder, row));
    }

    private void testDecimalOverflow(StructType schema, Row row) {
        this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Analyzer x$2;
            Seq x$1;
            ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
            ExpressionEncoder encoder = qual$1.resolveAndBind(x$1 = qual$1.resolveAndBind$default$1(), x$2 = qual$1.resolveAndBind$default$2());
            Exception exception = (Exception)this.intercept((Function0 & Serializable)() -> this.toRow((ExpressionEncoder<Row>)encoder, row), ClassTag$.MODULE$.apply(Exception.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            if (exception instanceof ArithmeticException) {
                ArithmeticException arithmeticException = (ArithmeticException)exception;
                String $org_scalatest_assert_macro_left = arithmeticException.getMessage();
                String $org_scalatest_assert_macro_right = "cannot be represented as Decimal";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (exception instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)exception;
                Throwable $org_scalatest_assert_macro_left = runtimeException.getCause();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "java.lang.ArithmeticException", $org_scalatest_assert_macro_left instanceof ArithmeticException, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
                String $org_scalatest_assert_macro_left2 = runtimeException.getCause().getMessage();
                String $org_scalatest_assert_macro_right = "cannot be represented as Decimal";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)exception);
            }
        });
        this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            ExpressionEncoder qual$2 = RowEncoder$.MODULE$.apply(schema);
            Seq x$3 = qual$2.resolveAndBind$default$1();
            Analyzer x$4 = qual$2.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$2.resolveAndBind(x$3, x$4);
            Object $org_scalatest_assert_macro_left = this.roundTrip((ExpressionEncoder<Row>)encoder, row).get(0);
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        });
    }

    private void encodeDecodeTest(StructType schema) {
        this.test(new StringBuilder(15).append("encode/decode: ").append(schema.simpleString()).toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)java8Api -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)java8Api)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema$2);
                Seq x$12 = qual$1.resolveAndBind$default$1();
                Analyzer x$2 = qual$1.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$1.resolveAndBind(x$12, x$2);
                Function0 inputGenerator = (Function0)RandomDataGenerator$.MODULE$.forType((DataType)schema$2, false, RandomDataGenerator$.MODULE$.forType$default$3(), RandomDataGenerator$.MODULE$.forType$default$4()).get();
                ObjectRef input = ObjectRef.create(null);
                try {
                    RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 5).foreach((Function1 & Serializable)x$1 -> RowEncoderSuite.$anonfun$encodeDecodeTest$4($this, input, inputGenerator, encoder, BoxesRunTime.unboxToInt((Object)x$1)));
                }
                catch (Exception e) {
                    throw $this.fail(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(75).append("\n                   |schema: ").append(schema$2.simpleString()).append("\n                   |input: ").append((Row)input.elem).append("\n                 ").toString())), e, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
                }
            });
            return BoxedUnit.UNIT;
        }), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
    }

    public static final /* synthetic */ void $anonfun$new$27(RowEncoderSuite $this, AtomicType elementType$1, boolean containsNull) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)nullable -> {
            $this.test(new StringBuilder(46).append("RowEncoder should preserve array nullability: ").append(new StringBuilder(41).append("ArrayType(").append(elementType$1).append(", containsNull = ").append(containsNull).append("), nullable = ").append(BoxesRunTime.unboxToBoolean((Object)nullable)).toString()).toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
                StructType schema = new StructType().add("array", (DataType)new ArrayType((DataType)elementType$1, containsNull$1), nullable);
                ExpressionEncoder qual$12 = RowEncoder$.MODULE$.apply(schema);
                Seq x$23 = qual$12.resolveAndBind$default$1();
                Analyzer x$24 = qual$12.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$12.resolveAndBind(x$23, x$24);
                Seq $org_scalatest_assert_macro_left = encoder.serializer();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
                DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder.serializer().head()).dataType();
                ArrayType $org_scalatest_assert_macro_right2 = new ArrayType((DataType)elementType$1, containsNull$1);
                DataType dataType = $org_scalatest_assert_macro_left2;
                ArrayType arrayType = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
                boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder.serializer().head()).nullable();
                boolean $org_scalatest_assert_macro_right3 = nullable;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$26(RowEncoderSuite $this, AtomicType elementType) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)containsNull -> {
            RowEncoderSuite.$anonfun$new$27($this, elementType, BoxesRunTime.unboxToBoolean((Object)containsNull));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$32(RowEncoderSuite $this, AtomicType keyType$1, AtomicType valueType$1, boolean valueContainsNull) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)nullable -> {
            $this.test(new StringBuilder(44).append("RowEncoder should preserve map nullability: ").append(new StringBuilder(35).append("MapType(").append(keyType$1).append(", ").append(valueType$1).append(", valueContainsNull = ").append(valueContainsNull).append("), ").toString()).append(new StringBuilder(11).append("nullable = ").append(BoxesRunTime.unboxToBoolean((Object)nullable)).toString()).toString(), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
                StructType schema = new StructType().add("map", (DataType)new MapType((DataType)keyType$1, (DataType)valueType$1, valueContainsNull$1), nullable);
                ExpressionEncoder qual$13 = RowEncoder$.MODULE$.apply(schema);
                Seq x$25 = qual$13.resolveAndBind$default$1();
                Analyzer x$26 = qual$13.resolveAndBind$default$2();
                ExpressionEncoder encoder = qual$13.resolveAndBind(x$25, x$26);
                Seq $org_scalatest_assert_macro_left = encoder.serializer();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
                DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder.serializer().head()).dataType();
                MapType $org_scalatest_assert_macro_right2 = new MapType((DataType)keyType$1, (DataType)valueType$1, valueContainsNull$1);
                DataType dataType = $org_scalatest_assert_macro_left2;
                MapType mapType = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(mapType) : mapType != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
                boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder.serializer().head()).nullable();
                boolean $org_scalatest_assert_macro_right3 = nullable;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$31(RowEncoderSuite $this, AtomicType keyType$1, AtomicType valueType) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, false})).foreach((Function1 & Serializable)valueContainsNull -> {
            RowEncoderSuite.$anonfun$new$32($this, keyType$1, valueType, BoxesRunTime.unboxToBoolean((Object)valueContainsNull));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(RowEncoderSuite $this, AtomicType keyType) {
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$})).foreach((Function1 & Serializable)valueType -> {
            RowEncoderSuite.$anonfun$new$31($this, keyType, valueType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Assertion $anonfun$encodeDecodeTest$4(RowEncoderSuite $this, ObjectRef input$1, Function0 inputGenerator$1, ExpressionEncoder encoder$3, int x$1) {
        int n = x$1;
        input$1.elem = (Row)inputGenerator$1.apply();
        Row convertedBack = $this.roundTrip((ExpressionEncoder<Row>)encoder$3, (Row)input$1.elem);
        Row $org_scalatest_assert_macro_left = (Row)input$1.elem;
        Row $org_scalatest_assert_macro_right = convertedBack;
        Row row = $org_scalatest_assert_macro_left;
        Row row2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(row != null ? !row.equals(row2) : row2 != null), Prettifier$.MODULE$.default());
        Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        return assertion;
    }

    public RowEncoderSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$(this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$(this);
        CodegenInterpretedPlanTest.$init$(this);
        this.structOfString = new StructType().add("str", (DataType)StringType$.MODULE$);
        this.structOfUDT = new StructType().add("udt", (DataType)new ExamplePointUDT(), false);
        this.arrayOfString = ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
        this.arrayOfNull = ArrayType$.MODULE$.apply((DataType)NullType$.MODULE$);
        this.mapOfString = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
        this.arrayOfUDT = new ArrayType((DataType)new ExamplePointUDT(), false);
        this.encodeDecodeTest(new StructType().add("null", (DataType)NullType$.MODULE$).add("boolean", (DataType)BooleanType$.MODULE$).add("byte", (DataType)ByteType$.MODULE$).add("short", (DataType)ShortType$.MODULE$).add("int", (DataType)IntegerType$.MODULE$).add("long", (DataType)LongType$.MODULE$).add("float", (DataType)FloatType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("string", (DataType)StringType$.MODULE$).add("binary", (DataType)BinaryType$.MODULE$).add("date", (DataType)DateType$.MODULE$).add("timestamp", (DataType)TimestampType$.MODULE$).add("udt", (DataType)new ExamplePointUDT()));
        this.encodeDecodeTest(new StructType().add("arrayOfNull", (DataType)this.arrayOfNull()).add("arrayOfString", (DataType)this.arrayOfString()).add("arrayOfArrayOfString", (DataType)ArrayType$.MODULE$.apply((DataType)this.arrayOfString())).add("arrayOfArrayOfInt", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))).add("arrayOfMap", (DataType)ArrayType$.MODULE$.apply((DataType)this.mapOfString())).add("arrayOfStruct", (DataType)ArrayType$.MODULE$.apply((DataType)this.structOfString())).add("arrayOfUDT", (DataType)this.arrayOfUDT()));
        this.encodeDecodeTest(new StructType().add("mapOfIntAndString", (DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$)).add("mapOfStringAndArray", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.arrayOfString())).add("mapOfArrayAndInt", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)IntegerType$.MODULE$)).add("mapOfArray", (DataType)MapType$.MODULE$.apply((DataType)this.arrayOfString(), (DataType)this.arrayOfString())).add("mapOfStringAndStruct", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)this.structOfString())).add("mapOfStructAndString", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)StringType$.MODULE$)).add("mapOfStruct", (DataType)MapType$.MODULE$.apply((DataType)this.structOfString(), (DataType)this.structOfString())));
        this.encodeDecodeTest(new StructType().add("structOfString", (DataType)this.structOfString()).add("structOfStructOfString", (DataType)new StructType().add("struct", (DataType)this.structOfString())).add("structOfArray", (DataType)new StructType().add("array", (DataType)this.arrayOfString())).add("structOfMap", (DataType)new StructType().add("map", (DataType)this.mapOfString())).add("structOfArrayAndMap", (DataType)new StructType().add("array", (DataType)this.arrayOfString()).add("map", (DataType)this.mapOfString())).add("structOfUDT", (DataType)this.structOfUDT()));
        this.test("encode/decode decimal type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$).add("string", (DataType)StringType$.MODULE$).add("double", (DataType)DoubleType$.MODULE$).add("java_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("scala_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT()).add("catalyst_decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
            ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(schema);
            Seq x$1 = qual$1.resolveAndBind$default$1();
            Analyzer x$2 = qual$1.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$1.resolveAndBind(x$1, x$2);
            BigDecimal javaDecimal = new BigDecimal("1234.5678");
            scala.math.BigDecimal scalaDecimal = package$.MODULE$.BigDecimal().apply("1234.5678");
            Decimal catalystDecimal = Decimal$.MODULE$.apply("1234.5678");
            Row input = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100), "test", BoxesRunTime.boxToDouble((double)0.123), javaDecimal, scalaDecimal, catalystDecimal}));
            Row convertedBack = this.roundTrip((ExpressionEncoder<Row>)encoder, input);
            int $org_scalatest_assert_macro_left = convertedBack.getDecimal(3).compareTo(javaDecimal);
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            int $org_scalatest_assert_macro_left2 = convertedBack.getDecimal(4).compareTo(scalaDecimal.bigDecimal());
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            int $org_scalatest_assert_macro_left3 = convertedBack.getDecimal(5).compareTo(catalystDecimal.toJavaBigDecimal());
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("RowEncoder should preserve decimal precision and scale", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("decimal", (DataType)new DecimalType(10, 5), false);
            ExpressionEncoder qual$2 = RowEncoder$.MODULE$.apply(schema);
            Seq x$3 = qual$2.resolveAndBind$default$1();
            Analyzer x$4 = qual$2.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$2.resolveAndBind(x$3, x$4);
            Decimal decimal = Decimal$.MODULE$.apply("67123.45");
            Row input = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{decimal}));
            InternalRow row = this.toRow((ExpressionEncoder<Row>)encoder, input);
            Object $org_scalatest_assert_macro_left = row.toSeq(schema).head();
            Decimal $org_scalatest_assert_macro_right = decimal;
            Object object = $org_scalatest_assert_macro_left;
            Decimal decimal2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(decimal2) : decimal2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("SPARK-23179: RowEncoder should respect nullOnOverflow for decimals", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("decimal", (DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
            this.testDecimalOverflow(schema, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigDecimal().apply(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("9"), 100))})));
            this.testDecimalOverflow(schema, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new BigDecimal(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("9"), 100))})));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("RowEncoder should preserve schema nullability", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$, false);
            ExpressionEncoder qual$3 = RowEncoder$.MODULE$.apply(schema);
            Seq x$5 = qual$3.resolveAndBind$default$1();
            Analyzer x$6 = qual$3.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$3.resolveAndBind(x$5, x$6);
            Seq $org_scalatest_assert_macro_left = encoder.serializer();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder.serializer().head()).dataType();
            IntegerType$ $org_scalatest_assert_macro_right2 = IntegerType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left2;
            IntegerType$ integerType$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder.serializer().head()).nullable();
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("RowEncoder should preserve nested column name", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("struct", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$, false).add("s", (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$, false), false), false);
            ExpressionEncoder qual$4 = RowEncoder$.MODULE$.apply(schema);
            Seq x$7 = qual$4.resolveAndBind$default$1();
            Analyzer x$8 = qual$4.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$4.resolveAndBind(x$7, x$8);
            Seq $org_scalatest_assert_macro_left = encoder.serializer();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            DataType $org_scalatest_assert_macro_left2 = ((Expression)encoder.serializer().head()).dataType();
            StructType $org_scalatest_assert_macro_right2 = new StructType().add("i", (DataType)IntegerType$.MODULE$, false).add("s", (DataType)new StructType().add("int", (DataType)IntegerType$.MODULE$, false), false);
            DataType dataType = $org_scalatest_assert_macro_left2;
            StructType structType = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(structType) : structType != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            boolean $org_scalatest_assert_macro_left3 = ((Expression)encoder.serializer().head()).nullable();
            boolean $org_scalatest_assert_macro_right3 = false;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("RowEncoder should support primitive arrays", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("booleanPrimitiveArray", (DataType)new ArrayType((DataType)BooleanType$.MODULE$, false)).add("bytePrimitiveArray", (DataType)new ArrayType((DataType)ByteType$.MODULE$, false)).add("shortPrimitiveArray", (DataType)new ArrayType((DataType)ShortType$.MODULE$, false)).add("intPrimitiveArray", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false)).add("longPrimitiveArray", (DataType)new ArrayType((DataType)LongType$.MODULE$, false)).add("floatPrimitiveArray", (DataType)new ArrayType((DataType)FloatType$.MODULE$, false)).add("doublePrimitiveArray", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false));
            ExpressionEncoder qual$5 = RowEncoder$.MODULE$.apply(schema);
            Seq x$9 = qual$5.resolveAndBind$default$1();
            Analyzer x$10 = qual$5.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$5.resolveAndBind(x$9, x$10);
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{new boolean[]{true, false}, new byte[]{(byte)1, (byte)64, 127}, new short[]{(short)1, (short)255, Short.MAX_VALUE}, new int[]{1, 10000, Integer.MAX_VALUE}, new long[]{1, 1000000, Long.MAX_VALUE}, new float[]{(float)1.1, (float)123.456, Float.MAX_VALUE}, new double[]{11.1111, 123456.7890123, Double.MAX_VALUE}}));
            Row convertedBack = this.roundTrip((ExpressionEncoder<Row>)encoder, Row$.MODULE$.fromSeq(input));
            return (Seq)((IterableOps)input.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object array = tuple2._1();
                int index = tuple2._2$mcI$sp();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(convertedBack.getSeq(index));
                Object $org_scalatest_assert_macro_right = array;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
                return assertion;
            });
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("RowEncoder should support array as the external type for ArrayType", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("array", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)).add("nestedArray", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$))).add("deepNestedArray", (DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$))));
            ExpressionEncoder qual$6 = RowEncoder$.MODULE$.apply(schema);
            Seq x$11 = qual$6.resolveAndBind$default$1();
            Analyzer x$12 = qual$6.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$6.resolveAndBind(x$11, x$12);
            Row input = Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null}, (Object[])new String[][]{(String[])((Object[])new String[]{"abc", null}), null}, new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Object[][]{{BoxesRunTime.boxToLong((long)0L), null}, null})), null}}));
            Row convertedBack = this.roundTrip((ExpressionEncoder<Row>)encoder, input);
            Seq $org_scalatest_assert_macro_left = convertedBack.getSeq(0);
            Seq $org_scalatest_assert_macro_right = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), null}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            Seq $org_scalatest_assert_macro_left2 = convertedBack.getSeq(1);
            Seq $org_scalatest_assert_macro_right2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc", null})), null}));
            Seq seq3 = $org_scalatest_assert_macro_left2;
            Seq seq4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            Seq $org_scalatest_assert_macro_left3 = convertedBack.getSeq(2);
            Seq $org_scalatest_assert_macro_right3 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)0L), null})), null})), null}));
            Seq seq5 = $org_scalatest_assert_macro_left3;
            Seq seq6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(seq5 != null ? !seq5.equals(seq6) : seq6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("RowEncoder should throw RuntimeException if input row object is null", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("int", (DataType)IntegerType$.MODULE$);
            ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
            RuntimeException e = (RuntimeException)this.intercept((Function0 & Serializable)() -> this.toRow((ExpressionEncoder<Row>)encoder, null), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Null value appeared in non-nullable field";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "top level Product or row object";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        this.test("RowEncoder should validate external type", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            RuntimeException e1 = (RuntimeException)this.intercept((Function0 & Serializable)() -> {
                StructType schema = new StructType().add("a", (DataType)IntegerType$.MODULE$);
                ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                return this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)1))})));
            }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "java.lang.Short is not a valid external type";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            RuntimeException e2 = (RuntimeException)this.intercept((Function0 & Serializable)() -> {
                StructType schema = new StructType().add("a", (DataType)StringType$.MODULE$);
                ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                return this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "java.lang.Integer is not a valid external type";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            RuntimeException e3 = (RuntimeException)this.intercept((Function0 & Serializable)() -> {
                StructType schema = new StructType().add("a", (DataType)new StructType().add("b", (DataType)IntegerType$.MODULE$).add("c", (DataType)StringType$.MODULE$));
                ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                return this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")})));
            }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            String $org_scalatest_assert_macro_left3 = e3.getMessage();
            String $org_scalatest_assert_macro_right3 = "scala.Tuple2 is not a valid external type";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            RuntimeException e4 = (RuntimeException)this.intercept((Function0 & Serializable)() -> {
                StructType schema = new StructType().add("a", (DataType)ArrayType$.MODULE$.apply((DataType)TimestampType$.MODULE$));
                ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
                return this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new String[]{"a"}})));
            }, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            String $org_scalatest_assert_macro_left4 = e4.getMessage();
            String $org_scalatest_assert_macro_right4 = "java.lang.String is not a valid external type";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        this.test("SPARK-25791: Datatype of serializers should be accessible", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType udtSQLType = new StructType().add("a", (DataType)IntegerType$.MODULE$);
            PythonUserDefinedType pythonUDT = new PythonUserDefinedType((DataType)udtSQLType, "pyUDT", "serializedPyClass");
            StructType schema = new StructType().add("pythonUDT", (DataType)pythonUDT, true);
            ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(schema);
            DataType $org_scalatest_assert_macro_left = ((Expression)encoder.serializer().apply(0)).dataType();
            DataType $org_scalatest_assert_macro_right = pythonUDT.sqlType();
            DataType dataType = $org_scalatest_assert_macro_left;
            DataType dataType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        this.test("encoding/decoding TimestampType to/from java.time.Instant", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("t", (DataType)TimestampType$.MODULE$);
            ExpressionEncoder qual$7 = RowEncoder$.MODULE$.apply(schema);
            Seq x$13 = qual$7.resolveAndBind$default$1();
            Analyzer x$14 = qual$7.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$7.resolveAndBind(x$13, x$14);
            Instant instant = Instant.parse("2019-02-26T16:56:00Z");
            InternalRow row = this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{instant})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)row.getLong(0)));
            long $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.instantToMicros(instant);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            Row readback = this.fromRow((ExpressionEncoder<Row>)encoder, row);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(readback.get(0));
            Instant $org_scalatest_assert_macro_right2 = instant;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("SPARK-35664: encoding/decoding TimestampNTZType to/from java.time.LocalDateTime", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            StructType schema = new StructType().add("t", (DataType)TimestampNTZType$.MODULE$);
            ExpressionEncoder qual$8 = RowEncoder$.MODULE$.apply(schema);
            Seq x$15 = qual$8.resolveAndBind$default$1();
            Analyzer x$16 = qual$8.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$8.resolveAndBind(x$15, x$16);
            LocalDateTime localDateTime = LocalDateTime.parse("2019-02-26T16:56:00");
            InternalRow row = this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{localDateTime})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)row.getLong(0)));
            long $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            Row readback = this.fromRow((ExpressionEncoder<Row>)encoder, row);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(readback.get(0));
            LocalDateTime $org_scalatest_assert_macro_right2 = localDateTime;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        }, new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("encoding/decoding DateType to/from java.time.LocalDate", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            StructType schema = new StructType().add("d", (DataType)DateType$.MODULE$);
            ExpressionEncoder qual$9 = RowEncoder$.MODULE$.apply(schema);
            Seq x$17 = qual$9.resolveAndBind$default$1();
            Analyzer x$18 = qual$9.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$9.resolveAndBind(x$17, x$18);
            LocalDate localDate = LocalDate.parse("2019-02-27");
            InternalRow row = this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{localDate})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)row.getInt(0)));
            int $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.localDateToDays(localDate);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
            Row readback = this.fromRow((ExpressionEncoder<Row>)encoder, row);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(readback.get(0).equals(localDate), "readback.get(0).equals(localDate)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        }), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("SPARK-34605: encoding/decoding DayTimeIntervalType to/from java.time.Duration", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> DataTypeTestUtils$.MODULE$.dayTimeIntervalTypes().foreach((Function1 & Serializable)dayTimeIntervalType -> {
            StructType schema = new StructType().add("d", (DataType)dayTimeIntervalType);
            ExpressionEncoder qual$10 = RowEncoder$.MODULE$.apply(schema);
            Seq x$19 = qual$10.resolveAndBind$default$1();
            Analyzer x$20 = qual$10.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$10.resolveAndBind(x$19, x$20);
            Duration duration = Duration.ofDays(1L);
            InternalRow row = this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{duration})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)row.getLong(0)));
            long $org_scalatest_assert_macro_right = IntervalUtils$.MODULE$.durationToMicros(duration);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            Row readback = this.fromRow((ExpressionEncoder<Row>)encoder, row);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(readback.get(0).equals(duration), "readback.get(0).equals(duration)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        }), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        this.test("SPARK-34615: encoding/decoding YearMonthIntervalType to/from java.time.Period", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> DataTypeTestUtils$.MODULE$.yearMonthIntervalTypes().foreach((Function1 & Serializable)yearMonthIntervalType -> {
            StructType schema = new StructType().add("p", (DataType)yearMonthIntervalType);
            ExpressionEncoder qual$11 = RowEncoder$.MODULE$.apply(schema);
            Seq x$21 = qual$11.resolveAndBind$default$1();
            Analyzer x$22 = qual$11.resolveAndBind$default$2();
            ExpressionEncoder encoder = qual$11.resolveAndBind(x$21, x$22);
            Period period = Period.ofMonths(1);
            InternalRow row = this.toRow((ExpressionEncoder<Row>)encoder, Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{period})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)row.getInt(0)));
            int $org_scalatest_assert_macro_right = IntervalUtils$.MODULE$.periodToMonths(period);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            Row readback = this.fromRow((ExpressionEncoder<Row>)encoder, row);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(readback.get(0).equals(period), "readback.get(0).equals(period)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        }), new Position("RowEncoderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$})).foreach((Function1 & Serializable)elementType -> {
            RowEncoderSuite.$anonfun$new$26(this, elementType);
            return BoxedUnit.UNIT;
        });
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{IntegerType$.MODULE$, StringType$.MODULE$})).foreach((Function1 & Serializable)keyType -> {
            RowEncoderSuite.$anonfun$new$30(this, keyType);
            return BoxedUnit.UNIT;
        });
    }
}

